/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.internal.response.impl;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.InstallJob;
import com.ibm.cic.agent.core.ModifyJob;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.RollbackJob;
import com.ibm.cic.agent.core.UninstallJob;
import com.ibm.cic.agent.core.UpdateOfferingJob;
import com.ibm.cic.agent.core.internal.headless.ShadowProfile;
import com.ibm.cic.agent.core.internal.response.IElementProxy;
import com.ibm.cic.agent.core.internal.response.IPackageElement;
import com.ibm.cic.agent.core.internal.response.impl.Diff;
import com.ibm.cic.agent.core.internal.response.impl.DiffFeature;
import com.ibm.cic.agent.core.internal.response.impl.DiffFix;
import com.ibm.cic.agent.core.internal.response.impl.OfferingProxy;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.Comparators;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

public class DiffPackage
extends Diff {
    private IOffering latestAvailableOffering = null;
    private boolean latestAvailalbeOfferingSearched = false;

    public DiffPackage(IElementProxy source, IElementProxy target) {
        super(source, target);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IStatus computeJobs(ShadowProfile tempProfile, List jobs) {
        CicMultiStatus ret = Statuses.ST.createMultiStatus();
        ret.add(this.processPackageProperties(tempProfile));
        if (this.isCreate()) {
            String featuresToAdd = this.getFeaturesToAdd();
            IOffering offering = this.findLatestAvailableOfferingWithinRange();
            if (offering == null) throw new IllegalArgumentException();
            InstallJob installJob = new InstallJob(tempProfile, (IOfferingOrFix)offering);
            installJob.setFeatureIds(featuresToAdd);
            jobs.add(installJob);
        } else if (this.isRemove()) {
            IOffering installedOffering = this.InstalledOffering();
            if (installedOffering == null) throw new IllegalArgumentException();
            jobs.add(new UninstallJob(tempProfile, (IOfferingOrFix)installedOffering));
        } else if (this.isReplace()) {
            if (this.isUpdate()) {
                IOffering offering = this.findLatestAvailableOfferingWithinRange();
                IOffering installedOffering = this.InstalledOffering();
                String featuresToAdd = this.getFeaturesToAdd();
                UpdateOfferingJob updateJob = new UpdateOfferingJob((Profile)tempProfile, offering, installedOffering);
                updateJob.setFeatureIds(featuresToAdd);
                jobs.add(updateJob);
            } else if (this.isModify()) {
                IOffering installedOffering = this.InstalledOffering();
                String featuresToAdd = this.getFeaturesToAdd();
                String featuresToRemove = this.getFeaturesToAdd();
                ModifyJob installJob = new ModifyJob(tempProfile, (IOfferingOrFix)installedOffering, AgentJob.AgentJobType.INSTALL_JOB);
                installJob.setFeatureIds(featuresToAdd);
                jobs.add(installJob);
                ModifyJob uninstallJob = new ModifyJob(tempProfile, (IOfferingOrFix)installedOffering, AgentJob.AgentJobType.UNINSTALL_JOB);
                uninstallJob.setFeatureIds(featuresToRemove);
                jobs.add(uninstallJob);
            } else if (this.isRollback()) {
                IOffering offering = this.findLatestAvailableOfferingWithinRange();
                IOffering installedOffering = this.InstalledOffering();
                String featuresToAdd = this.getFeaturesToAdd();
                if (this.isRollbackable(tempProfile, offering, installedOffering)) {
                    RollbackJob rollbackJob = new RollbackJob(tempProfile, (IOfferingOrFix)offering, installedOffering);
                    rollbackJob.setFeatureIds(featuresToAdd);
                } else {
                    jobs.add(new UninstallJob(tempProfile, (IOfferingOrFix)installedOffering));
                    InstallJob installJob = new InstallJob(tempProfile, (IOfferingOrFix)offering);
                    installJob.setFeatureIds(featuresToAdd);
                    jobs.add(installJob);
                }
            }
        }
        ret.add(this.computeFixJobs(tempProfile, jobs));
        if (!StatusUtil.isErrorOrCancel((IStatus)ret)) return ret;
        return ret;
    }

    private IStatus processPackageProperties(ShadowProfile tempProfile) {
        return Status.OK_STATUS;
    }

    private boolean isRollbackable(ShadowProfile tempProfile, IOffering offering, IOffering installedOffering) {
        return false;
    }

    private boolean isRollback() {
        VersionRange versionRange = this.getVersionRange();
        if (versionRange == null) {
            return false;
        }
        OfferingProxy offeringProxy = (OfferingProxy)this.getTargetElement();
        return offeringProxy != null && Comparators.compare((Version)versionRange.getRight(), (Version)offeringProxy.getVersion()) < 0;
    }

    private VersionRange getVersionRange() {
        IPackageElement packageElement = (IPackageElement)this.getSourceElement();
        if (packageElement == null) {
            return null;
        }
        String max = packageElement.getVersion();
        Version maxVersion = null;
        if (max != null) {
            maxVersion = new Version(max);
        } else {
            IOffering offering = this.findLatestAvailableOffering();
            if (offering != null) {
                maxVersion = offering.getVersion();
            } else {
                throw new IllegalArgumentException();
            }
        }
        String min = packageElement.getMinVersion();
        Version minVersion = null;
        minVersion = min != null ? new Version(min) : maxVersion;
        return new VersionRange(minVersion, true, maxVersion, true);
    }

    private IOffering findLatestAvailableOffering() {
        if (this.latestAvailalbeOfferingSearched) {
            return this.latestAvailableOffering;
        }
        this.latestAvailalbeOfferingSearched = true;
        IPackageElement packageElement = (IPackageElement)this.getSourceElement();
        if (packageElement == null) {
            return null;
        }
        String offeringId = packageElement.getId();
        List offerings = Agent.getInstance().getRepositoryGroup().getAllOfferings((IProgressMonitor)new NullProgressMonitor());
        for (IOffering offering : offerings) {
            if (!offeringId.equals(offering.getIdentity().getId()) || this.latestAvailableOffering != null && offering.compareVersion((IContent)this.latestAvailableOffering) <= 0) continue;
            this.latestAvailableOffering = offering;
        }
        return this.latestAvailableOffering;
    }

    private IOffering findLatestAvailableOfferingWithinRange() {
        VersionRange versionRange = this.getVersionRange();
        IPackageElement packageElement = (IPackageElement)this.getSourceElement();
        if (packageElement == null) {
            return null;
        }
        String offeringId = packageElement.getId();
        IOffering latestOffering = null;
        List offerings = Agent.getInstance().getRepositoryGroup().getAllOfferings((IProgressMonitor)new NullProgressMonitor());
        for (IOffering offering : offerings) {
            if (!offeringId.equals(offering.getIdentity().getId()) || latestOffering != null && offering.compareVersion(latestOffering) <= 0 || !versionRange.isIncluded(offering.getVersion())) continue;
            latestOffering = offering;
        }
        return latestOffering;
    }

    private boolean isModify() {
        VersionRange versionRange = this.getVersionRange();
        if (versionRange == null) {
            return false;
        }
        OfferingProxy offeringProxy = (OfferingProxy)this.getTargetElement();
        return offeringProxy != null && versionRange.isIncluded(offeringProxy.getVersion());
    }

    private boolean isUpdate() {
        VersionRange versionRange = this.getVersionRange();
        if (versionRange == null) {
            return false;
        }
        OfferingProxy offeringProxy = (OfferingProxy)this.getTargetElement();
        return offeringProxy != null && Comparators.compare((Version)versionRange.getRight(), (Version)offeringProxy.getVersion()) > 0;
    }

    private IOffering InstalledOffering() {
        OfferingProxy offeringProxy = (OfferingProxy)this.getTargetElement();
        return offeringProxy == null ? null : offeringProxy.getOffering();
    }

    private String getFeaturesToAdd() {
        StringBuffer ret = new StringBuffer();
        List diffFeatures = this.getDiffFeatures();
        for (DiffFeature diffFeature : diffFeatures) {
            if (!diffFeature.isCreate()) continue;
            ret.append(diffFeature.getId());
        }
        return ret.toString();
    }

    private IStatus computeFixJobs(ShadowProfile tempProfile, List jobs) {
        CicMultiStatus ret = Statuses.ST.createMultiStatus();
        List diffFixes = this.getDiffFixes();
        for (DiffFix diffFix : diffFixes) {
            ret.add(diffFix.computeJobs(tempProfile, jobs));
            if (!StatusUtil.isErrorOrCancel((IStatus)ret)) continue;
            return ret;
        }
        return ret;
    }

    private List getDiffFixes() {
        ArrayList<Diff> ret = new ArrayList<Diff>();
        for (Diff child : this.getChildren()) {
            if (!(child instanceof DiffFix)) continue;
            ret.add(child);
        }
        return ret;
    }

    private List getDiffFeatures() {
        ArrayList<Diff> ret = new ArrayList<Diff>();
        for (Diff child : this.getChildren()) {
            if (!(child instanceof DiffFeature)) continue;
            ret.add(child);
        }
        return ret;
    }
}

