/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.internal.response.impl;

import com.ibm.cic.agent.core.internal.response.Action;
import com.ibm.cic.agent.core.internal.response.IActionElement;
import com.ibm.cic.agent.core.internal.response.IElement;
import com.ibm.cic.agent.core.internal.response.IElementProxy;
import com.ibm.cic.agent.core.internal.response.impl.Diff;
import com.ibm.cic.agent.core.internal.response.impl.DiffFeature;
import com.ibm.cic.agent.core.internal.response.impl.DiffFix;
import com.ibm.cic.agent.core.internal.response.impl.DiffPackage;
import com.ibm.cic.agent.core.internal.response.impl.DiffPackageGroup;
import com.ibm.cic.agent.core.internal.response.impl.DiffProperty;
import com.ibm.cic.agent.core.internal.response.impl.ElementMatch;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class DiffHelper {
    private final DiffRemoveCollector diffRemoveSourceCollector = new DiffRemoveCollector(0);
    private final DiffRemoveCollector diffRemoveTargetCollector = new DiffRemoveCollector(1);

    private Diff getDiff(IElementProxy source, IElementProxy target, int kind) {
        if (source == null && target == null) {
            throw new IllegalArgumentException();
        }
        String configName = null;
        configName = source != null ? source.getConfigName() : target.getConfigName();
        Diff diff = null;
        if ("packageGroup".equals(configName)) {
            diff = new DiffPackageGroup(source, target);
        } else if ("package".equals(configName)) {
            diff = new DiffPackage(source, target);
        } else if ("property".equals(configName)) {
            diff = new DiffProperty(source, target);
        } else if ("feature".equals(configName)) {
            diff = new DiffFeature(source, target);
        } else if ("fix".equals(configName)) {
            diff = new DiffFix(source, target);
        }
        if (diff != null) {
            diff.setKind(kind);
        }
        return diff;
    }

    public List diffRemoveSource(IElementProxy sourceElement) {
        this.diffRemoveSourceCollector.reset();
        this.traverse(sourceElement, this.diffRemoveSourceCollector);
        return this.diffRemoveSourceCollector.getResult();
    }

    public List diffRemoveTarget(IElementProxy targetElement) {
        this.diffRemoveTargetCollector.reset();
        this.traverse(targetElement, this.diffRemoveTargetCollector);
        return this.diffRemoveSourceCollector.getResult();
    }

    private void traverse(IElementProxy element, DiffRemoveCollector collector) {
        boolean processChildren = collector.process(element);
        if (processChildren && element.hasChild()) {
            List children = element.getChildElements();
            for (IElementProxy child : children) {
                this.traverse(child, collector);
            }
        }
    }

    public List diffRemove(IElementProxy srcElement, IElementProxy targetElm) {
        return this.diffRemoveTarget(targetElm);
    }

    public Diff diffReplace(IElementProxy srcElement, IElementProxy targetElement) {
        return this.getDiff(srcElement, targetElement, 2);
    }

    public Diff diffCreate(IElementProxy srcElement) {
        return this.getDiff(srcElement, null, 1);
    }

    public static IStatus diffReplace(IElement sourceElement, IElementProxy targetElement, Diff parentDiff) {
        if (sourceElement == null) {
            throw new IllegalArgumentException();
        }
        if (targetElement != null) {
            parentDiff.addReplace(sourceElement, targetElement);
        } else {
            parentDiff.addCreate(sourceElement);
        }
        return Status.OK_STATUS;
    }

    public static IStatus diffReplace(IActionElement sourceElement, IElementProxy targetElement, Diff parentDiff) {
        if (sourceElement == null) {
            throw new IllegalArgumentException();
        }
        CicMultiStatus ret = Statuses.ST.createMultiStatus();
        Diff curDiff = null;
        curDiff = targetElement != null ? parentDiff.addReplace(sourceElement, targetElement) : parentDiff.addCreate(sourceElement);
        if (curDiff == null) {
            curDiff = parentDiff;
        }
        if (!sourceElement.hasChild()) {
            return ret;
        }
        ElementMatch elmMatch = null;
        elmMatch = targetElement != null ? new ElementMatch(sourceElement, targetElement) : new ElementMatch(sourceElement);
        Action action = sourceElement.getAction();
        switch (action.value()) {
            case 0: {
                ret.add(DiffHelper.processAdd(elmMatch, curDiff));
                break;
            }
            case 2: {
                ret.add(DiffHelper.processRemove(elmMatch, curDiff));
                break;
            }
            case 1: {
                ret.add(DiffHelper.processSet(elmMatch, curDiff));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return ret;
    }

    public static IStatus diffCreate(IActionElement sourceElement, Diff parentDiff) {
        if (sourceElement == null) {
            throw new IllegalArgumentException();
        }
        return DiffHelper.diffReplace(sourceElement, null, parentDiff);
    }

    public static IStatus diffCreate(IElement sourceElement, Diff parentDiff) {
        if (sourceElement == null) {
            throw new IllegalArgumentException();
        }
        return DiffHelper.diffReplace(sourceElement, null, parentDiff);
    }

    static IStatus processRemove(ElementMatch elmMatch, Diff parentDiff) {
        CicMultiStatus ret = Statuses.ST.createMultiStatus();
        List srcElms2 = elmMatch.getChildSourceElements();
        for (IActionElement srcElm : srcElms2) {
            List targetElms = elmMatch.getTargetElements(srcElm);
            if (!targetElms.isEmpty()) {
                parentDiff.addRemove((IElementProxy)srcElm, targetElms);
                continue;
            }
            parentDiff.addRemoveSource(srcElm);
        }
        return ret;
    }

    private static IStatus processSet(ElementMatch elmMatch, Diff parentDiff) {
        CicMultiStatus ret = Statuses.ST.createMultiStatus();
        ret.add(DiffHelper.processAdd(elmMatch, parentDiff));
        if (StatusUtil.isErrorOrCancel((IStatus)ret)) {
            return ret;
        }
        List targetElms = elmMatch.getUnmatchedTargetElements();
        for (IElementProxy targetElm : targetElms) {
            parentDiff.addRemoveTarget(targetElm);
        }
        return ret;
    }

    static IStatus processAdd(ElementMatch elmMatch, Diff parentDiff) {
        CicMultiStatus ret = Statuses.ST.createMultiStatus();
        List srcElms = elmMatch.getChildSourceElements();
        for (IActionElement srcElm : srcElms) {
            List targetElms = elmMatch.getTargetElements(srcElm);
            if (targetElms.isEmpty()) {
                ret.add(DiffHelper.diffCreate(srcElm, parentDiff));
            } else {
                ret.add(DiffHelper.diffReplace(srcElm, targetElms, parentDiff));
            }
            if (!StatusUtil.isErrorOrCancel((IStatus)ret)) continue;
            return ret;
        }
        return ret;
    }

    private static IStatus diffReplace(IActionElement srcElm, List targetElms, Diff parentDiff) {
        CicMultiStatus ret = Statuses.ST.createMultiStatus();
        for (IElementProxy targetElement : targetElms) {
            ret.add(DiffHelper.diffReplace(srcElm, targetElement, parentDiff));
        }
        return ret;
    }

    private class DiffRemoveCollector {
        public static final int ELEMENT_SOURCE = 0;
        public static final int ELEMENT_TARGET = 1;
        private final List diffs;
        private int kind = 0;

        public DiffRemoveCollector(int kind) {
            this.kind = kind;
            this.diffs = new ArrayList();
        }

        public List getResult() {
            return this.diffs;
        }

        public void reset() {
            this.diffs.clear();
        }

        public boolean process(IElementProxy element) {
            IElementProxy source = null;
            IElementProxy target = null;
            if (this.kind == 0) {
                source = element;
            } else {
                target = element;
            }
            Diff diff = DiffHelper.this.getDiff(source, target, this.kind);
            if (diff != null) {
                this.diffs.add(diff);
                return false;
            }
            return true;
        }
    }
}

