/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.internal.commands;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentDependencyCheckerUtil;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.BitModeUtils;
import com.ibm.cic.agent.core.InstallJob;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.UpdateOfferingJob;
import com.ibm.cic.agent.core.cmd.CmdLine;
import com.ibm.cic.agent.core.internal.commands.AbstractAcceptLicenseCommand;
import com.ibm.cic.agent.core.internal.commands.AbstractInstallCommand;
import com.ibm.cic.agent.core.internal.headless.IUpdateAllCommand;
import com.ibm.cic.agent.core.internal.headless.InstallFixesAction;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.console.PrompterUtils;
import com.ibm.cic.common.core.model.ExtensionCategory;
import com.ibm.cic.common.core.model.FixUtil;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.OfferingProperty;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.core.preferences.CicPreferenceManager;
import com.ibm.cic.common.core.preferences.ICicPreferenceConstants;
import com.ibm.cic.common.core.repository.IRepositoryGroup;
import com.ibm.cic.common.core.repository.ServiceRepositoryUtils;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class UpdateAllCommand
extends AbstractAcceptLicenseCommand
implements IUpdateAllCommand {
    private Set preparedOfferings;

    public UpdateAllCommand() {
        super("updateAll");
    }

    @Override
    public IStatus execute(Agent agent, IProgressMonitor monitor) {
        PrompterUtils.ConsoleCredentialPrompter credentialPrompts = CmdLine.CL.getConsoleCredentialPrompter();
        CicMultiStatus result = Statuses.ST.createMultiStatus();
        this.preparedOfferings = new HashSet();
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, new int[]{1, 17, 1});
        try {
            Profile[] profiles;
            boolean needRestart = this.installAgentUpdate(agent, result, false, spm.next());
            if (needRestart) {
                CicMultiStatus cicMultiStatus = result;
                return cicMultiStatus;
            }
            String installFixesStr = this.getAttribute("installFixes");
            String profileId = this.getAttribute("profile");
            String installLocation = this.getAttribute("installLocation");
            InstallFixesAction ifAction = null;
            if (installFixesStr != null) {
                ifAction = InstallFixesAction.getInstallFixesAction(installFixesStr);
                if (!InstallFixesAction.isValidInstallFixesString(installFixesStr)) {
                    result.add((IStatus)Statuses.ERROR.get(Messages.AbstractInstallCommand_InvalidValueInstallFixes, new Object[]{installFixesStr, "installFixes"}));
                    CicMultiStatus cicMultiStatus = result;
                    return cicMultiStatus;
                }
            }
            if (installLocation != null && profileId != null) {
                result.add((IStatus)Statuses.ERROR.get(Messages.HeadlessApplication_Profile_Or_Install_Location, new Object[]{this.getName(), "profile", "installLocation"}));
                CicMultiStatus cicMultiStatus = result;
                return cicMultiStatus;
            }
            if (profileId != null) {
                profiles = new Profile[]{agent.getProfile(profileId)};
                if (profiles[0] == null) {
                    result.add((IStatus)Statuses.ERROR.get(Messages.HeadlessApplication_Cannot_Find_Profile, new Object[]{profileId}));
                    CicMultiStatus cicMultiStatus = result;
                    return cicMultiStatus;
                }
            } else if (installLocation != null) {
                profiles = new Profile[]{agent.getProfileByInstallLocation(installLocation)};
                if (profiles[0] == null) {
                    result.add((IStatus)Statuses.ERROR.get(Messages.UnisntallCommand_NoPackageIsInstalledAtLocation, new Object[]{installLocation}));
                    CicMultiStatus cicMultiStatus = result;
                    return cicMultiStatus;
                }
            } else {
                profiles = agent.getSortedProductProfiles(false);
            }
            spm.splitNext(profiles.length);
            Profile[] profileArray = profiles;
            int n = profiles.length;
            int n2 = 0;
            while (n2 < n) {
                Profile profile = profileArray[n2];
                if (profile.shouldBeVisible()) {
                    this.updateProfile(result, agent, profile, spm.next(), ifAction);
                    if (result.isErrorOrCancel()) {
                        CicMultiStatus cicMultiStatus = result;
                        return cicMultiStatus;
                    }
                    if (spm.isCanceled()) {
                        result.add(Status.CANCEL_STATUS);
                        CicMultiStatus cicMultiStatus = result;
                        return cicMultiStatus;
                    }
                }
                ++n2;
            }
            CicMultiStatus cicMultiStatus = result;
            return cicMultiStatus;
        }
        finally {
            credentialPrompts.restore();
            try {
                result.add(agent.unprepare(null, spm.next()));
            }
            finally {
                spm.done();
                monitor.done();
            }
        }
    }

    private void updateProfile(CicMultiStatus result, Agent agent, Profile profile, IProgressMonitor monitor, InstallFixesAction installFixes) {
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, new int[]{1, 1, 1, 1, 1, 1, 1, 2, 22, 1});
        try {
            IOffering[] installedOfferings = agent.getInstalledOfferings(profile);
            IProgressMonitor loadSvcRepoMon = spm.next();
            if (CicPreferenceManager.getInstance().getBoolean(ICicPreferenceConstants.USE_SERVICE_REPOSITORIES.key()) || CmdLine.CL.containsCommand("-useServiceRepository")) {
                ServiceRepositoryUtils.loadServiceRepositories((boolean)false, null, null, (IRepositoryGroup)agent.getRepositoryGroup(), (IOffering[])installedOfferings, (IProgressMonitor)loadSvcRepoMon);
            }
            ArrayList updateJobs = new ArrayList();
            this.getUpdateJobs(result, agent, profile, updateJobs, spm.next());
            if (result.isErrorOrCancel()) {
                return;
            }
            result.add(this.prepareUpdateJobs(agent, updateJobs, spm.next()));
            if (result.isErrorOrCancel()) {
                return;
            }
            ArrayList fixJobs = new ArrayList();
            this.getFixJobs(result, agent, profile, updateJobs, fixJobs, spm.next(), installFixes);
            if (result.isErrorOrCancel()) {
                return;
            }
            result.add(this.prepareUpdateJobs(agent, fixJobs, spm.next()));
            if (result.isErrorOrCancel()) {
                return;
            }
            ArrayList allJobs = new ArrayList(updateJobs);
            allJobs.addAll(fixJobs);
            AgentJob[] arrAllJobs = AgentJob.toArray(allJobs);
            result.add(this.prepareInstalledFixes(agent, profile, spm.next()));
            if (StatusUtil.isErrorOrCancel((IStatus)result)) {
                return;
            }
            result.add(AbstractInstallCommand.performLocationPermissionCheck(arrAllJobs));
            if (result.isErrorOrCancel()) {
                return;
            }
            result.add(BitModeUtils.check64bitImSupported(arrAllJobs));
            if (result.isErrorOrCancel()) {
                return;
            }
            result.add(this.checkUpdateJobs(agent, allJobs, spm.next()));
            if (result.isErrorOrCancel()) {
                return;
            }
            result.add(AgentDependencyCheckerUtil.checkOfferingFixDependenciesMultipleProfiles(arrAllJobs, spm.next()));
            if (result.isErrorOrCancel()) {
                return;
            }
            result.add(agent.install(arrAllJobs, spm.next()));
            if (result.isErrorOrCancel()) {
                return;
            }
            this.outputCompletedAgentJobs(agent, arrAllJobs);
            ArrayList pekJobs = new ArrayList();
            IOffering[] iOfferingArray = installedOfferings;
            int n = installedOfferings.length;
            int n2 = 0;
            while (n2 < n) {
                IOffering installedOffering = iOfferingArray[n2];
                pekJobs.addAll(AgentUtil.getPekInstallJobs(installedOffering));
                ++n2;
            }
            result.add(agent.install(AgentJob.toArray(pekJobs), spm.next()));
        }
        finally {
            ServiceRepositoryUtils.unloadServiceRepositories((IRepositoryGroup)agent.getRepositoryGroup());
            spm.done();
            monitor.done();
        }
    }

    private void getUpdateJobs(CicMultiStatus result, Agent agent, Profile profile, List updateJobs, IProgressMonitor monitor) {
        IOffering[] installedOfferings = agent.getInstalledOfferings(profile);
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, installedOfferings.length);
        try {
            IOffering[] iOfferingArray = installedOfferings;
            int n = installedOfferings.length;
            int n2 = 0;
            while (n2 < n) {
                IOffering installedOffering = iOfferingArray[n2];
                if (agent.isAgentOffering((IOfferingOrFix)installedOffering) && agent.isAgentOfferingHidden()) {
                    spm.next().done();
                } else {
                    this.getUpdateJobs(result, agent, profile, installedOffering, updateJobs, spm.next());
                    if (result.isErrorOrCancel()) {
                        return;
                    }
                    if (spm.isCanceled()) {
                        result.add(Status.CANCEL_STATUS);
                        return;
                    }
                }
                ++n2;
            }
        }
        finally {
            spm.done();
            monitor.done();
        }
    }

    private void getUpdateJobs(CicMultiStatus result, Agent agent, Profile profile, IOffering installedOffering, List updateJobs, IProgressMonitor monitor) {
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, 1);
        try {
            IOffering[] updates = agent.findUpdates(profile, installedOffering, spm.next());
            if (updates.length == 0) {
                return;
            }
            IOffering updateOffering = updates[updates.length - 1];
            UpdateOfferingJob job = new UpdateOfferingJob(profile, updateOffering, installedOffering);
            updateJobs.add(job);
        }
        finally {
            spm.done();
            monitor.done();
        }
    }

    private void getFixJobs(CicMultiStatus result, Agent agent, Profile profile, List updateJobs, List fixJobs, IProgressMonitor monitor, InstallFixesAction installFixes) {
        boolean adjustJobs = true;
        IOfferingOrFix[] pkgs = AgentUtil.getResultingOfferingsAndFixes(profile, AgentJob.toArray(updateJobs), adjustJobs);
        ArrayList<IOfferingOrFix> offerings = new ArrayList<IOfferingOrFix>(pkgs.length);
        HashSet<IOfferingOrFix> fixes = new HashSet<IOfferingOrFix>();
        IOfferingOrFix[] iOfferingOrFixArray = pkgs;
        int n = pkgs.length;
        int n2 = 0;
        while (n2 < n) {
            IOfferingOrFix pkg = iOfferingOrFixArray[n2];
            if (pkg instanceof IFix) {
                fixes.add(pkg);
            } else {
                offerings.add(pkg);
            }
            ++n2;
        }
        if (installFixes == null) {
            installFixes = InstallFixesAction.ALL;
        }
        List<IFix> applicableFixes = agent.addAllApplicableFixes(monitor, installFixes, profile);
        for (IFix fix : applicableFixes) {
            IOffering offering;
            if (!fixes.contains(fix) && (offering = FixUtil.findApplicableOffering((IFix)fix, offerings)) != null) {
                fixJobs.add(new InstallFixJob(profile, offering, fix));
            }
            if (!monitor.isCanceled()) continue;
            result.add(Status.CANCEL_STATUS);
            return;
        }
    }

    private IStatus checkUpdateJobs(Agent agent, List jobs, IProgressMonitor monitor) {
        CicMultiStatus result = Statuses.ST.createMultiStatus();
        AgentJob[] arrAllJobs = AgentJob.toArray(jobs);
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, arrAllJobs.length);
        try {
            Set offeringsSeenBefore = AgentJob.getOfferingSetFromJobs(arrAllJobs);
            for (AgentJob agentJob : jobs) {
                agentJob.setRelatedJobs(arrAllJobs);
                result.add(this.checkUpdateJob(agent, agentJob, offeringsSeenBefore, spm.next()));
                if (!result.isErrorOrCancel()) continue;
                CicMultiStatus cicMultiStatus = result;
                return cicMultiStatus;
            }
        }
        finally {
            spm.done();
            monitor.done();
        }
        return result;
    }

    private IStatus prepareUpdateJobs(Agent agent, List jobs, IProgressMonitor monitor) {
        CicMultiStatus result = Statuses.ST.createMultiStatus();
        AgentJob[] arrAllJobs = AgentJob.toArray(jobs);
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, arrAllJobs.length);
        try {
            for (AgentJob agentJob : jobs) {
                agentJob.setRelatedJobs(arrAllJobs);
                result.add(this.prepareUpdateJob(agent, agentJob, spm.next()));
                if (!result.isErrorOrCancel()) continue;
                CicMultiStatus cicMultiStatus = result;
                return cicMultiStatus;
            }
        }
        finally {
            spm.done();
            monitor.done();
        }
        return result;
    }

    private IStatus prepareUpdateJob(Agent agent, AgentJob job, IProgressMonitor monitor) {
        IOffering installedOffering;
        CicMultiStatus result = Statuses.ST.createMultiStatus();
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, 2);
        if (job instanceof UpdateOfferingJob) {
            UpdateOfferingJob updateOfferingJob = (UpdateOfferingJob)job;
            installedOffering = updateOfferingJob.getUpdatedOffering();
        } else if (job instanceof InstallFixJob) {
            InstallFixJob installFixJob = (InstallFixJob)job;
            installedOffering = installFixJob.getInstalledOffering();
        } else {
            throw new IllegalArgumentException("internal error");
        }
        IOfferingOrFix updateOfferingOrFix = job.getOfferingOrFix();
        try {
            result.add(this.prepare(agent, (IOfferingOrFix)installedOffering, spm.next()));
            if (StatusUtil.isErrorOrCancel((IStatus)result)) {
                CicMultiStatus cicMultiStatus = result;
                return cicMultiStatus;
            }
            result.add(this.prepare(agent, updateOfferingOrFix, spm.next()));
            if (StatusUtil.isErrorOrCancel((IStatus)result)) {
                CicMultiStatus cicMultiStatus = result;
                return cicMultiStatus;
            }
        }
        finally {
            spm.done();
            monitor.done();
        }
        return result;
    }

    private IStatus checkUpdateJob(Agent agent, AgentJob job, Set offeringsSeenBefore, IProgressMonitor monitor) {
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, new int[]{1});
        CicMultiStatus result = Statuses.ST.createMultiStatus();
        IOfferingOrFix updateOfferingOrFix = job.getOfferingOrFix();
        IOffering updateOffering = null;
        if (updateOfferingOrFix instanceof IOffering) {
            updateOffering = (IOffering)updateOfferingOrFix;
        }
        try {
            if (updateOffering != null && OfferingProperty.hasUnacceptableRequirementForUserRights((IOffering)updateOffering)) {
                result.add((IStatus)new Status(2, Agent.PI_AGENT, 2, NLS.bind((String)Messages.AbstractInstallCommand_NonAdminError0, (Object)updateOffering.getName(), (Object)updateOffering.getVersion()), null));
                CicMultiStatus cicMultiStatus = result;
                return cicMultiStatus;
            }
            if (updateOffering != null && OfferingProperty.hasUnacceptableRequirementForGroupMode((IOfferingOrFix)updateOffering)) {
                result.add((IStatus)new Status(2, Agent.PI_AGENT, 2, NLS.bind((String)Messages.OfferingsDoNotSupportGroupMode, (Object)OfferingUtil.getOfferingOrFixLabel((IOfferingOrFix)updateOffering)), null));
                CicMultiStatus cicMultiStatus = result;
                return cicMultiStatus;
            }
            result.add(agent.evaluatePrecheckBundles(updateOfferingOrFix, job));
            if (StatusUtil.isErrorOrCancel((IStatus)result)) {
                CicMultiStatus cicMultiStatus = result;
                return cicMultiStatus;
            }
            result.add(Agent.getInstance().checkBetaRequirement(updateOfferingOrFix));
            if (StatusUtil.isErrorOrCancel((IStatus)result)) {
                CicMultiStatus cicMultiStatus = result;
                return cicMultiStatus;
            }
            result.add(agent.checkAgentRequirement(updateOfferingOrFix));
            if (StatusUtil.isErrorOrCancel((IStatus)result)) {
                CicMultiStatus cicMultiStatus = result;
                return cicMultiStatus;
            }
            result.add(agent.evaluatePrereqBundles(updateOfferingOrFix, job));
            if (StatusUtil.isErrorOrCancel((IStatus)result)) {
                CicMultiStatus cicMultiStatus = result;
                return cicMultiStatus;
            }
            if (!this.isAcceptLicense() && this.hasLicenseText(updateOfferingOrFix)) {
                ICicStatus iCicStatus = Statuses.ERROR.get(521, Messages.InstallCommand_AcceptLicense, new Object[]{updateOfferingOrFix.getName()});
                return iCicStatus;
            }
            result.add(AbstractInstallCommand.checkPrerequisite(agent, job, offeringsSeenBefore, spm.next()));
            if (StatusUtil.isErrorOrCancel((IStatus)result)) {
                CicMultiStatus cicMultiStatus = result;
                return cicMultiStatus;
            }
            result.add(job.checkOfferingApplicability());
            if (StatusUtil.isErrorOrCancel((IStatus)result)) {
                CicMultiStatus cicMultiStatus = result;
                return cicMultiStatus;
            }
            result.add(AbstractInstallCommand.checkPlatformSupport(agent, job));
            if (StatusUtil.isErrorOrCancel((IStatus)result)) {
                CicMultiStatus cicMultiStatus = result;
                return cicMultiStatus;
            }
        }
        finally {
            spm.done();
            monitor.done();
        }
        return result;
    }

    private IStatus prepare(Agent agent, IOfferingOrFix offeringOrFix, IProgressMonitor monitor) {
        if (this.preparedOfferings.add(offeringOrFix)) {
            return agent.prepare(offeringOrFix, ExtensionCategory.ALL, monitor);
        }
        monitor.done();
        return Status.OK_STATUS;
    }

    @Override
    public int getExecutionPoint() {
        return 4;
    }

    @Override
    public int getWeight() {
        return 100;
    }

    @Override
    public void addInstallFixesAttribute(InstallFixesAction installFixes) {
        if (installFixes != null) {
            super.addAttribute("installFixes", installFixes.getName());
        }
    }

    @Override
    public void addProfile(String profile) {
        if (profile != null) {
            super.addAttribute("profile", profile);
        }
    }

    @Override
    public void addInstallLocation(String installLocation) {
        if (installLocation != null) {
            super.addAttribute("installLocation", installLocation);
        }
    }

    private static class InstallFixJob
    extends InstallJob {
        private final IOffering installedOffering;

        public InstallFixJob(Profile profile, IOffering installedOffering, IFix fix) {
            super(profile, (IOfferingOrFix)fix);
            this.installedOffering = installedOffering;
        }

        public IOffering getInstalledOffering() {
            return this.installedOffering;
        }
    }
}

