/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.internal.commands;

import com.ibm.cic.agent.core.AbstractVariableSubstitution;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentDependencyCheckerUtil;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.BitModeUtils;
import com.ibm.cic.agent.core.CacheLocationManager;
import com.ibm.cic.agent.core.ErrorJob;
import com.ibm.cic.agent.core.InstallJob;
import com.ibm.cic.agent.core.ModifyJob;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.RollbackJob;
import com.ibm.cic.agent.core.UpdateOfferingJob;
import com.ibm.cic.agent.core.cmd.CmdLine;
import com.ibm.cic.agent.core.internal.commands.AbstractInstallCommand;
import com.ibm.cic.agent.core.internal.commands.HeadlessApplicationException;
import com.ibm.cic.agent.core.internal.commands.XMLElement;
import com.ibm.cic.agent.core.internal.headless.IInput;
import com.ibm.cic.agent.core.internal.headless.IInstallCommand;
import com.ibm.cic.agent.core.internal.headless.InstallFixesAction;
import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.internal.core.AgentPathValidator;
import com.ibm.cic.agent.internal.core.InstallRegistry;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.agent.internal.core.notify.AgentListener;
import com.ibm.cic.common.core.definitions.ProfileLanguageUtils;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IFeatureBase;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.SimpleIdentity;
import com.ibm.cic.common.core.model.utils.FixProperty;
import com.ibm.cic.common.core.model.utils.LicenseUtils;
import com.ibm.cic.common.core.model.utils.OfferingProperty;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.OutputFormatter;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.logging.ExceptionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.osgi.framework.Version;

public class InstallCommand
extends AbstractInstallCommand
implements IInstallCommand {
    private final Map<Profile, Boolean> newDefaultProfiles = new HashMap<Profile, Boolean>();

    public InstallCommand() {
        super("install");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected IStatus execute(Agent agent, AgentJob[] agentJobs, IProgressMonitor monitor) {
        CicMultiStatus status = Statuses.ST.createMultiStatus();
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, new int[]{2, 2, 1, 2, 72, 1});
        try {
            AgentJob[] jobMonitor;
            int n;
            status.add(SharedUIUtils.prepareAndResolveSelectedJobs(Arrays.asList(agentJobs), spm.next()));
            status.add(InstallCommand.performLocationPermissionCheck(agentJobs));
            if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                CicMultiStatus cicMultiStatus = status;
                return cicMultiStatus;
            }
            status.add(BitModeUtils.check64bitImSupported(agentJobs));
            if (status.isErrorOrCancel()) {
                CicMultiStatus cicMultiStatus = status;
                return cicMultiStatus;
            }
            SplitProgressMonitor jobLoopMonitor = new SplitProgressMonitor(spm.next(), agentJobs.length);
            try {
                Set offeringsSeenBefore = AgentJob.getOfferingSetFromJobs(agentJobs);
                AgentJob[] agentJobArray = agentJobs;
                n = agentJobs.length;
                int n2 = 0;
                while (n2 < n) {
                    AgentJob agentJob = agentJobArray[n2];
                    jobMonitor = jobLoopMonitor.next();
                    status.add(this.checkJob(agent, agentJob, offeringsSeenBefore, (IProgressMonitor)jobMonitor));
                    if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                        CicMultiStatus cicMultiStatus = status;
                        return cicMultiStatus;
                    }
                    if (jobLoopMonitor.isCanceled()) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    ++n2;
                }
            }
            finally {
                jobLoopMonitor.done();
            }
            ArrayList<AgentJob> productJobs = new ArrayList<AgentJob>();
            ArrayList<IOffering> productOfferings = new ArrayList<IOffering>();
            jobMonitor = agentJobs;
            int n3 = agentJobs.length;
            n = 0;
            while (n < n3) {
                AgentJob job = jobMonitor[n];
                IOffering offering = job.getOffering();
                if (offering != null && !agent.isAgentOffering((IOfferingOrFix)offering) && !LicenseUtils.isPEKOffering((IOffering)offering)) {
                    productJobs.add(job);
                    productOfferings.add(offering);
                }
                ++n;
            }
            IProgressMonitor cofiMon = spm.next();
            if (productJobs.size() > 0) {
                status.add(agent.checkOfferingFeatureInterdependencies(productJobs, cofiMon));
                if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                    CicMultiStatus cicMultiStatus = status;
                    return cicMultiStatus;
                }
            }
            status.add(AgentDependencyCheckerUtil.checkOfferingFixDependenciesMultipleProfiles(agentJobs, spm.next()));
            if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                CicMultiStatus cicMultiStatus = status;
                return cicMultiStatus;
            }
            IInput input = this.getInput();
            CacheLocationManager clm = CacheLocationManager.getInstance();
            if (CicCommonSettings.isPortable()) {
                clm.setCacheLocation(this.getPortableSharedLocation(agentJobs));
            } else if (!(input != null && input.isSettingEclipseCacheLocation() || !clm.isCacheLocationChangeable() || productJobs.isEmpty())) {
                try {
                    clm.setCacheLocation(clm.calculateDefaultCacheLocation(productJobs));
                }
                catch (AbstractVariableSubstitution.VariableSubstitutionException e) {
                    IStatus iStatus = e.getStatus();
                    try {
                        status.add(agent.unprepare(agentJobs, spm.next()));
                        return iStatus;
                    }
                    finally {
                        spm.done();
                        monitor.done();
                    }
                }
            }
            if (productJobs.size() > 0 && clm.isCacheLocationChangeable()) {
                status.add(AgentUtil.validateCommonDirectoryPermissions(clm.getCacheLocation()));
                if (status.isOK()) {
                    status.add((IStatus)AgentUtil.validateCacheLocation(agentJobs, clm.getCacheLocation(), productOfferings.toArray(new IOffering[productOfferings.size()])));
                }
                if (!status.isErrorOrCancel()) {
                    status.add(AgentPathValidator.checkSymbolicLinks(clm.getCacheLocation()));
                }
                if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                    CicMultiStatus cicMultiStatus = status;
                    return cicMultiStatus;
                }
            }
            ArrayList<ModifyJob> derivedUninstallJobs = new ArrayList<ModifyJob>();
            AgentJob[] agentJobArray = agentJobs;
            int n4 = agentJobs.length;
            int n5 = 0;
            while (n5 < n4) {
                AgentJob job = agentJobArray[n5];
                ArrayList<IFeature> uninstallFeatures = new ArrayList<IFeature>();
                if (job.isModify() && job.getSubType().isInstall()) {
                    Set installedFeatures = agent.getInstalledFeatures(job.getProfile(), job.getOffering());
                    CicMultiStatus mFeatureStatus = Statuses.ST.createMultiStatus();
                    for (IFeature installedFeature : installedFeatures) {
                        if (job.getFeatures().contains(installedFeature)) continue;
                        IStatus applicabilityStatus = agent.checkPrerequisite((IFeatureBase)installedFeature, job);
                        if (applicabilityStatus.getSeverity() == 4 && installedFeature.hasApplicabilityFlag(applicabilityStatus, 4)) {
                            mFeatureStatus.add(applicabilityStatus);
                        }
                        uninstallFeatures.add(installedFeature);
                    }
                    if (!mFeatureStatus.isOK()) {
                        CicMultiStatus cicMultiStatus = mFeatureStatus;
                        return cicMultiStatus;
                    }
                }
                if (!uninstallFeatures.isEmpty()) {
                    ModifyJob uninstallJob = new ModifyJob(job.getProfile(), (IOfferingOrFix)job.getOffering(), uninstallFeatures, AgentJob.AgentJobType.UNINSTALL_JOB);
                    derivedUninstallJobs.add(uninstallJob);
                }
                ++n5;
            }
            AgentJob[] uninstallJobs = AgentJob.toArray(derivedUninstallJobs);
            SubMonitor sm = SubMonitor.convert((IProgressMonitor)spm.next(), (int)(agentJobs.length + uninstallJobs.length));
            AgentListener listener = new AgentListener();
            this.registerAgentNotifications(agent, listener);
            status.add(agent.install(agentJobs, (IProgressMonitor)sm.newChild(agentJobs.length)));
            this.deregisterAgentListener(agent, listener);
            if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                CicMultiStatus cicMultiStatus = status;
                return cicMultiStatus;
            }
            this.outputCompletedAgentJobs(agent, agentJobs);
            if (uninstallJobs.length == 0) return status;
            status.add(agent.uninstall(uninstallJobs, (IProgressMonitor)sm.newChild(uninstallJobs.length)));
            return status;
        }
        finally {
            try {
                status.add(agent.unprepare(agentJobs, spm.next()));
            }
            finally {
                spm.done();
                monitor.done();
            }
        }
    }

    private String getPortableSharedLocation(AgentJob[] agentJobs) {
        return AgentUtil.genPortableSharedLocation(agentJobs[0].getProfile().getInstallLocation());
    }

    private void deregisterAgentListener(Agent agent, AgentListener listener) {
        agent.getEventManager().removeInstallOfferingOrFixListener(listener);
        agent.getEventManager().removeBeginFetchOfferingOrFixListener(listener);
        agent.getEventManager().removeFetchCompletedOfferingOrFixListener(listener);
    }

    private void registerAgentNotifications(Agent agent, AgentListener listener) {
        agent.getEventManager().addInstallOfferingOrFixListener(listener);
        agent.getEventManager().addBeginFetchOfferingOrFixListener(listener);
        agent.getEventManager().addFetchCompletedOfferingOrFixListener(listener);
    }

    private IStatus checkJob(Agent agent, AgentJob agentJob, Set offeringsSeenBefore, IProgressMonitor monitor) {
        CicMultiStatus status = Statuses.ST.createMultiStatus();
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, new int[]{1, 1});
        try {
            status.add(agent.evaluatePrecheckBundles(agentJob.getOfferingOrFix(), agentJob));
            if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                CicMultiStatus cicMultiStatus = status;
                return cicMultiStatus;
            }
            status.add(agent.checkAgentRequirement(agentJob.getOfferingOrFix(), true));
            if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                CicMultiStatus cicMultiStatus = status;
                return cicMultiStatus;
            }
            if (agentJob.isInstall() || agentJob.isUpdate() || agentJob.isRollback()) {
                status.add(agent.evaluatePrereqBundles(agentJob.getOfferingOrFix(), agentJob));
                if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                    CicMultiStatus cicMultiStatus = status;
                    return cicMultiStatus;
                }
            }
            IProgressMonitor resolveMon = spm.next();
            IOfferingOrFix offeringOrFix = agentJob.getOfferingOrFix();
            if (offeringOrFix != null && !this.isAcceptLicense() && !agentJob.isModify() && !agentJob.isRollback() && this.hasLicenseText(offeringOrFix)) {
                ICicStatus iCicStatus = Statuses.ERROR.get(521, Messages.InstallCommand_AcceptLicense, new Object[]{offeringOrFix.getName()});
                return iCicStatus;
            }
            IOffering offering = agentJob.getOffering();
            if (offering != null) {
                status.add(agentJob.resolveFeatureIds(agent, resolveMon));
                if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                    CicMultiStatus cicMultiStatus = status;
                    return cicMultiStatus;
                }
                status.add(InstallCommand.checkUninstallableFeatures(agent, agentJob));
                if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                    CicMultiStatus cicMultiStatus = status;
                    return cicMultiStatus;
                }
            }
            if (agentJob.isInstall() || agentJob.isUpdate() || agentJob.isRollback() || agentJob.isUninstall()) {
                status.add(InstallCommand.checkPrerequisite(agent, agentJob, offeringsSeenBefore, spm.next()));
                if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                    CicMultiStatus cicMultiStatus = status;
                    return cicMultiStatus;
                }
            }
            status.add(agentJob.checkOfferingApplicability());
            if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                CicMultiStatus cicMultiStatus = status;
                return cicMultiStatus;
            }
            resolveMon.done();
        }
        finally {
            spm.done();
            monitor.done();
        }
        return status;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected AgentJob[] getAsInputJob(Agent agent, XMLElement unit, boolean isWizardMode, Profile defaultProfile) {
        idString = unit.getAttribute("id");
        versionString = unit.getAttribute("version");
        profileId = unit.getAttribute("profile");
        selectedStr = unit.getAttribute("selected");
        installFixesStr = unit.getAttribute("installFixes");
        installFixesSpecified = installFixesStr != null;
        showFixesStr = unit.getAttribute("showFixes");
        showFixesSpecified = showFixesStr != null;
        expandFeatureTreeStr = unit.getAttribute("expandFeatureTree");
        installLocation = unit.getAttribute("installLocation");
        v0 = selected = selectedStr == null ? true : Boolean.valueOf(selectedStr);
        if (installFixesStr != null && !InstallFixesAction.isValidInstallFixesString(installFixesStr)) {
            if (isWizardMode) {
                return ErrorJob.create(false, Messages.AbstractInstallWizard_InvalidValueInstallFixes, new Object[]{installFixesStr, "installFixes"});
            }
            return ErrorJob.create(false, Messages.AbstractInstallCommand_InvalidValueInstallFixes, new Object[]{installFixesStr, "installFixes"});
        }
        if (showFixesStr != null && !InstallFixesAction.isValidInstallFixesString(showFixesStr)) {
            return ErrorJob.create(false, Messages.AbstractInstallCommand_InvalidValueInstallFixes, new Object[]{showFixesStr, "showFixes"});
        }
        if (expandFeatureTreeStr != null && !expandFeatureTreeStr.equalsIgnoreCase(Boolean.FALSE.toString()) && !expandFeatureTreeStr.equalsIgnoreCase(Boolean.TRUE.toString())) {
            return ErrorJob.create(false, Messages.AbstractInstallCommand_InvalidValueExpandFeatureTree, new Object[]{expandFeatureTreeStr, "expandFeatureTree"});
        }
        if (idString == null) {
            return AgentJob.NO_JOBS;
        }
        this.setAgentUpdate("com.ibm.cic.agent".equals(idString));
        if (this.shouldIgnoreOffering(idString, versionString)) {
            return AgentJob.NO_JOBS;
        }
        offeringOrFixes = new ArrayList<E>();
        modifyProfile = null;
        identity = new SimpleIdentity(idString);
        if (!isWizardMode && this.isModify()) {
            if (installLocation != null && !installLocation.isEmpty()) {
                modifyProfile = agent.getProfileByInstallLocation(installLocation);
            } else {
                profiles = agent.getProfilesByOfferingOrFixId(idString);
                if (profiles.size() == 1) {
                    modifyProfile = (Profile)profiles.get(0);
                    installLocation = modifyProfile.getInstallLocation();
                } else if (profiles.size() > 1 && versionString != null && !versionString.isEmpty()) {
                    i = 0;
                    while (i < profiles.size()) {
                        offering = agent.getInstalledOffering((Profile)profiles.get(i), (IIdentity)identity);
                        if (offering != null && offering.getVersion().equals((Object)Version.parseVersion((String)versionString))) {
                            modifyProfile = (Profile)profiles.get(i);
                            installLocation = modifyProfile.getInstallLocation();
                            break;
                        }
                        ++i;
                    }
                }
            }
            if (modifyProfile != null) {
                if (versionString == null || versionString.isEmpty()) {
                    versionString = agent.getInstalledOffering(modifyProfile, (IIdentity)identity).getVersion().toString();
                }
                profileId = modifyProfile.getProfileId();
            }
        }
        if (!(showFixesValueCheckStatus = InstallFixesAction.isValidShowFixesValue(ifAction = InstallFixesAction.getInstallFixesAction(installFixesStr, versionString != null), sfAction = this.calculateShowFixesAction(showFixesStr, ifAction), installFixesSpecified, showFixesSpecified)).isOK()) {
            return ErrorJob.create(false, showFixesValueCheckStatus);
        }
        explicitOfferingOrFix = null;
        if (versionString != null) {
            try {
                explicitOfferingOrFix = this.getOfferingOrFix(agent, idString, versionString, this.isModify(), profileId);
                betaCheckStatus = Agent.getInstance().checkBetaRequirement(explicitOfferingOrFix);
                if (!betaCheckStatus.isOK()) {
                    return ErrorJob.create(false, betaCheckStatus);
                }
                offeringOrFixes.add(explicitOfferingOrFix);
                if (!(explicitOfferingOrFix instanceof IOffering)) ** GOTO lbl94
                applicableFixes = agent.addApplicableFixes((IOffering)explicitOfferingOrFix, null, sfAction);
                offeringOrFixes.addAll(applicableFixes);
            }
            catch (HeadlessApplicationException e) {
                if (e.getStatus() != null) {
                    return ErrorJob.create(false, e.getStatus());
                }
                return ErrorJob.create(false, e.getMessage(), new Object[0]);
            }
        } else {
            if (!isWizardMode && this.isModify() && modifyProfile != null) {
                offering = agent.getInstalledOffering(modifyProfile, (IIdentity)identity);
                if (offering != null) {
                    offeringOrFixes.add((IOfferingOrFix)offering);
                }
            } else {
                offeringOrFixes = agent.findLatestOfferingOrUpdateFix(idString, null, sfAction);
                if (!offeringOrFixes.isEmpty()) {
                    explicitOfferingOrFix = (IOfferingOrFix)offeringOrFixes.get(0);
                }
            }
            if (offeringOrFixes.isEmpty()) {
                if ("com.ibm.cic.agent".equals(idString) && this.getInput().isAgentRepoSkipped()) {
                    return AgentJob.NO_JOBS;
                }
                fileName = this.getInput().getInputFilePath();
                if (fileName != null) {
                    return ErrorJob.create(false, Messages.AbstractCommand_Cannot_Find_Offering_Or_Fix_InFile, new Object[]{idString, this.getInput().getInputFilePath()});
                }
                return ErrorJob.create(false, Messages.AbstractCommand_Cannot_Find_Offering_Or_Fix, new Object[]{idString});
            }
            checkOffering = null;
            for (IOfferingOrFix offeringOrFix : offeringOrFixes) {
                if (!(offeringOrFix instanceof IOffering)) continue;
                checkOffering = (IOffering)offeringOrFix;
                break;
            }
            if (checkOffering != null && !(betaStatus = Agent.getInstance().checkBetaRequirement((IOfferingOrFix)checkOffering)).isOK()) {
                return ErrorJob.create(false, betaStatus.getMessage(), new Object[0]);
            }
        }
lbl94:
        // 4 sources

        if (!(installFixesCheckStatus = InstallCommand.checkIfInstallFixesSpecifiedForFix(explicitOfferingOrFix, installFixesSpecified, "installFixes")).isOK()) {
            return ErrorJob.create(false, installFixesCheckStatus.getMessage(), new Object[0]);
        }
        showFixesCheckStatus = InstallCommand.checkIfInstallFixesSpecifiedForFix(explicitOfferingOrFix, showFixesSpecified, "showFixes");
        if (!showFixesCheckStatus.isOK()) {
            return ErrorJob.create(false, showFixesCheckStatus.getMessage(), new Object[0]);
        }
        agentJobs = new ArrayList<AgentJob>();
        lastProfile = null;
        for (IOfferingOrFix offeringOrFix : offeringOrFixes) {
            block70: {
                profile = null;
                profile = this.getProfileFromOfferingOrFix(offeringOrFix, installLocation, lastProfile, agent, isWizardMode, defaultProfile, profileId);
                if (offeringOrFix instanceof IOffering && profile != null && profile.getInstallLocation() == null && !LicenseUtils.isPEKOffering((IOffering)((IOffering)offeringOrFix))) {
                    try {
                        defaultInstallLocation = profile.getDefaultInstallLocation((IOffering)offeringOrFix);
                        if (defaultInstallLocation != null) {
                            profile.setInstallLocation(defaultInstallLocation);
                            break block70;
                        }
                        return ErrorJob.create(false, Messages.InstallCommand_NoInstallationLocation, new Object[]{offeringOrFix.getIdentity().getId(), offeringOrFix.getVersion().toString()});
                    }
                    catch (AbstractVariableSubstitution.VariableSubstitutionException e) {
                        return ErrorJob.create(false, e.getLocalizedMessage(), new Object[0]);
                    }
                }
            }
            if (offeringOrFix instanceof IFix) {
                if (profile == null && !isWizardMode) {
                    return ErrorJob.create(true, Messages.HeadlessApplication_Cannot_Find_Profile, new Object[]{profileId});
                }
                installJob = new InstallJob(profile, offeringOrFix);
                if (offeringOrFix != explicitOfferingOrFix) {
                    this.setFixJobSelectedStatus(installJob, ifAction);
                }
                if (offeringOrFix == explicitOfferingOrFix) {
                    agentJobs.add(installJob);
                } else if (BitModeUtils.checkFixSupportedPlatforms((IFix)offeringOrFix, (IOffering)explicitOfferingOrFix)) {
                    agentJobs.add(installJob);
                }
            } else if (offeringOrFix instanceof IOffering) {
                offering = (IOffering)offeringOrFix;
                fromOffering = profile == null ? null : profile.getInstallRegistry().getInstalledOffering(offering.getIdentity());
                job = null;
                if (!isWizardMode && fromOffering != null) {
                    cmp = offering.compareVersion((IContent)fromOffering);
                    if (cmp > 0) {
                        job = new UpdateOfferingJob(profile, offering, fromOffering);
                    } else if (cmp < 0) {
                        if (!agent.isAgentOffering(offeringOrFix)) {
                            try {
                                offering = this.getInstalledOffering(agent, profile, idString, versionString);
                            }
                            catch (HeadlessApplicationException e) {
                                return ErrorJob.create(false, e.getStatus());
                            }
                            if (offering == null) {
                                return ErrorJob.create(true, Messages.RollbackCommand_NotInstalled, new Object[]{idString, versionString});
                            }
                            if (!agent.isRollbackAllowed(profile, offering)) {
                                return ErrorJob.create(true, Messages.RollbackCommand_NotAllowed, new Object[]{idString, versionString});
                            }
                        }
                        job = new RollbackJob(profile, (IOfferingOrFix)offering, fromOffering);
                    }
                }
                if (job == null) {
                    if (fromOffering != null && this.getInput() != null && StatusUtil.isErrorOrCancel((IStatus)(status = this.getInput().executeProfileCommands(agent, true, (IProgressMonitor)new NullProgressMonitor())))) {
                        return ErrorJob.create(false, status.getMessage(), new Object[0]);
                    }
                    if (profile == null && !isWizardMode) {
                        return ErrorJob.create(true, AgentUtil.makeUnresolvedRequirementsError(offering), new Object[0]);
                    }
                    if ((fromOffering != null || this.isModify()) && !isWizardMode) {
                        job = new ModifyJob(profile, (IOfferingOrFix)offering, AgentJob.AgentJobType.INSTALL_JOB);
                    } else {
                        job = new InstallJob(profile, (IOfferingOrFix)offering);
                        ((InstallJob)job).setInstallLocation(unit.getAttribute("installLocation"));
                        if (fromOffering != null) {
                            ((InstallJob)job).setExistingOffering(fromOffering);
                        }
                    }
                }
                if (!(job instanceof RollbackJob) || !agent.isAgentOffering(offeringOrFix)) {
                    agentJobs.add(job);
                    job.setFeatureIds(unit.getAttribute("features"));
                }
                if (isWizardMode && LicenseUtils.isOfferingLumApplicable((IOffering)offering)) {
                    job.setPEKOffering(this.findPEKLicense(agent, offering));
                }
                if (expandFeatureTreeStr != null) {
                    job.setExpandFeatureTree(Boolean.valueOf(expandFeatureTreeStr));
                }
            } else {
                throw new AssertionError((Object)"Bad result from getOfferingOrFix");
            }
            if (profile != null) {
                stat = this.setProfileData(profile);
                if (!stat.isOK()) {
                    return ErrorJob.create(true, stat);
                }
                if (agent.isAgentOffering(offeringOrFix)) {
                    supportedLangSet = OfferingProperty.getSupportedLocales((IOffering)((IOffering)offeringOrFix));
                    supportedLangString = ProfileLanguageUtils.convertCodeSetToString((Set)supportedLangSet);
                    profile.setData("cic.selector.nl", supportedLangString);
                }
            }
            lastProfile = profile;
        }
        for (AgentJob agentJob : agentJobs) {
            if (selected) continue;
            agentJob.setSelected(selected);
        }
        return AgentJob.toArray(agentJobs);
    }

    private InstallFixesAction calculateShowFixesAction(String showFixesStr, InstallFixesAction ifAction) {
        InstallFixesAction sfAction = null;
        boolean showFixesSpecified = showFixesStr != null;
        sfAction = showFixesSpecified ? InstallFixesAction.getInstallFixesAction(showFixesStr) : ifAction;
        return sfAction;
    }

    private void setFixJobSelectedStatus(InstallJob fixJob, InstallFixesAction ifAction) {
        if (InstallFixesAction.ALL.equals(ifAction)) {
            fixJob.setSelected(true);
        } else if (InstallFixesAction.RECOMMENDED.equals(ifAction)) {
            if (FixProperty.isRecommended((IFix)fixJob.getFix())) {
                fixJob.setSelected(true);
            } else {
                fixJob.setSelected(false);
            }
        } else if (InstallFixesAction.NONE.equals(ifAction)) {
            fixJob.setSelected(false);
        }
    }

    private Profile getProfileFromOfferingOrFix(IOfferingOrFix offeringOrFix, String installLocation, Profile lastProfile, Agent agent, boolean isWizardMode, Profile defaultProfile, String profileId) {
        Profile profile;
        if (offeringOrFix instanceof IOffering && LicenseUtils.isPEKOffering((IOffering)((IOffering)offeringOrFix))) {
            profile = Profile.getLicenseProfile(agent);
        } else {
            String pId = profileId != null ? profileId : OfferingProperty.getDefaultProfile((IOfferingOrFix)offeringOrFix);
            profile = this.getProfileFromAgent(agent, pId, installLocation, offeringOrFix);
            Profile profile2 = profile = profile == null ? lastProfile : profile;
            if (profile == null && offeringOrFix instanceof IOffering && Agent.isExtensionOffering(offeringOrFix)) {
                profile = defaultProfile;
            }
            if (!isWizardMode && profile == null) {
                if (offeringOrFix instanceof IOffering && !Agent.isExtensionOffering(offeringOrFix)) {
                    boolean noAlternativeLocation = profileId == null;
                    profile = Profile.makeNewProfileForOffering((IOffering)offeringOrFix, profileId, installLocation, noAlternativeLocation);
                    this.setProfileData(profile, true);
                    agent.addProfile(profile);
                    if (installLocation == null) {
                        this.newDefaultProfiles.put(profile, noAlternativeLocation);
                    }
                } else {
                    profile = defaultProfile;
                }
            }
        }
        return profile;
    }

    private Profile getProfileFromAgent(Agent agent, String profileId, String installLocation, IOfferingOrFix offeringOrFix) {
        Profile return_value = null;
        if (agent.isAgentOffering(offeringOrFix)) {
            return_value = agent.getAgentProfile();
        } else {
            if (profileId != null && (return_value = agent.getProfile(profileId)) != null && installLocation != null && !installLocation.equals(return_value.getInstallLocation())) {
                return_value = null;
            }
            if (return_value == null && installLocation != null) {
                return_value = agent.getProfileByInstallLocation(installLocation);
            }
        }
        return return_value;
    }

    @Override
    public AgentJob[] getAsInputJobs(Agent agent, boolean isWizardMode) {
        AgentJob[] jobs;
        ArrayList<AgentJob> result = new ArrayList<AgentJob>();
        ArrayList elementsWithProfileError = new ArrayList();
        Profile defaultProfile = null;
        HashMap<IIdentity, Boolean> fixImplicitlyAddedMap = new HashMap<IIdentity, Boolean>();
        ResponseFileModel model = new ResponseFileModel();
        this.newDefaultProfiles.clear();
        for (XMLElement child : this.children()) {
            jobs = this.getAsInputJob(agent, child, isWizardMode, defaultProfile);
            if (jobs.length <= 0 || this.checkForProfileError(jobs, child, elementsWithProfileError, isWizardMode)) continue;
            ArrayList<AgentJob> tempResult = new ArrayList<AgentJob>();
            this.addJobsToResult(tempResult, jobs, fixImplicitlyAddedMap);
            result.addAll(tempResult);
            model.sortSingleResponseFileEntryJobs(jobs);
            defaultProfile = this.resetDefaultProfile(defaultProfile, tempResult);
        }
        for (XMLElement element : elementsWithProfileError) {
            jobs = this.getAsInputJob(agent, element, isWizardMode, defaultProfile);
            this.addJobsToResult(result, jobs, fixImplicitlyAddedMap);
            model.sortSingleResponseFileEntryJobs(jobs);
        }
        List<AgentJob> explicitJobs = model.getExplicitJobs();
        this.initializeProfilePlatformProperties(AgentJob.toArray(explicitJobs));
        this.setProfileInstallLocationForBitMode();
        model.deselectPlatformIncompatibleImplicitJobs();
        AgentJob[] finalResult = model.getAllJobs();
        Profile.setLicenseProfileInstallLocation();
        this.setAcceptLicense(finalResult);
        return finalResult;
    }

    private void setProfileInstallLocationForBitMode() {
        for (Map.Entry<Profile, Boolean> entry : this.newDefaultProfiles.entrySet()) {
            Profile profile = entry.getKey();
            boolean wantNonConflicting = entry.getValue() == false;
            BitModeUtils.setProfileInstallLocationForBitMode(profile, wantNonConflicting);
        }
        this.newDefaultProfiles.clear();
    }

    private Profile resetDefaultProfile(Profile defaultProfile, List<AgentJob> tempResult) {
        int i = 0;
        while (defaultProfile == null && i < tempResult.size()) {
            Profile profile = tempResult.get(i).getProfile();
            if (profile != null && !profile.isAgentProfile()) {
                defaultProfile = profile;
            }
            ++i;
        }
        return defaultProfile;
    }

    private boolean checkForProfileError(AgentJob[] jobs, XMLElement child, List elementsWithProfileError, boolean isWizardMode) {
        IOffering offering;
        AgentJob firstJob = jobs[0];
        if (!isWizardMode && firstJob.isError()) {
            if (((ErrorJob)firstJob).isProfileError()) {
                elementsWithProfileError.add(child);
                return true;
            }
        } else if ((firstJob.getProfile() == null || firstJob.getProfile().isPhantom()) && (offering = firstJob.getOffering()) != null && Agent.isExtensionOffering((IOfferingOrFix)offering)) {
            elementsWithProfileError.add(child);
            return true;
        }
        return false;
    }

    private void addJobsToResult(List result, AgentJob[] jobs, Map<IIdentity, Boolean> fixImplicitlyAddedMap) {
        if (jobs != null && jobs.length > 0) {
            boolean currentFixImplicitlyAdded = jobs[0].getOffering() != null;
            AgentJob[] agentJobArray = jobs;
            int n = jobs.length;
            int n2 = 0;
            while (n2 < n) {
                AgentJob job = agentJobArray[n2];
                IFix fix = job.getFix();
                if (fix == null || !this.isSkippableFix(fix, currentFixImplicitlyAdded, fixImplicitlyAddedMap)) {
                    result.add(job);
                }
                ++n2;
            }
        }
    }

    private boolean isSkippableFix(IFix fix, boolean currentFixImplicitlyAdded, Map<IIdentity, Boolean> fixImplicitlyAddedMap) {
        IIdentity currentIdentity = fix.getIdentity();
        if (!fixImplicitlyAddedMap.containsKey(currentIdentity)) {
            fixImplicitlyAddedMap.put(currentIdentity, currentFixImplicitlyAdded);
            return false;
        }
        if (fixImplicitlyAddedMap.get(currentIdentity).equals(Boolean.TRUE)) {
            if (!currentFixImplicitlyAdded) {
                fixImplicitlyAddedMap.put(currentIdentity, Boolean.FALSE);
            }
            return true;
        }
        return currentFixImplicitlyAdded;
    }

    private IOffering findPEKLicense(Agent agent, IOffering offering) {
        List offerings = agent.getRepositoryGroup().getAllOfferings(null);
        for (IOffering foundOffering : offerings) {
            if (!LicenseUtils.isPEKOffering((IOffering)foundOffering) || !LicenseUtils.isPekApplicableToOffering((IOffering)foundOffering, (IOffering)offering)) continue;
            return foundOffering;
        }
        return null;
    }

    @Override
    public void addOffering(String id, String version, String profile, String features, InstallFixesAction installFixes) {
        super.addOffering(id, version, profile, features, installFixes);
    }

    @Override
    public void addOffering(String id, String version, String profile, String features, InstallFixesAction installFixes, InstallFixesAction showFixes) {
        this.addOfferingInternal(id, version, profile, features, null, true, installFixes, showFixes, null);
    }

    @Override
    public void addOffering(String id, String version, String profile, String features, boolean selected) {
        this.addOfferingInternal(id, version, profile, features, null, selected, null, null, null);
    }

    private static IStatus checkUninstallableFeatures(Agent agent, AgentJob job) {
        CicMultiStatus mStatus = Statuses.ST.createMultiStatus();
        if (job.isUpdate()) {
            Profile profile = job.getProfile();
            IOffering offering = agent.getInstalledOffering(profile, job.getOffering().getIdentity());
            Set installedFeatureSet = agent.getInstalledFeatures(profile, offering);
            List selectedFeatureList = job.getFeatures();
            for (IFeature installedFeature : installedFeatureSet) {
                IStatus status;
                if (selectedFeatureList.contains(installedFeature) || (status = agent.checkPrerequisite((IFeatureBase)installedFeature, job)).getSeverity() != 4 || !installedFeature.hasApplicabilityFlag(status, 4)) continue;
                mStatus.add(status);
            }
        }
        return mStatus;
    }

    private boolean shouldIgnoreOffering(String offeringId, String offeringVersion) {
        if (!"com.ibm.cic.agent".equals(offeringId) || offeringVersion == null) {
            return false;
        }
        IOffering agentOffering = Agent.getInstance().getAgentOffering();
        if (agentOffering == null) {
            return false;
        }
        try {
            return agentOffering.getVersion().compareTo(new Version(offeringVersion)) >= 0;
        }
        catch (IllegalArgumentException e) {
            ExceptionUtil.debugLogToReview((Throwable)e);
            return false;
        }
    }

    private boolean isValidInstallDirectoryForModify(String installationDirectory, List<InstallRegistry.ProfileInstallRegistry> installedLocations) {
        for (InstallRegistry.ProfileInstallRegistry location : installedLocations) {
            if (!FileUtil.filesAreSame((String)installationDirectory, (String)location.getProfile().getInstallLocation())) continue;
            return true;
        }
        return false;
    }

    private IStatus getInvalidnstallDirectoryError(IIdentity offeringId, Version offeringVersion) {
        String offeringIdVersion = offeringId.getId();
        if (offeringVersion != null) {
            offeringIdVersion = String.valueOf(offeringIdVersion) + "_" + offeringVersion.toString();
        }
        return Statuses.ERROR.get(Messages.Cmd_modifyInvalidInstallDirectoryError, new Object[]{offeringIdVersion});
    }

    private IStatus getMultipleInstancesError(IIdentity offeringId, Version offeringVersion, List<InstallRegistry.ProfileInstallRegistry> installedLocations, boolean isModify) {
        String offeringIdVersion = offeringId.getId();
        if (offeringVersion != null) {
            offeringIdVersion = String.valueOf(offeringIdVersion) + "_" + offeringVersion;
        }
        StringBuffer sb = new StringBuffer();
        for (InstallRegistry.ProfileInstallRegistry location : installedLocations) {
            sb.append(OutputFormatter.NEW_LINE_STR);
            sb.append(location.getProfile().getInstallLocation());
        }
        return Statuses.ERROR.get(isModify ? Messages.Cmd_modifyFeatures_multipleInstancesError : Messages.Cmd_install_multipleInstancesError, new Object[]{offeringIdVersion, sb.toString()});
    }

    private List searchInstalledLocations(IIdentity offeringId, Version offeringVersion, boolean isModify) {
        Collection<InstallRegistry.ProfileInstallRegistry> pirs = InstallRegistry.getInstance().getProfileInstallRegistries();
        ArrayList<InstallRegistry.ProfileInstallRegistry> installedLocations = new ArrayList<InstallRegistry.ProfileInstallRegistry>(pirs.size());
        for (InstallRegistry.ProfileInstallRegistry pir : pirs) {
            IOffering installedOffering = pir.getInstalledOffering(offeringId);
            if (installedOffering == null || offeringVersion != null && isModify && !offeringVersion.equals((Object)installedOffering.getVersion())) continue;
            installedLocations.add(pir);
        }
        return installedLocations;
    }

    @Override
    protected IStatus checkInstalledAtOneLocation(boolean isModify) {
        String installationDirectory = CmdLine.CL.getInstallationDirectory();
        boolean isInstanceFoundForModify = false;
        if (installationDirectory != null && !isModify) {
            return Status.OK_STATUS;
        }
        CicMultiStatus result = Statuses.OK.getMultiStatus();
        for (XMLElement child : this.children()) {
            List installedLocations;
            if (!child.getName().equals("offering")) continue;
            SimpleIdentity offeringId = new SimpleIdentity(child.getAttribute("id"));
            Version offeringVersion = null;
            String version = child.getAttribute("version");
            if (version != null && version.length() > 0) {
                offeringVersion = new Version(version);
            }
            if ((installedLocations = this.searchInstalledLocations((IIdentity)offeringId, offeringVersion, isModify)).size() > 1) {
                if (isModify) {
                    isInstanceFoundForModify = true;
                    if (installationDirectory == null) {
                        result.add(this.getMultipleInstancesError((IIdentity)offeringId, offeringVersion, installedLocations, isModify));
                    } else if (!this.isValidInstallDirectoryForModify(installationDirectory, installedLocations)) {
                        result.add(this.getInvalidnstallDirectoryError((IIdentity)offeringId, offeringVersion));
                    }
                } else {
                    if (offeringVersion != null) {
                        InstallRegistry.ProfileInstallRegistry pir = (InstallRegistry.ProfileInstallRegistry)installedLocations.get(0);
                        offeringVersion = Agent.getInstance().getInstalledOffering(pir.getProfile(), (IIdentity)offeringId).getVersion();
                    }
                    result.add(this.getMultipleInstancesError((IIdentity)offeringId, offeringVersion, installedLocations, isModify));
                }
            }
            if (!isModify || installedLocations.size() != 1) continue;
            isInstanceFoundForModify = true;
            if (installationDirectory == null || FileUtil.filesAreSame((String)installationDirectory, (String)((InstallRegistry.ProfileInstallRegistry)installedLocations.get(0)).getProfile().getInstallLocation())) continue;
            result.add(this.getInvalidnstallDirectoryError((IIdentity)offeringId, offeringVersion));
            break;
        }
        if (isModify && !isInstanceFoundForModify) {
            if (Agent.getInstance().isSkipInstall() && Agent.getInstance().isRecordMode()) {
                result.add((IStatus)Statuses.ERROR.get(Messages.Cmd_modifyIInvalidAppDataError, new Object[0]));
            } else {
                result.add((IStatus)Statuses.ERROR.get(Messages.Cmd_modifyINoInstanceFoundError, new Object[0]));
            }
        }
        return result;
    }

    private IOfferingOrFix findOfferingOrFix(Agent agent, String id, String version, IProgressMonitor monitor) {
        if (version == null) {
            List aList = agent.findLatestOfferingOrUpdateFix(id, monitor, InstallFixesAction.NONE);
            if (aList.size() > 0) {
                return (IOfferingOrFix)aList.get(0);
            }
        } else {
            try {
                return this.getOfferingOrFix(agent, id, version, this.isModify(), null);
            }
            catch (HeadlessApplicationException headlessApplicationException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    protected List getOfferingsToOpenServiceRepositories(Agent agent, String id, String version, IProgressMonitor monitor) {
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, 3);
        List offerings = super.getOfferingsToOpenServiceRepositories(agent, id, version, spm.next());
        IOfferingOrFix offeringOrFix = this.findOfferingOrFix(agent, id, version, spm.next());
        if (offeringOrFix == null && version != null) {
            offeringOrFix = this.findOfferingOrFix(agent, id, null, spm.next());
        }
        if (offeringOrFix instanceof IOffering) {
            offerings.add(offeringOrFix);
        }
        spm.done();
        return offerings;
    }

    private static class ResponseFileModel {
        private final List<AgentJob> errorJobs = new ArrayList<AgentJob>();
        private final List<AgentJob> orderedInitialJobs = new ArrayList<AgentJob>();
        private final Map<Profile, ResponseFileProfileModel> profileMap = new HashMap<Profile, ResponseFileProfileModel>();

        private ResponseFileModel() {
        }

        private List<AgentJob> getErrorJobs() {
            return this.errorJobs;
        }

        public void sortSingleResponseFileEntryJobs(AgentJob[] jobs) {
            this.orderedInitialJobs.addAll(Arrays.asList(jobs));
            boolean isFixesImplicitlyDefined = jobs[0].getOffering() != null;
            AgentJob[] agentJobArray = jobs;
            int n = jobs.length;
            int n2 = 0;
            while (n2 < n) {
                AgentJob job = agentJobArray[n2];
                Profile profile = job.getProfile();
                IOfferingOrFix oof = job.getOfferingOrFix();
                if (job.isError()) {
                    this.errorJobs.add(job);
                } else {
                    ResponseFileProfileModel profileModel = this.retrieveMapEntry(profile);
                    if (oof instanceof IOffering) {
                        profileModel.addExplicitJob(job);
                    } else if (oof instanceof IFix) {
                        if (!isFixesImplicitlyDefined) {
                            profileModel.addExplicitJob(job);
                        } else {
                            profileModel.addImplicitJob(job);
                        }
                    }
                }
                ++n2;
            }
        }

        public List<AgentJob> getExplicitJobs() {
            ArrayList<AgentJob> explicitJobs = new ArrayList<AgentJob>();
            for (ResponseFileProfileModel profileModel : this.profileMap.values()) {
                explicitJobs.addAll(profileModel.getExplicitJobs());
            }
            return explicitJobs;
        }

        public void deselectPlatformIncompatibleImplicitJobs() {
            for (ResponseFileProfileModel profileModel : this.profileMap.values()) {
                profileModel.deselectPlatformIncompatibleImplicitJobs();
            }
        }

        public List<AgentJob> getImplicitJobs() {
            ArrayList<AgentJob> result = new ArrayList<AgentJob>();
            for (ResponseFileProfileModel profileModel : this.profileMap.values()) {
                result.addAll(profileModel.getImplicitJobs());
            }
            return result;
        }

        public AgentJob[] getAllJobs() {
            ArrayList<AgentJob> result = new ArrayList<AgentJob>();
            ArrayList<AgentJob> orderedResult = new ArrayList<AgentJob>();
            result.addAll(this.getExplicitJobs());
            result.addAll(this.getImplicitJobs());
            result.addAll(this.getErrorJobs());
            for (AgentJob job : this.orderedInitialJobs) {
                if (!result.contains(job)) continue;
                orderedResult.add(job);
            }
            return AgentJob.toArray(orderedResult);
        }

        private ResponseFileProfileModel retrieveMapEntry(Profile profile) {
            if (!this.profileMap.containsKey(profile)) {
                this.profileMap.put(profile, new ResponseFileProfileModel(profile));
            }
            return this.profileMap.get(profile);
        }
    }

    private static class ResponseFileProfileModel {
        private final Profile profile;
        private final Map<IIdentity, List<AgentJob>> explicitJobMapPerIdentity = new HashMap<IIdentity, List<AgentJob>>();
        private final Map<IIdentity, AgentJob> implicitJobMapPerIdentity = new HashMap<IIdentity, AgentJob>();

        public ResponseFileProfileModel(Profile profile) {
            this.profile = profile;
        }

        public void addExplicitJob(AgentJob job) {
            IIdentity identity = job.getOfferingOrFix().getIdentity();
            List<AgentJob> explicitJobsList = this.retrieveMapEntry(this.explicitJobMapPerIdentity, identity);
            explicitJobsList.add(job);
            if (this.implicitJobMapPerIdentity.containsKey(identity)) {
                this.implicitJobMapPerIdentity.remove(identity);
            }
        }

        public void addImplicitJob(AgentJob job) {
            IIdentity identity = job.getOfferingOrFix().getIdentity();
            if (!this.explicitJobMapPerIdentity.containsKey(identity) && !this.implicitJobMapPerIdentity.containsKey(identity)) {
                this.implicitJobMapPerIdentity.put(identity, job);
            }
        }

        private List<AgentJob> retrieveMapEntry(Map<IIdentity, List<AgentJob>> map, IIdentity identity) {
            if (!map.containsKey(identity)) {
                ArrayList<AgentJob> newValue = new ArrayList<AgentJob>();
                map.put(identity, newValue);
                return newValue;
            }
            return map.get(identity);
        }

        public List<AgentJob> getExplicitJobs() {
            return this.getAllJobsFromMap(this.explicitJobMapPerIdentity);
        }

        private List<AgentJob> getAllJobsFromMap(Map<IIdentity, List<AgentJob>> map) {
            ArrayList<AgentJob> result = new ArrayList<AgentJob>();
            for (List<AgentJob> jobList : map.values()) {
                result.addAll(jobList);
            }
            return result;
        }

        public Collection<AgentJob> deselectPlatformIncompatibleImplicitJobs() {
            for (Map.Entry<IIdentity, AgentJob> entry : this.implicitJobMapPerIdentity.entrySet()) {
                AgentJob job = entry.getValue();
                IOfferingOrFix oof = job.getOfferingOrFix();
                if (BitModeUtils.isOfferingOrFixSupportedOnProfile(oof, this.profile)) continue;
                job.setSelected(false);
            }
            return this.implicitJobMapPerIdentity.values();
        }

        public Collection<AgentJob> getImplicitJobs() {
            return this.implicitJobMapPerIdentity.values();
        }
    }
}

