/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.custompanel.api;

import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.api.ICustomPanelData;
import com.ibm.cic.agent.core.api.IProfile;
import com.ibm.cic.agent.core.custompanel.api.TemplateCustomPanel;
import com.ibm.cic.agent.core.custompanel.api.TemplateSelectableWidget;
import com.ibm.cic.agent.core.custompanel.api.TemplateSelectableWidgetContainer;
import com.ibm.cic.agent.core.custompanel.api.TemplateWidget;
import com.ibm.cic.agent.core.custompanel.api.TemplateWidgetContainer;
import com.ibm.cic.agent.core.custompanel.api.TemplateWritableWidget;
import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.RuntimeStatusException;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;

public final class CustomPanelWrapper {
    private final TemplateCustomPanel panel;
    private boolean initializing;
    private final Map<String, TemplateWritableWidget> userDataToWidgetMap = new HashMap<String, TemplateWritableWidget>();

    public CustomPanelWrapper(TemplateCustomPanel panel) {
        this.panel = panel;
    }

    public Map<String, IStatus> validateInteractiveMode(IProgressMonitor monitor) {
        return this.validatePanel(TemplateCustomPanel.ProfileOnlyUserData.class, monitor);
    }

    public Map<String, IStatus> validateSilentMode(IProgressMonitor monitor) {
        return this.validatePanel(TemplateCustomPanel.WidgetOnlyUserData.class, monitor);
    }

    public void createWidgets(TemplateWidgetContainer parentContainer) {
        try {
            this.panel.createWidgets(parentContainer);
            this.userDataToWidgetMap.clear();
            this.checkUserDataWidgetBinding(parentContainer);
        }
        catch (Throwable e) {
            throw new RuntimeStatusException(SharedUIUtils.generateCustomPanelExceptionStatus(this.panel, e));
        }
    }

    private void checkUserDataWidgetBinding(TemplateWidgetContainer container) throws UserDataBoundToMultiWidgetException {
        List<? extends TemplateWidget> children = container.getChildren();
        for (TemplateWidget templateWidget : children) {
            if (templateWidget instanceof TemplateWritableWidget) {
                TemplateWritableWidget widgetWithUserData = (TemplateWritableWidget)templateWidget;
                TemplateCustomPanel.UserData userData = widgetWithUserData.getUserData();
                TemplateWritableWidget previouslyBoundWidget = this.userDataToWidgetMap.put(userData.getId(), widgetWithUserData);
                if (previouslyBoundWidget != null) {
                    throw new UserDataBoundToMultiWidgetException(NLS.bind((String)"User data {0} is associated with multiple widgets.", (Object)userData.getId()));
                }
                if (widgetWithUserData instanceof TemplateSelectableWidgetContainer) {
                    TemplateSelectableWidgetContainer selectableContainer = (TemplateSelectableWidgetContainer)widgetWithUserData;
                    List<TemplateSelectableWidget> items = selectableContainer.getItems();
                    for (TemplateSelectableWidget item : items) {
                        this.checkUserDataSelectableWidgetBinding(item);
                    }
                    continue;
                }
                if (!(widgetWithUserData instanceof TemplateSelectableWidget)) continue;
                TemplateSelectableWidget selectableWidget = (TemplateSelectableWidget)templateWidget;
                this.checkUserDataSelectableWidgetBinding(selectableWidget);
                continue;
            }
            if (!(templateWidget instanceof TemplateWidgetContainer)) continue;
            TemplateWidgetContainer childrenContainer = (TemplateWidgetContainer)templateWidget;
            this.checkUserDataWidgetBinding(childrenContainer);
        }
    }

    private void checkUserDataSelectableWidgetBinding(TemplateSelectableWidget selectableWidget) throws UserDataBoundToMultiWidgetException {
        Set<TemplateWidgetContainer> containers = selectableWidget.getChildren().keySet();
        for (TemplateWidgetContainer childrenContainer : containers) {
            this.checkUserDataWidgetBinding(childrenContainer);
        }
    }

    public void updateWidgets(TemplateCustomPanel.UserData userData) {
        if (this.initializing) {
            return;
        }
        try {
            this.panel.updateWidgets(userData);
        }
        catch (Throwable e) {
            throw new RuntimeStatusException(SharedUIUtils.generateCustomPanelExceptionStatus(this.panel, e));
        }
    }

    public void startInitializing() {
        this.initializing = true;
    }

    public void endInitializing() {
        this.initializing = false;
    }

    public boolean shouldSkip() {
        return this.panel.shouldSkip();
    }

    public String getPanelTitle() {
        return this.panel.getPanelTitle();
    }

    public void initCustomPanelData(ICustomPanelData data) {
        this.panel.initCustomPanelData(data);
    }

    public ICustomPanelData getCustomPanelData() {
        return this.panel.getCustomPanelData();
    }

    public boolean canAddPanelToWizard() {
        return this.panel.canAddPanelToWizard();
    }

    public IStatus performFinish(IProgressMonitor monitor) {
        return this.panel.performFinish(monitor);
    }

    public void setOfferingId(String offeringId) {
        this.panel.setOfferingId(offeringId);
    }

    public String getOfferingId() {
        return this.panel.getOfferingId();
    }

    public String getProfileKey(String userDataId) {
        String offeringId = this.panel.getOfferingId();
        return offeringId == null ? userDataId : Profile.createKey(userDataId, offeringId);
    }

    public String getHelpRef() {
        return this.panel.getHelpRef();
    }

    public Collection<TemplateCustomPanel.AbstractUserData> getProfileUserData() {
        return this.getUserData(TemplateCustomPanel.WidgetOnlyUserData.class);
    }

    public void loadProfilePropertyValues() {
        for (TemplateCustomPanel.AbstractUserData userData : this.getUserData(TemplateCustomPanel.WidgetOnlyUserData.class)) {
            String value = this.getValueFromProfile(userData.getId());
            if (value == null) continue;
            userData.setValue(value);
        }
        try {
            this.panel.preProcessUserData();
        }
        catch (Throwable e) {
            throw new RuntimeStatusException(SharedUIUtils.generateCustomPanelExceptionStatus(this.panel, e));
        }
    }

    public void storeProfilePropertyValues() {
        try {
            this.panel.postProcessUserData();
        }
        catch (Throwable e) {
            throw new RuntimeStatusException(SharedUIUtils.generateCustomPanelExceptionStatus(this.panel, e));
        }
        for (TemplateCustomPanel.AbstractUserData userData : this.getUserData(TemplateCustomPanel.WidgetOnlyUserData.class)) {
            this.setValueToProfile(userData.getId(), userData.getValueChars());
        }
    }

    private String getValueFromProfile(String propertyKey) {
        IProfile profile = this.panel.getCustomPanelData().getProfile();
        if (profile == null) {
            return null;
        }
        String offeringId = this.panel.getOfferingId();
        if (offeringId != null) {
            return profile.getOfferingUserData(propertyKey, offeringId);
        }
        return profile.getUserData(propertyKey);
    }

    private void setValueToProfile(String propertyKey, char[] propertyValue) {
        String offeringId;
        IProfile profile = this.panel.getCustomPanelData().getProfile();
        if (profile == null) {
            return;
        }
        if (propertyValue == null) {
            propertyValue = new char[]{};
        }
        if ((offeringId = this.panel.getOfferingId()) != null) {
            profile.setOfferingUserData(propertyKey, String.valueOf(propertyValue), offeringId);
        } else {
            profile.setUserData(propertyKey, String.valueOf(propertyValue));
        }
        SharedUIUtils.clearText(propertyValue);
    }

    private Map<String, IStatus> validatePanel(Class<? extends TemplateCustomPanel.AbstractUserData> exclude, IProgressMonitor monitor) {
        for (TemplateCustomPanel.AbstractUserData userData : this.getUserData(exclude)) {
            userData.clearStatuses();
        }
        try {
            this.panel.validate((IProgressMonitor)(monitor != null ? monitor : new NullProgressMonitor()));
        }
        catch (Throwable e) {
            throw new RuntimeStatusException(SharedUIUtils.generateCustomPanelExceptionStatus(this.panel, e));
        }
        HashMap<String, IStatus> result = new HashMap<String, IStatus>();
        for (TemplateCustomPanel.AbstractUserData userData : this.getUserData(exclude)) {
            this.markSensistiveData(userData);
            List<IStatus> statuses = userData.getStatuses();
            if (statuses.isEmpty()) continue;
            CicMultiStatus multiStatus = Statuses.ST.createMultiStatus();
            multiStatus.addAll(statuses);
            result.put(userData.getId(), StatusUtil.fixMultiStatusNoMsgProblem((IStatus)multiStatus));
        }
        return result;
    }

    private void markSensistiveData(TemplateCustomPanel.AbstractUserData userData) {
        if (!(userData instanceof TemplateCustomPanel.WidgetOnlyUserData) && userData.isSensitive()) {
            Profile profile = (Profile)this.panel.getCustomPanelData().getProfile();
            String offeringId = this.panel.getOfferingId();
            if (offeringId == null) {
                profile.setSensitiveUserData(userData.getId());
            } else {
                profile.setSensitiveUserData(userData.getId(), offeringId);
            }
        }
    }

    private Collection<TemplateCustomPanel.AbstractUserData> getUserData(Class<? extends TemplateCustomPanel.AbstractUserData> exclude) {
        ArrayList<TemplateCustomPanel.AbstractUserData> result = new ArrayList<TemplateCustomPanel.AbstractUserData>();
        for (TemplateCustomPanel.AbstractUserData userData : this.panel.getUserData()) {
            if (exclude.isInstance(userData)) continue;
            result.add(userData);
        }
        return result;
    }

    public boolean updateWidgetsOnVisible() {
        return this.panel.updateWidgetsOnVisible();
    }

    private static class UserDataBoundToMultiWidgetException
    extends Exception {
        public UserDataBoundToMultiWidgetException(String message) {
            super(message);
        }
    }
}

