/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core;

import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.InstallJob;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.ResponseFileBuilder;
import com.ibm.cic.agent.core.ResponseFileGenerator;
import com.ibm.cic.agent.core.custompanel.api.CustomPanelWrapper;
import com.ibm.cic.agent.core.custompanel.api.TemplateCustomPanel;
import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.core.sharedUI.TemplateCommonCustomPanelFactory;
import com.ibm.cic.agent.core.sharedUI.TemplateOfferingCustomPanelFactory;
import com.ibm.cic.agent.internal.core.InstallRegistry;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.internal.repository.RepositoryInfo;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.utils.LinkedProperties;
import com.ibm.cic.common.core.utils.MapList;
import com.ibm.cic.common.core.utils.MapMap;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.Util;
import com.ibm.cic.common.logging.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.osgi.framework.Version;

public class ResponseFileFromInstall
extends ResponseFileGenerator {
    private final MapMap<IIdentity, Version, Profile> packages = MapMap.newHashHash();
    private Profile profile = null;

    public ResponseFileFromInstall() {
        String sharedLocation = InstallRegistry.getInstance().getCacheLocation();
        if (sharedLocation != null) {
            this.rfb.sharedLocation(sharedLocation);
        }
    }

    public void setProfile(Profile profile) {
        this.profile = profile;
    }

    public void addPackage(Profile p, IIdentity id, Version version) {
        super.addPackage(id, version);
        this.packages.put((Object)id, (Object)version, (Object)p);
    }

    private <T extends IOfferingOrFix> Collection<T> filterPackages(Profile p, T[] pkgs) {
        ArrayList<IOfferingOrFix> result = new ArrayList<IOfferingOrFix>(pkgs.length);
        for (IOfferingOrFix pkg : super.filterPackages(pkgs)) {
            IIdentity id = pkg.getIdentity();
            Profile p2 = (Profile)this.packages.get((Object)id, (Object)pkg.getVersion());
            if (p2 != null && !p2.equals(p)) continue;
            result.add(pkg);
        }
        return result;
    }

    @Override
    protected void doGenerate() {
        ArrayList<Profile> profiles = new ArrayList<Profile>();
        MapList offeringGroups = MapList.newMapList();
        MapList fixGroups = MapList.newMapList();
        Profile[] profileArray = InstallRegistry.getInstance().getProfiles();
        int n = profileArray.length;
        int n2 = 0;
        while (n2 < n) {
            Profile p = profileArray[n2];
            InstallRegistry.ProfileInstallRegistry registry = p.getInstallRegistry();
            if (this.includeProfile(p)) {
                Collection offerings = this.filterPackages(p, (IOfferingOrFix[])registry.getInstalledOfferings());
                Collection fixes = this.filterPackages(p, (IOfferingOrFix[])registry.getInstalledFixes());
                if (!offerings.isEmpty() || !fixes.isEmpty()) {
                    profiles.add(p);
                    offeringGroups.addAll((Object)p, offerings);
                    fixGroups.addAll((Object)p, fixes);
                }
            }
            ++n2;
        }
        for (Profile p : profiles) {
            InstallRegistry.ProfileInstallRegistry registry = p.getInstallRegistry();
            List offerings = offeringGroups.get((Object)p);
            List fixes = fixGroups.get((Object)p);
            this.addRepos(registry);
            this.profile(p.getProfileId(), p.getInstallLocation(), profiles.size() > 1, !offerings.isEmpty() ? offerings : fixes);
            new GenProfileData(this.rfb, p, offerings).perform();
            for (IOffering offering : offerings) {
                this.install(offering, registry.getInstalledFeatures(offering));
            }
            for (IFix fix : fixes) {
                this.install(fix);
            }
        }
    }

    @Override
    protected IStatus missingPackageError(String idv) {
        return this.profile == null ? Statuses.ERROR.get(Messages.AbstractCommand_PackageIsNotInstalled, new Object[]{idv}) : Statuses.ERROR.get(Messages.AbstractCommand_PackageIsNotInstalledAtDirectory, new Object[]{idv, this.profile.getInstallLocation()});
    }

    @Override
    protected IStatus nothingIncludedError() {
        return Statuses.ERROR.get(Messages.GenerateResponseFileCommand_No_Packages_Installed, new Object[0]);
    }

    private boolean includeProfile(Profile p) {
        return !p.isAgentProfile() && (this.profile == null || this.profile == p);
    }

    private void addRepos(InstallRegistry.ProfileInstallRegistry registry) {
        IOffering[] iOfferingArray = registry.getInstalledOfferings();
        int n = iOfferingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IOffering offering = iOfferingArray[n2];
            for (IOffering offeringVersion : Util.reverse(Arrays.asList(registry.getInstalledOfferings(offering.getIdentity())))) {
                this.addRepo(registry.getInstalledRepositoryInfo((IOfferingOrFix)offeringVersion));
            }
            ++n2;
        }
        iOfferingArray = registry.getInstalledFixes();
        n = iOfferingArray.length;
        n2 = 0;
        while (n2 < n) {
            IOffering fix = iOfferingArray[n2];
            this.addRepo(registry.getInstalledRepositoryInfo((IOfferingOrFix)fix));
            ++n2;
        }
    }

    private void addRepo(String repoInfo) {
        if (repoInfo != null) {
            this.rfb.repository(RepositoryInfo.deserialize((String)repoInfo).getLocation());
        }
    }

    private static class GenProfileData {
        private final List<IOffering> offerings;
        private final Map<String, String> dataValues;
        private final Map<String, TemplateCustomPanel.AbstractUserData> allUserData;
        private final ResponseFileBuilder rfb;

        GenProfileData(ResponseFileBuilder rfb, Profile p, List<IOffering> offerings) {
            this.rfb = rfb;
            this.offerings = offerings;
            this.dataValues = GenProfileData.getUserDataValues(p);
            this.allUserData = GenProfileData.getUserDataDescriptions(p, offerings);
        }

        void perform() {
            this.perform(ProfileDataGroup.NON_USER_DATA);
            this.perform(ProfileDataGroup.COMMON_USER_DATA);
            for (IOffering offering : this.offerings) {
                this.perform(ProfileDataGroup.offeringData(offering));
            }
        }

        private void perform(ProfileDataGroup group) {
            for (Map.Entry<String, String> entry : this.dataValues.entrySet()) {
                this.profileData(group, entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, Object> entry : this.allUserData.entrySet()) {
                if (!((TemplateCustomPanel.AbstractUserData)entry.getValue()).isSensitive()) continue;
                this.profileData(group, entry.getKey(), "****");
            }
        }

        private void profileData(ProfileDataGroup group, String key, String value) {
            String description;
            if (!group.matchesData(key)) {
                return;
            }
            this.rfb.profileData(key, value);
            group.emitComment(this.rfb);
            TemplateCustomPanel.AbstractUserData userData = this.allUserData.get(key);
            if (userData != null && (description = userData.getDescription()) != null) {
                this.rfb.comment(description);
            }
        }

        private static Map<String, String> getUserDataValues(Profile p) {
            LinkedProperties properties = p.getAllData();
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(properties.size());
            String[] stringArray = properties.getPropertyKeys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                if (Profile.isUserSettableProperty(key) && !p.hasDefaultValue(key)) {
                    result.put(key, properties.getProperty(key));
                }
                ++n2;
            }
            return result;
        }

        private static Map<String, TemplateCustomPanel.AbstractUserData> getUserDataDescriptions(Profile p, List<IOffering> offerings) {
            TemplateCommonCustomPanelFactory commonFactory = TemplateCommonCustomPanelFactory.getInstance();
            TemplateOfferingCustomPanelFactory offeringFactory = TemplateOfferingCustomPanelFactory.getInstance();
            try {
                CustomPanelWrapper[] panels;
                StatusUtil.throwIfError((IStatus)SharedUIUtils.prepareOfferingsAndFixes(offerings, null));
                HashMap<String, TemplateCustomPanel.AbstractUserData> map = new HashMap<String, TemplateCustomPanel.AbstractUserData>();
                AgentJob[] jobs = new AgentJob[offerings.size()];
                int i = 0;
                while (i < offerings.size()) {
                    jobs[i] = new InstallJob(p, (IOfferingOrFix)offerings.get(i));
                    ++i;
                }
                CustomPanelWrapper[] customPanelWrapperArray = panels = (CustomPanelWrapper[])Util.splice((Object[])commonFactory.createCustomPanelTemplates(jobs), (Object[])offeringFactory.createCustomPanelTemplates(jobs));
                int n = panels.length;
                int n2 = 0;
                while (n2 < n) {
                    CustomPanelWrapper panel = customPanelWrapperArray[n2];
                    for (TemplateCustomPanel.AbstractUserData userData : panel.getProfileUserData()) {
                        map.put(panel.getProfileKey(userData.getId()), userData);
                    }
                    ++n2;
                }
                return map;
            }
            catch (CoreException e) {
                Logger.getLogger().status(e.getStatus());
                return Collections.emptyMap();
            }
        }

        private static class ProfileDataGroup {
            static final ProfileDataGroup NON_USER_DATA = new ProfileDataGroup("non user data", null);
            static final ProfileDataGroup COMMON_USER_DATA = new ProfileDataGroup("common user data", Messages.ResponseFileFromRepositories_Common_Data_Label);
            private final String id;
            private String comment = null;

            static ProfileDataGroup offeringData(IOffering offering) {
                return new ProfileDataGroup(offering.getIdentity().getId(), NLS.bind((String)Messages.ResponseFileFromRepositories_Data_For_Offering_Label, (Object)offering.getName()));
            }

            private ProfileDataGroup(String id, String comment) {
                this.id = id;
                this.comment = comment;
            }

            public boolean matchesData(String key) {
                if (!Profile.isUserData(key)) {
                    return this == NON_USER_DATA;
                }
                String offeringId = Profile.getUserDataOfferingId(key);
                if (offeringId == null) {
                    return this == COMMON_USER_DATA;
                }
                return offeringId.equals(this.id);
            }

            public void emitComment(ResponseFileBuilder rfb) {
                if (this.comment != null) {
                    rfb.comment(this.comment);
                    this.comment = null;
                }
            }
        }
    }
}

