/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentInstall;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.WindowSystemUtils;
import com.ibm.cic.agent.core.api.IProfile;
import com.ibm.cic.agent.core.utils.AgentUserOptions;
import com.ibm.cic.agent.internal.core.InstallRegistry;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.definitions.CommonDef;
import com.ibm.cic.common.core.definitions.ProfileArch;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.LicenseUtils;
import com.ibm.cic.common.core.model.utils.OfferingProperty;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.core.model.utils.PlatformFilter;
import com.ibm.cic.common.core.model.utils.SupportedPlatforms;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.repository.SliceUtils;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.IdentityUtil;
import com.ibm.cic.common.core.utils.LinkedProperties;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.PlatformUtils;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.Util;
import com.ibm.cic.common.logging.LogUtil;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Version;

public class BitModeUtils {
    public static final int BITS32 = 32;
    public static final int BITS64 = 64;
    private static HashSet<String> forced64bitSupport = null;

    private BitModeUtils() {
        assert (false);
    }

    public static IStatus checkBitModeCompatible(List oofs, Profile profile) {
        if (AgentUserOptions.CIC_SUPPRESS_PLATFORM_CHECKS.isSet()) {
            return Status.OK_STATUS;
        }
        boolean supports32 = BitModeUtils.supports32bits(oofs);
        boolean supports64 = BitModeUtils.supports64bits(oofs);
        if (profile != null) {
            if (profile.is32bit()) {
                supports64 = false;
            } else {
                supports32 = false;
            }
        }
        if (!supports32 && !supports64) {
            return Statuses.ERROR.get(Messages.AgentUtil_Validate_Cannot_Coexist, new Object[0]);
        }
        return Status.OK_STATUS;
    }

    public static IStatus checkFixBitModeSupportedAgainstProfile(Collection<IFix> fixes, Profile profile) {
        if (fixes.isEmpty() || profile == null) {
            return Status.OK_STATUS;
        }
        int fixesBits = 0;
        int profileBits = 0;
        if (profile.is32bit()) {
            fixesBits = 64;
            profileBits = 32;
        } else {
            fixesBits = 32;
            profileBits = 64;
        }
        ArrayList<IFix> unsupportedFixes = new ArrayList<IFix>();
        for (IFix fix : fixes) {
            if (unsupportedFixes.contains(fix)) continue;
            if (profileBits == 32) {
                if (BitModeUtils.supports32bits(fix)) continue;
                unsupportedFixes.add(fix);
                continue;
            }
            if (BitModeUtils.supports64bits(fix)) continue;
            unsupportedFixes.add(fix);
        }
        CicMultiStatus result = Statuses.ST.createMultiStatus();
        if (!unsupportedFixes.isEmpty()) {
            if (profile.isShadow() || profile.isInstallLocationChangeable()) {
                result.setMessage(NLS.bind((String)Messages.BitModeUils_Fix_Unsupported_Bit_Mode, (Object)fixesBits, (Object)profileBits));
            } else {
                result.setMessage(NLS.bind((String)Messages.BitModeUils_Fix_Unsupported_Bit_Mode_In_Profile, (Object[])new Object[]{fixesBits, profileBits, profile.getProfileId()}));
            }
            StringBuffer unsupportedFixList = new StringBuffer();
            for (IFix fix : unsupportedFixes) {
                unsupportedFixList.append(LogUtil.NEWLINE);
                unsupportedFixList.append("  ");
                unsupportedFixList.append(fix.getName());
            }
            result.add((IStatus)Statuses.ERROR.get(Messages.BitModeUils_Fix_Unsupported_Bit_Mode_Details, new Object[]{fixesBits, profileBits, unsupportedFixList.toString()}));
        }
        return result;
    }

    public static IStatus checkBitmodeSupported(AgentJob job) {
        if (!BitModeUtils.isMultiBitModePlatform()) {
            return Status.OK_STATUS;
        }
        IOffering offering = job.getOffering();
        if (offering == null || AgentUserOptions.CIC_SUPPRESS_PLATFORM_CHECKS.isSet()) {
            return Status.OK_STATUS;
        }
        Profile profile = job.getProfile();
        int profileBits = 0;
        int offeringBits = 0;
        String requiredOfferingArch = null;
        if (profile.is32bit()) {
            if (!BitModeUtils.supports32bits(offering)) {
                profileBits = 32;
                offeringBits = 64;
                requiredOfferingArch = BitModeUtils.get64bitArch();
            }
        } else if (!BitModeUtils.supports64bits(offering)) {
            profileBits = 64;
            offeringBits = 32;
            requiredOfferingArch = BitModeUtils.get32bitArch();
        }
        if (profileBits != 0 && offeringBits != 0 && requiredOfferingArch != null) {
            if (profile.isShadow() || profile.isInstallLocationChangeable()) {
                return Statuses.ERROR.get(Messages.BitModeUtils_Unsupported_Bit_Mode, new Object[]{offeringBits, offering.getName(), profileBits});
            }
            if (AgentInstall.getInstance().isAgentInstallerRunning() && profile.isAgentProfile()) {
                return Statuses.ERROR.get(Messages.BitModeUtils_Unsupported_Bit_Mode_In_InstallKitUpdate, new Object[]{profileBits, offeringBits});
            }
            if (job.isUpdate() && offeringBits == 64) {
                return Statuses.ERROR.get(Messages.BitModeUtils_Unsupported_Bit_Mode_In_Update, new Object[]{profile.getProfileId(), offering.getName()});
            }
            return Statuses.ERROR.get(Messages.BitModeUtils_Unsupported_Bit_Mode_In_Profile, new Object[]{offeringBits, offering.getName(), profileBits, profile.getProfileId()});
        }
        return Status.OK_STATUS;
    }

    public static void setProfilePlatformProperties(Profile profile, AgentJob[] jobs, String arch) {
        BitModeUtils.setProfilePlatformProperties(profile, BitModeUtils.getJobOofs(jobs), arch);
    }

    public static void setProfilePlatformProperties(Profile profile, IOfferingOrFix[] oofs, String arch) {
        BitModeUtils.setProfilePlatformProperties(profile, oofs, arch, true);
    }

    public static void setProfilePlatformProperties(Profile profile, IOfferingOrFix[] oofs, String arch, boolean override) {
        BitModeUtils.setProfilePlatformProperty(profile, "cic.selector.os", Platform.getOS(), override);
        BitModeUtils.setProfilePlatformProperty(profile, "cic.selector.arch", arch, override);
        BitModeUtils.setProfilePlatformProperty(profile, "cic.selector.ws", WindowSystemUtils.getPreferredWsValue(profile, oofs), override);
    }

    public static void setProfilePlatformProperty(Profile profile, String name, String value, boolean override) {
        if (override || profile.getData(name) == null) {
            profile.setData(name, value);
        }
    }

    public static boolean supports32bits(IOfferingOrFix offeringOrFix) {
        if (offeringOrFix instanceof IOffering) {
            return BitModeUtils.supports32bits((IOffering)offeringOrFix);
        }
        if (offeringOrFix instanceof IFix) {
            return BitModeUtils.supports32bits((IFix)offeringOrFix);
        }
        return true;
    }

    public static boolean supports32bits(IOffering offering) {
        PlatformFilter f;
        PlatformFilter f2;
        if (Agent.getInstance().isAgentOffering((IOfferingOrFix)offering) && AgentInstall.getInstance().isAgentInstallerRunning()) {
            return !BitModeUtils.is64bitIM();
        }
        String supports32bits = OfferingProperty.getSupports32bits((IOffering)offering);
        if (supports32bits != null && !(f2 = new PlatformFilter(supports32bits)).matchesPlatform(Platform.getOS(), BitModeUtils.getPlatformArch()).isOK()) {
            return false;
        }
        String supportedPlatforms = OfferingProperty.getSupportedPlatforms((IOfferingOrFix)offering);
        return supportedPlatforms == null || (f = new PlatformFilter(supportedPlatforms)).matchesPlatform(Platform.getOS(), BitModeUtils.get32bitArch()).isOK();
    }

    public static boolean supports32bits(IFix fix) {
        PlatformFilter f;
        String supportedPlatforms = OfferingProperty.getSupportedPlatforms((IOfferingOrFix)fix);
        return supportedPlatforms == null || (f = new PlatformFilter(supportedPlatforms)).matchesPlatform(Platform.getOS(), BitModeUtils.get32bitArch()).isOK();
    }

    public static boolean supports64bits(IOfferingOrFix offeringOrFix) {
        if (offeringOrFix instanceof IOffering) {
            return BitModeUtils.supports64bits((IOffering)offeringOrFix);
        }
        if (offeringOrFix instanceof IFix) {
            return BitModeUtils.supports64bits((IFix)offeringOrFix);
        }
        return true;
    }

    public static boolean supports64bits(IOffering offering) {
        PlatformFilter f;
        if (!CicCommonSettings.is64BitOs()) {
            return false;
        }
        if (Agent.getInstance().isAgentOffering((IOfferingOrFix)offering) && AgentInstall.getInstance().isAgentInstallerRunning()) {
            return BitModeUtils.is64bitIM();
        }
        if (BitModeUtils.isForced64bitSupport((IOfferingOrFix)offering)) {
            return true;
        }
        String supports64bits = OfferingProperty.getSupports64bits((IOffering)offering);
        String supportedPlatforms = OfferingProperty.getSupportedPlatforms((IOfferingOrFix)offering);
        if (supports64bits == null && supportedPlatforms == null) {
            return false;
        }
        if (CommonDef.False.equalsIgnoreCase(supports64bits)) {
            return false;
        }
        if (supports64bits != null && !CommonDef.True.equalsIgnoreCase(supports64bits) && !(f = new PlatformFilter(supports64bits)).matchesPlatform(Platform.getOS(), BitModeUtils.getPlatformArch()).isOK()) {
            return false;
        }
        return supportedPlatforms == null || (f = new PlatformFilter(supportedPlatforms)).matchesPlatform(Platform.getOS(), BitModeUtils.getPlatformArch()).isOK();
    }

    public static boolean supports64bits(IFix fix) {
        PlatformFilter f;
        if (!CicCommonSettings.is64BitOs()) {
            return false;
        }
        if (BitModeUtils.isForced64bitSupport((IOfferingOrFix)fix)) {
            return true;
        }
        String supportedPlatforms = OfferingProperty.getSupportedPlatforms((IOfferingOrFix)fix);
        return supportedPlatforms == null || (f = new PlatformFilter(supportedPlatforms)).matchesPlatform(Platform.getOS(), BitModeUtils.getPlatformArch()).isOK();
    }

    public static boolean supports32bits(IOfferingOrFix[] oofs) {
        IOfferingOrFix[] iOfferingOrFixArray = oofs;
        int n = oofs.length;
        int n2 = 0;
        while (n2 < n) {
            IOfferingOrFix oof = iOfferingOrFixArray[n2];
            if (!BitModeUtils.supports32bits(oof)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean supports32bits(List oofsList) {
        IOfferingOrFix[] oofs = oofsList.toArray(new IOfferingOrFix[oofsList.size()]);
        return BitModeUtils.supports32bits(oofs);
    }

    public static boolean supports64bits(IOfferingOrFix[] oofs) {
        IOfferingOrFix[] iOfferingOrFixArray = oofs;
        int n = oofs.length;
        int n2 = 0;
        while (n2 < n) {
            IOfferingOrFix oof = iOfferingOrFixArray[n2];
            if (!BitModeUtils.supports64bits(oof)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean supports64bits(List oofsList) {
        IOfferingOrFix[] oofs = oofsList.toArray(new IOfferingOrFix[oofsList.size()]);
        return BitModeUtils.supports64bits(oofs);
    }

    private static IOfferingOrFix[] getJobOofs(List jobs) {
        ArrayList<IOfferingOrFix> oofs = new ArrayList<IOfferingOrFix>(jobs.size());
        for (AgentJob job : jobs) {
            IOfferingOrFix oof = job.getOfferingOrFix();
            oofs.add(oof);
        }
        return oofs.toArray(new IOfferingOrFix[oofs.size()]);
    }

    private static IOfferingOrFix[] getJobOofs(AgentJob[] jobs) {
        IOfferingOrFix[] oofs = new IOfferingOrFix[jobs.length];
        int i = 0;
        while (i < jobs.length) {
            oofs[i] = jobs[i].getOfferingOrFix();
            ++i;
        }
        return oofs;
    }

    public static boolean jobsSupport64bits(List jobs) {
        IOfferingOrFix[] oofs = BitModeUtils.getJobOofs(jobs);
        return BitModeUtils.supports64bits(oofs);
    }

    public static boolean defaultProfileIs32bit(IOfferingOrFix[] oofs) {
        IOfferingOrFix[] iOfferingOrFixArray = oofs;
        int n = oofs.length;
        int n2 = 0;
        while (n2 < n) {
            IOfferingOrFix oof = iOfferingOrFixArray[n2];
            if (oof instanceof IOffering && OfferingProperty.defaultProfileIs32bit((IOffering)((IOffering)oof))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean jobsDefaultProfileIs32bit(List jobs) {
        IOfferingOrFix[] oofs = BitModeUtils.getJobOofs(jobs);
        return BitModeUtils.defaultProfileIs32bit(oofs);
    }

    public static String get32bitArch() {
        String arch = Platform.getOSArch();
        String arch32 = ProfileArch.get32bitArch((String)arch);
        if (!SupportedPlatforms.getInstance().isSupported(Platform.getOS(), arch32)) {
            return arch;
        }
        return arch32;
    }

    public static String get64bitArch() {
        return ProfileArch.get64bitArch((String)Platform.getOSArch());
    }

    public static String[] getValidArchitectures() {
        if ("solaris".equals(Platform.getOS()) && BitModeUtils.get32bitArch().equals("sparc")) {
            return new String[]{BitModeUtils.get32bitArch(), "sparc64", "sparcv9"};
        }
        return new String[]{BitModeUtils.get32bitArch(), BitModeUtils.get64bitArch()};
    }

    public static String getPlatformArch() {
        return CicCommonSettings.is64BitOs() ? BitModeUtils.get64bitArch() : BitModeUtils.get32bitArch();
    }

    public static String getGenericArch() {
        String arch32 = BitModeUtils.get32bitArch();
        String arch64 = BitModeUtils.get64bitArch();
        return arch32.length() < arch64.length() ? arch32 : arch64;
    }

    public static boolean is64bitIM() {
        return ProfileArch.is64bitArch((String)Platform.getOSArch());
    }

    public static LinkedProperties getMassagedData(Profile profile) {
        if (profile.getData("cic.selector.ws") == null) {
            profile.setData("cic.selector.ws", profile.getWS());
        }
        if (profile.getData("cic.selector.os") == null) {
            profile.setData("cic.selector.os", profile.getOS());
        }
        if (profile.getData("cic.selector.arch") == null) {
            profile.setData("cic.selector.arch", profile.getArch());
        }
        return profile.getAllData();
    }

    public static void initializeProfilePlatformProperties(Profile profile, AgentJob[] jobs) {
        BitModeUtils.initializeProfilePlatformProperties(profile, jobs, true);
    }

    public static void initializeProfilePlatformProperties(Profile profile, AgentJob[] jobs, boolean override) {
        IOfferingOrFix[] oofs = BitModeUtils.getJobOofs(jobs);
        BitModeUtils.initializeProfilePlatformProperties(profile, oofs, override);
    }

    public static void initializeProfilePlatformProperties(Profile profile, IOfferingOrFix[] oofs) {
        BitModeUtils.initializeProfilePlatformProperties(profile, oofs, true);
    }

    public static void initializeProfilePlatformProperties(Profile profile, IOfferingOrFix[] oofs, boolean override) {
        if (profile == null) {
            return;
        }
        if (!profile.isInstallLocationChangeable()) {
            return;
        }
        if (override && InstallRegistry.getInstance().hasProfile(profile)) {
            override = profile.isShadow();
        }
        BitModeUtils.setProfilePlatformProperties(profile, oofs, BitModeUtils.getRecommendedProfileArch(oofs), override);
        if (override) {
            BitModeUtils.setProfileInstallLocationForBitMode(profile);
        }
    }

    public static String getRecommendedProfileArch(IOfferingOrFix[] oofs) {
        String recommendedArch = null;
        recommendedArch = CicCommonSettings.is64BitOs() && !BitModeUtils.defaultProfileIs32bit(oofs) ? (BitModeUtils.supports64bits(oofs) || !BitModeUtils.supports32bits(oofs) ? BitModeUtils.get64bitArch() : BitModeUtils.get32bitArch()) : BitModeUtils.get32bitArch();
        return recommendedArch;
    }

    public static String getRecommendedProfileArch(AgentJob[] jobs) {
        return BitModeUtils.getRecommendedProfileArch(BitModeUtils.getJobOofs(jobs));
    }

    public static void setProfileInstallLocationForBitMode(Profile profile) {
        BitModeUtils.setProfileInstallLocationForBitMode(profile, true);
    }

    public static void setProfileInstallLocationForBitMode(Profile profile, boolean wantNonConflicting) {
        String newLocation = BitModeUtils.getProfileInstallLocationForBitMode(profile);
        profile.setInstallLocation(newLocation);
        if (wantNonConflicting) {
            profile.makeNonConflictingInstallLocation();
        }
    }

    public static String getProfileInstallLocationForBitMode(Profile profile) {
        String location = profile.getInstallLocation();
        String oldDefaultInstallRootLocation = PlatformUtils.getDefaultInstallRootLocation((!profile.is64bit() ? 1 : 0) != 0);
        String newDefaultInstallRootLocation = PlatformUtils.getDefaultInstallRootLocation((boolean)profile.is64bit());
        if (oldDefaultInstallRootLocation.length() > location.length()) {
            return location;
        }
        File oldDefaultInstallRootDir = new File(oldDefaultInstallRootLocation);
        File installDir = new File(location);
        if (!FileUtil.directoriesAreRelated((File)oldDefaultInstallRootDir, (File)installDir)) {
            return location;
        }
        if (FileUtil.filesAreSame((File)oldDefaultInstallRootDir, (File)installDir)) {
            return newDefaultInstallRootLocation;
        }
        String relativePath = FileUtil.getRelativePath((File)oldDefaultInstallRootDir, (File)installDir);
        File relDir = new File(relativePath);
        if (relDir.isAbsolute()) {
            return location;
        }
        String newLocation = String.valueOf(newDefaultInstallRootLocation) + File.separator + relativePath;
        return newLocation;
    }

    public static boolean isMultiBitModePlatform() {
        return CicCommonSettings.is64BitOs() && !BitModeUtils.get32bitArch().equals(BitModeUtils.get64bitArch());
    }

    public static String getBitModeTextOfIM() {
        return BitModeUtils.is64bitIM() ? BitModeUtils.getBitModeText(64) : BitModeUtils.getBitModeText(32);
    }

    public static String getBitModeText(int bits) {
        return NLS.bind((String)Messages.BitModeUtils_bitModeText, (Object)String.valueOf(bits));
    }

    public static String getBitModeText(Profile profile) {
        int bits = profile.is32bit() ? 32 : 64;
        return BitModeUtils.getBitModeText(bits);
    }

    public static boolean checkFixSupportedPlatforms(IFix fix, IOffering offering) {
        boolean supported = true;
        String supportedPlatforms = OfferingProperty.getSupportedPlatforms((IOfferingOrFix)fix);
        if (supportedPlatforms == null) {
            return supported;
        }
        boolean bl = supported = BitModeUtils.supports32bits(fix) && BitModeUtils.supports32bits(offering) && SliceUtils.checkPlatform((IOfferingOrFix)offering, (String)Platform.getOS(), (String)BitModeUtils.get32bitArch()).isOK();
        if (!supported && BitModeUtils.isMultiBitModePlatform()) {
            supported = BitModeUtils.supports64bits(fix) && BitModeUtils.supports64bits(offering) && SliceUtils.checkPlatform((IOfferingOrFix)offering, (String)Platform.getOS(), (String)BitModeUtils.get64bitArch()).isOK();
        }
        return supported;
    }

    public static IStatus checkSupportedPlatformsInOfferingOrFix(IOfferingOrFix offeringOrFix) {
        IStatus result = Status.OK_STATUS;
        String filter = OfferingProperty.getSupportedPlatforms((IOfferingOrFix)offeringOrFix);
        if (filter == null) {
            return result;
        }
        PlatformFilter f = new PlatformFilter(filter);
        result = f.matchesPlatform(Platform.getOS(), BitModeUtils.get32bitArch());
        if (result.isOK() || result.getCode() == 999) {
            return result;
        }
        if (BitModeUtils.isMultiBitModePlatform() && (result = f.matchesPlatform(Platform.getOS(), BitModeUtils.get64bitArch())).isOK()) {
            return result;
        }
        result = offeringOrFix instanceof IOffering ? Statuses.ERROR.get(Messages.BitModeUtils_Unsupported_Platform, new Object[]{offeringOrFix.getName(), Platform.getOS(), BitModeUtils.getGenericArch()}) : Statuses.ERROR.get(Messages.BitModeUtils_Unsupported_Platform_Fix, new Object[]{offeringOrFix.getName(), Platform.getOS(), BitModeUtils.getGenericArch()});
        return result;
    }

    public static IStatus checkSupportedPlatformsInOfferingOrFixAgainstProfile(IOfferingOrFix offeringOrFix, IProfile profile) {
        if (AgentUserOptions.CIC_CCB_CLASSIC_ECLIPSE.isSet()) {
            return Status.OK_STATUS;
        }
        IStatus result = Status.OK_STATUS;
        String filter = OfferingProperty.getSupportedPlatforms((IOfferingOrFix)offeringOrFix);
        if (filter == null) {
            return result;
        }
        PlatformFilter f = new PlatformFilter(filter);
        result = f.matchesPlatform(profile.getOS(), profile.getArch());
        if (result.isOK() || result.getCode() == 999) {
            return result;
        }
        result = offeringOrFix instanceof IOffering ? Statuses.ERROR.get(Messages.BitModeUtils_Unsupported_Platform, new Object[]{offeringOrFix.getName(), profile.getOS(), profile.getArch()}) : Statuses.ERROR.get(Messages.BitModeUtils_Unsupported_Platform_Fix, new Object[]{offeringOrFix.getName(), profile.getOS(), profile.getArch()});
        return result;
    }

    public static IStatus checkSupportedPlatformsInRepository(IOfferingOrFix offeringOrFix) {
        IStatus status = SliceUtils.checkPlatform((IOfferingOrFix)offeringOrFix, (String)Platform.getOS(), (String)BitModeUtils.get32bitArch());
        if (status.isOK()) {
            return status;
        }
        if (BitModeUtils.isMultiBitModePlatform()) {
            status = SliceUtils.checkPlatform((IOfferingOrFix)offeringOrFix, (String)Platform.getOS(), (String)BitModeUtils.get64bitArch());
        }
        return status;
    }

    public static IStatus checkSupportedPlatforms(IOfferingOrFix offeringOrFix) {
        IStatus status = BitModeUtils.checkSupportedPlatformsInOfferingOrFix(offeringOrFix);
        if (status.isOK()) {
            status = BitModeUtils.checkSupportedPlatformsInRepository(offeringOrFix);
        }
        return status;
    }

    public static boolean checkSupportsSpecificPlatform(IOfferingOrFix offeringOrFix, String os, String arch) {
        boolean result = true;
        String filter = OfferingProperty.getSupportedPlatforms((IOfferingOrFix)offeringOrFix);
        if (filter == null) {
            return result;
        }
        PlatformFilter f = new PlatformFilter(filter);
        IStatus status = f.matchesPlatform(os, arch);
        boolean bl = result = status.isOK() && status.getCode() != 999;
        if (result) {
            status = SliceUtils.checkPlatform((IOfferingOrFix)offeringOrFix, (String)os, (String)arch);
            result = status.isOK();
        }
        return result;
    }

    public static IStatus checkSupportedPlatformsAgainstProfile(IOfferingOrFix offeringOrFix, IProfile profile) {
        IStatus status = BitModeUtils.checkSupportedPlatformsInOfferingOrFixAgainstProfile(offeringOrFix, profile);
        if (status.isOK()) {
            status = BitModeUtils.checkSupportedPlatformsInRepository(offeringOrFix);
        }
        return status;
    }

    public static boolean isOfferingOrFixSupportedOnProfile(IOfferingOrFix offeringOrFix, IProfile profile) {
        return AgentUserOptions.CIC_SUPPRESS_PLATFORM_CHECKS.isSet() || BitModeUtils.checkSupportedPlatformsAgainstProfile(offeringOrFix, profile).isOK();
    }

    public static IStatus checkBitnessConflict(Collection<? extends AgentJob> jobs) {
        if (jobs.isEmpty() || AgentUserOptions.CIC_SUPPRESS_PLATFORM_CHECKS.isSet()) {
            return Status.OK_STATUS;
        }
        HashMap map32bitOnlyFixes = new HashMap();
        HashMap map64bitOnlyFixes = new HashMap();
        for (AgentJob agentJob : jobs) {
            IOfferingOrFix oof = agentJob.getOfferingOrFix();
            if (!(oof instanceof IFix)) continue;
            IFix fix = (IFix)oof;
            Profile currentProfile = agentJob.getProfile();
            Collection l32bitOnlyFixes = BitModeUtils.initMapEntry(currentProfile, map32bitOnlyFixes);
            Collection l64bitOnlyFixes = BitModeUtils.initMapEntry(currentProfile, map64bitOnlyFixes);
            String filter = OfferingProperty.getSupportedPlatforms((IOfferingOrFix)oof);
            if (filter == null) continue;
            PlatformFilter f = new PlatformFilter(filter);
            IStatus resultFor32bit = f.matchesPlatform(Platform.getOS(), BitModeUtils.get32bitArch());
            IStatus resultFor64bit = f.matchesPlatform(Platform.getOS(), BitModeUtils.get64bitArch());
            if (resultFor32bit.isOK() && !resultFor64bit.isOK()) {
                l32bitOnlyFixes.add(fix);
                continue;
            }
            if (resultFor32bit.isOK() || !resultFor64bit.isOK()) continue;
            l64bitOnlyFixes.add(fix);
        }
        CicMultiStatus cicMultiStatus = Statuses.ST.createMultiStatus(Messages.Agent_unsatisfiedDependencies, new Object[0]);
        boolean multiprofile = map32bitOnlyFixes.keySet().size() > 1;
        for (Map.Entry profileEntry : map32bitOnlyFixes.entrySet()) {
            Collection l32bitOnlyFixes = (Collection)profileEntry.getValue();
            Collection l64bitOnlyFixes = (Collection)map64bitOnlyFixes.get(profileEntry.getKey());
            if (l32bitOnlyFixes.size() == 0 || l64bitOnlyFixes.size() == 0) continue;
            Util.Formatter formatter = new Util.Formatter(){

                protected String format(Object object) {
                    return ((IOfferingOrFix)object).getIdentity().getId();
                }
            };
            ICicStatus status = Statuses.ERROR.get(Messages.BitModeUtils_Fix_Platform_Bitness_Conflict, new Object[]{32, Util.toString((Collection)l32bitOnlyFixes, (Util.Formatter)formatter), 64, Util.toString((Collection)l64bitOnlyFixes, (Util.Formatter)formatter)});
            if (multiprofile) {
                CicMultiStatus ms = Statuses.ST.createMultiStatus(profileEntry.getKey() != null ? NLS.bind((String)Messages.Agent_unsatisfiedDependenciesInProfile, (Object)((IProfile)profileEntry.getKey()).getProfileId()) : Messages.Agent_unsatisfiedDependenciesInNullProfile, new Object[0]);
                ms.add((IStatus)status);
                cicMultiStatus.add((IStatus)ms);
                continue;
            }
            cicMultiStatus.add((IStatus)status);
        }
        return cicMultiStatus;
    }

    private static <K, V> Collection<V> initMapEntry(K key, Map<K, Collection<V>> mapOfLists) {
        Collection<Object> list;
        if (!mapOfLists.containsKey(key)) {
            list = new Vector();
            mapOfLists.put(key, list);
        } else {
            list = mapOfLists.get(key);
        }
        return list;
    }

    public static IStatus checkBitnessConflictAgainstSingleProfile(Collection<? extends AgentJob> jobs) {
        if (jobs.isEmpty() || AgentUserOptions.CIC_SUPPRESS_PLATFORM_CHECKS.isSet()) {
            return Status.OK_STATUS;
        }
        Vector<IFix> l32bitOnlyFixes = new Vector<IFix>();
        Vector<IFix> l64bitOnlyFixes = new Vector<IFix>();
        for (AgentJob agentJob : jobs) {
            IOfferingOrFix oof = agentJob.getOfferingOrFix();
            if (!(oof instanceof IFix)) continue;
            IFix fix = (IFix)oof;
            String filter = OfferingProperty.getSupportedPlatforms((IOfferingOrFix)oof);
            if (filter == null) continue;
            PlatformFilter f = new PlatformFilter(filter);
            IStatus resultFor32bit = f.matchesPlatform(Platform.getOS(), BitModeUtils.get32bitArch());
            IStatus resultFor64bit = f.matchesPlatform(Platform.getOS(), BitModeUtils.get64bitArch());
            if (resultFor32bit.isOK() && !resultFor64bit.isOK()) {
                l32bitOnlyFixes.add(fix);
                continue;
            }
            if (resultFor32bit.isOK() || !resultFor64bit.isOK()) continue;
            l64bitOnlyFixes.add(fix);
        }
        if (l32bitOnlyFixes.size() != 0 && l64bitOnlyFixes.size() != 0) {
            Util.Formatter formatter = new Util.Formatter(){

                protected String format(Object object) {
                    return ((IOfferingOrFix)object).getIdentity().getId();
                }
            };
            ICicStatus status = Statuses.ERROR.get(Messages.BitModeUtils_Fix_Platform_Bitness_Conflict, new Object[]{32, Util.toString(l32bitOnlyFixes, (Util.Formatter)formatter), 64, Util.toString(l64bitOnlyFixes, (Util.Formatter)formatter)});
            return status;
        }
        return Status.OK_STATUS;
    }

    public static boolean isBitModeApplicable(IOffering offering) {
        if (!BitModeUtils.isMultiBitModePlatform()) {
            return false;
        }
        if (BitModeUtils.isForced64bitSupport((IOfferingOrFix)offering)) {
            return true;
        }
        String supportedPlatforms = OfferingProperty.getSupportedPlatforms((IOfferingOrFix)offering);
        String supports64bits = OfferingProperty.getSupports64bits((IOffering)offering);
        if (supports64bits == null && supportedPlatforms == null) {
            return false;
        }
        return !CommonDef.False.equalsIgnoreCase(supports64bits);
    }

    public static boolean isBitModeApplicable(IOffering[] offerings) {
        IOffering[] iOfferingArray = offerings;
        int n = offerings.length;
        int n2 = 0;
        while (n2 < n) {
            IOffering offering = iOfferingArray[n2];
            if (!Agent.isExtensionOffering((IOfferingOrFix)offering) && BitModeUtils.isBitModeApplicable(offering)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isBitModeApplicable(Profile profile, IOffering[] offerings) {
        boolean applicable = false;
        if (BitModeUtils.isBitModeApplicable(offerings)) {
            applicable = true;
        }
        if (!profile.isShadow()) {
            IStatus status;
            if (BitModeUtils.isBitModeApplicable(profile)) {
                applicable = true;
            } else if (applicable && StatusUtil.isErrorOrCancel((IStatus)(status = AgentUtil.validateCompatibleOfferings(profile, offerings)))) {
                applicable = false;
            }
        }
        return applicable;
    }

    public static boolean isBitModeApplicable(Profile profile) {
        IOffering[] installedOfferings = profile.getInstalledOfferings();
        return BitModeUtils.isBitModeApplicable(installedOfferings);
    }

    private static int getBitModeChoices(IOffering offering) {
        int choices = 0;
        if (BitModeUtils.supports32bits(offering)) {
            choices |= 0x20;
        }
        if (BitModeUtils.supports64bits(offering)) {
            choices |= 0x40;
        }
        return choices;
    }

    public static boolean hasBitModeChoice(IOffering[] offerings) {
        int choices = 0;
        IOffering[] iOfferingArray = offerings;
        int n = offerings.length;
        int n2 = 0;
        while (n2 < n) {
            IOffering offering = iOfferingArray[n2];
            if ((choices |= BitModeUtils.getBitModeChoices(offering)) == 96) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static IStatus check64bitImSupported(AgentJob[] jobs) {
        if (!BitModeUtils.is64bitIM()) {
            return Status.OK_STATUS;
        }
        LinkedHashSet<String> unsupported = new LinkedHashSet<String>();
        AgentJob[] agentJobArray = jobs;
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            AgentJob job = agentJobArray[n2];
            IOffering offering = job.getOffering();
            if (offering != null && !Agent.getInstance().isAgentOffering((IOfferingOrFix)offering) && !LicenseUtils.isPEKOffering((IOffering)offering)) {
                String msg = job.isModify() || job.isUninstall() ? Messages.BitModeUtils_IM64_notSupportedByInstalledPackage : Messages.BitModeUtils_IM64_notSupportedByPackage;
                BitModeUtils.check64bitImSupported(unsupported, offering, msg);
            }
            BitModeUtils.check64bitImSupportedByInstalled(unsupported, job.getProfile(), false);
            ++n2;
        }
        return BitModeUtils.get64bitImStatus(unsupported);
    }

    public static IStatus check64bitImSupportedByInstalled() {
        Profile[] profiles;
        if (!BitModeUtils.is64bitIM()) {
            return Status.OK_STATUS;
        }
        LinkedHashSet<String> unsupported = new LinkedHashSet<String>();
        Profile[] profileArray = profiles = Agent.getInstance().getProfiles();
        int n = profiles.length;
        int n2 = 0;
        while (n2 < n) {
            Profile profile = profileArray[n2];
            BitModeUtils.check64bitImSupportedByInstalled(unsupported, profile, true);
            ++n2;
        }
        return BitModeUtils.get64bitImStatus(unsupported);
    }

    private static void check64bitImSupported(Set<String> unsupported, IOffering offering, String msg) {
        if (!OfferingProperty.supports64bitIm((IOffering)offering)) {
            unsupported.add(NLS.bind((String)msg, (Object)offering.getName(), (Object)OfferingUtil.getDisplayableVersion((IOfferingOrFix)offering)));
        }
    }

    private static void check64bitImSupportedByInstalled(Set<String> unsupported, Profile profile, boolean allVersions) {
        IOffering offering;
        IOffering[] installedOfferings;
        String profileKind = profile.getProfileKind();
        if (profileKind.equals("self") || profileKind.equals("license")) {
            return;
        }
        IOffering[] iOfferingArray = installedOfferings = Agent.getInstance().getInstalledOfferings(profile);
        int n = installedOfferings.length;
        int n2 = 0;
        while (n2 < n) {
            offering = iOfferingArray[n2];
            BitModeUtils.check64bitImSupported(unsupported, offering, Messages.BitModeUtils_IM64_notSupportedByInstalledPackage);
            ++n2;
        }
        if (!allVersions) {
            return;
        }
        iOfferingArray = installedOfferings;
        n = installedOfferings.length;
        n2 = 0;
        while (n2 < n) {
            IOffering[] allInstalledVersions;
            offering = iOfferingArray[n2];
            Version version = offering.getVersion();
            IOffering[] iOfferingArray2 = allInstalledVersions = Agent.getInstance().getInstalledOfferings(profile, offering.getIdentity());
            int n3 = allInstalledVersions.length;
            int n4 = 0;
            while (n4 < n3) {
                IOffering vOffering = iOfferingArray2[n4];
                if (!version.equals((Object)vOffering.getVersion())) {
                    BitModeUtils.check64bitImSupported(unsupported, vOffering, Messages.BitModeUtils_IM64_notSupportedByPriorInstalledPackage);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private static IStatus get64bitImStatus(Set<String> unsupported) {
        if (unsupported.isEmpty()) {
            return Status.OK_STATUS;
        }
        ICicStatus status = Statuses.WARNING.get(Messages.BitModeUtils_IM64_notSupported, new Object[]{Util.toString(unsupported, (Util.Formatter)new Util.Formatter(", "))});
        Logger.getGlobalLogger().status((IStatus)status);
        return status;
    }

    private static boolean isForced64bitSupport(IOfferingOrFix offeringOrFix) {
        if (forced64bitSupport == null) {
            HashSet<String> set = new HashSet<String>();
            String value = AgentUserOptions.CIC_FORCE_64_BIT_MODE.value();
            if (value != null && value.length() > 0) {
                String[] versionedIds;
                String[] stringArray = versionedIds = Util.splitString((String)value, (String)",");
                int n = versionedIds.length;
                int n2 = 0;
                while (n2 < n) {
                    String versionedId = stringArray[n2];
                    if (versionedId.length() > 0) {
                        set.add(versionedId);
                    }
                    ++n2;
                }
            }
            forced64bitSupport = set;
        }
        String versionedId = IdentityUtil.getVersionedId((IContent)offeringOrFix);
        return forced64bitSupport.contains(versionedId);
    }
}

