/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentInstall;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.AgentRegistry;
import com.ibm.cic.agent.core.BitModeUtils;
import com.ibm.cic.agent.core.CacheManager;
import com.ibm.cic.agent.core.InstallJob;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.SpaceInfoUtils;
import com.ibm.cic.agent.core.UninstallJob;
import com.ibm.cic.agent.core.WindowSystemUtils;
import com.ibm.cic.agent.core.api.IProfile;
import com.ibm.cic.agent.core.cmd.CmdLine;
import com.ibm.cic.agent.core.custompanel.api.CustomPanelWrapper;
import com.ibm.cic.agent.core.sharedUI.TemplateCommonCustomPanelFactory;
import com.ibm.cic.agent.core.sharedUI.TemplateOfferingCustomPanelFactory;
import com.ibm.cic.agent.core.userdata.parser.CommonUserDataExtParser;
import com.ibm.cic.agent.core.userdata.parser.OfferingUserDataExtParser;
import com.ibm.cic.agent.internal.core.AgentInstallPathCheck;
import com.ibm.cic.agent.internal.core.AgentPathValidator;
import com.ibm.cic.agent.internal.core.Director;
import com.ibm.cic.agent.internal.core.InstallRegistry;
import com.ibm.cic.common.core.definitions.CommonDef;
import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.model.ExtensionCategory;
import com.ibm.cic.common.core.model.FixUtil;
import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IFeatureBase;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IInstallationContext;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.IShareableEntity;
import com.ibm.cic.common.core.model.PredefinedSelectors;
import com.ibm.cic.common.core.model.utils.LicenseUtils;
import com.ibm.cic.common.core.model.utils.OfferingProperty;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.core.model.utils.TwoTierMap;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.preferences.CicPreferenceManager;
import com.ibm.cic.common.core.preferences.ICicPreferenceConstants;
import com.ibm.cic.common.core.repository.CicFileLocation;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.IRepositoryGroup;
import com.ibm.cic.common.core.repository.RepositoryGroup;
import com.ibm.cic.common.core.repository.UpdateOfferingUtils;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.Comparators;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.MapList;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.PlatformUtils;
import com.ibm.cic.common.core.utils.RuntimeStatusException;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.Util;
import com.ibm.cic.common.logging.LogManager;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.osgi.framework.Version;

public class AgentUtil {
    private static final Logger log = Logger.getLogger();
    private static boolean onlyInstallingAgent = false;

    private AgentUtil() {
        assert (false);
    }

    public static AgentJob[] addUninstallFixJobs(AgentJob[] jobs, boolean adjustJobs) {
        ArrayList<AgentJob> newJobs = new ArrayList<AgentJob>();
        Collection profileJobsList = AgentUtil.groupByProfile(jobs, false);
        for (AgentJob[] profileJobs : profileJobsList) {
            newJobs.addAll(AgentUtil.getUninstallFixJobs(profileJobs, adjustJobs));
        }
        if (newJobs.isEmpty()) {
            return jobs;
        }
        log.debug("Jobs:  {0}\nAdded: {1}", new Object[]{jobs, newJobs});
        newJobs.addAll(0, Arrays.asList(jobs));
        return AgentJob.toArray(newJobs);
    }

    private static List getUninstallFixJobs(AgentJob[] jobs, boolean adjustJobs) {
        Profile profile = jobs[0].getProfile();
        IOfferingOrFix[] pkgs = AgentUtil.getResultingOfferingsAndFixes(profile, jobs, adjustJobs);
        ArrayList<IOfferingOrFix> offerings = new ArrayList<IOfferingOrFix>(pkgs.length);
        ArrayList<IOfferingOrFix> fixes = new ArrayList<IOfferingOrFix>(pkgs.length);
        IOfferingOrFix[] iOfferingOrFixArray = pkgs;
        int n = pkgs.length;
        int n2 = 0;
        while (n2 < n) {
            IOfferingOrFix pkg = iOfferingOrFixArray[n2];
            if (pkg instanceof IOffering) {
                offerings.add(pkg);
            } else {
                fixes.add(pkg);
            }
            ++n2;
        }
        ArrayList<UninstallJob> newJobs = new ArrayList<UninstallJob>(fixes.size());
        for (IFix iFix : fixes) {
            if (FixUtil.isFixApplicable((IFix)iFix, offerings)) continue;
            newJobs.add(new UninstallJob(profile, (IOfferingOrFix)iFix));
        }
        return newJobs;
    }

    static CicMultiStatus validateJobs(AgentJob[] jobs, boolean isUninstall) {
        CicMultiStatus status = Statuses.OK.getMultiStatus();
        if (!isUninstall) {
            status.addAll(AgentUtil.validateJobsInstallLocation(jobs, null));
            status.addAll(AgentUtil.validateJobsEclipseLocation(jobs));
        }
        if (!Agent.getInstance().isSkipInstall()) {
            status.addAll(SpaceInfoUtils.validateAvailableSpace(Arrays.asList(jobs)));
        }
        return status;
    }

    public static IStatus validateJobsInstallLocation(List jobs) {
        return AgentUtil.validateJobsInstallLocation(jobs, null);
    }

    public static IStatus validateJobsInstallLocation(List jobs, String cacheLocation) {
        return AgentUtil.validateJobsInstallLocation(AgentJob.toArray(jobs), cacheLocation);
    }

    private static IStatus validateJobsInstallLocation(AgentJob[] jobs, String cacheLocation) {
        HashSet validatedProfiles = new HashSet();
        CicMultiStatus status = Statuses.OK.getMultiStatus();
        Set<Profile> profilesWithExistingLocations = AgentUtil.buildAllowNonEmptyLocation(jobs);
        AgentJob[] agentJobArray = jobs;
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            AgentJob job = agentJobArray[n2];
            Profile profile = job.getProfile();
            IOffering offering = job.getOffering();
            if (offering != null && LicenseUtils.isPEKOffering((IOffering)offering) && !profile.getProfileKind().equals("license")) {
                profile = Profile.getLicenseProfile(Agent.getInstance());
                job.setProfile(profile);
            }
            if (!validatedProfiles.contains(profile) && !profile.skipLocationValidation()) {
                status.add(profile.validate());
                if (profile.isAgentProfile() && job.isInstall() && !AgentInstall.getInstance().isAgentInstalled()) {
                    status.add(AgentInstallPathCheck.validate(profile.getInstallLocation()));
                }
                if (job.isInstall()) {
                    status.add(AgentPathValidator.checkSymbolicLinks(profile.getInstallLocation()));
                }
                IStatus collisionStatus = profile.validateInstallLocationCollision();
                status.add(collisionStatus);
                if (!StatusUtil.isErrorOrCancel((IStatus)collisionStatus) && !onlyInstallingAgent) {
                    collisionStatus = profile.validateCacheLocationCollision(cacheLocation);
                    status.add(collisionStatus);
                }
                if (!StatusUtil.isErrorOrCancel((IStatus)collisionStatus)) {
                    collisionStatus = profile.validateDataLocationCollision();
                    status.add(collisionStatus);
                }
                if (!StatusUtil.isErrorOrCancel((IStatus)collisionStatus)) {
                    collisionStatus = profile.validateRegistryLocationCollision();
                    status.add(collisionStatus);
                }
                if (!StatusUtil.isErrorOrCancel((IStatus)collisionStatus)) {
                    boolean allowExistingInstallLocation = false;
                    if (profilesWithExistingLocations != null && profilesWithExistingLocations.contains(profile)) {
                        allowExistingInstallLocation = true;
                    }
                    status.add(profile.validateInstallLocation(allowExistingInstallLocation));
                }
            }
            if (offering != null) {
                status.add(AgentUtil.validateInstallIntoExistingEclipse(profile, new IOffering[]{offering}));
            }
            status.add(job.validate());
            ++n2;
        }
        if (status.isOK()) {
            return Status.OK_STATUS;
        }
        IStatus[] children = status.getChildren();
        if (children.length == 1) {
            return children[0];
        }
        status.setMessage(children[0].getMessage());
        return status;
    }

    private static Set<Profile> buildAllowNonEmptyLocation(AgentJob[] jobs) {
        HashSet<Profile> result = new HashSet<Profile>();
        AgentJob[] agentJobArray = jobs;
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            AgentJob job = agentJobArray[n2];
            if (OfferingProperty.isExistingLocationAllowed((IOffering)job.getOffering())) {
                result.add(job.getProfile());
            }
            ++n2;
        }
        return result;
    }

    public static String makeUnresolvedRequirementsError(IOffering offering) {
        return NLS.bind((String)com.ibm.cic.agent.internal.core.Messages.AgentUtil_Installation_Package_Requires_External_Components, (Object)offering.getName(), (Object)AgentUtil.getOfferingHintMessage(offering));
    }

    public static String getOfferingHintMessage(IOffering offering) {
        String hint = offering.getProperties().getProperty("offering.dependencies.hint", "");
        String[] hints = hint.trim().split("\\s*;\\s*");
        String msg = com.ibm.cic.agent.internal.core.Messages.AgentUtil_Extension_Package_Satisfaction_Hint2;
        StringBuffer sb = new StringBuffer(32 * hints.length);
        String[] stringArray = hints;
        int n = hints.length;
        int n2 = 0;
        while (n2 < n) {
            String hint2 = stringArray[n2];
            String[] info = hint2.trim().split("\\s*,\\s*");
            if (info.length != 0 && info[0].length() != 0) {
                String id = info[0];
                String version = info.length > 1 ? info[1] : "";
                sb.append('\n');
                if (info.length > 2) {
                    msg = com.ibm.cic.agent.internal.core.Messages.AgentUtil_Extension_Package_Satisfaction_Hint;
                    StringBuffer features = new StringBuffer();
                    int i = 2;
                    while (i < info.length) {
                        if (i > 2) {
                            features.append(", ");
                        }
                        features.append(info[i]);
                        ++i;
                    }
                    sb.append(NLS.bind((String)com.ibm.cic.agent.internal.core.Messages.AgentUtil_Package_Feature_Hint, (Object[])new Object[]{id, version, features}));
                } else {
                    sb.append(NLS.bind((String)com.ibm.cic.agent.internal.core.Messages.AgentUtil_Package_Feature_Hint2, (Object)id, (Object)version));
                }
            }
            ++n2;
        }
        if (sb.length() == 0) {
            return com.ibm.cic.agent.internal.core.Messages.AgentUtil_No_Extension_Package_Hint_Provided;
        }
        return String.valueOf(msg) + sb.toString();
    }

    private static IStatus validateJobsEclipseLocation(AgentJob[] jobs) {
        HashSet validatedProfiles = new HashSet();
        CicMultiStatus status = Statuses.OK.getMultiStatus();
        AgentJob[] agentJobArray = jobs;
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            AgentJob job = agentJobArray[n2];
            Profile profile = job.getProfile();
            if (!validatedProfiles.contains(profile)) {
                status.add(profile.validateEclipseLocationCollision());
            }
            ++n2;
        }
        return status;
    }

    public static IStatus getOfferingsApplicability(List jobs) {
        return AgentUtil.getOfferingsApplicability(jobs, null);
    }

    public static IStatus getOfferingsApplicability(List jobs, AgentJob[] relatedJobs) {
        CicMultiStatus result = Statuses.ST.createMultiStatus(com.ibm.cic.agent.internal.core.Messages.AgentUtil_multipleWarnings, new Object[0]);
        for (AgentJob job : jobs) {
            IStatus status;
            if (relatedJobs != null && !OfferingUtil.isMinimumAgentToleranceLessThan((IOfferingOrFix)job.getOfferingOrFix(), (Version)new Version(1, 4, 0))) {
                job.setRelatedJobs(relatedJobs);
            }
            if (StatusUtil.isErrorOrCancel((IStatus)(status = job.checkOfferingApplicability()))) {
                return status;
            }
            if (!StatusUtil.isWarning((IStatus)status)) continue;
            result.add(status);
        }
        IStatus status = BitModeUtils.check64bitImSupported(AgentJob.toArray(jobs));
        if (StatusUtil.isErrorOrCancel((IStatus)status)) {
            return status;
        }
        if (StatusUtil.isWarning((IStatus)status)) {
            result.add(status);
        }
        return StatusUtil.toSingleStatus((IStatus)result);
    }

    private static boolean isAllowExistingEclipse(IOffering offering) {
        String allowExistingEclipseStr = System.getProperty("allowExistingEclipse");
        if (allowExistingEclipseStr == null) {
            allowExistingEclipseStr = offering.getProperties().getProperty("allowExistingEclipse", "true");
        }
        return !CommonDef.False.equals(allowExistingEclipseStr);
    }

    public static boolean isAllowExistingEclipse(AgentJob[] jobs) {
        AgentJob[] agentJobArray = jobs;
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            AgentJob job = agentJobArray[n2];
            IOffering offering = job.getOffering();
            if (offering != null && !AgentUtil.isAllowExistingEclipse(offering)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isSingletonOffering(IOffering offering) {
        return !CommonDef.False.equals(OfferingProperty.getSingletonOffering((IOffering)offering));
    }

    public static List<IFix> getFixesFromJobs(AgentJob[] jobs) {
        ArrayList<IFix> fixes = new ArrayList<IFix>();
        AgentJob[] agentJobArray = jobs;
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            AgentJob job = agentJobArray[n2];
            IFix fix = job.getFix();
            if (fix != null) {
                fixes.add(fix);
            }
            ++n2;
        }
        return fixes;
    }

    private static IStatus validateInstallIntoExistingEclipse(Profile profile, IOffering[] offerings) {
        if (!profile.isExistingEclipseProfile()) {
            return Status.OK_STATUS;
        }
        if (CicCommonSettings.isPortable()) {
            return Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.AgentUtil_Portable_package_cannot_be_installed_into_existing_eclipse, new Object[0]);
        }
        int i = 0;
        while (i < offerings.length) {
            if (!AgentUtil.isAllowExistingEclipse(offerings[i])) {
                return Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.AgentUtil_Cannot_Install_ExistingEclipse, new Object[0]);
            }
            ++i;
        }
        return Status.OK_STATUS;
    }

    public static boolean hasEclipseContext(IOffering offering) {
        if (offering != null) {
            IShareableEntity se = OfferingUtil.findOfferingShareableEntity((IOffering)offering, (String)"com.ibm.sdp.eclipse.ide");
            if (se instanceof IInstallationContext) {
                return true;
            }
            String property = offering.getProperties().getProperty("minimum.eclipse.ide.platform.version");
            if (property != null) {
                return true;
            }
        }
        return false;
    }

    public static boolean hasEclipseContext(AgentJob[] jobs) {
        AgentJob[] agentJobArray = jobs;
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            AgentJob job = agentJobArray[n2];
            IOffering offering = job.getOffering();
            if (AgentUtil.hasEclipseContext(offering)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static IStatus validateCompatibleOfferings(Profile profile, IOffering[] offerings) {
        IStatus status = AgentUtil.validateCompatibleOfferings(offerings);
        if (status.isOK()) {
            status = AgentUtil.validateInstallIntoExistingEclipse(profile, offerings);
        }
        if (status.isOK()) {
            status = AgentUtil.doValidateCompatibleOfferings(profile, Arrays.asList(offerings), null);
        }
        return status;
    }

    public static IStatus validateCompatibleOfferings(IOffering[] offerings) {
        if (offerings.length > 1) {
            IStatus status = AgentUtil.validateCompatibleOfferingsWithoutPlatform(offerings);
            if (!status.isOK()) {
                return status;
            }
            List<IOffering> offeringsList = Arrays.asList(offerings);
            IStatus bitModeStatus = BitModeUtils.checkBitModeCompatible(offeringsList, null);
            if (!bitModeStatus.isOK()) {
                return bitModeStatus;
            }
            IStatus wsStatus = WindowSystemUtils.checkWindowSystemCompatible(offeringsList, null);
            if (!wsStatus.isOK()) {
                return wsStatus;
            }
        }
        return Status.OK_STATUS;
    }

    public static IStatus validateCompatibleOfferingsWithoutPlatform(IOffering[] offerings) {
        if (offerings.length > 1) {
            List<IOffering> offeringsList = Arrays.asList(offerings);
            IStatus shareStatus = AgentUtil.checkProfileShare(offeringsList);
            if (!shareStatus.isOK()) {
                return shareStatus;
            }
            IStatus p2Status = AgentUtil.checkP2Compatible(offeringsList, null);
            if (!p2Status.isOK()) {
                return p2Status;
            }
            if (AgentUtil.hasIncompatibleOverriddenPredefineds(offerings)) {
                return Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.AgentUtil_Validate_Cannot_Coexist, new Object[0]);
            }
            if (AgentUtil.intuitiveUninstallInstallOrderRequired(offerings) == IntuitiveState.MIXED_INTUITIVE) {
                log.error(com.ibm.cic.agent.internal.core.Messages.AgentUtil_Intuitive_Install_Incompatible_Selection_ErrorLog);
                IOffering[] iOfferingArray = offerings;
                int n = offerings.length;
                int n2 = 0;
                while (n2 < n) {
                    IOffering offering = iOfferingArray[n2];
                    log.error(com.ibm.cic.agent.internal.core.Messages.AgentUtil_Intutive_Property_Error, new Object[]{offering.getName(), offering.getProperty("intuitive.uninstall.install.order.required")});
                    ++n2;
                }
                return Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.AgentUtil_Intuitive_Install_Incompatible_Selection_Error, new Object[0]);
            }
        }
        return Status.OK_STATUS;
    }

    private static IntuitiveState intuitiveUninstallInstallOrderRequired(IOffering[] offerings) {
        boolean bCurIntuitiveState = false;
        boolean bCurOfferingState = false;
        int i = 0;
        while (i < offerings.length) {
            String prop = offerings[i].getProperties().getProperty("intuitive.uninstall.install.order.required");
            bCurOfferingState = Boolean.TRUE.equals(Boolean.valueOf(prop));
            if (i == 0) {
                bCurIntuitiveState = bCurOfferingState;
            } else if (bCurIntuitiveState != bCurOfferingState) {
                return IntuitiveState.MIXED_INTUITIVE;
            }
            ++i;
        }
        return bCurIntuitiveState ? IntuitiveState.INTUITIVE : IntuitiveState.NON_INTUITIVE;
    }

    private static IntuitiveState intuitiveUninstallInstallOrderRequired(List offeringList) {
        return AgentUtil.intuitiveUninstallInstallOrderRequired(offeringList.toArray(new IOffering[offeringList.size()]));
    }

    public static IStatus validateCompatibleJobs(AgentJob[] jobs) {
        if (jobs.length == 0) {
            return Status.OK_STATUS;
        }
        Profile profile = jobs[0].getProfile();
        if (profile.isAgentProfile() || profile.isLicenseProfile()) {
            return Status.OK_STATUS;
        }
        InstallRegistry.ProfileInstallRegistry registry = profile.getInstallRegistry();
        ArrayList<IOffering> offerings = new ArrayList<IOffering>(jobs.length);
        AgentJob[] agentJobArray = jobs;
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            AgentJob job = agentJobArray[n2];
            IOffering offering = job.getOffering();
            assert (profile.equals(job.getProfile()));
            if (offering != null && !job.isUninstall()) {
                offerings.add(offering);
                IOffering installed = registry.getInstalledOffering(offering.getIdentity());
                if (job.isInstall() && installed != null) {
                    return Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.AgentUtil_Offering_Already_Installed, new Object[]{installed.getName()});
                }
            }
            ++n2;
        }
        return AgentUtil.doValidateCompatibleOfferings(profile, offerings, jobs);
    }

    private static IStatus doValidateCompatibleOfferings(Profile profile, List offerings, AgentJob[] jobs) {
        IStatus intuitveStatus;
        IStatus supercedesStatus = AgentUtil.checkSupercedes(offerings, profile);
        if (!supercedesStatus.isOK()) {
            return supercedesStatus;
        }
        IStatus shareStatus = AgentUtil.checkProfileShare(offerings, profile);
        if (!shareStatus.isOK()) {
            return shareStatus;
        }
        IStatus p2Status = AgentUtil.checkP2Compatible(offerings, profile);
        if (!p2Status.isOK()) {
            return p2Status;
        }
        IStatus bitModeStatus = BitModeUtils.checkBitModeCompatible(offerings, profile);
        if (!bitModeStatus.isOK()) {
            return bitModeStatus;
        }
        IStatus wsStatus = WindowSystemUtils.checkWindowSystemCompatible(offerings, profile);
        if (!wsStatus.isOK()) {
            return wsStatus;
        }
        if (offerings.size() > 0 && jobs != null && !(intuitveStatus = AgentUtil.checkIntuitiveCompatible(offerings, profile, jobs)).isOK()) {
            return intuitveStatus;
        }
        for (IOffering offering : offerings) {
            if (!AgentUtil.hasIncompatibleOverriddenPredefineds(profile, offering)) continue;
            return Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.AgentUtil_Validate_Cannot_Coexist, new Object[0]);
        }
        return new SingletonOfferingCheck(profile).perform(OfferingUtil.toOfferingArray((Collection)offerings));
    }

    private static IStatus checkIntuitiveCompatible(List offerings, Profile profile, AgentJob[] jobs) {
        IOffering[] installedOfferings = profile.getInstalledOfferings();
        boolean bEmptyProfile = installedOfferings.length == 0;
        IntuitiveState installedOfferingsStatus = AgentUtil.intuitiveUninstallInstallOrderRequired(installedOfferings);
        IntuitiveState selectedOfferingsStatus = AgentUtil.intuitiveUninstallInstallOrderRequired(offerings);
        AgentJob.AgentJobType jobType = jobs[0].getType();
        IOfferingOrFix[] offeringOrFixes = new IOfferingOrFix[jobs.length];
        int i = 0;
        while (i < jobs.length) {
            offeringOrFixes[i] = jobs[i].getOfferingOrFix();
            ++i;
        }
        if (installedOfferingsStatus == IntuitiveState.MIXED_INTUITIVE) {
            IOffering[] iOfferingArray = installedOfferings;
            int n = installedOfferings.length;
            int n2 = 0;
            while (n2 < n) {
                IOffering installedOffering = iOfferingArray[n2];
                String prop = installedOffering.getProperties().getProperty("intuitive.uninstall.install.order.required");
                log.error(com.ibm.cic.agent.internal.core.Messages.AgentUtil_Intutive_Property_Error, new Object[]{installedOffering.getName(), prop});
                ++n2;
            }
            return Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.AgentUtil_Install_Location_Intuitive_problem_Error, new Object[0]);
        }
        if (selectedOfferingsStatus == IntuitiveState.MIXED_INTUITIVE) {
            log.error(com.ibm.cic.agent.internal.core.Messages.AgentUtil_Intuitive_Install_Incompatible_Selection_ErrorLog);
            for (IOffering offering : offerings) {
                String prop = offering.getProperties().getProperty("intuitive.uninstall.install.order.required");
                log.error(com.ibm.cic.agent.internal.core.Messages.AgentUtil_Intutive_Property_Error, new Object[]{offering.getName(), prop});
            }
            return Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.AgentUtil_Intuitive_Install_Incompatible_Selection_Error, new Object[0]);
        }
        if (jobType.isInstall() && !bEmptyProfile && installedOfferingsStatus != selectedOfferingsStatus) {
            String offeringLabel = OfferingUtil.getOfferingOrFixLabel((IOfferingOrFix)offeringOrFixes[0]);
            log.error(com.ibm.cic.agent.internal.core.Messages.AgentUtil_Intuitive_Install_Incompatible_Installed_Packages_ErrorLog, new Object[]{offeringLabel});
            IOffering[] iOfferingArray = installedOfferings;
            int n = installedOfferings.length;
            int prop = 0;
            while (prop < n) {
                IOffering installedOffering = iOfferingArray[prop];
                String prop2 = installedOffering.getProperties().getProperty("intuitive.uninstall.install.order.required");
                log.error(com.ibm.cic.agent.internal.core.Messages.AgentUtil_Intutive_Property_Error, new Object[]{installedOffering.getName(), prop2});
                ++prop;
            }
            for (IOffering offering : offerings) {
                String prop3 = offering.getProperties().getProperty("intuitive.uninstall.install.order.required");
                log.error(com.ibm.cic.agent.internal.core.Messages.AgentUtil_Intutive_Property_Error, new Object[]{offering.getName(), prop3});
            }
            return Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.AgentUtil_Intuitive_Install_Incompatible_Installed_Packages_Error, new Object[]{offeringLabel});
        }
        if (jobType.isUpdate()) {
            if (installedOfferingsStatus == IntuitiveState.NON_INTUITIVE && selectedOfferingsStatus == IntuitiveState.INTUITIVE && installedOfferings.length != offerings.size() || installedOfferingsStatus == IntuitiveState.INTUITIVE && selectedOfferingsStatus == IntuitiveState.NON_INTUITIVE) {
                IOffering updatingOffering = AgentUtil.getCorrespondingOffering(installedOfferings, offeringOrFixes);
                String prop = updatingOffering.getProperties().getProperty("intuitive.uninstall.install.order.required");
                log.error(com.ibm.cic.agent.internal.core.Messages.AgentUtil_Intutive_Installed_Property_Error, new Object[]{OfferingUtil.getOfferingOrFixLabel((IOfferingOrFix)updatingOffering), prop});
                prop = offeringOrFixes[0].getProperties().getProperty("intuitive.uninstall.install.order.required");
                log.error(com.ibm.cic.agent.internal.core.Messages.AgentUtil_Intutive_Update_Property_Error, new Object[]{OfferingUtil.getOfferingOrFixLabel((IOfferingOrFix)offeringOrFixes[0]), prop});
                return Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.AgentUtil_Intuitive_Update_Incompatible_Error, new Object[]{OfferingUtil.getOfferingOrFixLabel((IOfferingOrFix)updatingOffering), OfferingUtil.getOfferingOrFixLabel((IOfferingOrFix)offeringOrFixes[0])});
            }
        } else if (jobType.isRollback() && installedOfferingsStatus == IntuitiveState.INTUITIVE && selectedOfferingsStatus == IntuitiveState.NON_INTUITIVE && installedOfferings.length != offeringOrFixes.length) {
            IOffering rollbackOffering = AgentUtil.getCorrespondingOffering(installedOfferings, offeringOrFixes);
            String prop = rollbackOffering.getProperties().getProperty("intuitive.uninstall.install.order.required");
            log.error(com.ibm.cic.agent.internal.core.Messages.AgentUtil_Intutive_Installed_Property_Error, new Object[]{OfferingUtil.getOfferingOrFixLabel((IOfferingOrFix)rollbackOffering), prop});
            prop = offeringOrFixes[0].getProperties().getProperty("intuitive.uninstall.install.order.required");
            log.error(com.ibm.cic.agent.internal.core.Messages.AgentUtil_Intutive_Rollback_Property_Error, new Object[]{OfferingUtil.getOfferingOrFixLabel((IOfferingOrFix)offeringOrFixes[0]), prop});
            return Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.AgentUtil_Intuitive_Rollback_Incompatible_Error, new Object[]{OfferingUtil.getOfferingOrFixLabel((IOfferingOrFix)rollbackOffering), OfferingUtil.getOfferingOrFixLabel((IOfferingOrFix)offeringOrFixes[0])});
        }
        return Status.OK_STATUS;
    }

    private static IOffering getCorrespondingOffering(IOffering[] installedOfferings, IOfferingOrFix[] offeringOrFixes) {
        String updateOfferingId = offeringOrFixes[0].getIdentity().getId();
        int indexInstalledOffering = 0;
        int i = 0;
        while (i < installedOfferings.length) {
            if (updateOfferingId.equals(installedOfferings[i].getIdentity().getId())) {
                indexInstalledOffering = i;
                break;
            }
            ++i;
        }
        return installedOfferings[indexInstalledOffering];
    }

    public static IStatus checkP2Compatible(List oofs, Profile profile) {
        boolean p2Compatible = false;
        boolean classicCompatible = false;
        for (IOfferingOrFix oof : oofs) {
            String value = AgentUtil.getEclipseCompatibility(oof);
            if ("classic".equals(value)) {
                classicCompatible = true;
                continue;
            }
            if (!"p2".equals(value)) continue;
            p2Compatible = true;
        }
        if (profile != null) {
            IFix[] installedFixes;
            IOffering[] installedOfferings;
            IOffering[] iOfferingArray = installedOfferings = profile.getInstallRegistry().getInstalledOfferings();
            int n = installedOfferings.length;
            int value = 0;
            while (value < n) {
                IOffering offering = iOfferingArray[value];
                String value2 = AgentUtil.getEclipseCompatibility((IOfferingOrFix)offering);
                if ("classic".equals(value2)) {
                    classicCompatible = true;
                } else if ("p2".equals(value2)) {
                    p2Compatible = true;
                }
                ++value;
            }
            IFix[] iFixArray = installedFixes = profile.getInstallRegistry().getInstalledFixes();
            int n2 = installedFixes.length;
            n = 0;
            while (n < n2) {
                IFix fix = iFixArray[n];
                String value3 = AgentUtil.getEclipseCompatibility((IOfferingOrFix)fix);
                if ("classic".equals(value3)) {
                    classicCompatible = true;
                } else if ("p2".equals(value3)) {
                    p2Compatible = true;
                }
                ++n;
            }
        }
        if (p2Compatible && classicCompatible) {
            return Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.AgentUtil_Validate_Cannot_Coexist, new Object[0]);
        }
        return Status.OK_STATUS;
    }

    public static String getEclipseCompatibility(IOfferingOrFix oof) {
        return oof.getProperties().getProperty("eclipseCompatibility", "classic");
    }

    private static IStatus checkSupercedes(List offerings, Profile profile) {
        IOffering[] installedOfferings = profile.getInstallRegistry().getInstalledOfferings();
        ArrayList<IOffering> maySupercede = new ArrayList<IOffering>(offerings);
        maySupercede.addAll(Arrays.asList(installedOfferings));
        for (IOffering offering : maySupercede) {
            List supercedes = OfferingProperty.getSupercedes((IOffering)offering);
            for (IOffering o : offerings) {
                if (!supercedes.contains(o.getIdentity())) continue;
                return Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.AgentUtil_Superceded_Offering, new Object[]{o.getName(), OfferingUtil.getOfferingOrFixLabel((IOfferingOrFix)offering)});
            }
        }
        return Status.OK_STATUS;
    }

    private static IStatus checkProfileShare(List offerings, Profile profile) {
        IOffering[] installedOfferings;
        if (profile != null && (installedOfferings = profile.getInstallRegistry().getInstalledOfferings()).length > 0) {
            ArrayList<IOffering> allOfferings = new ArrayList<IOffering>(offerings.size() + installedOfferings.length);
            HashSet<IIdentity> offeringIds = new HashSet<IIdentity>(offerings.size());
            for (IOffering offering : offerings) {
                allOfferings.add(offering);
                offeringIds.add(offering.getIdentity());
            }
            IOffering[] iOfferingArray = installedOfferings;
            int n = installedOfferings.length;
            int n2 = 0;
            while (n2 < n) {
                IOffering offering = iOfferingArray[n2];
                if (!offeringIds.contains(offering.getIdentity())) {
                    allOfferings.add(offering);
                }
                ++n2;
            }
            offerings = allOfferings;
        }
        return AgentUtil.checkProfileShare(offerings);
    }

    private static IStatus checkProfileShare(List offerings) {
        Set shareIntersection = null;
        for (IOffering offering : offerings) {
            if (LicenseUtils.isPEKOffering((IOffering)offering)) continue;
            Set shareSet = OfferingProperty.getProfileShareSet((IOffering)offering);
            if (shareSet.isEmpty() && Agent.isExtensionOffering((IOfferingOrFix)offering)) {
                shareSet = OfferingProperty.UNIVERSAL_SET;
            }
            if (shareIntersection == null) {
                shareIntersection = shareSet;
                continue;
            }
            if (!(shareIntersection = AgentUtil.intersectShareSets(shareIntersection, shareSet)).isEmpty()) continue;
            for (IOffering offering2 : offerings) {
                Set shareSet2 = OfferingProperty.getProfileShareSet((IOffering)offering2);
                if (!AgentUtil.intersectShareSets(shareSet, shareSet2).isEmpty()) continue;
                return Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.AgentSelectorExpander_Incompatible_Profile_Share, new Object[]{OfferingUtil.getOfferingOrFixLabel((IOfferingOrFix)offering2), OfferingUtil.getOfferingOrFixLabel((IOfferingOrFix)offering)});
            }
            return Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.AgentSelectorExpander_Incompatible_Profile_Share2, new Object[]{OfferingUtil.getOfferingOrFixLabel((IOfferingOrFix)offering)});
        }
        return Status.OK_STATUS;
    }

    private static Set intersectShareSets(Set set1, Set set2) {
        if (set1 == OfferingProperty.UNIVERSAL_SET) {
            return set2;
        }
        if (set2 == OfferingProperty.UNIVERSAL_SET) {
            return set1;
        }
        if (set1.isEmpty() || set2.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        HashSet result = new HashSet(set1);
        result.retainAll(set2);
        return result;
    }

    private static boolean hasIncompatibleOverriddenPredefineds(IOffering[] offerings) {
        return offerings != null && offerings.length >= 2 && AgentUtil.hasIncompatibleOverriddenPredefineds(offerings[0], offerings, 1);
    }

    private static boolean hasIncompatibleOverriddenPredefineds(Profile profile, IOffering offering) {
        return profile != null && offering != null && AgentUtil.hasIncompatibleOverriddenPredefineds(offering, profile.getInstallRegistry().getInstalledOfferings(), 0);
    }

    private static boolean hasIncompatibleOverriddenPredefineds(IOffering givenOffering, IOffering[] otherOfferings, int startIndex) {
        Map map1 = PredefinedSelectors.makeOverridesMap((Map)givenOffering.getProperties(), (boolean)false);
        int i = startIndex;
        while (i < otherOfferings.length) {
            Map map2 = PredefinedSelectors.makeOverridesMap((Map)otherOfferings[i].getProperties(), (boolean)false);
            if (AgentUtil.incompatibleOverrides(givenOffering, map1, otherOfferings[i], map2)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean incompatibleOverrides(IOffering offering1, Map map1, IOffering offering2, Map map2) {
        if (map1 == null) {
            if (map2 != null) {
                log.debug("Only one has overridden predefined selectors!");
                log.debug("{0}: {1}", new Object[]{offering2, map2});
                return true;
            }
        } else if (!map1.equals(map2)) {
            log.debug("Overridden predefined selectors don't match!");
            log.debug("{0}: {1}", new Object[]{offering1, map1});
            log.debug("{0}: {1}", new Object[]{offering2, map2});
            return true;
        }
        return false;
    }

    public static Profile makeNewProfileForJob(AbstractJob job) {
        IOffering offering = job.getOffering();
        if (Agent.isExtensionOffering((IOfferingOrFix)offering) || LicenseUtils.isPEKOffering((IOffering)offering)) {
            return null;
        }
        Profile profile = AgentUtil.makeNewProfileForOffering(offering, job.getInstallLocation());
        BitModeUtils.initializeProfilePlatformProperties(profile, (IOfferingOrFix[])new IOffering[]{offering});
        return profile;
    }

    public static Profile makeNewIMProfileForJob(AbstractJob job) {
        Profile profile = AgentUtil.makeNewProfileForJob(job);
        return profile;
    }

    public static Profile makeNewProfileForOfferings(IOffering[] offerings, List<? extends AgentJob> jobs) {
        int minLength = Integer.MAX_VALUE;
        IOffering offering = null;
        IOffering[] iOfferingArray = offerings;
        int n = offerings.length;
        int n2 = 0;
        while (n2 < n) {
            int pathLength;
            IOffering currentOffering = iOfferingArray[n2];
            if (!Agent.isExtensionOffering((IOfferingOrFix)currentOffering) && !LicenseUtils.isPEKOffering((IOffering)currentOffering) && (pathLength = PlatformUtils.getMaxInstallLocationLengthForOffering((IOffering)currentOffering)) < minLength) {
                minLength = pathLength;
                offering = currentOffering;
            }
            ++n2;
        }
        if (offering == null) {
            return null;
        }
        Profile profile = AgentUtil.makeNewProfileForOffering(offering, AgentUtil.getInstallLocation(jobs));
        BitModeUtils.initializeProfilePlatformProperties(profile, jobs.toArray(new AgentJob[jobs.size()]));
        return profile;
    }

    private static Profile makeNewProfileForOffering(IOffering offering, String installLocation) {
        Profile profile = Profile.makeNewProfileForOffering(offering, null, installLocation, false);
        if (!AgentUtil.singletonOfferingCheck(profile, offering).isOK()) {
            return null;
        }
        profile.setShadow(true);
        return profile;
    }

    private static String getInstallLocation(List jobs) {
        for (AbstractJob object : jobs) {
            if (!(object instanceof InstallJob)) continue;
            return ((InstallJob)object).getInstallLocation();
        }
        return null;
    }

    public static IStatus validateInstallDirectoryPermissions(String installLocation) {
        IStatus status = Status.OK_STATUS;
        File dir = new File(installLocation);
        DirPermissionStatus permStatus = AgentUtil.validateDirectoryPermissions(dir);
        if (permStatus.equals((Object)DirPermissionStatus.NO_READ)) {
            status = Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.AgentUtil_Installation_Directory_Not_Readable, new Object[]{dir.toString()});
        } else if (permStatus.equals((Object)DirPermissionStatus.NO_WRITE)) {
            status = Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.AgentUtil_Installation_Directory_Not_Writable, new Object[]{dir.toString()});
        } else if (permStatus.equals((Object)DirPermissionStatus.NO_CREATE)) {
            status = Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.AgentUtil_Installation_Directory_Parent_Dirs_Not_Executable, new Object[]{dir.toString()});
        } else if (permStatus.equals((Object)DirPermissionStatus.NO_READ_WRITE)) {
            status = Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.AgentUtil_Installation_Directory_Not_Readable_And_Not_Writable, new Object[]{dir.toString()});
        }
        return status;
    }

    public static IStatus validateCommonDirectoryPermissions(String directory) {
        IStatus status = Status.OK_STATUS;
        if (directory == null || directory.equals("")) {
            return status;
        }
        File dir = new File(directory);
        DirPermissionStatus permStatus = AgentUtil.validateDirectoryPermissions(dir);
        if (permStatus.equals((Object)DirPermissionStatus.NO_READ)) {
            status = Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.AgentUtil_Shared_Resources_Dir_Not_Readable, new Object[]{dir.toString()});
        } else if (permStatus.equals((Object)DirPermissionStatus.NO_WRITE)) {
            status = Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.AgentUtil_Shared_Resources_Dir_Not_Writable, new Object[]{dir.toString()});
        } else if (permStatus.equals((Object)DirPermissionStatus.NO_CREATE)) {
            status = Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.AgentUtil_Shared_Resources_Dir_Parent_Dirs_Not_Executable, new Object[]{dir.toString()});
        } else if (permStatus.equals((Object)DirPermissionStatus.NO_READ_WRITE)) {
            status = Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.AgentUtil_Shared_Resources_Dir_Not_Readable_And_Not_Writable, new Object[]{dir.toString()});
        }
        return status;
    }

    private static DirPermissionStatus validateDirectoryPermissions(File dir) {
        DirPermissionStatus status = DirPermissionStatus.OK;
        if (!CicCommonSettings.getAccessRightsMode().isAdminMode()) {
            if (dir.isDirectory()) {
                if (!FileUtil.canWrite((File)dir)) {
                    status = DirPermissionStatus.NO_WRITE;
                }
                if (CicCommonSettings.getAccessRightsMode().isGroupMode() && !FileUtil.canRead((File)dir)) {
                    status = status.equals((Object)DirPermissionStatus.NO_WRITE) ? DirPermissionStatus.NO_READ_WRITE : DirPermissionStatus.NO_READ;
                }
            } else if (!FileUtil.directoryIsWriteable((String)FileUtil.getCanonicalPath((File)dir))) {
                status = DirPermissionStatus.NO_CREATE;
            }
        }
        return status;
    }

    public static ICicStatus validateCacheLocation(List jobs, String location, IOffering[] offerings) {
        if (jobs == null) {
            return AgentUtil.validateCacheLocation(null, location, offerings);
        }
        return AgentUtil.validateCacheLocation(AgentJob.toArray(jobs), location, offerings);
    }

    public static ICicStatus validateCacheLocation(AgentJob[] jobs, String location, IOffering[] offerings) {
        IStatus status = PlatformUtils.validatePath((String)location);
        if (!status.isOK()) {
            return Statuses.ERROR.get(String.valueOf(com.ibm.cic.agent.internal.core.Messages.CacheManager_Invalid_Cache_Location) + " " + status.getMessage(), new Object[0]);
        }
        if (location.indexOf(44) >= 0) {
            return Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.AgentUtil_Shared_Resources_Directory_Path_May_Not_Contain_A_Comma, new Object[0]);
        }
        if (offerings != null) {
            IOffering[] iOfferingArray = offerings;
            int n = offerings.length;
            int n2 = 0;
            while (n2 < n) {
                IOffering offering = iOfferingArray[n2];
                int length = PlatformUtils.getMaxCacheLocationLengthForOffering((IOffering)offering);
                if (location.length() > length) {
                    String msg = NLS.bind((String)com.ibm.cic.agent.internal.core.Messages.CacheManager_Offering_Cache_Location_Length, (Object[])new Object[]{offering.getName(), length, location.length() - length});
                    return Statuses.ERROR.get(msg, new Object[0]);
                }
                ++n2;
            }
        }
        Profile agentProfile = Agent.getInstance().getAgentProfile();
        String agentDirPath = null;
        if (agentProfile != null) {
            if (agentProfile.skipLocationValidation()) {
                return ICicStatus.OK_STATUS;
            }
            agentDirPath = agentProfile.getInstallLocation();
        } else {
            AgentJob installIMJob = AgentUtil.getInstallIMJob(jobs);
            if (installIMJob != null) {
                if (installIMJob.getProfile().skipLocationValidation()) {
                    return ICicStatus.OK_STATUS;
                }
                if (installIMJob.getProfile().getInstallLocation() != null) {
                    agentDirPath = installIMJob.getProfile().getInstallLocation();
                }
            }
        }
        if (agentDirPath != null && FileUtil.directoriesAreRelated((String)agentDirPath, (String)location)) {
            return Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.AgentUtil_Shared_Resources_Directory_Not_Allowed_Under_IM_Install_Dir, new Object[]{location, agentDirPath});
        }
        ICicStatus dataLocationStatus = AgentUtil.validateCacheAndDataLocationCollision(location);
        if (!dataLocationStatus.isOK()) {
            return dataLocationStatus;
        }
        ICicStatus registryLocationStatus = AgentUtil.validateCacheAndRegistryLocationCollision(location);
        if (!registryLocationStatus.isOK()) {
            return registryLocationStatus;
        }
        File file = new File(location);
        if (!file.exists()) {
            return ICicStatus.OK_STATUS;
        }
        if (!file.isDirectory()) {
            return Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.Agent_Invalid_Cache_Location, new Object[]{location});
        }
        String[] fileList = file.list();
        if (fileList == null || fileList.length == 0) {
            return ICicStatus.OK_STATUS;
        }
        RepositoryGroup tmpGroup = new RepositoryGroup("tmpGroup");
        IRepository rep = tmpGroup.addExistingRepository(location, false);
        if (rep != null) {
            try {
                String id = rep.getSiteProperties().getProperty("CACHE_MANAGER_REPOSITORY");
                if (id.length() > 0) {
                    if (!id.equals("cache")) {
                        ICicStatus iCicStatus = Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.Agent_Invalid_Cache_Location_Repository, new Object[]{location});
                        return iCicStatus;
                    }
                    ICicStatus iCicStatus = Statuses.WARNING.get(com.ibm.cic.agent.internal.core.Messages.Agent_Possible_Invalid_Cache_Location_Repository, new Object[]{location});
                    return iCicStatus;
                }
                if (rep.containsMetadata()) {
                    ICicStatus iCicStatus = Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.Agent_Invalid_Cache_Location_Repository, new Object[]{location});
                    return iCicStatus;
                }
                ICicStatus iCicStatus = Statuses.WARNING.get(com.ibm.cic.agent.internal.core.Messages.Agent_Possible_Invalid_Cache_Location_Repository, new Object[]{location});
                return iCicStatus;
            }
            finally {
                tmpGroup.removeAllRepositories();
            }
        }
        if (fileList.length == 1) {
            Path dipPath;
            File dipDir = CacheManager.getIncompleteDownloadsDir(file);
            Path foundPath = new Path(new File(file, fileList[0]).toString());
            if (!foundPath.isPrefixOf((IPath)(dipPath = new Path(dipDir.toString())))) {
                return Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.Agent_Invalid_Cache_Location, new Object[]{location});
            }
            return ICicStatus.OK_STATUS;
        }
        return Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.Agent_Invalid_Cache_Location, new Object[]{location});
    }

    private static ICicStatus validateCacheAndDataLocationCollision(String location) {
        String dataLocation = CicCommonSettings.getApplicationDataLocation();
        if (!FileUtil.directoriesAreRelated((String)dataLocation, (String)location)) {
            return ICicStatus.OK_STATUS;
        }
        return Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.AgentUtil_Shared_Resources_Directory_And_Data_Location_Collision, new Object[]{location, dataLocation});
    }

    private static ICicStatus validateCacheAndRegistryLocationCollision(String location) {
        File registryFile = AgentRegistry.getInstance().getRegistryFile();
        if (registryFile == null) {
            return ICicStatus.OK_STATUS;
        }
        if (CicCommonSettings.getAccessRightsMode().isGroupMode()) {
            return ICicStatus.OK_STATUS;
        }
        String registryLocation = registryFile.getParent();
        if (!FileUtil.directoriesAreRelated((String)registryLocation, (String)location)) {
            return ICicStatus.OK_STATUS;
        }
        return Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.AgentUtil_Shared_Resources_Directory_And_Registry_Location_Collision, new Object[]{location, registryLocation});
    }

    public static ICicStatus validateVistaVirtualizationLocation(String location, IOffering[] offerings) {
        if (offerings == null || offerings.length == 0) {
            return ICicStatus.OK_STATUS;
        }
        if (!CicCommonSettings.isWindowsVistaOrSimilar()) {
            return ICicStatus.OK_STATUS;
        }
        boolean warnVistaVirtualizationDir = false;
        IOffering[] iOfferingArray = offerings;
        int n = offerings.length;
        int n2 = 0;
        while (n2 < n) {
            IOffering offering = iOfferingArray[n2];
            if (OfferingProperty.warnVistaVirtualizationDir((IOffering)offering)) {
                warnVistaVirtualizationDir = true;
                break;
            }
            ++n2;
        }
        if (warnVistaVirtualizationDir && AgentUtil.startsWithSpecialFolder(location)) {
            return Statuses.WARNING.get(com.ibm.cic.agent.internal.core.Messages.Vista_Virtualization_Warning, new Object[0]);
        }
        return ICicStatus.OK_STATUS;
    }

    public static IStatus validateVistaVirtualizationLocation(List jobs, IOffering[] offerings) {
        if (jobs == null || jobs.isEmpty()) {
            return Status.OK_STATUS;
        }
        AgentJob job = (AgentJob)jobs.get(0);
        String installLocation = job.getProfile().getInstallLocation();
        if (installLocation == null || installLocation.length() == 0) {
            return Status.OK_STATUS;
        }
        return AgentUtil.validateVistaVirtualizationLocation(installLocation, offerings);
    }

    private static boolean startsWithSpecialFolder(String dirPath) {
        boolean return_value = false;
        String[] specialPaths = new String[]{PlatformUtils.getSpecialFolder((String)"PROGRAM_FILES", (boolean)false), PlatformUtils.getSpecialFolder((String)"PROGRAM_FILES", (boolean)true), PlatformUtils.getSpecialFolder((String)"COMMON_APPDATA"), PlatformUtils.getSpecialFolder((String)"WINDOWS")};
        if (dirPath != null) {
            String lowerCasePath = dirPath.toLowerCase();
            String[] stringArray = specialPaths;
            int n = specialPaths.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s != null) {
                    s = s.toLowerCase();
                    int sl = s.length();
                    if (lowerCasePath.startsWith(s)) {
                        if (sl < lowerCasePath.length()) {
                            if (CicFileLocation.isSeparator((char)lowerCasePath.charAt(sl))) {
                                return_value = true;
                                break;
                            }
                        } else {
                            return_value = true;
                            break;
                        }
                    }
                }
                ++n2;
            }
        }
        return return_value;
    }

    private static List getAllPekOfferings(List pool) {
        LinkedList<IOffering> result = new LinkedList<IOffering>();
        List offerings = pool;
        if (pool == null) {
            IRepositoryGroup repositories = Agent.getInstance().getRepositoryGroup();
            offerings = repositories.getAllOfferings((IProgressMonitor)new NullProgressMonitor());
        }
        for (IOffering offering : offerings) {
            if (!LicenseUtils.isPEKOffering((IOffering)offering)) continue;
            result.add(offering);
        }
        return result;
    }

    private static List getAllApplicablePekOfferings(IOffering prod, List pool) {
        List peks = AgentUtil.getAllPekOfferings(pool);
        LinkedList<IOffering> result = new LinkedList<IOffering>();
        for (IOffering pek : peks) {
            if (!LicenseUtils.isPekApplicableToOffering((IOffering)pek, (IOffering)prod)) continue;
            result.add(pek);
        }
        return result;
    }

    private static List getAllApplicablePekOfferings(IOffering prod, IFeatureBase featureOrGroup, List pool) {
        List peks = AgentUtil.getAllPekOfferings(pool);
        LinkedList<IOffering> result = new LinkedList<IOffering>();
        for (IOffering pek : peks) {
            if (!LicenseUtils.isPekApplicableToFeature((IOffering)pek, (IOffering)prod, (IFeatureBase)featureOrGroup)) continue;
            result.add(pek);
        }
        return result;
    }

    private static void pickPeks(List peks, LinkedHashMap peksToPick) {
        for (IOffering pek : peks) {
            String pekId = pek.getIdentity().getId();
            IOffering pekToPick = (IOffering)peksToPick.get(pekId);
            if (pekToPick == null) {
                peksToPick.put(pekId, pek);
                continue;
            }
            if (LicenseUtils.getLocalizedLicenseKindsArray((IOffering)pekToPick)[0].equalsIgnoreCase(LicenseUtils.LICENSE_TYPE_PERM)) continue;
            if (LicenseUtils.getLocalizedLicenseKindsArray((IOffering)pek)[0].equalsIgnoreCase(LicenseUtils.LICENSE_TYPE_PERM)) {
                peksToPick.put(pekId, pek);
                continue;
            }
            if (pek.getVersion().compareTo(pekToPick.getVersion()) <= 0) continue;
            peksToPick.put(pekId, pek);
        }
    }

    private static boolean isPekAutoEnabled() {
        String enableStr = CicPreferenceManager.getInstance().getString(ICicPreferenceConstants.PREF_LICENSE_AUTO_PEK.key(), null);
        if (enableStr != null) {
            return !enableStr.equals("false");
        }
        return true;
    }

    public static IOffering[] getApplicablePekOfferings(IOffering prod, List pool) {
        if (prod == null || LicenseUtils.isPEKOffering((IOffering)prod) || !AgentUtil.isPekAutoEnabled()) {
            return null;
        }
        List peks = AgentUtil.getAllApplicablePekOfferings(prod, pool);
        LinkedHashMap peksToPick = new LinkedHashMap();
        AgentUtil.pickPeks(peks, peksToPick);
        return OfferingUtil.toOfferingArray(peksToPick.values());
    }

    public static IOffering getApplicablePekOffering(IOffering prod, IFeatureBase featureOrGroup, List pool) {
        if (prod == null || LicenseUtils.isPEKOffering((IOffering)prod) || !AgentUtil.isPekAutoEnabled()) {
            return null;
        }
        List peks = AgentUtil.getAllApplicablePekOfferings(prod, featureOrGroup, pool);
        LinkedHashMap peksToPick = new LinkedHashMap();
        AgentUtil.pickPeks(peks, peksToPick);
        if (peksToPick.size() != 1) {
            return null;
        }
        IOffering result = (IOffering)peksToPick.values().iterator().next();
        return result;
    }

    public static boolean isPekInstalled(IOffering pek) {
        Agent agent = Agent.getInstance();
        if (agent.isSkipInstall()) {
            return false;
        }
        IOffering[] installedpeks = agent.getInstalledOfferings(Profile.getLicenseProfile(agent));
        if (installedpeks == null || installedpeks.length < 1) {
            return false;
        }
        IOffering[] iOfferingArray = installedpeks;
        int n = installedpeks.length;
        int n2 = 0;
        while (n2 < n) {
            IOffering installedpek = iOfferingArray[n2];
            if (installedpek.getIdentity().equals(pek.getIdentity()) && installedpek.getVersion().equals((Object)pek.getVersion())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static List getPekInstallJobs(IOffering prod) {
        Agent agent = Agent.getInstance();
        IOffering[] peks = AgentUtil.getApplicablePekOfferings(prod, null);
        if (peks == null) {
            return new ArrayList();
        }
        ArrayList<InstallJob> result = new ArrayList<InstallJob>(peks.length);
        IOffering[] iOfferingArray = peks;
        int n = peks.length;
        int n2 = 0;
        while (n2 < n) {
            IOffering pek = iOfferingArray[n2];
            if (!AgentUtil.isPekInstalled(pek)) {
                List pekfl = pek.getFeatureGroup().getChildren();
                IFeature[] pekfa = OfferingUtil.toFeaturesAsArray((Collection)pekfl);
                agent.prepare((IOfferingOrFix)pek, ExtensionCategory.ALL, (IProgressMonitor)new NullProgressMonitor());
                InstallJob pekjob = new InstallJob(Profile.getLicenseProfile(agent), (IOfferingOrFix)pek, pekfa);
                result.add(pekjob);
            }
            ++n2;
        }
        return result;
    }

    public static Collection<IFeature> getVisibleInstalledFeatures(Agent agent, Profile profile, IOffering offering) {
        Set installedFeatures = agent.getInstalledFeatures(profile, offering);
        ArrayList<IFeature> visible = new ArrayList<IFeature>(installedFeatures.size());
        for (IFeature feature : installedFeatures) {
            if (!feature.isVisible()) continue;
            visible.add(feature);
        }
        return visible;
    }

    public static Collection<IFeature> getVisibleOptionalInstalledFeatures(Agent agent, Profile profile, IOffering offering) {
        Set installedFeatures = agent.getInstalledFeatures(profile, offering);
        ArrayList<IFeature> visible = new ArrayList<IFeature>(installedFeatures.size());
        for (IFeature feature : installedFeatures) {
            if (!feature.isVisible() || OfferingUtil.isFeatureRequired((IFeatureBase)feature)) continue;
            visible.add(feature);
        }
        return visible;
    }

    public static Collection groupByProfile(AgentJob[] jobs, boolean checkProfile) {
        MapList map = new MapList();
        AgentJob[] agentJobArray = jobs;
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            AgentJob job = agentJobArray[n2];
            if (!job.isError()) {
                String profileId = job.getProfile().getProfileId();
                if (checkProfile && map.contains((Object)profileId) && !InstallRegistry.getInstance().hasProfile(job.getProfile())) {
                    throw new IllegalArgumentException(NLS.bind((String)"Profile is not registered: {0}", (Object)profileId));
                }
                map.add((Object)profileId, (Object)job);
            }
            ++n2;
        }
        int size = map.size();
        if (size == 0) {
            return Collections.EMPTY_LIST;
        }
        if (size == 1) {
            return Collections.singletonList(jobs);
        }
        ArrayList<AgentJob[]> result = new ArrayList<AgentJob[]>(size);
        for (List list : map.toMap().values()) {
            result.add(AgentJob.toArray(list));
        }
        return result;
    }

    public static boolean hasInstallAgentJob(AgentJob[] jobs) {
        if (jobs == null || jobs.length == 0) {
            return false;
        }
        AgentJob[] agentJobArray = jobs;
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            AgentJob job = agentJobArray[n2];
            IOffering offering = job.getOffering();
            if ((job.getType().isInstall() || job.getType().isUpdate()) && offering != null && Agent.getInstance().isAgentOffering((IOfferingOrFix)offering)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void setOnlyInstallingAgent(boolean value) {
        onlyInstallingAgent = value;
    }

    static void setOnlyInstallingAgent(AgentJob[] jobs) {
        AgentUtil.setOnlyInstallingAgent(AgentUtil.hasInstallAgentJob(jobs) && jobs.length == 1);
    }

    public static boolean isFinalUninstall(Profile profile, AgentJob[] jobs) {
        if (profile == null || jobs == null || jobs.length == 0) {
            return false;
        }
        InstallRegistry.ProfileInstallRegistry registry = profile.getInstallRegistry();
        HashSet<IOffering> toBeUninstalled = new HashSet<IOffering>();
        AgentJob[] agentJobArray = jobs;
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            AgentJob job = agentJobArray[n2];
            if (profile.equals(job.getProfile())) {
                AgentJob.AgentJobType type = job.getType();
                if (!type.isUninstall()) {
                    return false;
                }
                IOffering offering = job.getOffering();
                if (offering != null) {
                    List featuresToBeUninstalled = job.getFeatures();
                    Set<IFeature> installedFeatures = registry.getInstalledFeatures(offering);
                    installedFeatures.removeAll(featuresToBeUninstalled);
                    if (!installedFeatures.isEmpty()) {
                        return false;
                    }
                    toBeUninstalled.add(offering);
                }
            }
            ++n2;
        }
        if (toBeUninstalled.isEmpty()) {
            return false;
        }
        HashSet<IOffering> installed = new HashSet<IOffering>();
        IOffering[] installedOfferings = registry.getInstalledOfferings();
        installed.addAll(Arrays.asList(installedOfferings));
        installed.removeAll(toBeUninstalled);
        return installed.isEmpty();
    }

    private static List<IIdentity> findSupersededOfferings(Map state, IOfferingOrFix oof) {
        ArrayList<IIdentity> supersededOfferings = new ArrayList<IIdentity>(state.size());
        if (oof instanceof IOffering) {
            List supercedeOfferings = OfferingProperty.getSupercedes((IOffering)((IOffering)oof));
            for (IIdentity id : state.keySet()) {
                if (!supercedeOfferings.contains(id)) continue;
                supersededOfferings.add(id);
            }
        }
        return supersededOfferings;
    }

    static void getResultingOfferingsAndFixesAndChanges(IProfile profile, AgentJob[] profileJobs, boolean adjustJobs, List results, List removed) {
        LinkedHashMap<IIdentity, Object> state = new LinkedHashMap<IIdentity, Object>();
        if (profile != null) {
            IFix[] installedFixes;
            IOffering[] installedOfferings;
            IOffering[] iOfferingArray = installedOfferings = profile.getInstalledOfferings();
            int n = installedOfferings.length;
            int n2 = 0;
            while (n2 < n) {
                IOffering installedOffering = iOfferingArray[n2];
                state.put(installedOffering.getIdentity(), installedOffering);
                ++n2;
            }
            IFix[] iFixArray = installedFixes = profile.getInstalledFixes();
            int n3 = installedFixes.length;
            n = 0;
            while (n < n3) {
                IFix installedFix = iFixArray[n];
                state.put(installedFix.getIdentity(), installedFix);
                ++n;
            }
        }
        AgentJob[] agentJobArray = profileJobs;
        int n = profileJobs.length;
        int n4 = 0;
        while (n4 < n) {
            AgentJob job;
            AgentJob profileJob = agentJobArray[n4];
            AgentJob agentJob = job = adjustJobs ? Director.getAdjustedJob(profileJob) : profileJob;
            if (adjustJobs) assert (profile == null || job.getProfile() == profile);
            IOfferingOrFix oof = job.getOfferingOrFix();
            if (job.isInstall() || job.isUpdate() || job.isRollback()) {
                Object oldValue = state.put(oof.getIdentity(), oof);
                if (oldValue == null) {
                    List<IIdentity> supersedeOfferings = AgentUtil.findSupersededOfferings(state, oof);
                    for (IIdentity id : supersedeOfferings) {
                        oldValue = state.remove(id);
                        if (oldValue == null) continue;
                        removed.add(oldValue);
                    }
                } else {
                    removed.add(oldValue);
                }
            } else if (job.isUninstall()) {
                removed.add(state.remove(oof.getIdentity()));
            }
            removed.remove(null);
            ++n4;
        }
        results.addAll(state.values());
        if (log.isDebugLoggable()) {
            log.debug("After executing jobs:\n  " + Util.toString((Object[])profileJobs, (Util.Formatter)new Util.Formatter("\n  ")));
            log.debug("Resulting state is:\n  " + Util.toString((Collection)results, (Util.Formatter)new Util.Formatter("\n  "){

                protected String emptyString() {
                    return "empty";
                }

                protected String format(Object object) {
                    IOfferingOrFix oof = (IOfferingOrFix)object;
                    return String.valueOf(oof.getIdentity().getId()) + ' ' + oof.getVersion();
                }
            }));
            log.debug("Removed:\n  " + Util.toString((Collection)removed, (Util.Formatter)new Util.Formatter("\n  "){

                protected String emptyString() {
                    return "empty";
                }

                protected String format(Object object) {
                    IOfferingOrFix oof = (IOfferingOrFix)object;
                    return String.valueOf(oof.getIdentity().getId()) + ' ' + oof.getVersion();
                }
            }));
        }
    }

    public static IOfferingOrFix[] getResultingOfferingsAndFixes(IProfile profile, AgentJob[] profileJobs, boolean adjustJobs) {
        ArrayList afterInstall = new ArrayList();
        AgentUtil.getResultingOfferingsAndFixesAndChanges(profile, profileJobs, adjustJobs, afterInstall, new ArrayList());
        return afterInstall.toArray(new IOfferingOrFix[afterInstall.size()]);
    }

    static IStatus singletonOfferingCheck(Profile profile, IOffering offering) {
        return new SingletonOfferingCheck(profile).perform(new IOffering[]{offering});
    }

    public static ProfileOffering[] getInstalledOfferings(Agent agent, IIdentity offeringId) {
        Profile[] profiles;
        ArrayList<ProfileOffering> installedOfferings = new ArrayList<ProfileOffering>();
        Profile[] profileArray = profiles = agent.getProfiles();
        int n = profiles.length;
        int n2 = 0;
        while (n2 < n) {
            Profile profile = profileArray[n2];
            IOffering installedOffering = agent.getInstalledOffering(profile, offeringId);
            if (installedOffering != null) {
                installedOfferings.add(new ProfileOffering(installedOffering, profile));
            }
            ++n2;
        }
        return installedOfferings.toArray(new ProfileOffering[installedOfferings.size()]);
    }

    private static boolean zipAdd(ZipOutputStream zipOut, File file, File rootDir, IProgressMonitor monitor) throws IOException {
        if (file.isFile()) {
            return AgentUtil.zipFile(zipOut, file, rootDir, monitor);
        }
        if (file.isDirectory()) {
            return AgentUtil.zipDirectory(zipOut, file, rootDir, monitor);
        }
        return true;
    }

    private static boolean zipDirectory(ZipOutputStream zipOut, File dir, File rootDir, IProgressMonitor monitor) throws IOException {
        File[] files = dir.listFiles();
        if (files == null) {
            files = new File[]{};
        }
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, NLS.bind((String)com.ibm.cic.agent.internal.core.Messages.AgentUtil_ZipAddingFile, (Object)dir.getName()), files.length);
        try {
            int i = 0;
            while (i < files.length) {
                IProgressMonitor next = spm.next();
                if (!files[i].exists()) {
                    next.done();
                } else if (files[i].isDirectory() ? !AgentUtil.zipDirectory(zipOut, files[i], rootDir, next) : !AgentUtil.zipFile(zipOut, files[i], rootDir, next)) {
                    return false;
                }
                ++i;
            }
        }
        finally {
            spm.done();
        }
        return true;
    }

    private static boolean zipFile(ZipOutputStream zipOut, File file, File rootDir, IProgressMonitor monitor) throws IOException {
        if (".imlock".equals(file.getName())) {
            monitor.done();
            return true;
        }
        monitor.subTask(NLS.bind((String)com.ibm.cic.agent.internal.core.Messages.AgentUtil_ZipAddingFile, (Object)file.getName()));
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, NLS.bind((String)com.ibm.cic.agent.internal.core.Messages.AgentUtil_ZipAddingFile, (Object)file.getName()), 1);
        FileInputStream fin = new FileInputStream(file);
        try {
            String prefix;
            IProgressMonitor pmonitor = spm.next();
            String entryName = file.getAbsolutePath();
            if (rootDir != null && entryName.startsWith(prefix = rootDir.getAbsolutePath())) {
                entryName = String.valueOf(rootDir.getName()) + entryName.substring(prefix.length());
            }
            ZipEntry entry = new ZipEntry(entryName);
            zipOut.putNextEntry(entry);
            entry.setTime(file.lastModified());
            byte[] buffer = new byte[24576];
            int read = fin.read(buffer);
            while (read > 0) {
                zipOut.write(buffer, 0, read);
                read = fin.read(buffer);
                if (!pmonitor.isCanceled()) continue;
                return false;
            }
        }
        finally {
            try {
                fin.close();
            }
            finally {
                zipOut.closeEntry();
            }
            spm.done();
        }
        return true;
    }

    public static IStatus zipAgentAppDataWithAdditionalFiles(String destinationFileName, File[] additionalFiles, IProgressMonitor monitor) {
        String logLocationPreference;
        if (additionalFiles == null && !(logLocationPreference = CicPreferenceManager.getInstance().getString(ICicPreferenceConstants.LOG_LOCATION.key())).isEmpty()) {
            additionalFiles = new File[]{new File(logLocationPreference)};
        }
        return AgentUtil.zipAgentAppData(destinationFileName, additionalFiles, monitor);
    }

    private static IStatus zipAgentAppData(String destinationFileName, File[] additionalFiles, IProgressMonitor monitor) {
        CicMultiStatus status;
        block22: {
            status = Statuses.OK.getMultiStatus();
            File destFile = new File(destinationFileName);
            File appdataDir = new File(CicCommonSettings.getApplicationDataLocation());
            SplitProgressMonitor spm = new SplitProgressMonitor(monitor, com.ibm.cic.agent.internal.core.Messages.AgentUtil_ZippingInstallData, additionalFiles == null ? 1 : 2);
            ZipOutputStream zipOut = null;
            try {
                File parent = destFile.getParentFile();
                if (parent != null && !parent.exists()) {
                    parent.mkdirs();
                }
                if (!AgentUtil.zipDirectory(zipOut = new ZipOutputStream(new FileOutputStream(destFile)), appdataDir, appdataDir, spm.next())) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                if (additionalFiles == null) break block22;
                SplitProgressMonitor spm1 = new SplitProgressMonitor(spm.next(), com.ibm.cic.agent.internal.core.Messages.AgentUtil_ZippingInstallData, additionalFiles.length);
                int i = 0;
                while (i < additionalFiles.length) {
                    if (additionalFiles[i] != null && !AgentUtil.zipAdd(zipOut, additionalFiles[i], additionalFiles[i], spm1.next())) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    try {
                        ++i;
                        continue;
                    }
                    catch (IOException e) {
                        status.add((IStatus)new Status(4, Agent.PI_AGENT, 0, e.getLocalizedMessage(), (Throwable)e));
                    }
                    break;
                }
            }
            finally {
                if (zipOut != null) {
                    try {
                        zipOut.close();
                    }
                    catch (IOException e) {
                        status.add((IStatus)new Status(4, Agent.PI_AGENT, 0, e.getLocalizedMessage(), (Throwable)e));
                    }
                }
                spm.done();
            }
        }
        return status;
    }

    public static boolean checkImportEnabledFromRepositories(IRepositoryGroup repositoryGroup, IProgressMonitor monitor) {
        if (repositoryGroup == null) {
            return false;
        }
        if (CicPreferenceManager.getInstance().isSet(ICicPreferenceConstants.IMPORT_ENABLED.key())) {
            return false;
        }
        List offerings = UpdateOfferingUtils.getAllOfferingsUpdatesAndFixes((IRepository)repositoryGroup, (IProgressMonitor)monitor);
        int i = 0;
        while (i < offerings.size()) {
            IOfferingOrFix offeringOrFix = (IOfferingOrFix)offerings.get(i);
            if (OfferingProperty.isImportEnabled((IOfferingOrFix)offeringOrFix)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static IStatus checkZeroFeatureSelection(AgentJob[] jobs, boolean isWizard) {
        AgentJob[] agentJobArray = jobs;
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            AgentJob job = agentJobArray[n2];
            IOffering offering = job.getOffering();
            if (offering != null && job.getFeaturesArray().length == 0 && !LicenseUtils.isPEKOffering((IOffering)offering)) {
                if (job.isModify() && !isWizard) {
                    return Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.FeatureSelectionValidation_RequireAtLeastOneValidFeature, new Object[]{offering.getName()});
                }
                if (job.isInstall() || job.isUpdate() || job.isModify()) {
                    return Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.FeatureSelectionValidation_RequireAtLeastOneFeature, new Object[]{offering.getName()});
                }
            }
            ++n2;
        }
        return Status.OK_STATUS;
    }

    public static boolean isExclusiveLists(String addLists, String removeLists) {
        String COMMA = ",";
        if (addLists == null || removeLists == null || addLists.length() == 0 || removeLists.length() == 0) {
            return true;
        }
        String[] addArray = addLists.split(",");
        String[] stringArray = removeLists.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            String[] stringArray2 = addArray;
            int n3 = addArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String element = stringArray2[n4];
                if (id.trim().compareTo(element.trim()) == 0) {
                    return false;
                }
                ++n4;
            }
            ++n2;
        }
        return true;
    }

    public static IStatus checkZeroFeatureSelection(AgentJob[] jobs) {
        return AgentUtil.checkZeroFeatureSelection(jobs, false);
    }

    public static List<AbstractJob> getSelectedProductAbstractJobs(List<? extends AbstractJob> selectedJobs) {
        ArrayList<AbstractJob> result = new ArrayList<AbstractJob>();
        for (AbstractJob abstractJob : selectedJobs) {
            IOfferingOrFix offeringOrFix = abstractJob.getOfferingOrFix();
            if (Agent.getInstance().isAgentOffering(offeringOrFix) || LicenseUtils.isPEKOffering((IOfferingOrFix)offeringOrFix)) continue;
            result.add(abstractJob);
        }
        return result;
    }

    public static AgentJob[] getSelectedProductAgentJobArray(AgentJob[] jobs) {
        return AgentUtil.getSelectedProductAgentJobArray(Arrays.asList(jobs));
    }

    public static AgentJob[] getSelectedProductAgentJobArray(Collection<AgentJob> jobs) {
        List<AgentJob> selectedProductJobList = AgentUtil.getSelectedProductAgentJobs(jobs);
        return selectedProductJobList.toArray(new AgentJob[selectedProductJobList.size()]);
    }

    public static List<AgentJob> getSelectedProductAgentJobs(Collection<AgentJob> jobs) {
        ArrayList<AgentJob> result = new ArrayList<AgentJob>();
        for (AgentJob job : jobs) {
            if (!job.isSelected()) continue;
            IOfferingOrFix offeringOrFix = job.getOfferingOrFix();
            if (Agent.getInstance().isAgentOffering(offeringOrFix) || LicenseUtils.isPEKOffering((IOfferingOrFix)offeringOrFix)) continue;
            result.add(job);
        }
        return result;
    }

    static CicMultiStatus validateUserData(AgentJob[] jobs, IProgressMonitor monitor) {
        CicMultiStatus result = Statuses.OK.getMultiStatus();
        AgentJob[] selectedProductJobs = AgentUtil.getSelectedProductAgentJobArray(jobs);
        CicMultiStatus commonUserDataStatus = AgentUtil.validateCommonUserDataValues(selectedProductJobs);
        if (StatusUtil.isErrorOrCancel((IStatus)commonUserDataStatus)) {
            return commonUserDataStatus;
        }
        result.add(StatusUtil.fixMultiStatusNoMsgProblem((IStatus)commonUserDataStatus));
        CicMultiStatus offeringUserDataStatus = AgentUtil.validateOfferingUserDataValues(selectedProductJobs);
        if (StatusUtil.isErrorOrCancel((IStatus)offeringUserDataStatus)) {
            return offeringUserDataStatus;
        }
        result.add(StatusUtil.fixMultiStatusNoMsgProblem((IStatus)offeringUserDataStatus));
        CicMultiStatus userDataStatusInTemplate = AgentUtil.validateUserDataInTemplate(selectedProductJobs, monitor);
        if (StatusUtil.isErrorOrCancel((IStatus)userDataStatusInTemplate)) {
            return userDataStatusInTemplate;
        }
        result.add(StatusUtil.fixMultiStatusNoMsgProblem((IStatus)userDataStatusInTemplate));
        return result;
    }

    private static CicMultiStatus validateUserDataInTemplate(AgentJob[] jobs, IProgressMonitor monitor) {
        CicMultiStatus result = Statuses.OK.getMultiStatus();
        try {
            CustomPanelWrapper[] commonTemplates = TemplateCommonCustomPanelFactory.getInstance().createCustomPanelTemplates(jobs);
            CustomPanelWrapper[] offeringTemplates = TemplateOfferingCustomPanelFactory.getInstance().createCustomPanelTemplates(jobs);
            LinkedList<CustomPanelWrapper> allTemplates = new LinkedList<CustomPanelWrapper>();
            allTemplates.addAll(Arrays.asList(commonTemplates));
            allTemplates.addAll(Arrays.asList(offeringTemplates));
            if (!allTemplates.isEmpty()) {
                SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)allTemplates.size());
                for (CustomPanelWrapper template : allTemplates) {
                    if (template.shouldSkip()) continue;
                    template.loadProfilePropertyValues();
                    Map<String, IStatus> statusMap = template.validateSilentMode((IProgressMonitor)sm.newChild(1));
                    for (Map.Entry<String, IStatus> entry : statusMap.entrySet()) {
                        String key = template.getProfileKey(entry.getKey());
                        IStatus status = entry.getValue();
                        if (StatusUtil.isErrorOrCancel((IStatus)status) || status.getSeverity() == 2) {
                            CicMultiStatus wrapStatus = StatusUtil.isErrorOrCancel((IStatus)status) ? Statuses.ERROR.getMultiStatus(com.ibm.cic.agent.internal.core.Messages.CustomPanelTemplate_UserData_Validation_Error, new Object[]{key}) : Statuses.WARNING.getMultiStatus(com.ibm.cic.agent.internal.core.Messages.CustomPanelTemplate_UserData_Validation_Warning, new Object[]{key});
                            wrapStatus.addAll(status);
                            result.add((IStatus)wrapStatus);
                            continue;
                        }
                        result.addAll(status);
                    }
                    if (StatusUtil.isErrorOrCancel((IStatus)result)) continue;
                    template.storeProfilePropertyValues();
                }
            }
        }
        catch (RuntimeStatusException e) {
            Agent.getLogger().status(e.getStatus());
            result.add(e.getStatus());
        }
        catch (CoreException e) {
            Agent.getLogger().status(e.getStatus());
            result.add(e.getStatus());
        }
        return result;
    }

    private static CicMultiStatus validateCommonUserDataValues(AgentJob[] jobs) {
        CicMultiStatus result = Statuses.OK.getMultiStatus();
        Collection jobArrays = AgentUtil.groupByProfile(jobs, false);
        for (AgentJob[] jobGroup : jobArrays) {
            String[] dataKeys;
            Profile profile = jobGroup[0].getProfile();
            CommonUserDataExtParser.getInstance().initializeCommonUserDataExtensions(jobs, jobGroup);
            HashMap<String, String> dataValueMap = new HashMap<String, String>();
            String[] stringArray = dataKeys = Agent.getInstance().getCommonDataKeys();
            int n = dataKeys.length;
            int n2 = 0;
            while (n2 < n) {
                String dataKey = stringArray[n2];
                String dataValue = profile.getData(dataKey);
                dataValueMap.put(dataKey, dataValue);
                ++n2;
            }
            if (dataValueMap.isEmpty()) continue;
            result.add(Agent.getInstance().validateCommonData(dataValueMap));
        }
        return result;
    }

    private static CicMultiStatus validateOfferingUserDataValues(AgentJob[] jobs) {
        CicMultiStatus result = Statuses.OK.getMultiStatus();
        Collection jobArrays = AgentUtil.groupByProfile(jobs, false);
        for (AgentJob[] jobGroup : jobArrays) {
            Profile profile = jobGroup[0].getProfile();
            OfferingUserDataExtParser.getInstance().initializeOfferingUserDataExtensions(jobs, jobGroup);
            AgentJob[] agentJobArray = jobGroup;
            int n = jobGroup.length;
            int n2 = 0;
            while (n2 < n) {
                String[] dataKeys;
                AgentJob element = agentJobArray[n2];
                IOfferingOrFix offeringOrFix = element.getOfferingOrFix();
                HashMap<String, String> dataValueMap = new HashMap<String, String>();
                String[] stringArray = dataKeys = Agent.getInstance().getOfferingDataKeys(offeringOrFix);
                int n3 = dataKeys.length;
                int n4 = 0;
                while (n4 < n3) {
                    String dataKey = stringArray[n4];
                    String dataValue = profile.getOfferingUserData(dataKey, offeringOrFix.getIdentity().getId());
                    dataValueMap.put(dataKey, dataValue);
                    ++n4;
                }
                if (!dataValueMap.isEmpty()) {
                    result.add(Agent.getInstance().validateOfferingUserData(offeringOrFix, dataValueMap));
                }
                ++n2;
            }
        }
        return result;
    }

    public static boolean onlyInstallAgent(List selectedJobs) {
        return selectedJobs.size() == 1 && AgentUtil.hasInstallAgentJob(selectedJobs);
    }

    public static boolean onlyInstallAgent(Set<? extends AgentJob> selectedJobs) {
        return selectedJobs != null && selectedJobs.size() == 1 && AgentUtil.hasInstallAgentJob(selectedJobs.toArray(new AbstractJob[selectedJobs.size()]));
    }

    public static boolean hasInstallAgentJob(List selectedJobs) {
        if (selectedJobs == null || selectedJobs.isEmpty()) {
            return false;
        }
        return AgentUtil.hasInstallAgentJob(selectedJobs.toArray(new AbstractJob[selectedJobs.size()]));
    }

    public static AgentJob[] convertShadowProfiles(List jobs) {
        Agent agent = Agent.getInstance();
        ArrayList<AgentJob> offeringOrFixJobList = new ArrayList<AgentJob>();
        Profile newAgentProfile = null;
        Collection groupedJobs = AgentUtil.groupByProfile(AgentJob.toArray(jobs), false);
        Iterator it = groupedJobs.iterator();
        while (it.hasNext()) {
            AgentJob[] jobsInOneProfile;
            Profile newProductProfile = null;
            AgentJob[] agentJobArray = jobsInOneProfile = (AgentJob[])it.next();
            int n = jobsInOneProfile.length;
            int n2 = 0;
            while (n2 < n) {
                AgentJob element = agentJobArray[n2];
                if (element.isSelected()) {
                    IOfferingOrFix offeringOrFix = element.getOfferingOrFix();
                    Profile profile = element.getProfile();
                    if (profile.isShadow()) {
                        if (!agent.isAgentOffering(offeringOrFix)) {
                            if (newProductProfile == null) {
                                newProductProfile = AgentUtil.createProfileWithShadowProfile(agent, profile);
                            }
                            element.setProfile(newProductProfile);
                        } else {
                            if (newAgentProfile == null) {
                                newAgentProfile = AgentUtil.createProfileWithShadowProfile(agent, profile);
                            }
                            element.setProfile(newAgentProfile);
                        }
                    }
                    offeringOrFixJobList.add(element);
                }
                ++n2;
            }
        }
        return AgentJob.toArray(offeringOrFixJobList);
    }

    private static Profile createProfileWithShadowProfile(Agent agent, Profile shadowProfile) {
        Profile profile = shadowProfile.convertShadow();
        agent.addProfile(profile);
        return profile;
    }

    public static IStatus checkAgentOfferingApplicability(List jobs) {
        IOffering offering;
        CicMultiStatus result = Statuses.ST.createMultiStatus(com.ibm.cic.agent.internal.core.Messages.AgentUtil_multipleWarnings, new Object[0]);
        AgentJob job = AgentUtil.getAgentProfileJob(jobs);
        if (job == null) {
            return result;
        }
        Agent agent = Agent.getInstance();
        if (!agent.isAgentOffering((IOfferingOrFix)(offering = job.getOffering()))) {
            return result;
        }
        result.add(BitModeUtils.check64bitImSupportedByInstalled());
        IOffering installedAgent = agent.getAgentOffering();
        if (installedAgent == null) {
            return StatusUtil.toSingleStatus((IStatus)result);
        }
        if (!agent.isAgentUpdate(offering, Statuses.OK.getMultiStatus())) {
            return StatusUtil.toSingleStatus((IStatus)result);
        }
        IStatus status = agent.prepareAgentUpdate(installedAgent, offering, (IProgressMonitor)new NullProgressMonitor());
        if (StatusUtil.isErrorOrCancel((IStatus)status)) {
            return status;
        }
        result.add(status);
        status = job.checkOfferingApplicability();
        if (StatusUtil.isErrorOrCancel((IStatus)status)) {
            return status;
        }
        result.add(status);
        return StatusUtil.toSingleStatus((IStatus)result);
    }

    public static boolean isSyncOffering(IOffering offering) {
        return UpdateOfferingUtils.isSync((IOffering)offering);
    }

    public static IStatus checkGroupId(String path) {
        String eGroup = PlatformUtils.getEffectiveGroupForProcess();
        String fGroup = PlatformUtils.getOwningGroupForFile((String)path, (boolean)true);
        if (fGroup == null) {
            return Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.AgentUtil_GroupID_Check_Error, new Object[]{path});
        }
        if (!eGroup.equals(fGroup)) {
            return Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.AgentUtil_GroupID_Check_Fail, new Object[]{eGroup, fGroup});
        }
        return Status.OK_STATUS;
    }

    private static AgentJob getAgentProfileJob(List jobs) {
        for (AgentJob job : jobs) {
            if (!job.getProfile().isAgentProfile()) continue;
            return job;
        }
        return null;
    }

    private static AgentJob getInstallIMJob(AgentJob[] jobs) {
        if (jobs != null) {
            AgentJob[] agentJobArray = jobs;
            int n = jobs.length;
            int n2 = 0;
            while (n2 < n) {
                AgentJob job = agentJobArray[n2];
                if (Agent.getInstance().isAgentOffering(job.getOfferingOrFix())) {
                    return job;
                }
                ++n2;
            }
        }
        return null;
    }

    public static File[] getLogFiles(boolean sort) {
        File logDirectory = LogManager.getDirectory();
        File[] logFiles = null;
        if (logDirectory != null && logDirectory.isDirectory()) {
            logFiles = logDirectory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.length() > 4 && name.endsWith(".xml") && !name.equals("index.xml");
                }
            });
        }
        if (sort) {
            AgentUtil.sortFileArray(logFiles);
        }
        return logFiles;
    }

    private static void sortFileArray(File[] logFiles) {
        Arrays.sort(logFiles, new Comparator<File>(){
            final Comparator<String> cmp = Comparators.getIcuComparator();

            @Override
            public int compare(File a, File b) {
                return this.cmp.compare(a.getName(), b.getName());
            }
        });
    }

    public static String genPortableSharedLocation(String installLocation) {
        return new File(installLocation, ".ibmim/shared").getAbsolutePath();
    }

    public static IStatus validateAndSetDataLocation() {
        String value = CmdLine.CL.getCommandApplicationDataLocation();
        if (value != null) {
            IStatus status = AgentUtil.validateAndSetDataLocation(value);
            if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                return status;
            }
            log.statusNotOK(status);
        }
        return Status.OK_STATUS;
    }

    public static IStatus validateAndSetDataLocation(String dataLocation) {
        try {
            CicCommonSettings.setApplicationDataLocation((String)new File(dataLocation).getCanonicalPath());
            return AgentPathValidator.checkSymbolicLinks(dataLocation);
        }
        catch (IOException e) {
            return Statuses.ERROR.get(8008, Messages.Cmd_Error_Incorrect_Parameter_BadDirectory, new Object[]{dataLocation});
        }
    }

    private static enum DirPermissionStatus {
        OK,
        NO_READ,
        NO_WRITE,
        NO_READ_WRITE,
        NO_CREATE;

    }

    private static enum IntuitiveState {
        NON_INTUITIVE,
        INTUITIVE,
        MIXED_INTUITIVE;

    }

    public static class ProfileOffering {
        private final IOffering offering;
        private final Profile profile;

        ProfileOffering(IOffering offering, Profile profile) {
            this.offering = offering;
            this.profile = profile;
        }

        public IOffering getOffering() {
            return this.offering;
        }

        public Profile getProfile() {
            return this.profile;
        }
    }

    private static class SingletonOfferingCheck {
        private final Profile toProfile;
        private final TwoTierMap offeringMap;
        private final TwoTierMap singletonMap;

        SingletonOfferingCheck(Profile toProfile) {
            this.toProfile = toProfile;
            this.offeringMap = new TwoTierMap();
            this.singletonMap = new TwoTierMap();
            for (InstallRegistry.ProfileInstallRegistry registry : InstallRegistry.getInstance().getProfileInstallRegistries()) {
                IOffering[] installed;
                Profile profile = registry.getProfile();
                if (profile == null || profile.equals(toProfile) || profile.isAgentProfile() || profile.isLicenseProfile()) continue;
                IOffering[] iOfferingArray = installed = registry.getInstalledOfferings();
                int n = installed.length;
                int n2 = 0;
                while (n2 < n) {
                    IOffering offering = iOfferingArray[n2];
                    this.offeringMap.put((Object)offering.getIdentity(), (Object)profile, (Object)offering);
                    String singletonProp = OfferingProperty.getSingletonOffering((IOffering)offering);
                    if (!CommonDef.True.equals(singletonProp) && !CommonDef.False.equals(singletonProp)) {
                        this.singletonMap.put((Object)singletonProp, (Object)profile, (Object)offering);
                    }
                    ++n2;
                }
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("Check profile ").append(this.toProfile == null ? null : this.toProfile.getProfileId());
            for (IIdentity id : this.offeringMap.keySet()) {
                sb.append("\n  ").append(id).append(" installed in:");
                for (Profile profile : this.offeringMap.keySet((Object)id)) {
                    sb.append(' ').append(profile.getProfileId());
                }
            }
            for (String prop : this.singletonMap.keySet()) {
                sb.append("\n  singletonOffering=").append(prop).append(':');
                for (Profile profile : this.singletonMap.keySet((Object)prop)) {
                    IOffering offering = (IOffering)this.singletonMap.get((Object)prop, (Object)profile);
                    sb.append("\n    ").append(profile.getProfileId()).append(" - ").append(offering.getIdentity());
                }
            }
            return sb.toString();
        }

        IStatus perform(IOffering[] offerings) {
            try {
                IOffering[] iOfferingArray = offerings;
                int n = offerings.length;
                int n2 = 0;
                while (n2 < n) {
                    IOffering offering = iOfferingArray[n2];
                    this.performOffering(offering);
                    ++n2;
                }
                return Status.OK_STATUS;
            }
            catch (CoreException e) {
                return e.getStatus();
            }
        }

        private void performOffering(IOffering offering) throws CoreException {
            this.checkSingleton(offering);
            this.checkSingletonValue(offering);
        }

        private void checkSingleton(IOffering offering) throws CoreException {
            IIdentity offeringId = offering.getIdentity();
            Set profiles = this.offeringMap.keySet((Object)offeringId);
            if (profiles.isEmpty()) {
                return;
            }
            if (AgentUtil.isSingletonOffering(offering)) {
                Profile profile = (Profile)profiles.iterator().next();
                throw new CoreException((IStatus)Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.AgentUtil_Singleton_Offering_Error, new Object[]{offering.getName(), profile.getProfileId()}));
            }
            for (Profile profile : profiles) {
                IOffering installed = (IOffering)this.offeringMap.get((Object)offeringId, (Object)profile);
                if (!AgentUtil.isSingletonOffering(installed)) continue;
                throw new CoreException((IStatus)Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.AgentUtil_Singleton_Offering_Error, new Object[]{offering.getName(), profile.getProfileId()}));
            }
        }

        private void checkSingletonValue(IOffering offering) throws CoreException {
            String singletonProp = OfferingProperty.getSingletonOffering((IOffering)offering);
            Profile profile = this.findSingletonProfile(singletonProp);
            if (profile != null && !profile.equals(this.toProfile)) {
                IOffering installed = (IOffering)this.singletonMap.get((Object)singletonProp, (Object)profile);
                throw new CoreException((IStatus)Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.AgentUtil_Singleton_Offering_Profile_Error, new Object[]{offering.getName(), profile.getProfileId(), installed.getName()}));
            }
        }

        private Profile findSingletonProfile(String singletonProp) {
            Set profiles = this.singletonMap.keySet((Object)singletonProp);
            if (profiles.isEmpty()) {
                return null;
            }
            return (Profile)profiles.iterator().next();
        }
    }
}

