/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.core.p2;

import com.ibm.cic.agent.internal.core.p2.Messages;
import com.ibm.cic.agent.internal.core.p2.P2EclipseQualificationHistory;
import com.ibm.cic.agent.internal.core.p2.P2Engine;
import com.ibm.cic.agent.internal.core.p2.Utils;
import com.ibm.cic.common.core.internal.utils.CicConstants;
import com.ibm.cic.common.core.utils.FileURLUtil;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.eclipse.internals.update.configurator.IPlatformConfiguration;
import com.ibm.cic.eclipse.internals.update.configurator.PlatformConfiguration;
import com.ibm.cic.eclipse.internals.update.configurator.SiteEntry;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;

public class P2PlatformXmlFixup {
    private File installLocation;
    private File configLocation;
    private File cacheLocation;
    private final IInstallableUnit[] ius;
    private final boolean isFinalUninstall;

    public P2PlatformXmlFixup(File installLocation, File configLocation, File cacheLocation, IInstallableUnit[] ius, boolean isFinalUninstall) {
        this.installLocation = installLocation;
        this.configLocation = configLocation;
        this.cacheLocation = cacheLocation;
        this.ius = ius;
        this.isFinalUninstall = isFinalUninstall;
    }

    public IStatus perform() {
        try {
            this.installLocation = this.installLocation.getCanonicalFile();
            this.configLocation = this.configLocation.getCanonicalFile();
            this.cacheLocation = this.cacheLocation.getCanonicalFile();
            if (FileUtil.filesAreSame((File)this.installLocation, (File)this.cacheLocation)) {
                return Status.OK_STATUS;
            }
            File location = new File(this.configLocation, "org.eclipse.update/platform.xml");
            if (!(location = location.getCanonicalFile()).isFile()) {
                if (this.isFinalUninstall) {
                    return Status.OK_STATUS;
                }
                return Statuses.WARNING.get(Messages.P2EngineOperation_fileNotFound, new Object[]{location.getPath()});
            }
            PlatformConfiguration platformXml = new PlatformConfiguration(FileURLUtil.toUnescapedFileURL((File)location), FileURLUtil.toUnescapedFileURL((File)this.installLocation), false, false);
            URL siteUrl = FileURLUtil.toUnescapedFileURL((File)this.cacheLocation);
            IPlatformConfiguration.ISiteEntry site = platformXml.findConfiguredSite(siteUrl);
            if (this.isFinalUninstall) {
                if (site != null) {
                    platformXml.unconfigureSite(site);
                }
            } else {
                IPlatformConfiguration.ISitePolicy policy = platformXml.createSitePolicy(0, this.createPluginsList());
                if (site == null) {
                    site = platformXml.createSiteEntry(siteUrl, policy);
                    platformXml.configureSite(site);
                } else {
                    site.setSitePolicy(policy);
                }
                ((SiteEntry)site).setUpdateable(false);
            }
            platformXml.isTransient(false);
            platformXml.save();
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            return Statuses.ERROR.get((Throwable)e, e.toString(), new Object[0]);
        }
    }

    private String[] createPluginsList() {
        LinkedHashSet<String> plugins = new LinkedHashSet<String>(this.ius.length);
        File pluginsDir = new File(this.cacheLocation, "plugins");
        String jarExt = CicConstants.getJarFileDotExt();
        P2EclipseQualificationHistory qualificationHistory = P2Engine.getInstance().getQualificationHistory();
        IInstallableUnit[] iInstallableUnitArray = this.ius;
        int n = this.ius.length;
        int n2 = 0;
        while (n2 < n) {
            IInstallableUnit iu = iInstallableUnitArray[n2];
            if (Utils.isBundleUnit(iu) && (qualificationHistory == null || qualificationHistory.isInstalled(iu))) {
                Collection artifacts = iu.getArtifacts();
                for (IArtifactKey key : artifacts) {
                    String classifier = key.getClassifier();
                    if (!"osgi.bundle".equals(classifier)) continue;
                    File plugin = new File(pluginsDir, String.valueOf(key.getId()) + '_' + key.getVersion().toString());
                    if (plugin.isDirectory()) {
                        plugins.add("plugins/" + plugin.getName() + '/');
                        continue;
                    }
                    if (!(plugin = new File(String.valueOf(plugin.getPath()) + jarExt)).isFile()) continue;
                    plugins.add("plugins/" + plugin.getName());
                }
            }
            ++n2;
        }
        return plugins.toArray(new String[plugins.size()]);
    }
}

