/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.core.p2;

import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;

public class P2EclipseQualificationHistory {
    public static final String INSTALLED = "installed";
    private final Profile profile;
    private Properties history;
    private boolean historyDirty;

    public P2EclipseQualificationHistory(Profile profile) {
        this.profile = profile;
    }

    protected File getHistoryFile() {
        return new File(this.getExistingEclipseStorage(), "unitHistory.properties");
    }

    protected File getExistingEclipseStorage() {
        return new File(this.profile.getAdapterStorage("p2Eclipse"), "existingEclipse");
    }

    public void load() {
        this.historyDirty = false;
        File historyFile = this.getHistoryFile();
        if (!historyFile.isFile()) {
            this.history = new Properties();
            return;
        }
        try {
            this.history = FileUtil.readProperties((File)historyFile);
        }
        catch (IOException e) {
            Logger.getGlobalLogger().error((Throwable)e);
            this.history = new Properties();
        }
    }

    public boolean isInstalled(IInstallableUnit unit) {
        return this.isInstalled(unit.getId());
    }

    public boolean isInstalled(String id) {
        String value = this.history.getProperty(id);
        return value != null;
    }

    public void add(IInstallableUnit unit) {
        String prevValue = (String)this.history.setProperty(unit.getId(), INSTALLED);
        if (prevValue == null) {
            this.historyDirty = true;
        }
    }

    public void remove(IInstallableUnit unit) {
        String removedValue = (String)this.history.remove(unit.getId());
        if (removedValue != null) {
            this.historyDirty = true;
        }
    }

    public void store() {
        if (!this.historyDirty) {
            return;
        }
        File historyFile = this.getHistoryFile();
        historyFile.getParentFile().mkdirs();
        try {
            FileUtil.writeProperties((File)historyFile, (Properties)this.history);
            this.historyDirty = false;
        }
        catch (IOException e) {
            Logger.getGlobalLogger().error((Throwable)e);
        }
    }
}

