/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.core.p2;

import com.ibm.cic.common.logging.Logger;
import com.ibm.cic.p2.model.internal.P2MatchQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitFragment;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;

public class FragmentQuery
extends P2MatchQuery {
    private static final Logger log = Logger.getLogger(FragmentQuery.class);
    private final IInstallableUnit selectionContext;
    private final HashMap hostIdToVersions;

    public FragmentQuery(IInstallableUnit selectionContext, ArrayList bundleData) {
        this(selectionContext, FragmentQuery.createHashMap(bundleData));
    }

    private FragmentQuery(IInstallableUnit selectionContext, HashMap hostIdToVersions) {
        this.selectionContext = selectionContext;
        this.hostIdToVersions = hostIdToVersions;
    }

    public boolean isMatch(Object candidate) {
        if (!(candidate instanceof IInstallableUnitFragment)) {
            return false;
        }
        IInstallableUnitFragment fragment = (IInstallableUnitFragment)candidate;
        Collection hosts = fragment.getHost();
        for (IRequirement hostReq : hosts) {
            VersionRange tolerance;
            ArrayList versions;
            IRequiredCapability host;
            String namespace;
            if (!(hostReq instanceof IRequiredCapability) || !"osgi.bundle".equals(namespace = (host = (IRequiredCapability)hostReq).getNamespace()) || (versions = (ArrayList)this.hostIdToVersions.get(host.getName())) == null || (tolerance = host.getRange()) == null || !this.fragmentToleratesHostVersions(versions, tolerance) || !this.isApplicable((IInstallableUnit)fragment)) continue;
            return true;
        }
        return false;
    }

    private static HashMap createHashMap(ArrayList bundleData) {
        if (bundleData.size() == 0) {
            return new HashMap();
        }
        HashMap map = new HashMap(bundleData.size());
        StringBuffer sb = null;
        boolean debugLoggable = log.isDebugLoggable();
        if (debugLoggable) {
            sb = new StringBuffer(bundleData.size() * 64);
        }
        for (IInstallableUnit bundle : bundleData) {
            String id = bundle.getId();
            Version version = bundle.getVersion();
            ArrayList<Version> versions = (ArrayList<Version>)map.get(id);
            if (versions == null) {
                versions = new ArrayList<Version>(2);
                map.put(id, versions);
            }
            if (!versions.contains(version)) {
                versions.add(version);
            }
            if (!debugLoggable) continue;
            sb.append(String.valueOf(id) + ' ' + version + '\n');
        }
        if (debugLoggable) {
            sb.setLength(sb.length() - 1);
            log.debug("{0} hosts:\n{1}", new Object[]{String.valueOf(bundleData.size()), sb.toString()});
        }
        return map;
    }

    private boolean fragmentToleratesHostVersions(ArrayList versions, VersionRange tolerance) {
        for (Version version : versions) {
            if (!tolerance.isIncluded(version)) continue;
            return true;
        }
        return false;
    }

    private boolean isApplicable(IInstallableUnit unit) {
        IMatchExpression filter = unit.getFilter();
        if (filter == null) {
            return true;
        }
        return filter.isMatch((Object)this.selectionContext);
    }
}

