/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.console.preferences;

import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.internal.console.Messages;
import com.ibm.cic.agent.internal.console.actions.ConActionPrefsRepClearCredential;
import com.ibm.cic.agent.internal.console.actions.ConActionPrefsRepEdit;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtPrefsBase;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtPrefsReps;
import com.ibm.cic.agent.internal.console.preferences.ConPagePrefsBase;
import com.ibm.cic.agent.internal.console.preferences.ConPagePromptAddRepToList;
import com.ibm.cic.common.core.console.actions.AConActionEntry;
import com.ibm.cic.common.core.console.manager.IConManager;
import com.ibm.cic.common.core.console.pages.AConPage;
import com.ibm.cic.common.core.console.pages.ConPageEnterPath;
import com.ibm.cic.common.core.console.views.ConViewList;
import com.ibm.cic.common.core.console.views.ConViewListEntry;
import com.ibm.cic.common.core.console.views.ConViewListNumbered;
import com.ibm.cic.common.core.console.views.IConView;
import com.ibm.cic.common.core.downloads.RememberDownloadUserPrompts;
import com.ibm.cic.common.core.preferences.ICicPreferenceConstants;
import com.ibm.cic.common.core.repository.IRepositoryGroup;
import com.ibm.cic.common.core.repository.IRepositoryInfo;
import com.ibm.cic.common.core.repository.RepositoryGroup;
import com.ibm.cic.common.core.repository.RepositoryStatus;
import com.ibm.cic.common.core.repository.RepositoryUtils;
import com.ibm.cic.common.core.utils.ConsoleProgressMonitor;
import com.ibm.cic.common.core.utils.OutputFormatter;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.downloads.CredentialStore;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class ConPagePrefsReps
extends ConPagePrefsBase {
    ConViewListNumbered mainList;
    ConDataCtxtPrefsReps m_repContext;
    ConViewList m_serviceRepOption;
    ConViewList options;

    public ConPagePrefsReps(IConManager controller) {
        super(controller);
    }

    @Override
    protected ConDataCtxtPrefsBase initializeDataContext() {
        this.m_repContext = (ConDataCtxtPrefsReps)this.conManager().getDataContext(ConDataCtxtPrefsReps.class);
        return this.m_repContext;
    }

    @Override
    public void init() {
        this.setHeaderView(Messages.PagePreference_Rep_Header);
        this.mainList = new ConViewListNumbered(Messages.PagePreference_Rep_Reps, true, 1);
        this.addView((IConView)this.mainList);
        this.options = new ConViewList(Messages.General_OtherOptions, true);
        this.addView((IConView)this.options);
        if (SharedUIUtils.isPreferenceEditable((ICicPreferenceConstants.PreferenceTag)ConDataCtxtPrefsReps.serviceRepTag)) {
            this.m_serviceRepOption = new ConViewList(null, true, true, 0);
            this.addView((IConView)this.m_serviceRepOption);
        }
        super.init();
    }

    @Override
    public void present(OutputFormatter a_output) {
        this.mainList.clearList();
        List<ConDataCtxtPrefsReps.RepositoryData> data = this.m_repContext.getList();
        for (ConDataCtxtPrefsReps.RepositoryData d : data) {
            this.mainList.addEntry(d.location, (AConActionEntry)new ConActionPrefsRepEdit(), d.open);
        }
        this.options.clearList();
        if (SharedUIUtils.isPreferenceEditable((ICicPreferenceConstants.PreferenceTag)ConDataCtxtPrefsReps.repTag)) {
            this.options.addEntry(Messages.PagePreference_Rep_Add, "D", (AConActionEntry)ConPageEnterPath.getEnterPathPageAction((String)Messages.PagePreference_RepAdd_Header, (String)Messages.PagePreference_RepAdd_Location, (ConPageEnterPath.ConActionEnterPath)new ConActionEnterRepository()));
        }
        if (CredentialStore.INSTANCE.isAnyCredentialSaved()) {
            this.options.addEntry(Messages.PagePreference_Rep_ClearCredential, "C", (AConActionEntry)new ConActionPrefsRepClearCredential());
        }
        if (this.m_serviceRepOption != null) {
            this.m_serviceRepOption.clearList();
            this.m_serviceRepOption.addEntry(Messages.PagePreference_Rep_ServiceRep, "S", (AConActionEntry)new ConActFlipUseServiceRep()).setSelected(this.m_repContext.getIfUseServiceRep());
        }
        super.present(a_output);
    }

    static class ConActFlipUseServiceRep
    extends AConActionEntry<ConViewListEntry> {
        ConActFlipUseServiceRep() {
        }

        public void run(IConManager a_conManager) {
            ConDataCtxtPrefsReps context = (ConDataCtxtPrefsReps)a_conManager.getDataContext(ConDataCtxtPrefsReps.class);
            if (SharedUIUtils.isPreferenceEditable((ICicPreferenceConstants.PreferenceTag)ConDataCtxtPrefsReps.serviceRepTag)) {
                context.setIfUseServiceRep(!context.getIfUseServiceRep());
            }
            super.run(a_conManager);
        }
    }

    private class ConActionEnterRepository
    extends ConPageEnterPath.ConActionEnterPath {
        private ConActionEnterRepository() {
        }

        protected IStatus processInput() {
            String repLocation = this.getInput();
            if (ConPagePrefsReps.this.m_repContext.isRepositoryInList(repLocation)) {
                return Statuses.ERROR.get(com.ibm.cic.common.core.sharedUI.Messages.AddRepositoryDialog_error, new Object[0]);
            }
            if (ConPagePrefsReps.this.m_repContext.isPassportAdvantageRep(repLocation)) {
                return Statuses.ERROR.get(com.ibm.cic.common.core.sharedUI.Messages.AddRepositoryDialog_passportAdvantagedRepositoryUsedMsg, new Object[0]);
            }
            return Status.OK_STATUS;
        }

        public void run(IConManager manager) {
            if (this.getInput().length() > 0) {
                boolean[] askIfAddToList;
                IStatus result = this.processInput();
                if (this.remainOnThisPage(manager, result)) {
                    return;
                }
                String repLocation = this.getInput();
                IStatus repConnectionStatus = this.checkRepositoryAccessible(repLocation, askIfAddToList = new boolean[1]);
                if (repConnectionStatus.isOK()) {
                    ConPagePrefsReps.this.m_repContext.addRepository(repLocation);
                    manager.returnToPreviousPage(1);
                } else if (!askIfAddToList[0]) {
                    if (this.remainOnThisPage(manager, repConnectionStatus)) {
                        return;
                    }
                } else {
                    ConPagePromptAddRepToList promptPage = new ConPagePromptAddRepToList(manager, repLocation, repConnectionStatus);
                    promptPage.setSuggestedInput("N");
                    manager.addPage((AConPage)promptPage);
                }
            } else {
                manager.returnToPreviousPage(1);
            }
        }

        private IStatus checkRepositoryAccessible(String repLocation, boolean[] askAddToList) {
            RepositoryGroup repGroup = RepositoryGroup.getDefault();
            IRepositoryInfo repInfo = RepositoryUtils.createRepInfoForExistingRepository((IRepositoryGroup)repGroup, (String)repLocation, null, null, (String)repLocation, null);
            repGroup.getFileCacheManager().resetPathTree(repInfo.getLocation());
            RememberDownloadUserPrompts rememberPrompts = new RememberDownloadUserPrompts();
            IProgressMonitor monitor = ConsoleProgressMonitor.createMonitorWithUnknownWork();
            monitor.beginTask(com.ibm.cic.common.core.sharedUI.Messages.ProgressDialog_Checking_Repositories, -1);
            try {
                RepositoryStatus.StatusAndErrorType displayStatusAndType;
                IStatus status = RepositoryGroup.getDefault().canAddExistingRepository(repInfo, (IProgressMonitor)new SubProgressMonitor(monitor, 0));
                if (status.isOK()) {
                    IStatus iStatus = status;
                    return iStatus;
                }
                String msg = NLS.bind((String)com.ibm.cic.common.core.sharedUI.Messages.AddRepositoryDialog_addRepFailed_msg, (Object)repLocation);
                msg = String.valueOf(msg) + "\n\n";
                IStatus repStatus = repInfo.getRepositoryReportedStatus();
                if (repStatus != null && repStatus.getSeverity() == 4 && repStatus.getMessage().trim().length() > 0) {
                    msg = String.valueOf(msg) + repStatus.getMessage();
                    msg = String.valueOf(msg) + "\n\n";
                }
                if ((displayStatusAndType = RepositoryStatus.getDisplayStatusForCanAddExisting((String)msg, (IStatus)status)).isKnownInvalidLocation()) {
                    if (displayStatusAndType.getCode() == 6002) {
                        Status newDisplayStatus = new Status(displayStatusAndType.getSeverity(), displayStatusAndType.getPlugin(), String.valueOf(displayStatusAndType.getMessage()) + "\n\n");
                        askAddToList[0] = true;
                        Status status2 = newDisplayStatus;
                        return status2;
                    }
                    askAddToList[0] = false;
                    RepositoryStatus.StatusAndErrorType statusAndErrorType = displayStatusAndType;
                    return statusAndErrorType;
                }
                askAddToList[0] = true;
                RepositoryStatus.StatusAndErrorType statusAndErrorType = displayStatusAndType;
                return statusAndErrorType;
            }
            finally {
                monitor.done();
                rememberPrompts.forget();
            }
        }
    }
}

