/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.console.pages;

import com.ibm.cic.agent.internal.console.Messages;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtLocaleLangs;
import com.ibm.cic.common.core.console.actions.AConActionEntry;
import com.ibm.cic.common.core.console.manager.IConManager;
import com.ibm.cic.common.core.console.pages.AConPage;
import com.ibm.cic.common.core.console.views.ConViewList;
import com.ibm.cic.common.core.console.views.ConViewListEntry;
import com.ibm.cic.common.core.console.views.ConViewListNumbered;
import com.ibm.cic.common.core.console.views.ConViewStatus;
import com.ibm.cic.common.core.console.views.ConViewText;
import com.ibm.cic.common.core.console.views.IConView;
import com.ibm.cic.common.core.definitions.ProfileLanguageUtils;
import com.ibm.cic.common.core.utils.OutputFormatter;
import com.ibm.cic.common.core.utils.StatusUtil;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;

public class ConPageLocaleLangs
extends AConPage {
    private ConDataCtxtLocaleLangs m_context;

    public ConPageLocaleLangs(IConManager controller) {
        super(controller);
    }

    public void init() {
        this.setHeaderView(com.ibm.cic.agent.core.sharedUI.Messages.EnvironmentPage_language);
        super.init();
    }

    public void present(OutputFormatter a_output) {
        this.clear();
        this.addView((IConView)new ConViewText(com.ibm.cic.agent.core.sharedUI.Messages.EnvironmentPage_des));
        this.addView((IConView)new ConViewText(""));
        this.m_context = (ConDataCtxtLocaleLangs)this.conManager().getDataContext(ConDataCtxtLocaleLangs.class);
        Set<String> commonLangs = this.m_context.getCommonLangs();
        Set<String> nonCommonLangs = this.m_context.getNonCommonLangs();
        Map<String, String> codeLabelMap = this.m_context.getCodeLabelMap();
        String currentPlatformLocale = this.m_context.getCurrentPlatformLocaleLang();
        if (commonLangs.size() > 0) {
            ConViewListNumbered mainList = new ConViewListNumbered(com.ibm.cic.agent.core.sharedUI.Messages.EnvironmentPage_commonLanguage, true, 1);
            HashSet<String> labelSet = new HashSet<String>();
            Map labelCodeMap = ProfileLanguageUtils.getLabelLocaleCodeMap();
            if (currentPlatformLocale != null && commonLangs.contains(currentPlatformLocale)) {
                String label = codeLabelMap.get(currentPlatformLocale);
                labelSet.add(label);
                mainList.addEntry(label, (AConActionEntry)new ConActFlipLanguageSelection(), this.m_context.isSelected(currentPlatformLocale)).setContext(labelCodeMap.get(label));
            }
            String[] orderedCode = ProfileLanguageUtils.getLocaleLanguageCodes();
            int i = 0;
            while (i < orderedCode.length) {
                String label;
                if (!orderedCode[i].equals(currentPlatformLocale) && commonLangs.contains(orderedCode[i]) && labelSet.add(label = codeLabelMap.get(orderedCode[i]))) {
                    mainList.addEntry(label, (AConActionEntry)new ConActFlipLanguageSelection(), this.m_context.isSelected(orderedCode[i])).setContext(labelCodeMap.get(label));
                }
                ++i;
            }
            this.addView((IConView)mainList);
        }
        int commonLabelNum = this.getCommonLangLabelNum(commonLangs, codeLabelMap);
        if (nonCommonLangs.size() > 0) {
            ConViewListNumbered optionalList = new ConViewListNumbered(com.ibm.cic.agent.core.sharedUI.Messages.EnvironmentPage_nonCommonLanguage, true, commonLabelNum + 1);
            HashSet<String> labelSet = new HashSet<String>();
            Map labelCodeMap = ProfileLanguageUtils.getLabelLocaleCodeMap();
            if (currentPlatformLocale != null && nonCommonLangs.contains(currentPlatformLocale)) {
                String label = codeLabelMap.get(currentPlatformLocale);
                labelSet.add(label);
                optionalList.addEntry(label, (AConActionEntry)new ConActFlipLanguageSelection(), this.m_context.isSelected(currentPlatformLocale)).setContext(labelCodeMap.get(label));
            }
            String[] orderedCode = ProfileLanguageUtils.getLocaleLanguageCodes();
            int i = 0;
            while (i < orderedCode.length) {
                String label;
                if (!orderedCode[i].equals(currentPlatformLocale) && nonCommonLangs.contains(orderedCode[i]) && labelSet.add(label = codeLabelMap.get(orderedCode[i]))) {
                    optionalList.addEntry(label, (AConActionEntry)new ConActFlipLanguageSelection(), this.m_context.isSelected(orderedCode[i])).setContext(labelCodeMap.get(label));
                }
                ++i;
            }
            this.addView((IConView)optionalList);
        }
        HashSet<String> totalLangs = new HashSet<String>(this.m_context.getCommonLangs());
        totalLangs.addAll(this.m_context.getNonCommonLangs());
        HashSet<String> requiredCodes = new HashSet<String>(this.m_context.getRequiredLangs());
        totalLangs.removeAll(requiredCodes);
        if (!totalLangs.isEmpty()) {
            ConViewList otherOptions = new ConViewList(Messages.General_OtherOptions, true);
            otherOptions.addEntry(Messages.PageInstallEnvironment_SelectAllButton, "S", (AConActionEntry)new ConActSelectAllLanguages()).setContext((Object)Boolean.TRUE);
            otherOptions.addEntry(Messages.PageInstallEnvironment_ClearAllButton, "U", (AConActionEntry)new ConActSelectAllLanguages()).setContext((Object)Boolean.FALSE);
            this.addView((IConView)otherOptions);
        }
        ConViewStatus statusView = new ConViewStatus();
        statusView.setStatus(this.m_context.getLanguageValidationStatus());
        this.addView((IConView)statusView);
        super.present(a_output);
    }

    private int getCommonLangLabelNum(Set<String> commonLangCode, Map<String, String> map) {
        HashSet<String> labels = new HashSet<String>();
        for (String code : commonLangCode) {
            labels.add(map.get(code));
        }
        return labels.size();
    }

    public boolean isPageComplete() {
        return !StatusUtil.isErrorOrCancel((IStatus)this.m_context.getLanguageValidationStatus());
    }

    public boolean skipPage() {
        this.m_context = (ConDataCtxtLocaleLangs)this.conManager().getDataContext(ConDataCtxtLocaleLangs.class);
        return this.m_context.shouldSkip();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.m_context.validateSelectedLanguages(true);
        }
        super.setVisible(visible);
    }

    class ConActFlipLanguageSelection
    extends AConActionEntry<ConViewListEntry> {
        ConActFlipLanguageSelection() {
        }

        public void run(IConManager a_conManager) {
            Set codes = (Set)((ConViewListEntry)this.getEntry()).getContext();
            ConPageLocaleLangs.this.m_context.flipSelection(codes, !ConPageLocaleLangs.this.m_context.isSelected(codes));
            super.run(a_conManager);
        }
    }

    class ConActSelectAllLanguages
    extends AConActionEntry<ConViewListEntry> {
        ConActSelectAllLanguages() {
        }

        public void run(IConManager a_conManager) {
            Boolean select = (Boolean)((ConViewListEntry)this.getEntry()).getContext();
            ConPageLocaleLangs.this.m_context.selectAllLangs(select);
            super.run(a_conManager);
        }
    }
}

