/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.console.pages;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.BitModeUtils;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.sharedUI.ProfileOffering;
import com.ibm.cic.agent.core.sharedUI.ProfileOfferingFix;
import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.internal.console.Messages;
import com.ibm.cic.agent.internal.core.history.IActivity;
import com.ibm.cic.agent.internal.core.history.IFeatureInfo;
import com.ibm.cic.agent.internal.core.history.IOfferingInfo;
import com.ibm.cic.common.core.console.manager.IConManager;
import com.ibm.cic.common.core.console.pages.AConPage;
import com.ibm.cic.common.core.console.views.AConViewContentProvider;
import com.ibm.cic.common.core.console.views.ConViewProperties;
import com.ibm.cic.common.core.console.views.ConViewText;
import com.ibm.cic.common.core.console.views.ConViewTreeList;
import com.ibm.cic.common.core.console.views.IConView;
import com.ibm.cic.common.core.console.views.IConViewContentProvider;
import com.ibm.cic.common.core.definitions.ProfileLanguageUtils;
import com.ibm.cic.common.core.internal.repository.RepositoryInfo;
import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IFeatureBase;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.Information;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.core.preferences.CicPreferenceManager;
import com.ibm.cic.common.core.preferences.ICicPreferenceConstants;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.logging.LogUtil;
import com.ibm.cic.common.logging.parser.EntryRecord;
import com.ibm.cic.common.logging.parser.ThrownRecord;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.osgi.framework.Version;

public abstract class AConPageElementDetails
extends AConPage {
    public AConPageElementDetails(IConManager aConManager) {
        super(aConManager);
    }

    protected void addElementDescription(Object element) {
        if (element == null) {
            return;
        }
        ConViewProperties propertiesView = null;
        if (element instanceof Profile) {
            Profile profile = (Profile)element;
            propertiesView = new ConViewProperties(NLS.bind((String)Messages.ConPageDetail_ProfileDetailDes, (Object)profile.getProfileId()), null, null);
            propertiesView.addProperty(com.ibm.cic.agent.core.sharedUI.Messages.General_Summary_PackageGroupName, profile.getProfileId());
            propertiesView.addProperty(Messages.General_Summary_SharedResourceDirectory, profile.getCacheLocation());
            propertiesView.addProperty(Messages.General_Summary_InstallationDirectory, profile.getInstallLocation());
            String eclipseLocation = profile.getEclipseLocation();
            if (eclipseLocation != null && eclipseLocation.length() > 0 && profile.isExistingEclipseProfile()) {
                propertiesView.addProperty(Messages.ConPageDetail_EclipseIDE, eclipseLocation);
            }
            String localeLanguages = ProfileLanguageUtils.getLabelString((String)profile.getData("cic.selector.nl"), (boolean)false);
            propertiesView.addProperty(com.ibm.cic.agent.core.sharedUI.Messages.EnvironmentPage_language, localeLanguages);
            if (BitModeUtils.isBitModeApplicable((Profile)profile)) {
                String bitModeText = BitModeUtils.getBitModeText((Profile)profile);
                propertiesView.addProperty(Messages.ConPageDetail_architecture, bitModeText);
            }
            this.addView((IConView)propertiesView);
        } else if (element instanceof ProfileOffering) {
            Collection visibleFeatures;
            String repLocation;
            String des;
            ProfileOffering profileOffering = (ProfileOffering)element;
            Profile profile = profileOffering.getProfile();
            IOffering offering = profileOffering.getOffering();
            propertiesView = new ConViewProperties(NLS.bind((String)Messages.ConPageDetail_OfferingDetailDes, (Object)OfferingUtil.getOfferingOrFixLabelA((IOfferingOrFix)offering, (boolean)CicPreferenceManager.getInstance().getBoolean(ICicPreferenceConstants.DISPLAY_INTERNAL_VERSION.key()))), null, null);
            Information info = offering.getInformation();
            if (info != null && (des = info.getDescription()) != null && des.length() > 0) {
                propertiesView.addProperty(Messages.ConPageDetail_OfferingDes, des);
            }
            if ((repLocation = this.getInstallRepository(profile, (IOfferingOrFix)offering)) != null) {
                propertiesView.addProperty(Messages.ConPageDetail_Repository, repLocation);
            }
            if (!(visibleFeatures = AgentUtil.getVisibleInstalledFeatures((Agent)Agent.getInstance(), (Profile)profile, (IOffering)offering)).isEmpty()) {
                StringBuffer features = new StringBuffer();
                for (IFeature feature : visibleFeatures) {
                    features.append(SharedUIUtils.getFeatureBaseLabel((IFeatureBase)feature));
                    features.append(", ");
                }
                String featuresList = features.substring(0, features.length() - 2);
                propertiesView.addProperty(Messages.ConPageDetail_InstalledFeatures, featuresList);
            }
            this.addView((IConView)propertiesView);
        } else if (element instanceof ProfileOfferingFix) {
            ProfileOfferingFix profileOfferingFix = (ProfileOfferingFix)element;
            ProfileOffering profileOffering = profileOfferingFix.getProfileOffering();
            Profile profile = profileOffering.getProfile();
            IFix fix = profileOfferingFix.getFix();
            propertiesView = new ConViewProperties(NLS.bind((String)Messages.ConPageDetail_FixDetailDes, (Object)OfferingUtil.getOfferingOrFixLabelA((IOfferingOrFix)fix, (boolean)CicPreferenceManager.getInstance().getBoolean(ICicPreferenceConstants.DISPLAY_INTERNAL_VERSION.key()))), null, null);
            String repLocation = this.getInstallRepository(profile, (IOfferingOrFix)fix);
            if (repLocation != null) {
                propertiesView.addProperty(Messages.ConPageDetail_Repository, repLocation);
            }
            this.addView((IConView)propertiesView);
        } else if (element instanceof IActivity) {
            IActivity activity = (IActivity)element;
            propertiesView = new ConViewProperties("", null, null);
            propertiesView.addProperty(Messages.ConPageDetail_StartTime, activity.getStartTime());
            propertiesView.addProperty(Messages.ConPageDetail_EndTime, activity.getEndTime());
            propertiesView.addProperty(com.ibm.cic.agent.core.sharedUI.Messages.InstallationHistoryView_activityCol, SharedUIUtils.ACTIVITY_TYPE[activity.getActivityType()]);
            propertiesView.addProperty(com.ibm.cic.agent.core.sharedUI.Messages.General_Summary_PackageGroupName, activity.getHistory().getProfileInfo().getProfileIdentity().getProfileId());
            propertiesView.addProperty(com.ibm.cic.agent.core.sharedUI.Messages.InstallationHistoryView_statusCol, SharedUIUtils.getLocalizedStatus((IActivity)activity));
            this.addView((IConView)propertiesView);
            this.addView((IConView)new ConViewText(""));
            ConViewTreeList installedPkgTree = new ConViewTreeList(com.ibm.cic.agent.core.sharedUI.Messages.InstallationHistoryPkg, 1, false, false, 1, false, false);
            installedPkgTree.setContentProvider((IConViewContentProvider)new ActivityInstalledPackagesContentProvider(activity));
            this.addView((IConView)installedPkgTree);
        } else if (element instanceof EntryRecord) {
            EntryRecord entry = (EntryRecord)element;
            propertiesView = new ConViewProperties("", null, null);
            propertiesView.addProperty(com.ibm.cic.agent.core.sharedUI.Messages.InstallationHistoryView_dateCol, LogUtil.toISO8601((long)entry.getTime()));
            propertiesView.addProperty(com.ibm.cic.agent.core.sharedUI.Messages.AgentLogView_severityCol, SharedUIUtils.getLogSeverity((int)entry.getLevel()));
            String messageId = entry.getUid();
            if (messageId != null) {
                propertiesView.addProperty(com.ibm.cic.agent.core.sharedUI.Messages.AgentLogView_messageIDCol, messageId);
            }
            propertiesView.addProperty(com.ibm.cic.agent.core.sharedUI.Messages.AgentLogView_desCol, StatusUtil.combineAnchors((String)SharedUIUtils.constructLogDescription((EntryRecord)entry)));
            ThrownRecord stackTrace = entry.getThrownRecord();
            if (SharedUIUtils.displayStatckTrace((ThrownRecord)stackTrace)) {
                propertiesView.addProperty(Messages.ConPageLogEntry_Exception, SharedUIUtils.formatStackTrace((ThrownRecord)stackTrace));
            }
            this.addView((IConView)propertiesView);
        }
        this.addView((IConView)ConViewText.NEW_LINE);
    }

    private String getInstallRepository(Profile profile, IOfferingOrFix offeringOrFix) {
        String repLocation = null;
        IRepository rep = offeringOrFix.getRepository();
        if (rep != null && rep.getLocationStr() != null) {
            repLocation = rep.getLocationStr();
            IRepository installRegistryRep = profile.getInstallRegistry().getRepository();
            if (installRegistryRep != null && installRegistryRep.equals(rep)) {
                String serializedRepInfo = Agent.getInstance().getInstalledOfferingRepInfo(profile, offeringOrFix);
                RepositoryInfo repInfo = RepositoryInfo.deserialize((String)serializedRepInfo);
                repLocation = repInfo.getLocationStr();
            }
        }
        return repLocation;
    }

    private static class ActivityInstalledPackagesContentProvider
    extends AConViewContentProvider {
        private final IActivity activity;

        ActivityInstalledPackagesContentProvider(IActivity a_activity) {
            this.activity = a_activity;
        }

        public String getLabel(Object object) {
            if (object instanceof IOfferingInfo) {
                IOfferingInfo offeringInfo = (IOfferingInfo)object;
                StringBuffer result = new StringBuffer();
                result.append(offeringInfo.getOfferingName());
                result.append("  ");
                result.append(offeringInfo.getLocalizedVersion());
                Version offeringVersion = offeringInfo.getOfferingVersion();
                if (offeringVersion != null) {
                    String offeringVersionStr = offeringVersion.toString();
                    boolean showInternalVersion = CicPreferenceManager.getInstance().getBoolean(ICicPreferenceConstants.DISPLAY_INTERNAL_VERSION.key());
                    if (!offeringVersionStr.equals(offeringInfo.getLocalizedVersion()) && showInternalVersion) {
                        result.append("  ");
                        result.append(offeringInfo.getOfferingVersion());
                    }
                }
                return result.toString();
            }
            if (object instanceof IFeatureInfo) {
                IFeatureInfo featureInfo = (IFeatureInfo)object;
                return featureInfo.getFeatureName();
            }
            return super.getLabel(object);
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IOfferingInfo) {
                ArrayList<IFeatureInfo> features = new ArrayList<IFeatureInfo>();
                IOfferingInfo offeringInfo = (IOfferingInfo)parentElement;
                Iterator it = offeringInfo.getFeatures();
                while (it.hasNext()) {
                    IFeatureInfo feature = (IFeatureInfo)it.next();
                    if (!feature.isVisible()) continue;
                    features.add(feature);
                }
                return features.toArray();
            }
            return null;
        }

        public Object[] getElements() {
            return this.activity.getAllOfferingArray();
        }
    }
}

