/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.console.pages;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.AgentRelaunch;
import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.internal.console.ConUpdateAgentUtils;
import com.ibm.cic.agent.internal.console.ConUtils;
import com.ibm.cic.agent.internal.console.manager.AConDataAgentWizard;
import com.ibm.cic.common.core.console.Messages;
import com.ibm.cic.common.core.console.actions.AConActionEntry;
import com.ibm.cic.common.core.console.manager.IConManager;
import com.ibm.cic.common.core.console.pages.AConPage;
import com.ibm.cic.common.core.console.pages.AConPageWizard;
import com.ibm.cic.common.core.utils.ConsoleProgressMonitor;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.logging.Logger;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;

public abstract class AConPageAgentWizard
extends AConPageWizard {
    private AConDataAgentWizard context;

    public AConPageAgentWizard(IConManager manager) {
        super(manager);
        Logger.getGlobalLogger().statusNotOK(Agent.getInstance().unloadAgentBundles((IProgressMonitor)new NullProgressMonitor()));
    }

    protected AConDataAgentWizard getContext() {
        return this.context;
    }

    protected void setContext(AConDataAgentWizard context) {
        this.context = context;
    }

    protected AConActionEntry getCancelAction() {
        return ConUtils.getCancelAction();
    }

    public void dispose() {
        this.conManager().setDataContext(null);
        this.setContext(null);
        Agent.getInstance().clearProfileLanguageMap();
        super.dispose();
    }

    protected IStatus checkForAgentUpdate(boolean[] installNewerIM, IProgressMonitor monitor) {
        installNewerIM[0] = false;
        IStatus status = ConUpdateAgentUtils.checkForAgentUpdateNDisplayServiceRepStatus(this.conManager(), monitor);
        return status;
    }

    protected boolean checkForAgentUpdate(boolean mandatoryUpdate) {
        boolean[] installNewerIM = new boolean[1];
        IProgressMonitor monitor = ConsoleProgressMonitor.createMonitorWithUnknownWork();
        IStatus status = this.checkForAgentUpdate(installNewerIM, monitor);
        if (StatusUtil.isError((IStatus)status)) {
            return true;
        }
        if (StatusUtil.isCancel((IStatus)status)) {
            return mandatoryUpdate;
        }
        if (installNewerIM[0]) {
            this.installNewerVersionOfIM();
            return true;
        }
        return status.getCode() != -51;
    }

    protected void installNewerVersionOfIM() {
        this.setCurrentPageToNextPage();
    }

    private boolean jobToleratesAgent(AbstractJob job) {
        IStatus status = SharedUIUtils.getAgentToleranceStatus((AgentJob)job);
        if (StatusUtil.isError((IStatus)status)) {
            System.out.println(String.valueOf(Messages.General_Error) + " " + status.getMessage());
            return false;
        }
        return true;
    }

    protected boolean checkJobsToleranceForAgent(AbstractJob job) {
        if (!this.jobToleratesAgent(job)) {
            AConPage curPage = this.getCurrentPage();
            if (this.checkForAgentUpdate(true) && (AgentRelaunch.getInstance().needsRelaunch() || this.getCurrentPage() != curPage)) {
                return true;
            }
        }
        return false;
    }

    protected void checkJobsToleranceForAgent(List<? extends AbstractJob> jobs) {
        for (AbstractJob abstractJob : jobs) {
            if (this.jobToleratesAgent(abstractJob)) continue;
            this.checkForAgentUpdate(true);
            return;
        }
    }
}

