/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.console.manager;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.sharedUI.Messages;
import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtPrefsBase;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtPrefsMain;
import com.ibm.cic.common.core.preferences.CicPreferenceManager;
import com.ibm.cic.common.core.preferences.ICicPreferenceConstants;
import com.ibm.cic.common.core.utils.ConsoleProgressMonitor;
import com.ibm.cic.common.downloads.FormatUtil;
import com.ibm.cic.common.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ConDataCtxtPrefsFileForRollback
extends ConDataCtxtPrefsBase {
    private final ICicPreferenceConstants.PreferenceTag m_saveFilesTag = ICicPreferenceConstants.PRESERVE_DOWNLOADED_ARTIFACTS;
    private static final Logger log = Logger.getLogger(ConDataCtxtPrefsFileForRollback.class);
    private Agent.IPurgeableFiles m_purgeableFile = null;
    private boolean m_saveFilesForRollback = CicPreferenceManager.getInstance().getBoolean(this.m_saveFilesTag.key());
    private long m_purgeableFileSize = -1L;

    ConDataCtxtPrefsFileForRollback(ConDataCtxtPrefsMain a_mainPreferenceDataContext) {
        super(a_mainPreferenceDataContext);
    }

    public boolean getSaveFilesForRollback() {
        return this.m_saveFilesForRollback;
    }

    public void setSaveFilesForRollback(boolean saveFiles) {
        this.m_saveFilesForRollback = saveFiles;
        this.m_preferencesChanged = true;
    }

    public void determinePurgeableFiles() {
        IStatus status;
        block5: {
            status = Status.OK_STATUS;
            IProgressMonitor monitor = ConsoleProgressMonitor.createMonitorWithUnknownWork();
            try {
                try {
                    this.m_purgeableFile = Agent.getInstance().determinePurgeableFiles(monitor);
                }
                catch (CoreException e) {
                    status = e.getStatus();
                    log.error((Throwable)e);
                    monitor.done();
                    break block5;
                }
            }
            catch (Throwable throwable) {
                monitor.done();
                throw throwable;
            }
            monitor.done();
        }
        this.determinePurgeableFileSize(status);
    }

    private void determinePurgeableFileSize(IStatus status) {
        this.m_purgeableFileSize = -1L;
        if (status != null && status.isOK() && this.m_purgeableFile != null) {
            this.m_purgeableFileSize = this.m_purgeableFile.getTotalSize();
        }
    }

    public String getFileSizeLabel() {
        String sizeLabel = Messages.DownloadCachePreferencePage_CleanUp_CurrentStatus_Unknown;
        if (this.m_purgeableFileSize >= 0L) {
            sizeLabel = FormatUtil.formatBytes((long)this.m_purgeableFileSize);
        }
        return sizeLabel;
    }

    public long getSavedFileSize() {
        return this.m_purgeableFileSize;
    }

    public long getPurgeableFileSize() {
        return this.m_purgeableFileSize;
    }

    public void deletePurgeableFiles() {
        if (this.m_purgeableFile != null) {
            IProgressMonitor monitor = ConsoleProgressMonitor.createMonitorWithUnknownWork();
            try {
                IStatus status = this.m_purgeableFile.purgeFiles(monitor);
                this.determinePurgeableFileSize(status);
            }
            finally {
                monitor.done();
            }
        }
    }

    @Override
    public boolean isPreferenceEditable() {
        return SharedUIUtils.isPreferenceEditable((ICicPreferenceConstants.PreferenceTag)this.m_saveFilesTag);
    }

    @Override
    public void savePreferences() {
        this.m_mainPrefDataContext.getCurrentPrefHandler().setValue(this.m_saveFilesTag.key(), this.m_saveFilesForRollback);
        super.savePreferences();
    }

    @Override
    public void restoreDefaults() {
        this.setSaveFilesForRollback(this.m_mainPrefDataContext.getDefaultPrefHandler().getBoolean(this.m_saveFilesTag));
    }
}

