/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.console.manager;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.sharedUI.Messages;
import com.ibm.cic.common.core.console.manager.AConDataCtxt;
import com.ibm.cic.common.core.definitions.LanguageCode;
import com.ibm.cic.common.core.definitions.ProfileLanguageUtils;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.utils.OfferingProperty;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class ConDataCtxtLocaleLangs
extends AConDataCtxt {
    private final List<? extends AbstractJob> m_selectedProductJobs;
    private List<AbstractJob> m_changeLangProductJobs;
    private Map<String, String> m_codeLabelMap;
    private Set m_commonLanguages;
    private Set m_nonCommonLanguages;
    private Set<String> m_requiredLanguages;
    private Set<String> m_selectedLanguages;
    private String m_currentPlatformLocaleLang;
    private IStatus m_validationStatus = Status.OK_STATUS;
    private IStatus m_previousApplicabilityStatus = Status.OK_STATUS;
    private boolean isInstall = true;
    private Profile m_selectedProfile;

    public ConDataCtxtLocaleLangs(List<? extends AbstractJob> selectedJobs) {
        Agent.getInstance().clearProfileLanguageMap();
        this.m_selectedProductJobs = AgentUtil.getSelectedProductAbstractJobs(selectedJobs);
        if (this.m_selectedProductJobs.size() > 0) {
            String[] orderedCodes;
            Map map = ProfileLanguageUtils.getLocaleCodeLabelMap();
            this.m_codeLabelMap = new LinkedHashMap<String, String>();
            String[] stringArray = orderedCodes = ProfileLanguageUtils.getLocaleLanguageCodes();
            int n = orderedCodes.length;
            int n2 = 0;
            while (n2 < n) {
                String orderedCode = stringArray[n2];
                this.m_codeLabelMap.put(orderedCode, (String)map.get(orderedCode));
                ++n2;
            }
            if (!this.m_selectedProductJobs.get(0).isInstall()) {
                this.isInstall = false;
            }
            this.m_changeLangProductJobs = new ArrayList<AbstractJob>(this.m_selectedProductJobs);
            if (this.m_changeLangProductJobs.size() > 0) {
                this.generateLanguageSet();
                this.generateDefaultSelectedLangs();
            }
        }
    }

    public boolean shouldSkip() {
        if (this.m_changeLangProductJobs == null || this.m_changeLangProductJobs.isEmpty()) {
            return true;
        }
        this.m_selectedProfile = this.m_changeLangProductJobs.get(0).getProfile();
        if (this.m_selectedProfile == null || this.isInstall && !this.m_selectedProfile.isShadow()) {
            Agent.getInstance().clearProfileLanguageMap();
            return true;
        }
        HashSet allLangs = new HashSet(this.m_commonLanguages);
        allLangs.addAll(this.m_nonCommonLanguages);
        if (allLangs.isEmpty() || allLangs.size() == 1 && allLangs.contains(LanguageCode.ENGLISH.getId())) {
            HashSet<String> tempSet = new HashSet<String>();
            tempSet.add(LanguageCode.ENGLISH.getId());
            this.setSelectedLanguages(tempSet, true);
            return true;
        }
        Agent.getInstance().getProfileLanguageMap().put(this.m_selectedProfile, ProfileLanguageUtils.convertCodeSetToString(this.m_selectedLanguages));
        return false;
    }

    private void setSelectedLanguages(Set langCodeSet, boolean add) {
        if (add) {
            this.m_selectedLanguages.addAll(langCodeSet);
        } else {
            this.m_selectedLanguages.removeAll(langCodeSet);
        }
        Agent.getInstance().getProfileLanguageMap().put(this.m_selectedProfile, ProfileLanguageUtils.convertCodeSetToString(this.m_selectedLanguages));
    }

    private void generateDefaultSelectedLangs() {
        if (this.m_selectedLanguages == null) {
            this.m_selectedLanguages = new HashSet<String>();
            if (!this.m_changeLangProductJobs.isEmpty()) {
                if (this.isInstall) {
                    this.m_selectedLanguages.add(LanguageCode.ENGLISH.getId());
                    this.m_selectedLanguages.addAll(this.m_requiredLanguages);
                    if (this.m_currentPlatformLocaleLang != null && this.m_commonLanguages.contains(this.m_currentPlatformLocaleLang)) {
                        this.m_selectedLanguages.add(this.m_currentPlatformLocaleLang);
                    }
                } else {
                    for (AbstractJob job : this.m_changeLangProductJobs) {
                        Profile profile = job.getProfile();
                        String value = profile.getData("cic.selector.nl");
                        Set installedLangs = ProfileLanguageUtils.convertCodeStringToSet((String)value);
                        for (String code : installedLangs) {
                            if (this.m_selectedLanguages.contains(code) || !this.m_commonLanguages.contains(code) && !this.m_nonCommonLanguages.contains(code)) continue;
                            this.m_selectedLanguages.add(code);
                        }
                    }
                }
                if (this.m_selectedProfile == null) {
                    this.m_selectedProfile = this.m_changeLangProductJobs.get(0).getProfile();
                }
                if (this.m_selectedProfile != null) {
                    Agent.getInstance().getProfileLanguageMap().put(this.m_selectedProfile, ProfileLanguageUtils.convertCodeSetToString(this.m_selectedLanguages));
                }
            }
        }
    }

    private void generateLanguageSet() {
        String languageCode;
        String[] languageCodes;
        if (this.m_commonLanguages != null || this.m_nonCommonLanguages != null) {
            return;
        }
        String currentNL = Platform.getNL();
        String[] stringArray = languageCodes = ProfileLanguageUtils.getLocaleLanguageCodes();
        int n = languageCodes.length;
        int n2 = 0;
        while (n2 < n) {
            languageCode = stringArray[n2];
            if (languageCode.startsWith(currentNL)) {
                this.m_currentPlatformLocaleLang = languageCode;
                break;
            }
            ++n2;
        }
        if (this.m_currentPlatformLocaleLang == null) {
            stringArray = languageCodes;
            n = languageCodes.length;
            n2 = 0;
            while (n2 < n) {
                languageCode = stringArray[n2];
                if (currentNL.startsWith(languageCode)) {
                    this.m_currentPlatformLocaleLang = languageCode;
                    break;
                }
                ++n2;
            }
        }
        this.m_commonLanguages = new HashSet();
        this.m_nonCommonLanguages = new HashSet();
        this.m_requiredLanguages = new HashSet<String>();
        HashSet superSetLanguages = new HashSet();
        for (AbstractJob job : this.m_changeLangProductJobs) {
            IOffering offering = job.getOffering();
            if (offering == null) continue;
            Set pkgLanguages = OfferingProperty.getSupportedLocales((IOffering)offering);
            Set supportedLangs = ProfileLanguageUtils.getLocaleLanguageCodeSet();
            supportedLangs.retainAll(pkgLanguages);
            superSetLanguages.addAll(supportedLangs);
            if (this.m_commonLanguages.isEmpty()) {
                this.m_commonLanguages.addAll(supportedLangs);
            } else {
                this.m_commonLanguages.retainAll(supportedLangs);
            }
            this.m_requiredLanguages.addAll(OfferingProperty.getRequiredLocales((IOffering)offering));
        }
        this.m_commonLanguages.add(LanguageCode.ENGLISH.getId());
        this.m_requiredLanguages.add(LanguageCode.ENGLISH.getId());
        superSetLanguages.removeAll(this.m_commonLanguages);
        this.m_nonCommonLanguages = superSetLanguages;
    }

    public void flipSelection(Set<String> langCode, boolean select) {
        if (select) {
            this.setSelectedLanguages(langCode, true);
        } else {
            if (this.m_requiredLanguages != null) {
                HashSet<String> requiredLangCopy = new HashSet<String>(this.m_requiredLanguages);
                requiredLangCopy.retainAll(langCode);
                if (!requiredLangCopy.isEmpty()) {
                    return;
                }
            }
            this.setSelectedLanguages(langCode, false);
        }
        this.validateSelectedLanguages(false);
    }

    public void selectAllLangs(boolean select) {
        HashSet allLangs = new HashSet(this.m_commonLanguages);
        allLangs.addAll(this.m_nonCommonLanguages);
        if (select) {
            this.setSelectedLanguages(allLangs, true);
        } else {
            allLangs.removeAll(this.m_requiredLanguages);
            if (!allLangs.isEmpty()) {
                this.setSelectedLanguages(allLangs, false);
            }
        }
        this.validateSelectedLanguages(false);
    }

    public void validateSelectedLanguages(boolean checkApplicability) {
        IStatus applicabilityCheckStatus = this.m_previousApplicabilityStatus;
        if (checkApplicability && this.m_selectedProductJobs.size() > 0) {
            AbstractJob job = this.m_selectedProductJobs.get(0);
            applicabilityCheckStatus = job.isInstall() ? AgentUtil.getOfferingsApplicability(this.m_selectedProductJobs) : AgentUtil.getOfferingsApplicability(this.m_selectedProductJobs, (AgentJob[])AgentJob.toArray(this.m_selectedProductJobs));
            this.m_previousApplicabilityStatus = applicabilityCheckStatus;
        }
        if (StatusUtil.isErrorOrCancel((IStatus)applicabilityCheckStatus)) {
            this.m_validationStatus = applicabilityCheckStatus;
            return;
        }
        IStatus langConsistencyStatus = this.checkLangConsistency();
        if (StatusUtil.isErrorOrCancel((IStatus)langConsistencyStatus)) {
            this.m_validationStatus = langConsistencyStatus;
            return;
        }
        CicMultiStatus resultStatus = Statuses.ST.createMultiStatus();
        resultStatus.add(langConsistencyStatus);
        resultStatus.add(applicabilityCheckStatus);
        this.m_validationStatus = resultStatus;
    }

    private IStatus checkLangConsistency() {
        HashSet<String> selectedLangs = new HashSet<String>(this.m_selectedLanguages);
        selectedLangs.retainAll(this.m_nonCommonLanguages);
        if (!selectedLangs.isEmpty()) {
            boolean singleLang = selectedLangs.size() == 1;
            String labels = ProfileLanguageUtils.getLabelString(selectedLangs, this.m_codeLabelMap);
            return Statuses.WARNING.get(singleLang ? Messages.EnvironmentPage_nonSupportedLangMsg : Messages.EnvironmentPage_nonSupportedLangsMsg, new Object[]{labels});
        }
        return Status.OK_STATUS;
    }

    public IStatus getLanguageValidationStatus() {
        return this.m_validationStatus;
    }

    public String getCurrentPlatformLocaleLang() {
        return this.m_currentPlatformLocaleLang;
    }

    public Set<String> getSelectedLangs() {
        if (this.m_selectedLanguages != null) {
            return this.m_selectedLanguages;
        }
        return new HashSet<String>();
    }

    public String getSelectedLangLabels() {
        if (this.m_selectedLanguages != null && !this.m_selectedLanguages.isEmpty()) {
            String[] orderedCode;
            LinkedHashSet<String> orderedList = new LinkedHashSet<String>();
            String[] stringArray = orderedCode = ProfileLanguageUtils.getLocaleLanguageCodes();
            int n = orderedCode.length;
            int n2 = 0;
            while (n2 < n) {
                String code = stringArray[n2];
                if (this.m_selectedLanguages.contains(code)) {
                    orderedList.add(code);
                }
                ++n2;
            }
            return ProfileLanguageUtils.getLabelString(orderedList, this.m_codeLabelMap);
        }
        return "";
    }

    public Set<String> getCommonLangs() {
        return this.m_commonLanguages;
    }

    public Set<String> getNonCommonLangs() {
        return this.m_nonCommonLanguages;
    }

    public Set<String> getRequiredLangs() {
        return this.m_requiredLanguages;
    }

    public Map<String, String> getCodeLabelMap() {
        return this.m_codeLabelMap;
    }

    public boolean isSelected(String code) {
        if (this.m_selectedLanguages == null || this.m_selectedLanguages.isEmpty()) {
            return false;
        }
        return this.m_selectedLanguages.contains(code);
    }

    public boolean isSelected(Set<String> codes) {
        if (this.m_selectedLanguages == null || this.m_selectedLanguages.isEmpty()) {
            return false;
        }
        for (String code : codes) {
            if (!this.isSelected(code)) continue;
            return true;
        }
        return false;
    }

    public List<? extends AbstractJob> getSelectedProductJobs() {
        return this.m_selectedProductJobs;
    }
}

