/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.console.manager;

import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.api.TextCustomPanel;
import com.ibm.cic.agent.core.sharedUI.CommonCustomPanelFactory;
import com.ibm.cic.agent.core.sharedUI.CustomPanelFactory;
import com.ibm.cic.agent.core.sharedUI.CustomPanelJobPair;
import com.ibm.cic.agent.core.sharedUI.ICustomPanelFactory;
import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.core.sharedUI.WizardType;
import com.ibm.cic.agent.core.userdata.parser.CommonUserDataExtParser;
import com.ibm.cic.agent.core.userdata.parser.OfferingUserDataExtParser;
import com.ibm.cic.agent.internal.console.Messages;
import com.ibm.cic.common.core.console.manager.AConDataCtxt;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.logging.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;

public class ConDataCtxtCustomPanels
extends AConDataCtxt {
    private static final Logger log = Logger.getLogger();
    private final AgentJob[] jobs;
    private List<CustomPanelJobPair> panels;

    public ConDataCtxtCustomPanels(AgentJob[] jobs) {
        this.jobs = jobs;
    }

    public boolean shouldSkipCustomPanels(WizardType wizardType) {
        this.panels = this.getCustomPanels(wizardType);
        return this.panels.isEmpty();
    }

    public void transferControlToCustomPanels() {
        CommonUserDataExtParser.getInstance().initializeCommonUserDataExtensions(this.jobs);
        OfferingUserDataExtParser.getInstance().initializeOfferingUserDataExtensions(this.jobs);
        Map profileMap = CustomPanelJobPair.groupCustomPanels(this.panels);
        for (Map.Entry e1 : profileMap.entrySet()) {
            Profile profile = (Profile)e1.getKey();
            if (profileMap.size() > 1) {
                System.out.println("---- " + NLS.bind((String)Messages.ConDataCtxtCustomPanels_Configuration_For_Packages_In, (Object)profile.getInstallLocation()));
                System.out.println();
            }
            for (Map.Entry e2 : ((Map)e1.getValue()).entrySet()) {
                IOffering offering = (IOffering)e2.getKey();
                if (offering == null) {
                    System.out.println("---- " + Messages.ConDataCtxtCustomPanels_Common_Configuration);
                } else {
                    System.out.println("---- " + NLS.bind((String)Messages.ConDataCtxtCustomPanels_Configuration_For_Package, (Object)offering.getName(), (Object)OfferingUtil.getDisplayableVersion((IOfferingOrFix)offering)));
                }
                System.out.println();
                for (CustomPanelJobPair pair : (List)e2.getValue()) {
                    ((TextCustomPanel)pair.getPanel()).perform();
                }
                System.out.println();
            }
        }
    }

    private List<CustomPanelJobPair> getCustomPanels(WizardType wizardType) {
        ArrayList<CustomPanelJobPair> result = new ArrayList<CustomPanelJobPair>();
        ICustomPanelFactory[] iCustomPanelFactoryArray = new ICustomPanelFactory[]{CustomPanelFactory.getInstance(), CommonCustomPanelFactory.getInstance()};
        int n = iCustomPanelFactoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICustomPanelFactory factory = iCustomPanelFactoryArray[n2];
            try {
                CustomPanelJobPair[] customPanelJobPairArray = factory.createCustomPanels(true, TextCustomPanel.class, wizardType, this.jobs, false);
                int n3 = customPanelJobPairArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    CustomPanelJobPair panelJobPair = customPanelJobPairArray[n4];
                    try {
                        if (!panelJobPair.getPanel().shouldSkip()) {
                            result.add(panelJobPair);
                        }
                    }
                    catch (Exception e) {
                        IStatus status = SharedUIUtils.generateCustomPanelExceptionStatus((CustomPanelJobPair)panelJobPair, (Throwable)e);
                        log.status(status);
                    }
                    ++n4;
                }
            }
            catch (CoreException e) {
                log.status(e.getStatus());
            }
            ++n2;
        }
        return result;
    }
}

