/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.console;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.LocationCheckManager;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.internal.headless.AgentInput;
import com.ibm.cic.agent.internal.console.Messages;
import com.ibm.cic.common.core.console.actions.AConActionEntry;
import com.ibm.cic.common.core.console.actions.ConActionExit;
import com.ibm.cic.common.core.console.actions.ConActionReturnToPreviousPage;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.ISelectionExpression;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.core.repository.SliceUtils;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.ConsoleProgressMonitor;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

public class ConUtils {
    public static IStatus performLocationChecks(Set<Profile> selectedProfiles, AgentJob.AgentJobType jobType) {
        CicMultiStatus status = Statuses.ST.createMultiStatus();
        for (Profile profile : selectedProfiles) {
            status.add(AgentUtil.validateInstallDirectoryPermissions((String)profile.getInstallLocation()));
        }
        if (StatusUtil.isErrorOrCancel((IStatus)status)) {
            status.setMessage(com.ibm.cic.agent.core.sharedUI.Messages.ProfileSelectionPage_Permission_Check_ErrMsg);
            return status;
        }
        IProgressMonitor monitor = ConsoleProgressMonitor.createMonitorWithUnknownWork();
        monitor.beginTask(Messages.ConDataCtxtUpdateVersionSelector_CheckLocation, -1);
        return LocationCheckManager.getInstance().perform(selectedProfiles.toArray(new Profile[selectedProfiles.size()]), jobType, (IProgressMonitor)new SubProgressMonitor(monitor, 0));
    }

    public static IStatus performPreCheck(List<? extends AgentJob> jobs) {
        for (AgentJob agentJob : jobs) {
            IStatus status = ConUtils.performPreCheck(agentJob);
            if (!StatusUtil.isErrorOrCancel((IStatus)status)) continue;
            return status;
        }
        return Status.OK_STATUS;
    }

    public static IStatus performPreCheck(AgentJob job) {
        IOfferingOrFix offeringOrFix = job.getOfferingOrFix();
        if (offeringOrFix != null) {
            ISelectionExpression.ISelectedByBundle[] bundles = Agent.getInstance().getPrecheckBundles(offeringOrFix);
            return Agent.getInstance().evaluateOfferingBundles((ISelectionExpression[])bundles, job, false);
        }
        return Status.OK_STATUS;
    }

    public static IStatus containPkgNotSupportConsoleMode(Profile profile) {
        IOffering[] installedPkgs = Agent.getInstance().getInstalledOfferings(profile);
        if (installedPkgs == null || installedPkgs.length == 0) {
            return Status.OK_STATUS;
        }
        CicMultiStatus returnStatus = Statuses.ST.createMultiStatus();
        IOffering[] iOfferingArray = installedPkgs;
        int n = installedPkgs.length;
        int n2 = 0;
        while (n2 < n) {
            IOffering installedPkg = iOfferingArray[n2];
            IStatus offeringStatus = OfferingUtil.supportsConsoleMode((IOffering)installedPkg);
            if (!offeringStatus.isOK()) {
                returnStatus.add(offeringStatus);
            }
            ++n2;
        }
        if (StatusUtil.isErrorOrCancel((IStatus)returnStatus)) {
            returnStatus.setMessage(NLS.bind((String)com.ibm.cic.common.core.internal.Messages.SingleProfileNotSupportConsoleMode, (Object)profile.getProfileId()));
        }
        return returnStatus;
    }

    public static IStatus checkOfferingSupportConsoleMode(List<? extends AgentJob> jobList) {
        CicMultiStatus return_result = Statuses.ST.createMultiStatus();
        if (jobList != null && !jobList.isEmpty()) {
            int i = 0;
            while (i < jobList.size()) {
                IStatus status;
                IOffering offering = jobList.get(i).getOffering();
                if (offering != null && !(status = OfferingUtil.supportsConsoleMode((IOffering)offering)).isOK()) {
                    return_result.add(status);
                }
                ++i;
            }
        }
        if (!return_result.isOK() && return_result.getChildren().length == 1) {
            return return_result.getChildren()[0];
        }
        return return_result;
    }

    public static IStatus checkOfferingSupportCurrentPlatform(List<? extends AgentJob> jobList) {
        CicMultiStatus return_result = Statuses.ST.createMultiStatus();
        if (jobList != null && !jobList.isEmpty()) {
            int i = 0;
            while (i < jobList.size()) {
                IStatus status;
                IOffering offering = jobList.get(i).getOffering();
                Profile profile = jobList.get(i).getProfile();
                if (offering != null && !(status = SliceUtils.checkPlatform((IOfferingOrFix)offering, (String)profile.getOS(), (String)profile.getArch())).isOK()) {
                    return_result.add(status);
                }
                ++i;
            }
        }
        if (!return_result.isOK() && return_result.getChildren().length == 1) {
            return return_result.getChildren()[0];
        }
        return return_result;
    }

    public static AConActionEntry getCancelAction() {
        AgentInput agentInput = AgentInput.getInstance();
        if (agentInput.getMode() == 1) {
            return ConActionExit.INSTANCE;
        }
        return ConActionReturnToPreviousPage.INSTANCE_FIRST;
    }
}

