/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.application;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentInstall;
import com.ibm.cic.agent.core.AgentRelaunch;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.CacheLocationManager;
import com.ibm.cic.agent.core.CommandRecorder;
import com.ibm.cic.agent.core.IHeadlessApplication;
import com.ibm.cic.agent.core.StartupManager;
import com.ibm.cic.agent.core.application.AAgentApplication;
import com.ibm.cic.agent.core.application.Activator;
import com.ibm.cic.agent.core.cmd.CmdInputBuilder;
import com.ibm.cic.agent.core.cmd.CmdLine;
import com.ibm.cic.agent.core.ds.ConsoleManagerService;
import com.ibm.cic.agent.core.internal.commands.Input;
import com.ibm.cic.agent.core.internal.headless.CommandFactory;
import com.ibm.cic.agent.core.internal.headless.HeadlessUtils;
import com.ibm.cic.agent.core.internal.headless.IInput;
import com.ibm.cic.agent.core.internal.headless.IInstallAllCommand;
import com.ibm.cic.agent.core.internal.headless.IUpdateAllCommand;
import com.ibm.cic.agent.core.utils.SaveCredentialUtils;
import com.ibm.cic.agent.internal.core.InstallRegistry;
import com.ibm.cic.common.core.api.utils.EncryptionUtils;
import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.preferences.ICicPreferenceConstants;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.PlatformUtils;
import com.ibm.cic.common.core.utils.RebootRequest;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.volrepo.DiskPrompter;
import com.ibm.cic.common.core.volrepo.IDiskChangePrompter;
import com.ibm.cic.common.core.volrepo.IDiskInsertedValidator;
import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class HeadlessApplication
extends AAgentApplication
implements IHeadlessApplication {
    private Agent agent = null;
    private boolean deleteSavedFiles = false;
    private boolean purgeAgentAll = false;
    private boolean preservePrefs = false;
    private boolean purgeAgentData = false;
    private boolean validate = false;
    private boolean updateAll = false;
    private boolean modify = false;
    private boolean rollback = false;
    private String agentDataDestinationFile = null;
    private BundleContext bundleContext;
    private ConsoleManagerService consoleManagerService;

    public Object start(IApplicationContext context) throws Exception {
        String[] args = (String[])context.getArguments().get("application.args");
        this.bundleContext = context.getBrandingBundle().getBundleContext();
        return this.run(args);
    }

    public Object run(String[] args) {
        IStatus status = this.runAgent(args);
        Agent.getLogger().statusNotOK(status);
        if (AgentRelaunch.getInstance().needsRelaunch()) {
            return IApplication.EXIT_RESTART;
        }
        if (status.getSeverity() != 4 && status.getSeverity() != 8) {
            return IApplication.EXIT_OK;
        }
        PlatformUtils.disableErrorOutput();
        return 1;
    }

    public static Object runHeadlessApplication(Agent agent, String[] args) {
        HeadlessApplication headlessApplication = new HeadlessApplication();
        headlessApplication.setAgent(agent);
        return headlessApplication.run(args);
    }

    public static IStatus runHeadlessApplication(String[] args) {
        HeadlessApplication headlessApplication = new HeadlessApplication();
        return headlessApplication.runAgentNoStdout(args);
    }

    public IStatus runAgent(String[] args) {
        IStatus s = this.runAgentNoStdout(args);
        Agent.getInstance().flushStdoutBuffer();
        return s;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IStatus runAgentNoStdout(String[] args) {
        block68: {
            block66: {
                cmd_status = CmdLine.CL.loadCommandLineData(args);
                if (!cmd_status.isOK()) {
                    this.reportError(cmd_status, null);
                    return cmd_status;
                }
                return_value = this.processCommonCommandLineArguments();
                if (return_value != null) {
                    return return_value;
                }
                accessRightsStatus = Agent.getAccessRightsStatus();
                if (!accessRightsStatus.isOK()) {
                    this.printNotOKStatus(accessRightsStatus);
                    if (accessRightsStatus.getSeverity() == 4) {
                        return accessRightsStatus;
                    }
                }
                if (!(instanceAreaStatus = CicCommonSettings.setInstanceArea()).isOK()) {
                    this.printNotOKStatus(instanceAreaStatus);
                    return instanceAreaStatus;
                }
                responseFile = CmdLine.CL.getResponseFile();
                value = CmdLine.CL.getParam1StrVal("-log");
                logfile = null;
                if (value != null) {
                    logfile = new File(value);
                }
                this.deleteSavedFiles = CmdLine.CL.containsCommand("deleteSavedFiles");
                this.purgeAgentAll = CmdLine.CL.containsCommand("-purgeAgentAll");
                this.purgeAgentData = CmdLine.CL.containsCommand("-purgeAgentData");
                this.preservePrefs = CmdLine.CL.containsCommand("-preservePreferences");
                this.validate = CmdLine.CL.containsCommand("-validate");
                this.updateAll = CmdLine.CL.containsCommand("updateAll");
                this.modify = CmdLine.CL.containsCommand("modify");
                this.rollback = CmdLine.CL.containsCommand("rollback");
                CicCommonSettings.setIgnoreRepositoryDigest((boolean)CmdLine.CL.containsCommand("-ignoreRepositoryDigest"));
                this.agentDataDestinationFile = CmdLine.CL.getParam1StrVal("exportInstallData");
                retStatus = Statuses.ST.createMultiStatus();
                try {
                    value = CmdLine.CL.getParam1StrVal("-passwordKey");
                    if (value != null) {
                        EncryptionUtils.setPasswordKey((String)value);
                    } else if (CmdLine.CL.containsCommand("-passwordKey")) {
                        msg = Messages.PasswordKey_KeyWasNotSetByTheUser;
                        status = Statuses.ERROR.get(msg, new Object[0]);
                        this.reportError((IStatus)status, null);
                        retStatus.add((IStatus)status);
                        var18_16 = retStatus;
                        return var18_16;
                    }
                    value = CmdLine.CL.getParam1StrVal("encryptString");
                    if (value != null) {
                        value = value.trim();
                        this.reportInfo(EncryptionUtils.encrypt((String)value));
                        var18_17 = Status.OK_STATUS;
                        return var18_17;
                    }
                    if (CmdLine.CL.containsCommand("saveCredential")) {
                        var18_18 = rc = SaveCredentialUtils.save();
                        return var18_18;
                    }
                    Agent.getInstance().setSkipInstall(CmdLine.CL.containsCommand("-skipInstall"));
                    recordFile = CmdLine.CL.getParam1StrVal("-record");
                    if (recordFile != null && !(status = CommandRecorder.validateRecordFile((String)recordFile)).isOK()) {
                        this.reportError((IStatus)status, null);
                        retStatus.add((IStatus)status);
                        var18_19 = retStatus;
                        return var18_19;
                    }
                    agentCheckForIMLite = AgentInstall.getInstance().checkForIMLite();
                    if (!agentCheckForIMLite.isOK()) {
                        this.printNotOKStatus(agentCheckForIMLite);
                        retStatus.add(agentCheckForIMLite);
                        var18_20 = retStatus;
                        return var18_20;
                    }
                    agentInstallCheck = AgentInstall.getInstance().checkForAgentInstall();
                    if (!agentInstallCheck.isOK()) {
                        this.printNotOKStatus(agentInstallCheck);
                        retStatus.add(agentInstallCheck);
                        var18_21 = retStatus;
                        return var18_21;
                    }
                    if (AgentRelaunch.getInstance().needsRelaunch()) {
                        var18_22 = Status.OK_STATUS;
                        return var18_22;
                    }
                    DiskPrompter.INSTANCE.setPrompter(new IDiskChangePrompter(){

                        public IStatus promptInsertDisk(IDiskInsertedValidator validator, ICicLocation rootDir, String diskLabel, String diskSetId, int diskNum) {
                            return Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.HeadlessApplication_MultipleDiscsNotSupported, new Object[0]);
                        }
                    });
                    status /* !! */  = Status.OK_STATUS;
                    if (CmdLine.CL.isConsoleMode()) {
                        consoleManager = this.getConsoleManager();
                        status /* !! */  = consoleManager == null ? Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.ConsoleManager_ServiceNotFound, new Object[0]) : consoleManager.start((IHeadlessApplication)this);
                        this.printNotOKStatus(status /* !! */ );
                        var18_23 = status /* !! */ ;
                        return var18_23;
                    }
                    if (CmdLine.CL.isServerMode()) {
                        var18_24 = status /* !! */ ;
                        return var18_24;
                    }
                    if (responseFile == null) {
                        block65: {
                            installAll = CmdLine.CL.containsCommand("installAll");
                            if (!(this.deleteSavedFiles || this.purgeAgentData || this.purgeAgentAll || this.updateAll || installAll || this.agentDataDestinationFile != null || CmdInputBuilder.getCommandList() != null)) {
                                throw new HeadlessApplicationException(com.ibm.cic.agent.internal.core.Messages.HeadlessApplication_Missing_Input_Argument);
                            }
                            if (CmdLine.CL.shouldPrompt() && (consoleManager = this.getConsoleManager()) == null) {
                                var18_25 = status /* !! */  = Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.ImclPrompt_ServiceNotFound, new Object[0]);
                                return var18_25;
                            }
                            if (this.deleteSavedFiles) {
                                try {
                                    try {
                                        InstallRegistry.getInstance().open();
                                        purgeableFiles = null;
                                        purgeableFiles = Agent.getInstance().determinePurgeableFiles(HeadlessUtils.createProgressMonitor());
                                        status /* !! */  = purgeableFiles.purgeFiles(HeadlessUtils.createProgressMonitor());
                                    }
                                    catch (CoreException e) {
                                        status /* !! */  = e.getStatus();
                                        if (InstallRegistry.getInstance().isOpen()) {
                                            InstallRegistry.getInstance().close();
                                        }
                                        break block65;
                                    }
                                }
                                catch (Throwable var16_128) {
                                    if (InstallRegistry.getInstance().isOpen() == false) throw var16_128;
                                    InstallRegistry.getInstance().close();
                                    throw var16_128;
                                }
                                if (InstallRegistry.getInstance().isOpen()) {
                                    InstallRegistry.getInstance().close();
                                }
                            } else if (this.purgeAgentAll) {
                                status /* !! */  = this.purgeAll();
                            } else if (this.purgeAgentData) {
                                status /* !! */  = this.purgeData();
                            } else if (this.updateAll) {
                                v0 = isNewCommandLine = "imcl".equals(CmdLine.CL.getParam1StrVal("-toolId")) != false || "iimcl".equals(CmdLine.CL.getParam1StrVal("-toolId")) != false;
                                status /* !! */  = isNewCommandLine && CmdInputBuilder.getCommandList() != null ? this.run(CmdInputBuilder.getCommandList(), recordFile) : this.updateAll();
                            } else if (installAll) {
                                v1 = isNewCommandLine = "imcl".equals(CmdLine.CL.getParam1StrVal("-toolId")) != false || "iimcl".equals(CmdLine.CL.getParam1StrVal("-toolId")) != false;
                                status /* !! */  = isNewCommandLine && CmdInputBuilder.getCommandList() != null ? this.run(CmdInputBuilder.getCommandList(), recordFile) : this.installAll();
                            } else if (CmdInputBuilder.getCommandList() != null) {
                                if (this.modify) {
                                    addFeatures = CmdLine.CL.getParam1StrVal("-addFeatures");
                                    removeFeatures = CmdLine.CL.getParam1StrVal("-removeFeatures");
                                    if (addFeatures != null && addFeatures.trim().length() == 0 || removeFeatures != null && removeFeatures.trim().length() == 0) {
                                        status /* !! */  = Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.Cmd_modify_noFeatureListError, new Object[0]);
                                    } else if (!AgentUtil.isExclusiveLists((String)addFeatures, (String)removeFeatures)) {
                                        status /* !! */  = Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.Cmd_modify_duplicatedFeaturesError, new Object[0]);
                                    }
                                }
                                if (status /* !! */ .isOK()) {
                                    skipInstallMode = Agent.getInstance().isSkipInstall();
                                    status /* !! */  = this.run(CmdInputBuilder.getCommandList(), recordFile);
                                    if (!status /* !! */ .isOK() && (this.modify || this.rollback) && skipInstallMode && recordFile != null) {
                                        FileUtil.delete((File)new File(recordFile));
                                    }
                                }
                            }
                        }
                        if (logfile != null) {
                            new Input().recordLog(logfile, status /* !! */ );
                        }
                        if (!status /* !! */ .isOK()) {
                            retStatus.add(status /* !! */ );
                            this.reportError(status /* !! */ , null);
                            var18_26 = retStatus;
                            return var18_26;
                        }
                        break block66;
                    }
                    status /* !! */  = this.runAndReport(responseFile, logfile, CmdLine.CL.getParam1StrVal("-record"));
                    if (!status /* !! */ .isOK()) {
                        retStatus.add(status /* !! */ );
                        var18_27 = retStatus;
                        return var18_27;
                    }
                    break;
                }
                catch (Throwable e) {
                    status = Statuses.ERROR.get(e, com.ibm.cic.agent.internal.core.Messages.Unhandled_Exception_Detected, new Object[0]);
                    this.reportError((IStatus)status, null);
                    Agent.getLogger().status((IStatus)status);
                    retStatus.add((IStatus)status);
                    var18_28 = retStatus;
                    return var18_28;
                }
            }
            finally {
                if (this.agentDataDestinationFile == null) return var18_16;
                additionalFiles = null;
                if (CmdInputBuilder.getCommandList() == null) break block68;
                var24_59 = preferenceCommands = CmdInputBuilder.getCommandList().getPreferenceCommands();
                var23_74 = preferenceCommands.length;
                var22_89 = 0;
                ** while (var22_89 < var23_74)
            }
lbl-1000:
            // 1 sources

            {
                preferenceCommand = var24_59[var22_89];
                if (ICicPreferenceConstants.LOG_LOCATION.key().equals(preferenceCommand.getPreferenceName()) && preferenceCommand.getPreferenceValue() != null && !preferenceCommand.getPreferenceValue().isEmpty()) {
                    additionalFiles = new File[]{new File(preferenceCommand.getPreferenceValue())};
                }
                ++var22_89;
                continue;
            }
        }
        if ((exportStatus = AgentUtil.zipAgentAppDataWithAdditionalFiles((String)this.agentDataDestinationFile, additionalFiles, (IProgressMonitor)HeadlessUtils.createProgressMonitor())) == null) return var18_16;
        retStatus.add(exportStatus);
        return var18_16;
    }

    private IStatus run(String inputFile, File logfile, String recordFile) {
        Input input = new Input(logfile);
        CicMultiStatus status = Statuses.ST.createMultiStatus();
        status.add(input.load(inputFile));
        if (!StatusUtil.isError((IStatus)status)) {
            status.add(input.substituteVariables(CmdInputBuilder.getCommandList()));
        }
        if (!StatusUtil.isError((IStatus)status)) {
            status.add(this.run((IInput)input, recordFile));
        }
        if (logfile != null) {
            input.recordLog(logfile, (IStatus)status);
        }
        return status;
    }

    private IStatus runAndReport(String inputFile, File logfile, String recordFile) {
        IStatus status = this.run(inputFile, logfile, recordFile);
        this.printNotOKStatus(status);
        return status;
    }

    private IStatus purgeData() {
        return Agent.getInstance().purgeAgentData();
    }

    private IStatus purgeAll() {
        return Agent.getInstance().purgeAll(this.preservePrefs);
    }

    private IStatus updateAll() {
        CicMultiStatus status = Statuses.ST.createMultiStatus();
        Agent newAgent = Agent.getInstance();
        try {
            status.add(HeadlessApplication.initializeAgent(newAgent, null));
            if (!status.isOK()) {
                CicMultiStatus cicMultiStatus = status;
                return cicMultiStatus;
            }
            IUpdateAllCommand updateCommand = CommandFactory.createUpdateAllCommand();
            updateCommand.setAcceptLicense(CmdLine.CL.containsCommand("-acceptLicense"));
            status.add(updateCommand.execute(newAgent, HeadlessUtils.createProgressMonitor()));
        }
        finally {
            newAgent.stop();
        }
        return status;
    }

    private IStatus installAll() {
        CicMultiStatus status = Statuses.ST.createMultiStatus();
        Agent newAgent = Agent.getInstance();
        try {
            status.add(HeadlessApplication.initializeAgent(newAgent, null));
            if (!status.isOK()) {
                CicMultiStatus cicMultiStatus = status;
                return cicMultiStatus;
            }
            IInstallAllCommand installCommand = CommandFactory.createInstallAllCommand();
            installCommand.setAcceptLicense(CmdLine.CL.containsCommand("-acceptLicense"));
            status.add(installCommand.execute(newAgent, HeadlessUtils.createProgressMonitor()));
        }
        finally {
            newAgent.stop();
        }
        return status;
    }

    public IStatus run(IInput input, String recordFile) {
        CicMultiStatus status = Statuses.ST.createMultiStatus();
        boolean noPersist = false;
        boolean agentCreated = false;
        if (this.agent == null) {
            this.agent = Agent.getInstance();
            agentCreated = true;
        }
        try {
            if (status.getSeverity() != 4 && agentCreated) {
                status.add(HeadlessApplication.initializeAgent(this.agent, input, !this.purgeAgentAll && !this.purgeAgentData));
            }
            if (status.getSeverity() != 4) {
                if (this.purgeAgentAll) {
                    this.purgeAgentAll = false;
                    this.purgeAgentData = false;
                    status.add(this.agent.purgeAll(this.preservePrefs));
                    this.preservePrefs = false;
                    noPersist = true;
                } else if (this.purgeAgentData) {
                    this.purgeAgentData = false;
                    status.add(this.agent.purgeAgentData());
                    noPersist = true;
                }
            }
            if (status.getSeverity() != 4) {
                this.agent.setValidating(this.validate);
                if (recordFile != null) {
                    status.add(this.agent.setRecordMode(recordFile));
                }
                if (!input.isNewFormat()) {
                    status.add(input.executeCommands(this.agent, 12, HeadlessUtils.createProgressMonitor()));
                } else {
                    status.add(input.execute());
                }
                if (RebootRequest.shouldRebootNow()) {
                    if (CmdLine.CL.containsCommand("-showVerboseProgress")) {
                        this.reportInfo(com.ibm.cic.agent.internal.core.Messages.HeadlessApplication_rebootingNow);
                    }
                    PlatformUtils.reboot();
                } else if (RebootRequest.isSet()) {
                    this.reportInfo(com.ibm.cic.agent.internal.core.Messages.HeadlessApplication_needToReboot);
                }
            }
        }
        finally {
            if (agentCreated) {
                this.agent.stop(noPersist);
                this.agent = null;
            }
        }
        return status;
    }

    public static Agent createAgent(File inputFile) throws CoreException {
        Input input = new Input();
        input.load(inputFile);
        return HeadlessApplication.createAgent(input);
    }

    private static Agent createAgent(Input input) throws CoreException {
        Agent agent = Agent.getInstance();
        StatusUtil.throwIfError((IStatus)HeadlessApplication.initializeAgent(agent, input));
        return agent;
    }

    public static IStatus initializeAgent(Agent agent, IInput input, boolean startAgent) {
        if (input == null || !input.isNewFormat()) {
            return HeadlessApplication.initializeAgentOld(agent, input, startAgent);
        }
        return input.getResponse().initiallizeAgent(agent, startAgent);
    }

    private static IStatus initializeAgentOld(Agent agent, IInput input, boolean startAgent) {
        IStatus repositoryStatus;
        IStatus ret;
        CicMultiStatus status = Statuses.ST.createMultiStatus();
        agent.setSilentMode(true);
        agent.initializeAgentPreferences();
        if (input == null) {
            agent.setCleanTemporaryMode(false, false);
            CacheLocationManager.getInstance().setSettingCacheLocationByPreference(false);
        } else {
            agent.setCleanTemporaryMode(input.isCleanMode(), input.isTemporaryMode());
            if (input.isRebootLater()) {
                RebootRequest.setRebootLater();
            }
            if (!(ret = input.executeCommands(agent, 1, (IProgressMonitor)new NullProgressMonitor())).isOK()) {
                status.add(ret);
                if (status.matches(4)) {
                    return status;
                }
            }
            CacheLocationManager.getInstance().setSettingCacheLocationByPreference(input.isSettingEclipseCacheLocation());
        }
        if (startAgent) {
            ret = agent.start();
            if (!ret.isOK()) {
                status.add(ret);
                if (status.matches(4)) {
                    return status;
                }
            }
            if (input != null) {
                agent.logInputFile(input);
            }
            Agent.getLogger().statusNotOK(agent.unloadAgentBundles((IProgressMonitor)new NullProgressMonitor()));
            IStatus startupStatus = StartupManager.getInstance().runStartups(HeadlessUtils.createProgressMonitor());
            if (!startupStatus.isOK()) {
                Agent.getLogger().statusNotOK(startupStatus);
                status.add(startupStatus);
                if (status.matches(4)) {
                    return status;
                }
            }
            if (input != null && !(ret = input.executeCommands(agent, 2, (IProgressMonitor)new NullProgressMonitor())).isOK()) {
                status.add(ret);
                if (status.matches(4)) {
                    return status;
                }
            }
        }
        if ((input == null || input.needAccessRepositoris()) && (repositoryStatus = agent.getRepositoryGroupStatus(false, (IProgressMonitor)new NullProgressMonitor())) != null && !repositoryStatus.isOK() && repositoryStatus.matches(4)) {
            status.add((IStatus)Statuses.WARNING.get(com.ibm.cic.agent.internal.core.Messages.HeadlessApplication_Repositories_Not_Connected, new Object[]{repositoryStatus.getMessage()}));
            HeadlessUtils.addSpecificDisplayStatus((CicMultiStatus)status, (IStatus)repositoryStatus);
        }
        return status;
    }

    private static IStatus initializeAgent(Agent agent, Input input) {
        return HeadlessApplication.initializeAgent(agent, (IInput)input, true);
    }

    public Agent getAgent() {
        return this.agent;
    }

    public void setAgent(Agent agent) {
        this.agent = agent;
    }

    private void printNotOKStatus(IStatus a_status) {
        if (StatusUtil.isErrorOrWarning((IStatus)a_status)) {
            this.reportError(a_status, null);
        }
    }

    public ConsoleManagerService getConsoleManager() {
        if (this.consoleManagerService == null) {
            if (this.bundleContext == null) {
                this.bundleContext = Activator.getBundleContext();
            }
            if (this.bundleContext == null) {
                return null;
            }
            ServiceReference ref = this.bundleContext.getServiceReference(ConsoleManagerService.class.getName());
            if (ref != null) {
                this.consoleManagerService = (ConsoleManagerService)this.bundleContext.getService(ref);
            }
        }
        return this.consoleManagerService;
    }

    @Override
    protected int promptForDataLocation() {
        ConsoleManagerService consoleManager = this.getConsoleManager();
        if (consoleManager == null) {
            ICicStatus status = Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.ConsoleManager_ServiceNotFound, new Object[0]);
            this.reportError((IStatus)status, null);
            return 1;
        }
        return consoleManager.promptForDataLocation();
    }

    public static class HeadlessApplicationException
    extends CoreException {
        private static final long serialVersionUID = 8842555060411044814L;

        public HeadlessApplicationException(String msg) {
            this((IStatus)new Status(4, Agent.PI_AGENT, 0, msg, null));
        }

        public HeadlessApplicationException(IStatus status) {
            super(status);
        }
    }
}

