/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.application;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentInstall;
import com.ibm.cic.agent.core.AgentRegistry;
import com.ibm.cic.agent.core.AgentSettings;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.BitModeUtils;
import com.ibm.cic.agent.core.cmd.CmdInputBuilder;
import com.ibm.cic.agent.core.cmd.CmdLine;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.auth.AuthorizationInfo;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.utils.StatusFormatter;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.logging.UidUtil;
import java.io.File;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Version;

public abstract class AAgentApplication
implements IApplication {
    private static final String INDENT = "  ";

    public void stop() {
    }

    protected void reportError(IStatus a_status, String message) {
        this.printErrorOrWarning(a_status, message, 0);
    }

    protected void reportInfo(String message) {
        this.printMessage(message, 0, null, 1);
    }

    private void printMessage(String message, int indent, String uid, int severity) {
        StringBuffer output = new StringBuffer();
        int i = 0;
        while (i < indent) {
            output.append(INDENT);
            ++i;
        }
        String indentStr = output.toString();
        if (uid != null) {
            output.append(uid);
            output.append(" ");
        }
        output.append(message.replaceAll("\n(?= *\\S)", "\n" + indentStr));
        if (severity == 4 || severity == 8) {
            System.err.println(output);
        } else {
            Agent.getInstance().getStdoutBuffer().appendNTnl(output.toString());
        }
    }

    private void printErrorOrWarning(IStatus status, String message, int indent) {
        if (!StatusUtil.isErrorOrWarning((IStatus)status)) {
            return;
        }
        if (message != null) {
            this.printMessage(message, indent++, null, 4);
        }
        String uid = UidUtil.getUid((IStatus)status);
        if (!status.getMessage().isEmpty()) {
            String formatted = new StatusFormatter().omitUid(true).format(status);
            if (status.getSeverity() == 4) {
                this.printMessage(NLS.bind((String)Messages.MessageError, (Object)formatted), indent, uid, status.getSeverity());
            } else if (status.getSeverity() == 2) {
                this.printMessage(NLS.bind((String)Messages.MessageWarning, (Object)formatted), indent, uid, status.getSeverity());
            }
            ++indent;
        }
        IStatus[] iStatusArray = status.getChildren();
        int n = iStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus child = iStatusArray[n2];
            this.printErrorOrWarning(child, null, indent);
            ++n2;
        }
    }

    protected IStatus processCommonCommandLineArguments() {
        File file;
        String keyRingFilePath;
        IStatus keyringStatus;
        IStatus return_value = null;
        return_value = CmdLine.CL.processHelpCommand();
        if (return_value != null) {
            if (return_value.isOK()) {
                this.reportInfo(return_value.getMessage());
            } else {
                this.reportError(return_value, return_value.getMessage());
            }
            return return_value;
        }
        String value = CmdLine.CL.getParam1StrVal("-accessRights");
        CicCommonSettings.setAccessRightsMode((String)value);
        if (Agent.getInstance().dataLocationPromptRequired()) {
            int dataLocationStatus = this.promptForDataLocation();
            if (dataLocationStatus != 0) {
                return Status.OK_STATUS;
            }
        } else {
            IStatus dataLocationStatus = AgentUtil.validateAndSetDataLocation();
            if (StatusUtil.isErrorOrCancel((IStatus)dataLocationStatus)) {
                this.reportError(dataLocationStatus, dataLocationStatus.getMessage());
                return dataLocationStatus;
            }
        }
        if (!(keyringStatus = AuthorizationInfo.determineKeyringMechanism((CmdLine.CL.isInteractiveMode() || CmdLine.CL.shouldPrompt() ? 1 : 0) != 0)).isOK()) {
            this.reportError(keyringStatus, keyringStatus.getMessage());
            if (keyringStatus.getSeverity() == 4) {
                return keyringStatus;
            }
        }
        if (AuthorizationInfo.isLegacyKeyringActive() && (keyRingFilePath = CmdLine.CL.getParam1StrVal("-keyring")) != null && !(file = new File(keyRingFilePath)).isAbsolute()) {
            return_value = Statuses.ERROR.get(Messages.Agent_keyringPathRelative, new Object[0]);
            this.reportError(return_value, null);
            return return_value;
        }
        if (CmdLine.CL.containsCommand("version")) {
            StringBuffer sb = new StringBuffer();
            if (AgentInstall.getInstance().isAgentInstallerRunning()) {
                Version installerVersion = AgentInstall.getInstance().getInstallerVersion();
                Version installerInternalVersion = AgentInstall.getInstance().getInstallerInternalVersion();
                this.appendVersionAndArchitecture(sb, installerVersion, installerInternalVersion, Messages.Agent_IK_Version_Architecture_Msg, Messages.Agent_IK_Version_Msg, BitModeUtils.is64bitIM());
            } else if (AgentInstall.getInstance().isIMLiteRunning()) {
                this.appendVersionAndArchitecture(sb, AgentSettings.getRunningAgentVersion(), AgentSettings.getRunningAgentInternalVersion(), Messages.Agent_Lite_Version_Architecture_Msg, Messages.Agent_Lite_Version_Msg, BitModeUtils.is64bitIM());
            }
            boolean installed = AgentInstall.getInstance().isAgentInstalled();
            if (installed) {
                Version installedVersion = AgentInstall.getInstance().getInstalledAgentVersion();
                Version installedInternalVersion = AgentInstall.getInstance().getInstalledAgentInternalVersion();
                this.appendVersionAndArchitecture(sb, installedVersion, installedInternalVersion, Messages.Agent_Version_Architecture_Msg, Messages.Agent_Version_Msg, AgentRegistry.getInstance().isInstalledAgent64Bit());
            } else {
                sb.append(Messages.Agent_NotInstalled_Msg);
            }
            this.reportInfo(sb.toString());
            return_value = Status.OK_STATUS;
            return return_value;
        }
        CmdInputBuilder.generateInputCommandList();
        return return_value;
    }

    protected abstract int promptForDataLocation();

    private void appendVersionAndArchitecture(StringBuffer sb, Version version, Version internalVersion, String versionArchMsg, String versionMsg, boolean is64bit) {
        if (BitModeUtils.isMultiBitModePlatform()) {
            int bits = is64bit ? 64 : 32;
            sb.append(NLS.bind((String)versionArchMsg, (Object[])new Object[]{version, internalVersion, BitModeUtils.getBitModeText((int)bits)}));
        } else {
            sb.append(NLS.bind((String)versionMsg, (Object)version, (Object)internalVersion));
        }
    }
}

