/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zertjsse;

import com.ibm.zertjsse.Debug;
import com.ibm.zertjsse.Role;
import com.ibm.zertjsse.ZERTCertificateUtils;
import com.ibm.zertjsse.ZERTCipherInformation;
import com.ibm.zertjsse.ZERTInputStream;
import com.ibm.zertjsse.ZERTOutputStream;
import com.ibm.zos.net.SiocSSecattr;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;

class ZERTSSLSocketImpl
extends SSLSocket {
    private static Debug debug = Debug.getInstance("zertjsse");
    private static final String className = "com.ibm.zertjsse.ZERTSSLSocketImpl";
    private SSLSocket sslSocket = null;
    private Socket socket = null;
    private Field sslSessionField = null;
    private boolean initialHandshakeCompleted = false;
    private SiocSSecattr.Status zERTStatus = SiocSSecattr.Status.SECATTR_DISABLED;

    public ZERTSSLSocketImpl(SSLSocket sSLSocket) {
        this(sSLSocket, null);
    }

    public ZERTSSLSocketImpl(SSLSocket sSLSocket, Socket socket) {
        String string = "ZERTSSLSocketImpl";
        if (debug != null) {
            Debug.traceEntry(debug, className, string, sSLSocket, socket);
        }
        if (debug != null) {
            SiocSSecattr.getLogger().setLevel(Level.INFO);
        } else {
            SiocSSecattr.getLogger().setLevel(Level.OFF);
        }
        this.sslSocket = sSLSocket;
        this.socket = socket;
        this.queryzERT();
        this.initSSLSessionField();
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSSLSessionField() {
        String string = "initSSLSessionField";
        if (debug != null) {
            Debug.traceEntry(debug, className, string);
        }
        ArrayList<Exception> arrayList = new ArrayList<Exception>();
        Field[] fieldArray = this.sslSocket.getClass().getDeclaredFields();
        for (Field field : fieldArray) {
            boolean bl = false;
            try {
                Object object;
                if (Modifier.isPrivate(field.getModifiers()) || Modifier.isFinal(field.getModifiers())) {
                    field.setAccessible(true);
                    bl = true;
                }
                if ((object = field.get(this.sslSocket)) == null || !(object instanceof SSLSession)) continue;
                this.setSSLSessionField(field);
                break;
            }
            catch (Exception exception) {
                arrayList.add(exception);
            }
            finally {
                try {
                    if (bl) {
                        field.setAccessible(false);
                    }
                }
                catch (Exception exception) {}
            }
        }
        if (this.getSSLSessionField() == null) {
            if (debug != null) {
                Debug.traceText(debug, className, string, "We were unable to instantiate the sslSessionField. Here are the exceptions that we encountered:");
            }
            for (Exception exception : arrayList) {
                if (debug == null) continue;
                Debug.traceException(debug, className, string, exception);
            }
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    private Field getSSLSessionField() {
        String string = "getSSLSessionField";
        if (debug != null) {
            Debug.traceEntry(debug, className, string);
            Debug.traceExit(debug, className, string, this.sslSessionField);
        }
        return this.sslSessionField;
    }

    private void setSSLSessionField(Field field) {
        String string = "setSSLSessionField";
        if (debug != null) {
            Debug.traceEntry(debug, className, string, field);
        }
        this.sslSessionField = field;
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    protected synchronized boolean getInitialHandshakeCompleted() {
        String string = "getInitialHandshakeCompleted";
        if (debug != null) {
            Debug.traceEntry(debug, className, string);
            Debug.traceExit(debug, className, string, this.initialHandshakeCompleted);
        }
        return this.initialHandshakeCompleted;
    }

    protected synchronized void setInitialHandshakeCompleted(boolean bl) {
        String string = "setInitialHandshakeCompleted";
        if (debug != null) {
            Debug.traceEntry(debug, className, string, bl);
        }
        this.initialHandshakeCompleted = bl;
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    protected SiocSSecattr.Status getzERTStatus() {
        String string = "getzERTStatus";
        if (debug != null) {
            Debug.traceEntry(debug, className, string);
            Debug.traceExit(debug, className, string, this.zERTStatus);
        }
        return this.zERTStatus;
    }

    protected void setzERTStatus(SiocSSecattr.Status status) {
        String string = "setzERTStatus";
        if (debug != null) {
            Debug.traceEntry(debug, className, string, status);
        }
        this.zERTStatus = status;
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    @Override
    public synchronized void addHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        String string = "addHandshakeCompletedListener";
        if (debug != null) {
            Debug.traceEntry(debug, className, string, handshakeCompletedListener);
        }
        try {
            this.sslSocket.addHandshakeCompletedListener(handshakeCompletedListener);
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    @Override
    public synchronized String[] getEnabledCipherSuites() {
        String string = "getEnabledCipherSuites";
        if (debug != null) {
            Debug.traceEntry(debug, className, string);
        }
        String[] stringArray = null;
        try {
            stringArray = this.sslSocket.getEnabledCipherSuites();
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string, stringArray);
        }
        return stringArray;
    }

    @Override
    public synchronized String[] getEnabledProtocols() {
        String string = "getEnabledProtocols";
        if (debug != null) {
            Debug.traceEntry(debug, className, string);
        }
        String[] stringArray = null;
        try {
            stringArray = this.sslSocket.getEnabledProtocols();
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string, stringArray);
        }
        return stringArray;
    }

    @Override
    public synchronized boolean getEnableSessionCreation() {
        String string = "getEnableSessionCreation";
        if (debug != null) {
            Debug.traceEntry(debug, className, string);
        }
        boolean bl = false;
        try {
            bl = this.sslSocket.getEnableSessionCreation();
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string, bl);
        }
        return bl;
    }

    @Override
    public synchronized SSLSession getHandshakeSession() {
        String string = "getHandshakeSession";
        if (debug != null) {
            Debug.traceEntry(debug, className, string);
        }
        SSLSession sSLSession = null;
        try {
            sSLSession = this.sslSocket.getHandshakeSession();
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string, sSLSession);
        }
        return sSLSession;
    }

    @Override
    public synchronized boolean getNeedClientAuth() {
        String string = "getNeedClientAuth";
        if (debug != null) {
            Debug.traceEntry(debug, className, string);
        }
        boolean bl = false;
        try {
            bl = this.sslSocket.getNeedClientAuth();
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string, bl);
        }
        return bl;
    }

    @Override
    public SSLSession getSession() {
        String string = "getSession";
        if (debug != null) {
            Debug.traceEntry(debug, className, string);
        }
        SSLSession sSLSession = null;
        try {
            sSLSession = this.sslSocket.getSession();
            if (sSLSession.equals("SSL_NULL_WITH_NULL_NULL")) {
                this.notifyzERTInitialHandshakeFailure();
            }
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        this.notifyzERTHandshakePossible();
        if (debug != null) {
            Debug.traceExit(debug, className, string, sSLSession);
        }
        return sSLSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SSLSession getSessionZERT() {
        String string = "getSessionZERT";
        if (debug != null) {
            Debug.traceEntry(debug, className, string);
        }
        SSLSession sSLSession = null;
        boolean bl = false;
        Field field = this.getSSLSessionField();
        if (field == null) {
            if (debug != null) {
                Debug.traceText(debug, className, string, "We were unable to get an SSLSession because the sslSessionField was not initialized. This is most likely a security issue.");
                Debug.traceExit(debug, className, string, sSLSession);
            }
            return sSLSession;
        }
        try {
            if (Modifier.isPrivate(field.getModifiers()) || Modifier.isFinal(field.getModifiers())) {
                field.setAccessible(true);
                bl = true;
            }
            field.setAccessible(true);
            sSLSession = (SSLSession)field.get(this.sslSocket);
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceText(debug, className, string, "We were unable to get an SSLSession via reflection. This is most likely a security issue.");
                Debug.traceException(debug, className, string, exception);
            }
        }
        finally {
            if (bl) {
                try {
                    field.setAccessible(false);
                }
                catch (Exception exception) {}
            }
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string, sSLSession);
        }
        return sSLSession;
    }

    @Override
    public String[] getSupportedCipherSuites() {
        String string = "getSupportedCipherSuites";
        if (debug != null) {
            Debug.traceEntry(debug, className, string);
        }
        String[] stringArray = null;
        try {
            stringArray = this.sslSocket.getSupportedCipherSuites();
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string, stringArray);
        }
        return stringArray;
    }

    @Override
    public String[] getSupportedProtocols() {
        String string = "getSupportedProtocols";
        if (debug != null) {
            Debug.traceEntry(debug, className, string);
        }
        String[] stringArray = null;
        try {
            stringArray = this.sslSocket.getSupportedProtocols();
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string, stringArray);
        }
        return stringArray;
    }

    @Override
    public synchronized boolean getUseClientMode() {
        String string = "getUseClientMode";
        if (debug != null) {
            Debug.traceEntry(debug, className, string);
        }
        boolean bl = false;
        try {
            bl = this.sslSocket.getUseClientMode();
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string, bl);
        }
        return bl;
    }

    @Override
    public synchronized boolean getWantClientAuth() {
        String string = "getWantClientAuth";
        if (debug != null) {
            Debug.traceEntry(debug, className, string);
        }
        boolean bl = false;
        try {
            bl = this.sslSocket.getWantClientAuth();
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string, bl);
        }
        return bl;
    }

    @Override
    public synchronized void removeHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        String string = "removeHandshakeCompletedListener";
        if (debug != null) {
            Debug.traceEntry(debug, className, string, handshakeCompletedListener);
        }
        try {
            this.sslSocket.removeHandshakeCompletedListener(handshakeCompletedListener);
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    @Override
    public synchronized void setEnabledCipherSuites(String[] stringArray) {
        String string = "setEnabledCipherSuites";
        if (debug != null) {
            Debug.traceEntry(debug, className, string, stringArray);
        }
        try {
            this.sslSocket.setEnabledCipherSuites(stringArray);
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    @Override
    public synchronized void setEnabledProtocols(String[] stringArray) {
        String string = "setEnabledProtocols";
        if (debug != null) {
            Debug.traceEntry(debug, className, string, stringArray);
        }
        try {
            this.sslSocket.setEnabledProtocols(stringArray);
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    @Override
    public synchronized void setEnableSessionCreation(boolean bl) {
        String string = "setEnableSessionCreation";
        if (debug != null) {
            Debug.traceEntry(debug, className, string, bl);
        }
        try {
            this.sslSocket.setEnableSessionCreation(bl);
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    @Override
    public synchronized void setNeedClientAuth(boolean bl) {
        String string = "setNeedClientAuth";
        if (debug != null) {
            Debug.traceEntry(debug, className, string, bl);
        }
        try {
            this.sslSocket.setNeedClientAuth(bl);
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    @Override
    public synchronized void setUseClientMode(boolean bl) {
        String string = "setUseClientMode";
        if (debug != null) {
            Debug.traceEntry(debug, className, string, bl);
        }
        try {
            this.sslSocket.setUseClientMode(bl);
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    @Override
    public synchronized void setWantClientAuth(boolean bl) {
        String string = "setWantClientAuth";
        if (debug != null) {
            Debug.traceEntry(debug, className, string, bl);
        }
        try {
            this.sslSocket.setWantClientAuth(bl);
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    @Override
    public void startHandshake() throws IOException {
        String string = "startHandshake";
        if (debug != null) {
            Debug.traceEntry(debug, className, string);
        }
        try {
            this.sslSocket.startHandshake();
        }
        catch (InterruptedIOException interruptedIOException) {
            if (debug != null) {
                Debug.traceException(debug, className, string, interruptedIOException);
                Debug.traceExit(debug, className, string);
            }
            throw interruptedIOException;
        }
        catch (IOException iOException) {
            if (debug != null) {
                Debug.traceException(debug, className, string, iOException);
            }
            this.notifyzERTFailure();
            if (debug != null) {
                Debug.traceExit(debug, className, string);
            }
            throw iOException;
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        this.notifyzERTHandshakePossible();
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    @Override
    public synchronized SSLParameters getSSLParameters() {
        String string = "getSSLParameters";
        if (debug != null) {
            Debug.traceEntry(debug, className, string);
        }
        SSLParameters sSLParameters = null;
        try {
            sSLParameters = this.sslSocket.getSSLParameters();
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string, sSLParameters);
        }
        return sSLParameters;
    }

    @Override
    public synchronized void setSSLParameters(SSLParameters sSLParameters) throws IllegalArgumentException {
        String string = "setSSLParameters";
        if (debug != null) {
            Debug.traceEntry(debug, className, string, sSLParameters);
        }
        try {
            this.sslSocket.setSSLParameters(sSLParameters);
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    @Override
    public void bind(SocketAddress socketAddress) throws IOException {
        String string = "bind";
        if (debug != null) {
            Debug.traceEntry(debug, className, string, socketAddress);
        }
        try {
            this.sslSocket.bind(socketAddress);
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    @Override
    public void close() throws IOException {
        String string = "close";
        if (debug != null) {
            Debug.traceEntry(debug, className, string);
        }
        try {
            this.notifyzERTTermination();
            this.sslSocket.close();
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    @Override
    public void connect(SocketAddress socketAddress) throws IOException {
        String string = "connect";
        if (debug != null) {
            Debug.traceEntry(debug, className, string, socketAddress);
        }
        try {
            this.sslSocket.connect(socketAddress);
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    @Override
    public void connect(SocketAddress socketAddress, int n) throws IOException {
        String string = "connect";
        if (debug != null) {
            Debug.traceEntry(debug, className, string, socketAddress, n);
        }
        try {
            this.sslSocket.connect(socketAddress, n);
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    @Override
    public SocketChannel getChannel() {
        String string = "getChannel";
        if (debug != null) {
            Debug.traceEntry(debug, className, string);
        }
        SocketChannel socketChannel = null;
        try {
            socketChannel = this.sslSocket.getChannel();
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string, socketChannel);
        }
        return socketChannel;
    }

    @Override
    public InetAddress getInetAddress() {
        String string = "getInetAddress";
        if (debug != null) {
            Debug.traceEntry(debug, className, string);
        }
        InetAddress inetAddress = null;
        try {
            inetAddress = this.sslSocket.getInetAddress();
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string, inetAddress);
        }
        return inetAddress;
    }

    @Override
    public synchronized InputStream getInputStream() throws IOException {
        String string = "getInputStream";
        if (debug != null) {
            Debug.traceEntry(debug, className, string);
        }
        ZERTInputStream zERTInputStream = null;
        try {
            zERTInputStream = new ZERTInputStream(this.sslSocket.getInputStream(), this);
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string, zERTInputStream);
        }
        return zERTInputStream;
    }

    @Override
    public boolean getKeepAlive() throws SocketException {
        String string = "getKeepAlive";
        if (debug != null) {
            Debug.traceEntry(debug, className, string);
        }
        boolean bl = false;
        try {
            bl = this.sslSocket.getKeepAlive();
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string, bl);
        }
        return bl;
    }

    @Override
    public InetAddress getLocalAddress() {
        String string = "getLocalAddress";
        if (debug != null) {
            Debug.traceEntry(debug, className, string);
        }
        InetAddress inetAddress = null;
        try {
            inetAddress = this.sslSocket.getLocalAddress();
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string, inetAddress);
        }
        return inetAddress;
    }

    @Override
    public int getLocalPort() {
        String string = "getLocalPort";
        if (debug != null) {
            Debug.traceEntry(debug, className, string);
        }
        int n = 0;
        try {
            n = this.sslSocket.getLocalPort();
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string, n);
        }
        return n;
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        String string = "getLocalSocketAddress";
        if (debug != null) {
            Debug.traceEntry(debug, className, string);
        }
        SocketAddress socketAddress = null;
        try {
            socketAddress = this.sslSocket.getLocalSocketAddress();
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string, socketAddress);
        }
        return socketAddress;
    }

    @Override
    public boolean getOOBInline() throws SocketException {
        String string = "getOOBInline";
        if (debug != null) {
            Debug.traceEntry(debug, className, string);
        }
        boolean bl = false;
        try {
            bl = this.sslSocket.getOOBInline();
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string, bl);
        }
        return bl;
    }

    @Override
    public synchronized OutputStream getOutputStream() throws IOException {
        String string = "getOutputStream";
        if (debug != null) {
            Debug.traceEntry(debug, className, string);
        }
        ZERTOutputStream zERTOutputStream = null;
        try {
            zERTOutputStream = new ZERTOutputStream(this.sslSocket.getOutputStream(), this);
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string, zERTOutputStream);
        }
        return zERTOutputStream;
    }

    @Override
    public int getPort() {
        String string = "getPort";
        if (debug != null) {
            Debug.traceEntry(debug, className, string);
        }
        int n = 0;
        try {
            n = this.sslSocket.getPort();
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string, n);
        }
        return n;
    }

    @Override
    public int getReceiveBufferSize() throws SocketException {
        String string = "getReceiveBufferSize";
        if (debug != null) {
            Debug.traceEntry(debug, className, string);
        }
        int n = 0;
        try {
            n = this.sslSocket.getReceiveBufferSize();
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string, n);
        }
        return n;
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        String string = "getRemoteSocketAddress";
        if (debug != null) {
            Debug.traceEntry(debug, className, string);
        }
        SocketAddress socketAddress = null;
        try {
            socketAddress = this.sslSocket.getRemoteSocketAddress();
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string, socketAddress);
        }
        return socketAddress;
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        String string = "getReuseAddress";
        if (debug != null) {
            Debug.traceEntry(debug, className, string);
        }
        boolean bl = false;
        try {
            bl = this.sslSocket.getReuseAddress();
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string, bl);
        }
        return bl;
    }

    @Override
    public int getSendBufferSize() throws SocketException {
        String string = "getSendBufferSize";
        if (debug != null) {
            Debug.traceEntry(debug, className, string);
        }
        int n = 0;
        try {
            n = this.sslSocket.getSendBufferSize();
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string, n);
        }
        return n;
    }

    @Override
    public int getSoLinger() throws SocketException {
        String string = "getSoLinger";
        if (debug != null) {
            Debug.traceEntry(debug, className, string);
        }
        int n = 0;
        try {
            n = this.sslSocket.getSoLinger();
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string, n);
        }
        return n;
    }

    @Override
    public int getSoTimeout() throws SocketException {
        String string = "getSoTimeout";
        if (debug != null) {
            Debug.traceEntry(debug, className, string);
        }
        int n = 0;
        try {
            n = this.sslSocket.getSoTimeout();
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string, n);
        }
        return n;
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        String string = "getTcpNoDelay";
        if (debug != null) {
            Debug.traceEntry(debug, className, string);
        }
        boolean bl = false;
        try {
            bl = this.sslSocket.getTcpNoDelay();
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string, bl);
        }
        return bl;
    }

    @Override
    public int getTrafficClass() throws SocketException {
        String string = "getTrafficClass";
        if (debug != null) {
            Debug.traceEntry(debug, className, string);
        }
        int n = 0;
        try {
            n = this.sslSocket.getTrafficClass();
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string, n);
        }
        return n;
    }

    @Override
    public boolean isBound() {
        String string = "isBound";
        if (debug != null) {
            Debug.traceEntry(debug, className, string);
        }
        boolean bl = false;
        try {
            bl = this.sslSocket.isBound();
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string, bl);
        }
        return bl;
    }

    @Override
    public boolean isClosed() {
        String string = "isClosed";
        if (debug != null) {
            Debug.traceEntry(debug, className, string);
        }
        boolean bl = false;
        try {
            bl = this.sslSocket.isClosed();
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string, bl);
        }
        return bl;
    }

    @Override
    public boolean isConnected() {
        String string = "isConnected";
        if (debug != null) {
            Debug.traceEntry(debug, className, string);
        }
        boolean bl = false;
        try {
            bl = this.sslSocket.isConnected();
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string, bl);
        }
        return bl;
    }

    @Override
    public boolean isInputShutdown() {
        String string = "isInputShutdown";
        if (debug != null) {
            Debug.traceEntry(debug, className, string);
        }
        boolean bl = false;
        try {
            bl = this.sslSocket.isInputShutdown();
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string, bl);
        }
        return bl;
    }

    @Override
    public boolean isOutputShutdown() {
        String string = "isOutputShutdown";
        if (debug != null) {
            Debug.traceEntry(debug, className, string);
        }
        boolean bl = false;
        try {
            bl = this.sslSocket.isOutputShutdown();
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string, bl);
        }
        return bl;
    }

    @Override
    public void sendUrgentData(int n) throws IOException {
        String string = "sendUrgentData";
        if (debug != null) {
            Debug.traceEntry(debug, className, string, n);
        }
        try {
            this.sslSocket.sendUrgentData(n);
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    @Override
    public void setKeepAlive(boolean bl) throws SocketException {
        String string = "setKeepAlive";
        if (debug != null) {
            Debug.traceEntry(debug, className, string, bl);
        }
        try {
            this.sslSocket.setKeepAlive(bl);
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    @Override
    public void setOOBInline(boolean bl) throws SocketException {
        String string = "setOOBInline";
        if (debug != null) {
            Debug.traceEntry(debug, className, string, bl);
        }
        try {
            this.sslSocket.setOOBInline(bl);
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    @Override
    public void setPerformancePreferences(int n, int n2, int n3) {
        String string = "setPerformancePreferences";
        if (debug != null) {
            Debug.traceEntry(debug, className, string + n3);
        }
        try {
            this.sslSocket.setPerformancePreferences(n, n2, n3);
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    @Override
    public void setReceiveBufferSize(int n) throws SocketException {
        String string = "setReceiveBufferSize";
        if (debug != null) {
            Debug.traceEntry(debug, className, string, n);
        }
        try {
            this.sslSocket.setReceiveBufferSize(n);
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    @Override
    public void setReuseAddress(boolean bl) throws SocketException {
        String string = "setReuseAddress";
        if (debug != null) {
            Debug.traceEntry(debug, className, string, bl);
        }
        try {
            this.sslSocket.setReuseAddress(bl);
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    @Override
    public void setSendBufferSize(int n) throws SocketException {
        String string = "setSendBufferSize";
        if (debug != null) {
            Debug.traceEntry(debug, className, string, n);
        }
        try {
            this.sslSocket.setSendBufferSize(n);
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    @Override
    public void setSoLinger(boolean bl, int n) throws SocketException {
        String string = "setSoLinger";
        if (debug != null) {
            Debug.traceEntry(debug, className, string, bl, n);
        }
        try {
            this.sslSocket.setSoLinger(bl, n);
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    @Override
    public void setSoTimeout(int n) throws SocketException {
        String string = "setSoTimeout";
        if (debug != null) {
            Debug.traceEntry(debug, className, string, n);
        }
        try {
            this.sslSocket.setSoTimeout(n);
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    @Override
    public void setTcpNoDelay(boolean bl) throws SocketException {
        String string = "setTcpNoDelay";
        if (debug != null) {
            Debug.traceEntry(debug, className, string, bl);
        }
        try {
            this.sslSocket.setTcpNoDelay(bl);
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    @Override
    public void setTrafficClass(int n) throws SocketException {
        String string = "setTrafficClass";
        if (debug != null) {
            Debug.traceEntry(debug, className, string, n);
        }
        try {
            this.sslSocket.setTrafficClass(n);
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    @Override
    public void shutdownInput() throws IOException {
        String string = "shutdownInput";
        if (debug != null) {
            Debug.traceEntry(debug, className, string);
        }
        try {
            this.sslSocket.shutdownInput();
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    @Override
    public void shutdownOutput() throws IOException {
        String string = "shutdownOutput";
        if (debug != null) {
            Debug.traceEntry(debug, className, string);
        }
        try {
            this.sslSocket.shutdownOutput();
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    private int sendzERT(SiocSSecattr siocSSecattr) {
        String string = "sendzERT";
        if (debug != null) {
            Debug.traceEntry(debug, className, string, siocSSecattr);
        }
        int n = -1;
        if (this.socket != null) {
            if (debug != null) {
                Debug.traceText(debug, className, string, "Underlying Socket is not null.  We must have a layered SSLSocket, so we will send the underlying Socket to zERT");
            }
            n = siocSSecattr.send(this.socket);
        } else {
            if (debug != null) {
                Debug.traceText(debug, className, string, "Underlying Socket is null.  We must have a non-layered SSLSocket, so we will send the underlying SSLSocket to zERT");
            }
            n = siocSSecattr.send((Socket)this.sslSocket);
        }
        if (n != 0) {
            if (debug != null) {
                Debug.traceText(debug, className, string, "SiocSSecattr.send(SSLSocket) was unsuccessful, rc: " + n);
            }
        } else if (debug != null) {
            Debug.traceText(debug, className, string, "Notified zERT successfully");
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string, n);
        }
        return n;
    }

    protected void queryzERT() {
        String string;
        block7: {
            string = "queryzERT";
            if (debug != null) {
                Debug.traceEntry(debug, className, string);
            }
            try {
                SiocSSecattr siocSSecattr;
                int n;
                if (debug != null) {
                    Debug.traceText(debug, className, string, "Querying zERT");
                }
                if ((n = this.sendzERT(siocSSecattr = new SiocSSecattr(SiocSSecattr.EventType.SECATTR_QUERY))) == 0) {
                    SiocSSecattr.Status status = siocSSecattr.getSecattriStatus();
                    if (debug != null) {
                        Debug.traceText(debug, className, string, "Queried zERT successfully: " + status);
                    }
                    this.setzERTStatus(status);
                }
            }
            catch (Exception exception) {
                if (debug == null) break block7;
                Debug.traceText(debug, className, string, "Unable to query zERT, zERT will remain disabled");
                Debug.traceException(debug, className, string, exception);
            }
        }
        if (debug != null) {
            Debug.traceText(debug, className, string, "zERTEnabled: " + this.getzERTStatus());
            Debug.traceExit(debug, className, string);
        }
    }

    protected synchronized void notifyzERTHandshakePossible() {
        boolean bl;
        String string = "notifyzERTHandshakePossible";
        if (debug != null) {
            Debug.traceEntry(debug, className, string);
        }
        if (!(bl = this.getInitialHandshakeCompleted())) {
            this.setInitialHandshakeCompleted(true);
            this.notifyzERTInitialHandshake();
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    protected synchronized void notifyzERTInitialHandshake() {
        String string;
        block9: {
            string = "notifyzERTInitialHandshake";
            if (debug != null) {
                Debug.traceEntry(debug, className, string);
            }
            try {
                SiocSSecattr.Status status = this.getzERTStatus();
                if (status.equals((Object)SiocSSecattr.Status.SECATTR_DISABLED)) {
                    if (debug != null) {
                        Debug.traceText(debug, className, string, "zERT is disabled, skipping the notification");
                        Debug.traceExit(debug, className, string);
                    }
                    return;
                }
                SSLSession sSLSession = this.getSessionZERT();
                if (sSLSession == null) {
                    if (debug != null) {
                        Debug.traceText(debug, className, string, "Unable to obtain SSLSession, skipping the notification");
                        Debug.traceExit(debug, className, string);
                    }
                    return;
                }
                SiocSSecattr siocSSecattr = new SiocSSecattr(SiocSSecattr.EventType.SECATTR_INITIALIZATION);
                this.addZERTInformation(siocSSecattr, sSLSession);
                if (debug != null) {
                    Debug.traceText(debug, className, string, "Notifying zERT");
                }
                this.sendzERT(siocSSecattr);
            }
            catch (Exception exception) {
                if (debug == null) break block9;
                Debug.traceText(debug, className, string, "Unable to notify zERT");
                Debug.traceException(debug, className, string, exception);
            }
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    protected void notifyzERTRenegotiation() {
        String string;
        block9: {
            string = "notifyzERTRenegotiation";
            if (debug != null) {
                Debug.traceEntry(debug, className, string);
            }
            try {
                SiocSSecattr.Status status = this.getzERTStatus();
                if (status.equals((Object)SiocSSecattr.Status.SECATTR_DISABLED)) {
                    if (debug != null) {
                        Debug.traceText(debug, className, string, "zERT is disabled, skipping the notification");
                        Debug.traceExit(debug, className, string);
                    }
                    return;
                }
                SSLSession sSLSession = this.getSessionZERT();
                if (sSLSession == null) {
                    if (debug != null) {
                        Debug.traceText(debug, className, string, "Unable to obtain SSLSession, skipping the notification");
                        Debug.traceExit(debug, className, string);
                    }
                    return;
                }
                SiocSSecattr siocSSecattr = new SiocSSecattr(SiocSSecattr.EventType.SECATTR_RENEGOTIATION);
                this.addZERTInformation(siocSSecattr, sSLSession);
                if (debug != null) {
                    Debug.traceText(debug, className, string, "Notifying zERT");
                }
                this.sendzERT(siocSSecattr);
            }
            catch (Exception exception) {
                if (debug == null) break block9;
                Debug.traceText(debug, className, string, "Unable to notify zERT");
                Debug.traceException(debug, className, string, exception);
            }
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    protected void notifyzERTFailure() {
        boolean bl;
        String string = "notifyzERTFailure";
        if (debug != null) {
            Debug.traceEntry(debug, className, string);
        }
        if (bl = this.getInitialHandshakeCompleted()) {
            this.notifyzERTTermination();
        } else {
            this.notifyzERTInitialHandshakeFailure();
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    protected void notifyzERTTermination() {
        String string;
        block7: {
            string = "notifyzERTTermination";
            if (debug != null) {
                Debug.traceEntry(debug, className, string);
            }
            try {
                SiocSSecattr.Status status = this.getzERTStatus();
                if (status.equals((Object)SiocSSecattr.Status.SECATTR_DISABLED)) {
                    if (debug != null) {
                        Debug.traceText(debug, className, string, "zERT is disabled, skipping the notification");
                        Debug.traceExit(debug, className, string);
                    }
                    return;
                }
                SiocSSecattr siocSSecattr = new SiocSSecattr(SiocSSecattr.EventType.SECATTR_TERMINATION);
                if (debug != null) {
                    Debug.traceText(debug, className, string, "Notifying zERT");
                }
                this.sendzERT(siocSSecattr);
            }
            catch (Exception exception) {
                if (debug == null) break block7;
                Debug.traceText(debug, className, string, "Unable to notify zERT");
                Debug.traceException(debug, className, string, exception);
            }
        }
        this.setInitialHandshakeCompleted(false);
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    protected void notifyzERTInitialHandshakeFailure() {
        String string;
        block7: {
            string = "notifyzERTInitialHandshakeFailure";
            if (debug != null) {
                Debug.traceEntry(debug, className, string);
            }
            try {
                SiocSSecattr.Status status = this.getzERTStatus();
                if (status.equals((Object)SiocSSecattr.Status.SECATTR_DISABLED)) {
                    if (debug != null) {
                        Debug.traceText(debug, className, string, "zERT is disabled, skipping the notification");
                        Debug.traceExit(debug, className, string);
                    }
                    return;
                }
                SiocSSecattr siocSSecattr = new SiocSSecattr(SiocSSecattr.EventType.SECATTR_FAILURE);
                if (debug != null) {
                    Debug.traceText(debug, className, string, "Notifying zERT");
                }
                this.sendzERT(siocSSecattr);
            }
            catch (Exception exception) {
                if (debug == null) break block7;
                Debug.traceText(debug, className, string, "Unable to notify zERT");
                Debug.traceException(debug, className, string, exception);
            }
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    private void addZERTInformation(SiocSSecattr siocSSecattr, SSLSession sSLSession) {
        String string = "addZERTInformation";
        if (debug != null) {
            Debug.traceEntry(debug, className, string, siocSSecattr, sSLSession);
        }
        this.addProtocolProvider(siocSSecattr);
        this.addProtVer(siocSSecattr, sSLSession);
        this.addHandshakeRole(siocSSecattr, sSLSession);
        this.addCipherSuiteInformation(siocSSecattr, sSLSession);
        this.addFipsMode(siocSSecattr);
        this.addEncThenMac(siocSSecattr);
        this.addSessionID(siocSSecattr, sSLSession);
        this.addCertificateInformation(siocSSecattr, sSLSession);
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    private short getProtVer(SSLSession sSLSession) {
        int n;
        String string;
        block19: {
            string = "getProtVer";
            if (debug != null) {
                Debug.traceEntry(debug, className, string, sSLSession);
            }
            n = 0;
            try {
                String string2 = sSLSession.getProtocol();
                switch (string2.toUpperCase()) {
                    case "SSLV2": {
                        n = 512;
                        break;
                    }
                    case "SSLV3": {
                        n = 768;
                        break;
                    }
                    case "TLSV1": {
                        n = 769;
                        break;
                    }
                    case "TLSV1.1": {
                        n = 770;
                        break;
                    }
                    case "TLSV1.2": {
                        n = 771;
                        break;
                    }
                    default: {
                        if (debug != null) {
                            Debug.traceText(debug, className, string, "Protocol version not found, defaulting to unknown");
                        }
                        break;
                    }
                }
            }
            catch (Exception exception) {
                if (debug == null) break block19;
                Debug.traceText(debug, className, string, "Unable to obtain protocol version for zERT");
                Debug.traceException(debug, className, string, exception);
            }
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string, (short)n);
        }
        return (short)n;
    }

    private byte getHandshakeRole(SSLSession sSLSession) {
        byte by;
        String string;
        block4: {
            string = "getHandshakeRole";
            if (debug != null) {
                Debug.traceEntry(debug, className, string, sSLSession);
            }
            by = 0;
            try {
                by = this.getUseClientMode() ? (byte)1 : (this.getPeerAuth(sSLSession) ? (byte)3 : 2);
            }
            catch (Exception exception) {
                if (debug == null) break block4;
                Debug.traceText(debug, className, string, "Unable to obtain handshake role for zERT");
                Debug.traceException(debug, className, string, exception);
            }
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string, by);
        }
        return by;
    }

    private boolean getPeerAuth(SSLSession sSLSession) {
        boolean bl;
        String string;
        block6: {
            string = "getPeerAuth";
            if (debug != null) {
                Debug.traceEntry(debug, className, string, sSLSession);
            }
            bl = false;
            try {
                sSLSession.getPeerCertificates();
                bl = true;
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                if (debug != null) {
                    Debug.traceText(debug, className, string, "No peer certificate information available for zERT, peer was not authenticated");
                }
            }
            catch (Exception exception) {
                if (debug == null) break block6;
                Debug.traceText(debug, className, string, "Error when trying to obtain peer certificate information for zERT");
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string, bl);
            }
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string, bl);
        }
        return bl;
    }

    private String getNegCipher(SSLSession sSLSession) {
        String string;
        String string2;
        block4: {
            string2 = "getNegCipher";
            if (debug != null) {
                Debug.traceEntry(debug, className, string2, sSLSession);
            }
            string = "";
            try {
                string = sSLSession.getCipherSuite();
            }
            catch (Exception exception) {
                if (debug == null) break block4;
                Debug.traceText(debug, className, string2, "Unable to obtain negotiated cipher suite for zERT");
                Debug.traceException(debug, className, string2, exception);
            }
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string2, string);
        }
        return string;
    }

    private ZERTCipherInformation getCipherSuiteInformation(SSLSession sSLSession) {
        ZERTCipherInformation zERTCipherInformation;
        String string;
        block4: {
            string = "getCipherSuiteInformation";
            if (debug != null) {
                Debug.traceEntry(debug, className, string, sSLSession);
            }
            zERTCipherInformation = new ZERTCipherInformation();
            try {
                String string2 = this.getNegCipher(sSLSession);
                zERTCipherInformation = new ZERTCipherInformation(string2);
            }
            catch (Exception exception) {
                if (debug == null) break block4;
                Debug.traceText(debug, className, string, "Unable to obtain negotiated cipher suite information for zERT");
                Debug.traceException(debug, className, string, exception);
            }
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string, zERTCipherInformation);
        }
        return zERTCipherInformation;
    }

    private byte[] getSessionID(SSLSession sSLSession) {
        byte[] byArray;
        String string;
        block4: {
            string = "getSessionID";
            if (debug != null) {
                Debug.traceEntry(debug, className, string, sSLSession);
            }
            byArray = null;
            try {
                byArray = sSLSession.getId();
            }
            catch (Exception exception) {
                if (debug == null) break block4;
                Debug.traceText(debug, className, string, "Unable to obtain session ID for zERT");
                Debug.traceException(debug, className, string, exception);
            }
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string, byArray);
        }
        return byArray;
    }

    private void addProtocolProvider(SiocSSecattr siocSSecattr) {
        String string;
        block6: {
            string = "addProtocolProvider";
            if (debug != null) {
                Debug.traceEntry(debug, className, string, siocSSecattr);
            }
            try {
                String string2 = "IBM JSSE";
                if (debug != null) {
                    Debug.traceText(debug, className, string, "Calling setSecattriProtocolProvider with secattriProtocolProvider: " + string2);
                }
                siocSSecattr.setSecattriProtocolProvider(string2);
                if (debug != null) {
                    Debug.traceText(debug, className, string, "Called setSecattriProtocolProvider successfully, ioctl: " + siocSSecattr);
                }
            }
            catch (Exception exception) {
                if (debug == null) break block6;
                Debug.traceText(debug, className, string, "Unable to send protocol provider to zERT");
                Debug.traceException(debug, className, string, exception);
            }
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    private void addProtVer(SiocSSecattr siocSSecattr, SSLSession sSLSession) {
        String string;
        block6: {
            string = "addProtVer";
            if (debug != null) {
                Debug.traceEntry(debug, className, string, siocSSecattr, sSLSession);
            }
            try {
                short s = this.getProtVer(sSLSession);
                if (debug != null) {
                    Debug.traceText(debug, className, string, "Calling setSecattriTlsProtVer with secattriTlsProtVer: " + s);
                }
                siocSSecattr.setSecattriTlsProtVer(Short.valueOf(s));
                if (debug != null) {
                    Debug.traceText(debug, className, string, "Called setSecattriTlsProtVer successfully, ioctl: " + siocSSecattr);
                }
            }
            catch (Exception exception) {
                if (debug == null) break block6;
                Debug.traceText(debug, className, string, "Unable to send protocol version to zERT");
                Debug.traceException(debug, className, string, exception);
            }
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    private void addHandshakeRole(SiocSSecattr siocSSecattr, SSLSession sSLSession) {
        String string;
        block6: {
            string = "addHandshakeRole";
            if (debug != null) {
                Debug.traceEntry(debug, className, string, siocSSecattr, sSLSession);
            }
            try {
                byte by = this.getHandshakeRole(sSLSession);
                if (debug != null) {
                    Debug.traceText(debug, className, string, "Calling setSecattriTlsHandshakeRole with secattriTlsHandshakeRole: " + by);
                }
                siocSSecattr.setSecattriTlsHandshakeRole(Byte.valueOf(by));
                if (debug != null) {
                    Debug.traceText(debug, className, string, "Called setSecattriTlsHandshakeRole successfully, ioctl: " + siocSSecattr);
                }
            }
            catch (Exception exception) {
                if (debug == null) break block6;
                Debug.traceText(debug, className, string, "Unable to send handshake role to zERT");
                Debug.traceException(debug, className, string, exception);
            }
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    private void addNegCipher(SiocSSecattr siocSSecattr, String string) {
        String string2;
        block6: {
            string2 = "addNegCipher";
            if (debug != null) {
                Debug.traceEntry(debug, className, string2, siocSSecattr, string);
            }
            try {
                if (debug != null) {
                    Debug.traceText(debug, className, string2, "Calling setSecattriTlsNegCipher with secattriTlsNegCipher: " + string);
                }
                siocSSecattr.setSecattriTlsNegCipher(string);
                if (debug != null) {
                    Debug.traceText(debug, className, string2, "Called setSecattriTlsNegCipher successfully, ioctl: " + siocSSecattr);
                }
            }
            catch (Exception exception) {
                if (debug == null) break block6;
                Debug.traceText(debug, className, string2, "Unable to send negotiated cipher suite to zERT");
                Debug.traceException(debug, className, string2, exception);
            }
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string2);
        }
    }

    private void addCSEncAlg(SiocSSecattr siocSSecattr, short s) {
        String string;
        block6: {
            string = "addCSEncAlg";
            if (debug != null) {
                Debug.traceEntry(debug, className, string, siocSSecattr, s);
            }
            try {
                if (debug != null) {
                    Debug.traceText(debug, className, string, "Calling setSecattriTlsCSEncAlg with secattriTlsCSEncAlg: " + s);
                }
                siocSSecattr.setSecattriTlsCSEncAlg(Short.valueOf(s));
                if (debug != null) {
                    Debug.traceText(debug, className, string, "Called setSecattriTlsCSEncAlg successfully, ioctl: " + siocSSecattr);
                }
            }
            catch (Exception exception) {
                if (debug == null) break block6;
                Debug.traceText(debug, className, string, "Unable to send encryption algorithm to zERT");
                Debug.traceException(debug, className, string, exception);
            }
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    private void addCSMsgAuth(SiocSSecattr siocSSecattr, short s) {
        String string;
        block6: {
            string = "addCSMsgAuth";
            if (debug != null) {
                Debug.traceEntry(debug, className, string, siocSSecattr, s);
            }
            try {
                if (debug != null) {
                    Debug.traceText(debug, className, string, "Calling setSecattriTlsCSMsgAuth with secattriTlsCSMsgAuth: " + s);
                }
                siocSSecattr.setSecattriTlsCSMsgAuth(Short.valueOf(s));
                if (debug != null) {
                    Debug.traceText(debug, className, string, "Called setSecattriTlsCSMsgAuth successfully, ioctl: " + siocSSecattr);
                }
            }
            catch (Exception exception) {
                if (debug == null) break block6;
                Debug.traceText(debug, className, string, "Unable to send message authentication algorithm to zERT");
                Debug.traceException(debug, className, string, exception);
            }
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    private void addCSKexAlg(SiocSSecattr siocSSecattr, short s) {
        String string;
        block6: {
            string = "addCSKexAlg";
            if (debug != null) {
                Debug.traceEntry(debug, className, string, siocSSecattr, s);
            }
            try {
                if (debug != null) {
                    Debug.traceText(debug, className, string, "Calling setSecattriTlsCSKexAlg with secattriTlsCSKexAlg: " + s);
                }
                siocSSecattr.setSecattriTlsCSKexAlg(Short.valueOf(s));
                if (debug != null) {
                    Debug.traceText(debug, className, string, "Called setSecattriTlsCSKexAlg successfully, ioctl: " + siocSSecattr);
                }
            }
            catch (Exception exception) {
                if (debug == null) break block6;
                Debug.traceText(debug, className, string, "Unable to send key encryption algorithm to zERT");
                Debug.traceException(debug, className, string, exception);
            }
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    private void addCipherSuiteInformation(SiocSSecattr siocSSecattr, SSLSession sSLSession) {
        String string;
        block4: {
            string = "addCipherSuiteInformation";
            if (debug != null) {
                Debug.traceEntry(debug, className, string, siocSSecattr, sSLSession);
            }
            try {
                ZERTCipherInformation zERTCipherInformation = this.getCipherSuiteInformation(sSLSession);
                this.addNegCipher(siocSSecattr, zERTCipherInformation.secattriTlsNegCipher);
                this.addCSEncAlg(siocSSecattr, zERTCipherInformation.secattriTlsCSEncAlg);
                this.addCSMsgAuth(siocSSecattr, zERTCipherInformation.secattriTlsCSMsgAuth);
                this.addCSKexAlg(siocSSecattr, zERTCipherInformation.secattriTlsCSKexAlg);
            }
            catch (Exception exception) {
                if (debug == null) break block4;
                Debug.traceText(debug, className, string, "Unable to send negotiated cipher suite information to zERT");
                Debug.traceException(debug, className, string, exception);
            }
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    private void addFipsMode(SiocSSecattr siocSSecattr) {
        String string;
        block6: {
            string = "addFipsMode";
            if (debug != null) {
                Debug.traceEntry(debug, className, string, siocSSecattr);
            }
            try {
                byte by = 0;
                if (debug != null) {
                    Debug.traceText(debug, className, string, "Calling setSecattriTlsFipsMode with secattriTlsFipsMode: " + by);
                }
                siocSSecattr.setSecattriTlsFipsMode(Byte.valueOf(by));
                if (debug != null) {
                    Debug.traceText(debug, className, string, "Called setSecattriTlsFipsMode successfully, ioctl: " + siocSSecattr);
                }
            }
            catch (Exception exception) {
                if (debug == null) break block6;
                Debug.traceText(debug, className, string, "Unable to send FIPS mode to zERT");
                Debug.traceException(debug, className, string, exception);
            }
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    private void addEncThenMac(SiocSSecattr siocSSecattr) {
        String string;
        block6: {
            string = "addEncThenMac";
            if (debug != null) {
                Debug.traceEntry(debug, className, string, siocSSecattr);
            }
            try {
                boolean bl = false;
                if (debug != null) {
                    Debug.traceText(debug, className, string, "Calling setSecattriTlsEncThenMac with secattriTlsEncThenMac: " + bl);
                }
                siocSSecattr.setSecattriTlsEncThenMac(Boolean.valueOf(bl));
                if (debug != null) {
                    Debug.traceText(debug, className, string, "Called setSecattriTlsEncThenMac successfully, ioctl: " + siocSSecattr);
                }
            }
            catch (Exception exception) {
                if (debug == null) break block6;
                Debug.traceText(debug, className, string, "Unable to send Encrypt-then-MAC flag to zERT");
                Debug.traceException(debug, className, string, exception);
            }
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    private void addSessionID(SiocSSecattr siocSSecattr, SSLSession sSLSession) {
        String string;
        block6: {
            string = "addSessionID";
            if (debug != null) {
                Debug.traceEntry(debug, className, string, siocSSecattr, sSLSession);
            }
            try {
                byte[] byArray = this.getSessionID(sSLSession);
                if (debug != null) {
                    Debug.traceText(debug, className, string, "Calling setSecattriTlsSessionID with secattriTlsSessionID: " + byArray);
                }
                siocSSecattr.setSecattriTlsSessionID(byArray);
                if (debug != null) {
                    Debug.traceText(debug, className, string, "Called setSecattriTlsSessionID successfully, ioctl: " + siocSSecattr);
                }
            }
            catch (Exception exception) {
                if (debug == null) break block6;
                Debug.traceText(debug, className, string, "Unable to send session ID to zERT");
                Debug.traceException(debug, className, string, exception);
            }
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    private void addCertificateInformation(SiocSSecattr siocSSecattr, SSLSession sSLSession) {
        String string = "addCertificateInformation";
        if (debug != null) {
            Debug.traceEntry(debug, className, string, siocSSecattr, sSLSession);
        }
        boolean bl = this.getUseClientMode();
        SiocSSecattr.Status status = this.getzERTStatus();
        if (bl) {
            if (debug != null) {
                Debug.traceText(debug, className, string, "Using local certificates for client certificates and peer certificates for server certificates");
            }
            this.addCertificateInformation(siocSSecattr, sSLSession, status, Role.CLIENT, Role.SERVER);
        } else {
            if (debug != null) {
                Debug.traceText(debug, className, string, "Using local certificates for server certificates and peer certificates for client certificates");
            }
            this.addCertificateInformation(siocSSecattr, sSLSession, status, Role.SERVER, Role.CLIENT);
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    private void addCertificateInformation(SiocSSecattr siocSSecattr, SSLSession sSLSession, SiocSSecattr.Status status, Role role, Role role2) {
        block8: {
            Certificate[] certificateArray;
            String string;
            block7: {
                string = "addCertificateInformation";
                if (debug != null) {
                    Debug.traceEntry(debug, className, string, siocSSecattr, "session: " + sSLSession + ", status: " + status + ", localRole: " + role + ", peerRole: " + role2);
                }
                try {
                    certificateArray = sSLSession.getLocalCertificates();
                    this.addCertificateInformation(siocSSecattr, certificateArray, status, role);
                }
                catch (Exception exception) {
                    if (debug == null) break block7;
                    Debug.traceText(debug, className, string, "Unable to obtain local certificate information for zERT");
                    Debug.traceException(debug, className, string, exception);
                }
            }
            try {
                certificateArray = sSLSession.getPeerCertificates();
                this.addCertificateInformation(siocSSecattr, certificateArray, status, role2);
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                if (debug != null) {
                    Debug.traceText(debug, className, string, "No peer certificate information available for zERT");
                }
                ZERTCertificateUtils.addNULLCertificateInformation(siocSSecattr, role2);
            }
            catch (Exception exception) {
                if (debug == null) break block8;
                Debug.traceText(debug, className, string, "Unable to obtain peer certificate information for zERT");
                Debug.traceException(debug, className, string, exception);
            }
        }
    }

    private void addCertificateInformation(SiocSSecattr siocSSecattr, Certificate[] certificateArray, SiocSSecattr.Status status, Role role) {
        String string = "addCertificateInformation";
        if (debug != null) {
            Debug.traceEntry(debug, className, string, siocSSecattr, "certificates: " + certificateArray + ", status: " + status + ", role: " + role);
        }
        try {
            if (certificateArray != null) {
                Certificate certificate = certificateArray[0];
                X509Certificate x509Certificate = (X509Certificate)certificate;
                ZERTCertificateUtils.addCertificateInformation(siocSSecattr, x509Certificate, status, role);
            } else {
                ZERTCertificateUtils.addNULLCertificateInformation(siocSSecattr, role);
            }
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    @Override
    public String toString() {
        return this.sslSocket.toString();
    }
}

