/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zertjsse;

import com.ibm.zertjsse.Debug;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.interfaces.DHPublicKey;

class ZERTPublicKeyInformation {
    private static Debug debug = Debug.getInstance("zertjsse");
    private static final String className = "com.ibm.zertjsse.ZERTPublicKeyInformation";
    protected short secattriTlsCertKeyType;
    protected short secattriTlsCertKeyLen;

    protected ZERTPublicKeyInformation() {
        this.secattriTlsCertKeyType = 0;
        this.secattriTlsCertKeyLen = 0;
        String string = "ZERTPublicKeyInformation";
        if (debug != null) {
            Debug.traceEntry(debug, className, string);
            Debug.traceExit(debug, className, string);
        }
    }

    protected ZERTPublicKeyInformation(PublicKey publicKey) {
        String string;
        block13: {
            this.secattriTlsCertKeyType = 0;
            this.secattriTlsCertKeyLen = 0;
            string = "ZERTPublicKeyInformation";
            if (debug != null) {
                Debug.traceEntry(debug, className, string, publicKey);
            }
            try {
                if (publicKey instanceof RSAPublicKey) {
                    RSAPublicKey rSAPublicKey = (RSAPublicKey)publicKey;
                    this.secattriTlsCertKeyType = (short)2;
                    this.secattriTlsCertKeyLen = (short)rSAPublicKey.getModulus().bitLength();
                } else if (publicKey instanceof DSAPublicKey) {
                    DSAPublicKey dSAPublicKey = (DSAPublicKey)publicKey;
                    this.secattriTlsCertKeyType = (short)3;
                    this.secattriTlsCertKeyLen = (short)dSAPublicKey.getParams().getP().bitLength();
                } else if (publicKey instanceof DHPublicKey) {
                    DHPublicKey dHPublicKey = (DHPublicKey)publicKey;
                    this.secattriTlsCertKeyType = (short)4;
                    this.secattriTlsCertKeyLen = (short)dHPublicKey.getParams().getP().bitLength();
                } else if (publicKey instanceof ECPublicKey) {
                    ECPublicKey eCPublicKey = (ECPublicKey)publicKey;
                    this.secattriTlsCertKeyType = (short)5;
                    this.secattriTlsCertKeyLen = (short)eCPublicKey.getParams().getOrder().bitLength();
                } else if (debug != null) {
                    Debug.traceText(debug, className, string, "Unable to find public key type for zERT, using default unknown values");
                }
            }
            catch (Exception exception) {
                if (debug == null) break block13;
                Debug.traceText(debug, className, string, "There was an issue trying to obtain public key information for zERT");
                Debug.traceException(debug, className, string, exception);
            }
        }
        if (debug != null) {
            Debug.traceText(debug, className, string, "secattriTlsCertKeyType: " + this.secattriTlsCertKeyType + ", secattriTlsCertKeyLen: " + this.secattriTlsCertKeyLen);
            Debug.traceExit(debug, className, string);
        }
    }
}

