/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zertjsse;

import com.ibm.zertjsse.Debug;
import com.ibm.zertjsse.ZERTSSLSocketImpl;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;

class ZERTOutputStream
extends OutputStream {
    private static Debug debug = Debug.getInstance("zertjsse");
    private static final String className = "com.ibm.zertjsse.ZERTOutputStream";
    private OutputStream oStream;
    private ZERTSSLSocketImpl socket;

    public ZERTOutputStream(OutputStream outputStream, ZERTSSLSocketImpl zERTSSLSocketImpl) {
        String string = "ZERTOutputStream";
        if (debug != null) {
            Debug.traceEntry(debug, className, string, outputStream, zERTSSLSocketImpl);
        }
        this.oStream = outputStream;
        this.socket = zERTSSLSocketImpl;
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    @Override
    public void write(int n) throws IOException {
        String string = "write";
        if (debug != null) {
            Debug.traceEntry(debug, className, string, n);
        }
        try {
            this.oStream.write(n);
        }
        catch (InterruptedIOException interruptedIOException) {
            if (debug != null) {
                Debug.traceException(debug, className, string, interruptedIOException);
                Debug.traceExit(debug, className, string);
            }
            throw interruptedIOException;
        }
        catch (IOException iOException) {
            if (debug != null) {
                Debug.traceException(debug, className, string, iOException);
            }
            this.socket.notifyzERTFailure();
            if (debug != null) {
                Debug.traceExit(debug, className, string);
            }
            throw iOException;
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        this.socket.notifyzERTHandshakePossible();
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        String string = "write";
        if (debug != null) {
            Debug.traceEntry(debug, className, string, (Object)byArray);
        }
        try {
            this.oStream.write(byArray);
        }
        catch (InterruptedIOException interruptedIOException) {
            if (debug != null) {
                Debug.traceException(debug, className, string, interruptedIOException);
                Debug.traceExit(debug, className, string);
            }
            throw interruptedIOException;
        }
        catch (IOException iOException) {
            if (debug != null) {
                Debug.traceException(debug, className, string, iOException);
            }
            this.socket.notifyzERTFailure();
            if (debug != null) {
                Debug.traceExit(debug, className, string);
            }
            throw iOException;
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        this.socket.notifyzERTHandshakePossible();
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        String string = "write";
        if (debug != null) {
            Debug.traceEntry(debug, className, string, "b: " + byArray + ", off: " + n + ", len: " + n2);
        }
        try {
            this.oStream.write(byArray, n, n2);
        }
        catch (InterruptedIOException interruptedIOException) {
            if (debug != null) {
                Debug.traceException(debug, className, string, interruptedIOException);
            }
            Debug.traceExit(debug, className, string);
            throw interruptedIOException;
        }
        catch (IOException iOException) {
            if (debug != null) {
                Debug.traceException(debug, className, string, iOException);
            }
            this.socket.notifyzERTFailure();
            if (debug != null) {
                Debug.traceExit(debug, className, string);
            }
            throw iOException;
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        this.socket.notifyzERTHandshakePossible();
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    @Override
    public void flush() throws IOException {
        String string = "flush";
        if (debug != null) {
            Debug.traceEntry(debug, className, string);
        }
        try {
            this.oStream.flush();
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    @Override
    public void close() throws IOException {
        String string = "close";
        if (debug != null) {
            Debug.traceEntry(debug, className, string);
        }
        try {
            this.socket.notifyzERTRenegotiation();
            this.oStream.close();
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        finally {
            this.socket.notifyzERTTermination();
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }
}

