/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zertjsse;

import com.ibm.zertjsse.Debug;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;

public final class ZERTJSSE
extends Provider {
    static final long serialVersionUID = -7704267969561265640L;
    private static String info = "ZERTJSSE Provider";
    private static Debug debug = Debug.getInstance("zertjsse");
    private static String className = "com.ibm.zertjsse.ZERTJSSE";
    static boolean register = true;
    static boolean disableSSLv3;
    static boolean convertSSLv3;
    static boolean useFIPSProvider;
    private static final String PROVIDER_VERSION;

    private static void initProperties() {
        String string = "initProperties";
        if (debug != null) {
            Debug.traceEntry(debug, className, string);
        }
        try {
            Class.forName("com.ibm.zos.net.SiocSSecattr");
        }
        catch (Error | Exception throwable) {
            register = false;
            if (debug != null) {
                Debug.traceText(debug, className, string, "Unable to load the zERT Java API, setting register to false");
                Debug.traceException(debug, className, string, throwable);
                Debug.traceExit(debug, className, string);
            }
            return;
        }
        if (debug != null) {
            Debug.traceText(debug, className, string, "Able to load the zERT Java API, setting register to true");
        }
        disableSSLv3 = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ZERTJSSE.getBooleanProperty("com.ibm.jsse2.disableSSLv3", true);
            }
        });
        if (debug != null) {
            Debug.traceText(debug, className, string, "disableSSLv3 set to " + disableSSLv3);
        }
        convertSSLv3 = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ZERTJSSE.getBooleanProperty("com.ibm.jsse2.convertSSLv3", false);
            }
        });
        if (debug != null) {
            Debug.traceText(debug, className, string, "convertSSLv3 set to " + convertSSLv3);
        }
        useFIPSProvider = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ZERTJSSE.getBooleanProperty("com.ibm.jsse2.usefipsprovider", false);
            }
        });
        if (debug != null) {
            Debug.traceText(debug, className, string, "useFIPSProvider set to " + useFIPSProvider);
            Debug.traceExit(debug, className, string);
        }
    }

    public ZERTJSSE() {
        super("ZERTJSSE", PROVIDER_VERSION, info);
        if (debug != null) {
            Debug.traceEntry(debug, className, "ZERTJSSE");
        }
        if (register) {
            if (debug != null) {
                Debug.traceText(debug, className, "ZERTJSSE", "register is true, registering for protocols");
            }
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ZERTJSSE.this.put("SSLContext.SSL", "com.ibm.zertjsse.ZERTSSLContextImplSSL");
                    if (convertSSLv3 || !disableSSLv3) {
                        if (debug != null) {
                            Debug.traceText(debug, className, "ZERTJSSE", "Registering for SSLv3");
                        }
                        ZERTJSSE.this.put("SSLContext.SSLv3", "com.ibm.zertjsse.ZERTSSLContextImplSSLv3");
                    } else if (debug != null) {
                        Debug.traceText(debug, className, "ZERTJSSE", "Not registering for SSLv3");
                    }
                    ZERTJSSE.this.put("SSLContext.TLS", "com.ibm.zertjsse.ZERTSSLContextImplTLS");
                    ZERTJSSE.this.put("SSLContext.TLSv1", "com.ibm.zertjsse.ZERTSSLContextImplTLSv10");
                    ZERTJSSE.this.put("SSLContext.TLSv1.1", "com.ibm.zertjsse.ZERTSSLContextImplTLSv11");
                    ZERTJSSE.this.put("SSLContext.TLSv1.2", "com.ibm.zertjsse.ZERTSSLContextImplTLSv12");
                    ZERTJSSE.this.put("SSLContext.TLSv1.3", "com.ibm.zertjsse.ZERTSSLContextImplTLSv13");
                    ZERTJSSE.this.put("SSLContext.SSL_TLS", "com.ibm.zertjsse.ZERTSSLContextImplSSL_TLS");
                    ZERTJSSE.this.put("SSLContext.SSL_TLSv2", "com.ibm.zertjsse.ZERTSSLContextImplSSL_TLSv2");
                    ZERTJSSE.this.put("SSLContext.Default", "com.ibm.zertjsse.ZERTDefaultSSLContextImpl");
                    return null;
                }
            });
        } else if (debug != null) {
            Debug.traceText(debug, className, "ZERTJSSE", "register is false, not registering for protocols");
        }
        if (debug != null) {
            Debug.traceExit(debug, className, "ZERTJSSE");
        }
    }

    protected static boolean getUseFIPSProvider() {
        String string = "getUseFIPSProvider";
        if (debug != null) {
            Debug.traceEntry(debug, className, string);
            Debug.traceExit(debug, className, string, useFIPSProvider);
        }
        return useFIPSProvider;
    }

    private static boolean getBooleanProperty(String string, boolean bl) {
        String string2 = "getBooleanProperty";
        if (debug != null) {
            Debug.traceEntry(debug, className, string2, string, bl);
        }
        final String string3 = string;
        boolean bl2 = false;
        String string4 = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(string3);
            }
        });
        if (string4 == null) {
            bl2 = bl;
            if (debug != null) {
                Debug.traceExit(debug, className, string2, bl2);
            }
            return bl2;
        }
        if (string4.equalsIgnoreCase("false")) {
            bl2 = false;
            if (debug != null) {
                Debug.traceExit(debug, className, string2, bl2);
            }
            return bl2;
        }
        if (string4.equalsIgnoreCase("true")) {
            bl2 = true;
            if (debug != null) {
                Debug.traceExit(debug, className, string2, bl2);
            }
            return bl2;
        }
        RuntimeException runtimeException = new RuntimeException("Value of " + string + " must either be 'true' or 'false'");
        if (debug != null) {
            Debug.traceException(debug, className, string2, runtimeException);
            Debug.traceExit(debug, className, string2);
        }
        throw runtimeException;
    }

    static {
        ZERTJSSE.initProperties();
        PROVIDER_VERSION = System.getProperty("java.specification.version");
    }
}

