/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zertjsse;

import com.ibm.zertjsse.Debug;
import com.ibm.zertjsse.ZERTSSLSocketImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;

class ZERTInputStream
extends InputStream {
    private static Debug debug = Debug.getInstance("zertjsse");
    private static final String className = "com.ibm.zertjsse.ZERTInputStream";
    private InputStream iStream;
    private ZERTSSLSocketImpl socket;

    public ZERTInputStream(InputStream inputStream, ZERTSSLSocketImpl zERTSSLSocketImpl) {
        String string = "ZERTInputStream";
        if (debug != null) {
            Debug.traceEntry(debug, className, string, inputStream, zERTSSLSocketImpl);
        }
        this.iStream = inputStream;
        this.socket = zERTSSLSocketImpl;
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    @Override
    public int read() throws IOException {
        String string = "read";
        if (debug != null) {
            Debug.traceEntry(debug, className, string);
        }
        int n = 0;
        try {
            n = this.iStream.read();
            if (n == -1) {
                this.socket.notifyzERTTermination();
            } else {
                this.socket.notifyzERTHandshakePossible();
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            if (debug != null) {
                Debug.traceException(debug, className, string, interruptedIOException);
                Debug.traceExit(debug, className, string);
            }
            throw interruptedIOException;
        }
        catch (IOException iOException) {
            if (debug != null) {
                Debug.traceException(debug, className, string, iOException);
            }
            this.socket.notifyzERTFailure();
            if (debug != null) {
                Debug.traceExit(debug, className, string);
            }
            throw iOException;
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string, n);
        }
        return n;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        String string = "read";
        if (debug != null) {
            Debug.traceEntry(debug, className, string, (Object)byArray);
        }
        int n = 0;
        try {
            n = this.iStream.read(byArray);
            if (n == -1) {
                this.socket.notifyzERTTermination();
            } else {
                this.socket.notifyzERTHandshakePossible();
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            if (debug != null) {
                Debug.traceException(debug, className, string, interruptedIOException);
                Debug.traceExit(debug, className, string);
            }
            throw interruptedIOException;
        }
        catch (IOException iOException) {
            if (debug != null) {
                Debug.traceException(debug, className, string, iOException);
            }
            this.socket.notifyzERTFailure();
            if (debug != null) {
                Debug.traceExit(debug, className, string);
            }
            throw iOException;
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string, n);
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        String string = "read";
        if (debug != null) {
            Debug.traceEntry(debug, className, string, "b: " + byArray + ", off: " + n + ", len: " + n2);
        }
        int n3 = 0;
        try {
            n3 = this.iStream.read(byArray, n, n2);
            if (n3 == -1) {
                this.socket.notifyzERTTermination();
            } else {
                this.socket.notifyzERTHandshakePossible();
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            if (debug != null) {
                Debug.traceException(debug, className, string, interruptedIOException);
                Debug.traceExit(debug, className, string);
            }
            throw interruptedIOException;
        }
        catch (IOException iOException) {
            if (debug != null) {
                Debug.traceException(debug, className, string, iOException);
            }
            this.socket.notifyzERTFailure();
            if (debug != null) {
                Debug.traceExit(debug, className, string);
            }
            throw iOException;
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string, n3);
        }
        return n3;
    }

    @Override
    public long skip(long l) throws IOException {
        String string = "skip";
        if (debug != null) {
            Debug.traceEntry(debug, className, string, l);
        }
        long l2 = 0L;
        try {
            l2 = this.iStream.skip(l);
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string, l2);
        }
        return l2;
    }

    @Override
    public int available() throws IOException {
        String string = "available";
        if (debug != null) {
            Debug.traceEntry(debug, className, string);
        }
        int n = 0;
        try {
            n = this.iStream.available();
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string, n);
        }
        return n;
    }

    @Override
    public void close() throws IOException {
        String string = "close";
        if (debug != null) {
            Debug.traceEntry(debug, className, string);
        }
        try {
            this.socket.notifyzERTRenegotiation();
            this.iStream.close();
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        finally {
            this.socket.notifyzERTTermination();
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    @Override
    public void mark(int n) {
        String string = "mark";
        if (debug != null) {
            Debug.traceEntry(debug, className, string, n);
        }
        try {
            this.iStream.mark(n);
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    @Override
    public void reset() throws IOException {
        String string = "reset";
        if (debug != null) {
            Debug.traceEntry(debug, className, string);
        }
        try {
            this.iStream.reset();
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    @Override
    public boolean markSupported() {
        String string = "markSupported";
        if (debug != null) {
            Debug.traceEntry(debug, className, string);
        }
        boolean bl = false;
        try {
            bl = this.iStream.markSupported();
        }
        catch (Exception exception) {
            if (debug != null) {
                Debug.traceException(debug, className, string, exception);
                Debug.traceExit(debug, className, string);
            }
            throw exception;
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string, bl);
        }
        return bl;
    }
}

