/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zertjsse;

import com.ibm.zertjsse.Debug;
import com.ibm.zertjsse.Role;
import com.ibm.zertjsse.ZERTPublicKeyInformation;
import com.ibm.zertjsse.ZERTSignatureInformation;
import com.ibm.zos.net.SiocSSecattr;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Date;

class ZERTCertificateUtils {
    private static Debug debug = Debug.getInstance("zertjsse");
    private static final String className = "com.ibm.zertjsse.ZERTCertificateUtils";

    ZERTCertificateUtils() {
    }

    protected static void addCertificateInformation(SiocSSecattr siocSSecattr, X509Certificate x509Certificate, SiocSSecattr.Status status, Role role) {
        String string;
        block8: {
            string = "addCertificateInformation";
            if (debug != null) {
                Debug.traceEntry(debug, className, string, "ioctl: " + siocSSecattr + ", cert: " + x509Certificate + ", status: " + status + ", role: " + role);
            }
            try {
                ZERTCertificateUtils.addCertSerial(siocSSecattr, x509Certificate, role);
                ZERTCertificateUtils.addCertSignatureInformation(siocSSecattr, x509Certificate, role);
                ZERTCertificateUtils.addCertTime(siocSSecattr, x509Certificate, role);
                ZERTCertificateUtils.addCertPublicKeyInformation(siocSSecattr, x509Certificate, role);
                ZERTCertificateUtils.addCertSdn(siocSSecattr, x509Certificate, role);
                ZERTCertificateUtils.addCertIdn(siocSSecattr, x509Certificate, role);
                if (status.equals((Object)SiocSSecattr.Status.SECATTR_ENABLED_CERT)) {
                    if (debug != null) {
                        Debug.traceText(debug, className, string, "zERT is enabled for sending complete certificates");
                    }
                    ZERTCertificateUtils.addCert(siocSSecattr, x509Certificate, role);
                } else if (debug != null) {
                    Debug.traceText(debug, className, string, "zERT is not enabled for sending complete certificates");
                }
            }
            catch (Exception exception) {
                if (debug == null) break block8;
                Debug.traceText(debug, className, string, "Unable to send certificate information to zERT");
                Debug.traceException(debug, className, string, exception);
            }
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    private static String getCertSerial(X509Certificate x509Certificate) {
        String string;
        String string2;
        block4: {
            string2 = "getCertSerial";
            if (debug != null) {
                Debug.traceEntry(debug, className, string2);
            }
            string = "";
            try {
                string = x509Certificate.getSerialNumber().toString();
            }
            catch (Exception exception) {
                if (debug == null) break block4;
                Debug.traceText(debug, className, string2, "Unable to obtain certificate serial number for zERT");
                Debug.traceException(debug, className, string2, exception);
            }
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string2, string);
        }
        return string;
    }

    private static ZERTSignatureInformation getCertSignatureInformation(X509Certificate x509Certificate) {
        ZERTSignatureInformation zERTSignatureInformation;
        String string;
        block4: {
            string = "getCertSignatureInformation";
            if (debug != null) {
                Debug.traceEntry(debug, className, string);
            }
            zERTSignatureInformation = new ZERTSignatureInformation();
            try {
                String string2 = x509Certificate.getSigAlgName();
                zERTSignatureInformation = new ZERTSignatureInformation(string2);
            }
            catch (Exception exception) {
                if (debug == null) break block4;
                Debug.traceText(debug, className, string, "Unable to obtain certificate signature information for zERT");
                Debug.traceException(debug, className, string, exception);
            }
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string, zERTSignatureInformation);
        }
        return zERTSignatureInformation;
    }

    private static Date getCertTime(X509Certificate x509Certificate) {
        Date date;
        String string;
        block4: {
            string = "getCertTime";
            if (debug != null) {
                Debug.traceEntry(debug, className, string);
            }
            date = null;
            try {
                date = x509Certificate.getNotAfter();
            }
            catch (Exception exception) {
                if (debug == null) break block4;
                Debug.traceText(debug, className, string, "Unable to obtain certificate not after date for zERT");
                Debug.traceException(debug, className, string, exception);
            }
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string, date);
        }
        return date;
    }

    private static ZERTPublicKeyInformation getCertPublicKeyInformation(X509Certificate x509Certificate) {
        ZERTPublicKeyInformation zERTPublicKeyInformation;
        String string;
        block4: {
            string = "getCertPublicKeyInformation";
            if (debug != null) {
                Debug.traceEntry(debug, className, string);
            }
            zERTPublicKeyInformation = new ZERTPublicKeyInformation();
            try {
                PublicKey publicKey = x509Certificate.getPublicKey();
                zERTPublicKeyInformation = new ZERTPublicKeyInformation(publicKey);
            }
            catch (Exception exception) {
                if (debug == null) break block4;
                Debug.traceText(debug, className, string, "Unable to obtain certificate public key information for zERT");
                Debug.traceException(debug, className, string, exception);
            }
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string, zERTPublicKeyInformation);
        }
        return zERTPublicKeyInformation;
    }

    private static String getCertSdn(X509Certificate x509Certificate) {
        String string;
        String string2;
        block4: {
            string2 = "getCertSdn";
            if (debug != null) {
                Debug.traceEntry(debug, className, string2);
            }
            string = "";
            try {
                string = x509Certificate.getSubjectDN().getName();
            }
            catch (Exception exception) {
                if (debug == null) break block4;
                Debug.traceText(debug, className, string2, "Unable to obtain subject distinguished name of certificate for zERT");
                Debug.traceException(debug, className, string2, exception);
            }
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string2, string);
        }
        return string;
    }

    private static String getCertIdn(X509Certificate x509Certificate) {
        String string;
        String string2;
        block4: {
            string2 = "getCertIdn";
            if (debug != null) {
                Debug.traceEntry(debug, className, string2);
            }
            string = "";
            try {
                string = x509Certificate.getIssuerDN().getName();
            }
            catch (Exception exception) {
                if (debug == null) break block4;
                Debug.traceText(debug, className, string2, "Unable to obtain issuer distinguished name of certificate for zERT");
                Debug.traceException(debug, className, string2, exception);
            }
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string2, string);
        }
        return string;
    }

    private static byte[] getCert(X509Certificate x509Certificate) {
        byte[] byArray;
        String string;
        block4: {
            string = "getCert";
            if (debug != null) {
                Debug.traceEntry(debug, className, string);
            }
            byArray = null;
            try {
                byArray = x509Certificate.getEncoded();
            }
            catch (Exception exception) {
                if (debug == null) break block4;
                Debug.traceText(debug, className, string, "Unable to obtain full certificate for zERT");
                Debug.traceException(debug, className, string, exception);
            }
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string, byArray);
        }
        return byArray;
    }

    private static void addCertSerial(SiocSSecattr siocSSecattr, X509Certificate x509Certificate, Role role) {
        String string;
        block9: {
            string = "addCertSerial";
            if (debug != null) {
                Debug.traceEntry(debug, className, string, siocSSecattr, (Object)role);
            }
            try {
                String string2 = ZERTCertificateUtils.getCertSerial(x509Certificate);
                if (debug != null) {
                    Debug.traceText(debug, className, string, "Calling setSecattriTlsXCertSerial with secattriTlsCertSerial: " + string2);
                }
                if (role.equals((Object)Role.CLIENT)) {
                    siocSSecattr.setSecattriTlsCCertSerial(string2);
                } else if (role.equals((Object)Role.SERVER)) {
                    siocSSecattr.setSecattriTlsSCertSerial(string2);
                }
                if (debug != null) {
                    Debug.traceText(debug, className, string, "Called setSecattriTlsXCertSerial successfully, ioctl: " + siocSSecattr);
                }
            }
            catch (Exception exception) {
                if (debug == null) break block9;
                Debug.traceText(debug, className, string, "Unable to send certificate serial to zERT");
                Debug.traceException(debug, className, string, exception);
            }
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    private static void addCertSignatureInformation(SiocSSecattr siocSSecattr, X509Certificate x509Certificate, Role role) {
        String string;
        block4: {
            string = "addCertSignatureInformation";
            if (debug != null) {
                Debug.traceEntry(debug, className, string, siocSSecattr, (Object)role);
            }
            try {
                ZERTSignatureInformation zERTSignatureInformation = ZERTCertificateUtils.getCertSignatureInformation(x509Certificate);
                ZERTCertificateUtils.addCertSignatureMethod(siocSSecattr, zERTSignatureInformation.secattriTlsCertSignatureMethod, role);
                ZERTCertificateUtils.addCertEncMethod(siocSSecattr, zERTSignatureInformation.secattriTlsCertEncMethod, role);
                ZERTCertificateUtils.addCertDigestAlg(siocSSecattr, zERTSignatureInformation.secattriTlsCertDigestAlg, role);
            }
            catch (Exception exception) {
                if (debug == null) break block4;
                Debug.traceText(debug, className, string, "Unable to send certificate signature information to zERT");
                Debug.traceException(debug, className, string, exception);
            }
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    private static void addCertSignatureMethod(SiocSSecattr siocSSecattr, short s, Role role) {
        String string;
        block9: {
            string = "addCertSignatureMethod";
            if (debug != null) {
                Debug.traceEntry(debug, className, string, "ioctl: " + siocSSecattr + ", secattriTlsCertSignatureMethod: " + s + ", role: " + role);
            }
            try {
                if (debug != null) {
                    Debug.traceText(debug, className, string, "Calling setSecattriTlsXCertSignatureMethod with secattriTlsCertSignatureMethod: " + s);
                }
                if (role.equals((Object)Role.CLIENT)) {
                    siocSSecattr.setSecattriTlsCCertSignatureMethod(Short.valueOf(s));
                } else if (role.equals((Object)Role.SERVER)) {
                    siocSSecattr.setSecattriTlsSCertSignatureMethod(Short.valueOf(s));
                }
                if (debug != null) {
                    Debug.traceText(debug, className, string, "Called setSecattriTlsXCertSignatureMethod successfully, ioctl: " + siocSSecattr);
                }
            }
            catch (Exception exception) {
                if (debug == null) break block9;
                Debug.traceText(debug, className, string, "Unable to send certificate signature method to zERT");
                Debug.traceException(debug, className, string, exception);
            }
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    private static void addCertEncMethod(SiocSSecattr siocSSecattr, short s, Role role) {
        String string;
        block9: {
            string = "addCertEncMethod";
            if (debug != null) {
                Debug.traceEntry(debug, className, string, "ioctl: " + siocSSecattr + ", secattriTlsCertEncMethod: " + s + ", role: " + role);
            }
            try {
                if (debug != null) {
                    Debug.traceText(debug, className, string, "Calling setSecattriTlsXCertEncMethod with secattriTlsCertEncMethod: " + s);
                }
                if (role.equals((Object)Role.CLIENT)) {
                    siocSSecattr.setSecattriTlsCCertEncMethod(Short.valueOf(s));
                } else if (role.equals((Object)Role.SERVER)) {
                    siocSSecattr.setSecattriTlsSCertEncMethod(Short.valueOf(s));
                }
                if (debug != null) {
                    Debug.traceText(debug, className, string, "Called setSecattriTlsXCertEncMethod successfully, ioctl: " + siocSSecattr);
                }
            }
            catch (Exception exception) {
                if (debug == null) break block9;
                Debug.traceText(debug, className, string, "Unable to send certificate encryption method to zERT");
                Debug.traceException(debug, className, string, exception);
            }
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    private static void addCertDigestAlg(SiocSSecattr siocSSecattr, short s, Role role) {
        String string;
        block9: {
            string = "addCertDigestAlg";
            if (debug != null) {
                Debug.traceEntry(debug, className, string, "ioctl: " + siocSSecattr + ", secattriTlsCertDigestAlg: " + s + ", role: " + role);
            }
            try {
                if (debug != null) {
                    Debug.traceText(debug, className, string, "Calling setSecattriTlsXCertDigestAlg with secattriTlsCertDigestAlg: " + s);
                }
                if (role.equals((Object)Role.CLIENT)) {
                    siocSSecattr.setSecattriTlsCCertDigestAlg(Short.valueOf(s));
                } else if (role.equals((Object)Role.SERVER)) {
                    siocSSecattr.setSecattriTlsSCertDigestAlg(Short.valueOf(s));
                }
                if (debug != null) {
                    Debug.traceText(debug, className, string, "Called setSecattriTlsXCertDigestAlg successfully, ioctl: " + siocSSecattr);
                }
            }
            catch (Exception exception) {
                if (debug == null) break block9;
                Debug.traceText(debug, className, string, "Unable to send certificate digest algorithm to zERT");
                Debug.traceException(debug, className, string, exception);
            }
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    private static void addCertTime(SiocSSecattr siocSSecattr, X509Certificate x509Certificate, Role role) {
        String string;
        block9: {
            string = "addCertTime";
            if (debug != null) {
                Debug.traceEntry(debug, className, string, siocSSecattr, (Object)role);
            }
            try {
                Date date = ZERTCertificateUtils.getCertTime(x509Certificate);
                if (debug != null) {
                    Debug.traceText(debug, className, string, "Calling setSecattriTlsXCertTime with secattriTlsCertTime: " + date);
                }
                if (role.equals((Object)Role.CLIENT)) {
                    siocSSecattr.setSecattriTlsCCertTime(date);
                } else if (role.equals((Object)Role.SERVER)) {
                    siocSSecattr.setSecattriTlsSCertTime(date);
                }
                if (debug != null) {
                    Debug.traceText(debug, className, string, "Called setSecattriTlsXCertTime successfully, ioctl: " + siocSSecattr);
                }
            }
            catch (Exception exception) {
                if (debug == null) break block9;
                Debug.traceText(debug, className, string, "Unable to send certificate not after date to zERT");
                Debug.traceException(debug, className, string, exception);
            }
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    private static void addCertKeyType(SiocSSecattr siocSSecattr, short s, Role role) {
        String string;
        block9: {
            string = "addCertKeyType";
            if (debug != null) {
                Debug.traceEntry(debug, className, string, "ioctl: " + siocSSecattr + ", secattriTlsCertKeyType: " + s + ", role: " + role);
            }
            try {
                if (debug != null) {
                    Debug.traceText(debug, className, string, "Calling setSecattriTlsXCertKeyType with secattriTlsCertKeyType: " + s);
                }
                if (role.equals((Object)Role.CLIENT)) {
                    siocSSecattr.setSecattriTlsCCertKeyType(Short.valueOf(s));
                } else if (role.equals((Object)Role.SERVER)) {
                    siocSSecattr.setSecattriTlsSCertKeyType(Short.valueOf(s));
                }
                if (debug != null) {
                    Debug.traceText(debug, className, string, "Called setSecattriTlsXCertKeyType successfully, ioctl: " + siocSSecattr);
                }
            }
            catch (Exception exception) {
                if (debug == null) break block9;
                Debug.traceText(debug, className, string, "Unable to send certificate key type to zERT");
                Debug.traceException(debug, className, string, exception);
            }
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    private static void addCertKeyLen(SiocSSecattr siocSSecattr, short s, Role role) {
        String string;
        block9: {
            string = "addCertKeyLen";
            if (debug != null) {
                Debug.traceEntry(debug, className, string, "ioctl: " + siocSSecattr + ", secattriTlsCertKeyLen: " + s + ", role: " + role);
            }
            try {
                if (debug != null) {
                    Debug.traceText(debug, className, string, "Calling setSecattriTlsXCertKeyLen with secattriTlsCertKeyLen: " + s);
                }
                if (role.equals((Object)Role.CLIENT)) {
                    siocSSecattr.setSecattriTlsCCertKeyLen(Short.valueOf(s));
                } else if (role.equals((Object)Role.SERVER)) {
                    siocSSecattr.setSecattriTlsSCertKeyLen(Short.valueOf(s));
                }
                if (debug != null) {
                    Debug.traceText(debug, className, string, "Called setSecattriTlsXCertKeyLen successfully, ioctl: " + siocSSecattr);
                }
            }
            catch (Exception exception) {
                if (debug == null) break block9;
                Debug.traceText(debug, className, string, "Unable to send certificate key length to zERT");
                Debug.traceException(debug, className, string, exception);
            }
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    private static void addCertPublicKeyInformation(SiocSSecattr siocSSecattr, X509Certificate x509Certificate, Role role) {
        String string;
        block4: {
            string = "addCertPublicKeyInformation";
            if (debug != null) {
                Debug.traceEntry(debug, className, string, siocSSecattr, (Object)role);
            }
            try {
                ZERTPublicKeyInformation zERTPublicKeyInformation = ZERTCertificateUtils.getCertPublicKeyInformation(x509Certificate);
                ZERTCertificateUtils.addCertKeyType(siocSSecattr, zERTPublicKeyInformation.secattriTlsCertKeyType, role);
                ZERTCertificateUtils.addCertKeyLen(siocSSecattr, zERTPublicKeyInformation.secattriTlsCertKeyLen, role);
            }
            catch (Exception exception) {
                if (debug == null) break block4;
                Debug.traceText(debug, className, string, "Unable to send certificate public key information to zERT");
                Debug.traceException(debug, className, string, exception);
            }
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    private static void addCertSdn(SiocSSecattr siocSSecattr, X509Certificate x509Certificate, Role role) {
        String string;
        block9: {
            string = "addCertSdn";
            if (debug != null) {
                Debug.traceEntry(debug, className, string, siocSSecattr, (Object)role);
            }
            try {
                String string2 = ZERTCertificateUtils.getCertSdn(x509Certificate);
                if (debug != null) {
                    Debug.traceText(debug, className, string, "Calling setSecattriTlsXCertSdn with secattriTlsCertSdn: " + string2);
                }
                if (role.equals((Object)Role.CLIENT)) {
                    siocSSecattr.setSecattriTlsCCertSdn(string2);
                } else if (role.equals((Object)Role.SERVER)) {
                    siocSSecattr.setSecattriTlsSCertSdn(string2);
                }
                if (debug != null) {
                    Debug.traceText(debug, className, string, "Called setSecattriTlsXCertSdn successfully, ioctl: " + siocSSecattr);
                }
            }
            catch (Exception exception) {
                if (debug == null) break block9;
                Debug.traceText(debug, className, string, "Unable to send subject distinguished name of certificate to zERT");
                Debug.traceException(debug, className, string, exception);
            }
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    private static void addCertIdn(SiocSSecattr siocSSecattr, X509Certificate x509Certificate, Role role) {
        String string;
        block9: {
            string = "addCertIdn";
            if (debug != null) {
                Debug.traceEntry(debug, className, string, siocSSecattr, (Object)role);
            }
            try {
                String string2 = ZERTCertificateUtils.getCertIdn(x509Certificate);
                if (debug != null) {
                    Debug.traceText(debug, className, string, "Calling setSecattriTlsXCertIdn with secattriTlsCertIdn: " + string2);
                }
                if (role.equals((Object)Role.CLIENT)) {
                    siocSSecattr.setSecattriTlsCCertIdn(string2);
                } else if (role.equals((Object)Role.SERVER)) {
                    siocSSecattr.setSecattriTlsSCertIdn(string2);
                }
                if (debug != null) {
                    Debug.traceText(debug, className, string, "Called setSecattriTlsXCertIdn successfully, ioctl: " + siocSSecattr);
                }
            }
            catch (Exception exception) {
                if (debug == null) break block9;
                Debug.traceText(debug, className, string, "Unable to send issuer distinguished name of certificate to zERT");
                Debug.traceException(debug, className, string, exception);
            }
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    private static void addCert(SiocSSecattr siocSSecattr, X509Certificate x509Certificate, Role role) {
        String string;
        block9: {
            string = "addCert";
            if (debug != null) {
                Debug.traceEntry(debug, className, string, siocSSecattr, (Object)role);
            }
            try {
                byte[] byArray = ZERTCertificateUtils.getCert(x509Certificate);
                if (debug != null) {
                    Debug.traceText(debug, className, string, "Calling setSecattriTlsXCert with secattriTlsCert: " + byArray);
                }
                if (role.equals((Object)Role.CLIENT)) {
                    siocSSecattr.setSecattriTlsCCert(byArray);
                } else if (role.equals((Object)Role.SERVER)) {
                    siocSSecattr.setSecattriTlsSCert(byArray);
                }
                if (debug != null) {
                    Debug.traceText(debug, className, string, "Called setSecattriTlsXCert successfully, ioctl: " + siocSSecattr);
                }
            }
            catch (Exception exception) {
                if (debug == null) break block9;
                Debug.traceText(debug, className, string, "Unable to send full certificate to zERT");
                Debug.traceException(debug, className, string, exception);
            }
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    protected static void addNULLCertificateInformation(SiocSSecattr siocSSecattr, Role role) {
        String string;
        block4: {
            string = "addCertificateInformation";
            if (debug != null) {
                Debug.traceEntry(debug, className, string, siocSSecattr, (Object)role);
            }
            try {
                ZERTCertificateUtils.addNULLSignatureInformation(siocSSecattr, role);
                ZERTCertificateUtils.addNULLKeyType(siocSSecattr, role);
            }
            catch (Exception exception) {
                if (debug == null) break block4;
                Debug.traceText(debug, className, string, "Unable to send certificate information to zERT");
                Debug.traceException(debug, className, string, exception);
            }
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    private static void addNULLSignatureInformation(SiocSSecattr siocSSecattr, Role role) {
        String string;
        block4: {
            string = "addNULLSignatureInformation";
            if (debug != null) {
                Debug.traceEntry(debug, className, string, siocSSecattr, (Object)role);
            }
            short s = 1;
            short s2 = 1;
            short s3 = 1;
            try {
                ZERTCertificateUtils.addNULLSignatureMethod(siocSSecattr, s, role);
                ZERTCertificateUtils.addNULLEncMethod(siocSSecattr, s2, role);
                ZERTCertificateUtils.addNULLDigestAlg(siocSSecattr, s3, role);
            }
            catch (Exception exception) {
                if (debug == null) break block4;
                Debug.traceText(debug, className, string, "Unable to send certificate signature information to zERT");
                Debug.traceException(debug, className, string, exception);
            }
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    private static void addNULLSignatureMethod(SiocSSecattr siocSSecattr, short s, Role role) {
        String string;
        block9: {
            string = "addNULLSignatureMethod";
            if (debug != null) {
                Debug.traceEntry(debug, className, string, "ioctl: " + siocSSecattr + ", secattriTlsCertSignatureMethod: " + s + ", role: " + role);
            }
            try {
                if (debug != null) {
                    Debug.traceText(debug, className, string, "Calling setSecattriTlsXCertSignatureMethod with secattriTlsCertSignatureMethod: " + s);
                }
                if (role.equals((Object)Role.CLIENT)) {
                    siocSSecattr.setSecattriTlsCCertSignatureMethod(Short.valueOf(s));
                } else if (role.equals((Object)Role.SERVER)) {
                    siocSSecattr.setSecattriTlsSCertSignatureMethod(Short.valueOf(s));
                }
                if (debug != null) {
                    Debug.traceText(debug, className, string, "Called setSecattriTlsXCertSignatureMethod successfully, ioctl: " + siocSSecattr);
                }
            }
            catch (Exception exception) {
                if (debug == null) break block9;
                Debug.traceText(debug, className, string, "Unable to send certificate signature method to zERT");
                Debug.traceException(debug, className, string, exception);
            }
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    private static void addNULLEncMethod(SiocSSecattr siocSSecattr, short s, Role role) {
        String string;
        block9: {
            string = "addNULLEncMethod";
            if (debug != null) {
                Debug.traceEntry(debug, className, string, "ioctl: " + siocSSecattr + ", secattriTlsCertEncMethod: " + s + ", role: " + role);
            }
            try {
                if (debug != null) {
                    Debug.traceText(debug, className, string, "Calling setSecattriTlsXCertEncMethod with secattriTlsCertEncMethod: " + s);
                }
                if (role.equals((Object)Role.CLIENT)) {
                    siocSSecattr.setSecattriTlsCCertEncMethod(Short.valueOf(s));
                } else if (role.equals((Object)Role.SERVER)) {
                    siocSSecattr.setSecattriTlsSCertEncMethod(Short.valueOf(s));
                }
                if (debug != null) {
                    Debug.traceText(debug, className, string, "Called setSecattriTlsXCertEncMethod successfully, ioctl: " + siocSSecattr);
                }
            }
            catch (Exception exception) {
                if (debug == null) break block9;
                Debug.traceText(debug, className, string, "Unable to send certificate encryption method to zERT");
                Debug.traceException(debug, className, string, exception);
            }
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    private static void addNULLDigestAlg(SiocSSecattr siocSSecattr, short s, Role role) {
        String string;
        block9: {
            string = "addNULLDigestAlg";
            if (debug != null) {
                Debug.traceEntry(debug, className, string, "ioctl: " + siocSSecattr + ", secattriTlsCertDigestAlg: " + s + ", role: " + role);
            }
            try {
                if (debug != null) {
                    Debug.traceText(debug, className, string, "Calling setSecattriTlsXCertDigestAlg with secattriTlsCertDigestAlg: " + s);
                }
                if (role.equals((Object)Role.CLIENT)) {
                    siocSSecattr.setSecattriTlsCCertDigestAlg(Short.valueOf(s));
                } else if (role.equals((Object)Role.SERVER)) {
                    siocSSecattr.setSecattriTlsSCertDigestAlg(Short.valueOf(s));
                }
                if (debug != null) {
                    Debug.traceText(debug, className, string, "Called setSecattriTlsXCertDigestAlg successfully, ioctl: " + siocSSecattr);
                }
            }
            catch (Exception exception) {
                if (debug == null) break block9;
                Debug.traceText(debug, className, string, "Unable to send certificate digest algorithm to zERT");
                Debug.traceException(debug, className, string, exception);
            }
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }

    private static void addNULLKeyType(SiocSSecattr siocSSecattr, Role role) {
        String string;
        block9: {
            string = "addNULLKeyType";
            if (debug != null) {
                Debug.traceEntry(debug, className, string, siocSSecattr, (Object)role);
            }
            short s = 1;
            try {
                if (debug != null) {
                    Debug.traceText(debug, className, string, "Calling setSecattriTlsXCertKeyType with secattriTlsCertKeyType: " + s);
                }
                if (role.equals((Object)Role.CLIENT)) {
                    siocSSecattr.setSecattriTlsCCertKeyType(Short.valueOf(s));
                } else if (role.equals((Object)Role.SERVER)) {
                    siocSSecattr.setSecattriTlsSCertKeyType(Short.valueOf(s));
                }
                if (debug != null) {
                    Debug.traceText(debug, className, string, "Called setSecattriTlsXCertKeyType successfully, ioctl: " + siocSSecattr);
                }
            }
            catch (Exception exception) {
                if (debug == null) break block9;
                Debug.traceText(debug, className, string, "Unable to send certificate key type to zERT");
                Debug.traceException(debug, className, string, exception);
            }
        }
        if (debug != null) {
            Debug.traceExit(debug, className, string);
        }
    }
}

