/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zertjsse;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class Debug {
    private String prefix;
    private static String args;
    private static Level specifiedLevel;
    private static Handler ch;
    private static Logger tl;
    public static final long TYPE_NONE = 0L;
    public static final long TYPE_ALL = -1L;
    public static final long TYPE_FINE;
    public static final long TYPE_FINER;
    public static final long TYPE_FINEST;
    public static final long TYPE_INFO = 1L;
    public static final long TYPE_INFORMATION = 1L;
    public static final long TYPE_WARN = 2L;
    public static final long TYPE_WARNING = 2L;
    public static final long TYPE_ERR = 4L;
    public static final long TYPE_ERROR = 4L;
    public static final long TYPE_FATAL = 8L;
    public static final long TYPE_DEFAULT_MESSAGE = 15L;
    public static final long TYPE_PUBLIC;
    public static final long TYPE_API = 16L;
    public static final long TYPE_CALLBACK = 32L;
    @Deprecated
    public static final long TYPE_ENTRY_EXIT = 64L;
    public static final long TYPE_ENTRY = 128L;
    public static final long TYPE_EXIT = 256L;
    public static final long TYPE_ERROR_EXC = 512L;
    public static final long TYPE_MISC_DATA = 1024L;
    public static final long TYPE_OBJ_CREATE = 2048L;
    public static final long TYPE_OBJ_DELETE = 4096L;
    public static final long TYPE_PRIVATE = 8192L;
    public static final long TYPE_STATIC = 32768L;
    public static final long TYPE_SVC = 65536L;
    public static final long TYPE_PERF = 131072L;
    public static final long TYPE_LEVEL1 = 262144L;
    public static final long TYPE_LEVEL2 = 524288L;
    public static final long TYPE_LEVEL3 = 0x100000L;
    private static final char[] hexDigits;

    public Debug(String string, String string2) {
        if (tl == null) {
            tl = Logger.getLogger(string);
            ch = new ConsoleHandler();
            tl.addHandler(ch);
            tl.setLevel(specifiedLevel);
            ch.setLevel(specifiedLevel);
        }
    }

    public static void Help() {
        System.err.println();
        System.err.println("all       turn on all debugging");
        System.err.println("access    print all checkPermission results");
        System.err.println("jar       jar verification");
        System.err.println("policy    loading and granting");
        System.err.println("scl       permissions SecureClassLoader assigns");
        System.err.println();
        System.err.println("The following can be used with access:");
        System.err.println();
        System.err.println("stack     include stack trace");
        System.err.println("domain    dumps all domains in context");
        System.err.println("failure   before throwing exception, dump stack");
        System.err.println("          and domain that didn't have permission");
        System.err.println();
        System.exit(0);
    }

    public static Debug getInstance(String string) {
        return Debug.getInstance(string, string);
    }

    public static Debug getInstance(String string, String string2) {
        if (Debug.isOn(string)) {
            return new Debug("com.ibm.zertjsse.Debug", null);
        }
        return null;
    }

    public static boolean isOn(String string) {
        if (args == null) {
            return false;
        }
        if (args.indexOf("all") != -1) {
            return true;
        }
        return args.indexOf(string) != -1;
    }

    private String getParms(Object[] objectArray) {
        Object object = " ";
        for (int i = 0; i < objectArray.length; ++i) {
            object = (String)object + objectArray[i].toString() + " ";
        }
        return object;
    }

    public void data(long l, Object object, String string, byte[] byArray) {
        Object[] objectArray = new Object[]{byArray};
        tl.log(Level.FINER, (String)object + " " + string, objectArray);
    }

    public void entry(long l, Object object, String string) {
        if (l == TYPE_FINE) {
            tl.logp(Level.FINE, (String)object, string, "ENTRY");
        } else {
            tl.entering((String)object, string);
        }
    }

    public void entry(long l, Object object, String string, Object object2) {
        Object[] objectArray = new Object[]{object2};
        if (l == TYPE_FINE) {
            tl.logp(Level.FINE, (String)object, string, "ENTRY {0}", object2);
        } else {
            tl.entering((String)object, string, objectArray);
        }
    }

    public void entry(long l, Object object, String string, Object object2, Object object3) {
        Object[] objectArray = new Object[]{object2, object3};
        if (l == TYPE_FINE) {
            Object object4 = "ENTRY";
            if (!tl.isLoggable(Level.FINE)) {
                return;
            }
            for (int i = 0; i < objectArray.length; ++i) {
                object4 = (String)object4 + " {" + i + "}";
            }
            tl.logp(Level.FINE, (String)object, string, (String)object4, objectArray);
        } else {
            tl.entering((String)object, string, objectArray);
        }
    }

    public void entry(long l, Object object, String string, Object[] objectArray) {
        if (l == TYPE_FINE) {
            Object object2 = "ENTRY";
            if (objectArray == null) {
                tl.logp(Level.FINER, (String)object, string, (String)object2);
                return;
            }
            if (!tl.isLoggable(Level.FINE)) {
                return;
            }
            for (int i = 0; i < objectArray.length; ++i) {
                object2 = (String)object2 + " {" + i + "}";
            }
            tl.logp(Level.FINER, (String)object, string, (String)object2, objectArray);
        } else {
            tl.entering((String)object, string, objectArray);
        }
    }

    public void exception(long l, Object object, String string, Throwable throwable) {
        tl.log(Level.FINE, (String)object + " " + string, throwable);
    }

    public void exit(long l, Object object, String string) {
        if (l == TYPE_FINE) {
            tl.logp(Level.FINE, (String)object, string, "RETURN");
        } else {
            tl.exiting((String)object, string);
        }
    }

    public void exit(long l, Object object, String string, byte by) {
        if (l == TYPE_FINE) {
            tl.logp(Level.FINE, (String)object, string, "RETURN {0}", by);
        } else {
            tl.exiting((String)object, string, by);
        }
    }

    public void exit(long l, Object object, String string, short s) {
        if (l == TYPE_FINE) {
            tl.logp(Level.FINE, (String)object, string, "RETURN {0}", s);
        } else {
            tl.exiting((String)object, string, s);
        }
    }

    public void exit(long l, Object object, String string, int n) {
        if (l == TYPE_FINE) {
            tl.logp(Level.FINE, (String)object, string, "RETURN {0}", n);
        } else {
            tl.exiting((String)object, string, n);
        }
    }

    public void exit(long l, Object object, String string, long l2) {
        if (l == TYPE_FINE) {
            tl.logp(Level.FINE, (String)object, string, "RETURN {0}", l2);
        } else {
            tl.exiting((String)object, string, l2);
        }
    }

    public void exit(long l, Object object, String string, float f) {
        if (l == TYPE_FINE) {
            tl.logp(Level.FINE, (String)object, string, "RETURN {0}", Float.valueOf(f));
        } else {
            tl.exiting((String)object, string, Float.valueOf(f));
        }
    }

    public void exit(long l, Object object, String string, double d) {
        if (l == TYPE_FINE) {
            tl.logp(Level.FINE, (String)object, string, "RETURN {0}", d);
        } else {
            tl.exiting((String)object, string, d);
        }
    }

    public void exit(long l, Object object, String string, char c) {
        if (l == TYPE_FINE) {
            tl.logp(Level.FINE, (String)object, string, "RETURN {0}", Character.valueOf(c));
        } else {
            tl.exiting((String)object, string, Character.valueOf(c));
        }
    }

    public void exit(long l, Object object, String string, boolean bl) {
        if (l == TYPE_FINE) {
            tl.logp(Level.FINE, (String)object, string, "RETURN {0}", bl);
        } else {
            tl.exiting((String)object, string, bl);
        }
    }

    public void exit(long l, Object object, String string, Object object2) {
        if (l == TYPE_FINE) {
            tl.logp(Level.FINE, (String)object, string, "RETURN {0}", object2);
        } else {
            tl.exiting((String)object, string, object2);
        }
    }

    public void stackTrace(long l, Object object, String string) {
        StringWriter stringWriter = new StringWriter();
        new Throwable().printStackTrace(new PrintWriter(stringWriter));
        tl.logp(Level.FINER, (String)object, string, stringWriter.toString());
    }

    public void stackTrace(long l, Object object, String string, String string2) {
        StringWriter stringWriter = new StringWriter();
        new Throwable(string2).printStackTrace(new PrintWriter(stringWriter));
        Object[] objectArray = new Object[]{stringWriter.toString()};
        tl.logp(Level.FINER, (String)object, string, string2, objectArray);
    }

    public void text(long l, Object object, String string, String string2) {
        tl.logp(Debug.longToLevel(l), (String)object, string, string2);
    }

    public void text(long l, Object object, String string, String string2, Object object2) {
        Object[] objectArray = new Object[]{object2};
        tl.logp(Debug.longToLevel(l), (String)object, string, string2, objectArray);
    }

    public void text(long l, Object object, String string, String string2, Object object2, Object object3) {
        Object[] objectArray = new Object[]{object2, object3};
        tl.logp(Debug.longToLevel(l), (String)object, string, string2, objectArray);
    }

    public void text(long l, Object object, String string, String string2, Object[] objectArray) {
        tl.logp(Debug.longToLevel(l), (String)object, string, string2, objectArray);
    }

    public static String toHexString(BigInteger bigInteger) {
        Object object = bigInteger.toString(16);
        StringBuffer stringBuffer = new StringBuffer(((String)object).length() * 2);
        if (((String)object).startsWith("-")) {
            stringBuffer.append("   -");
            object = ((String)object).substring(1);
        } else {
            stringBuffer.append("    ");
        }
        if (((String)object).length() % 2 != 0) {
            object = "0" + (String)object;
        }
        int n = 0;
        while (n < ((String)object).length()) {
            stringBuffer.append(((String)object).substring(n, n + 2));
            if ((n += 2) == ((String)object).length()) continue;
            if (n % 64 == 0) {
                stringBuffer.append("\n    ");
                continue;
            }
            if (n % 8 != 0) continue;
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    private static String marshal(String string) {
        if (string != null) {
            String string2;
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer(string);
            String string3 = "[Pp][Ee][Rr][Mm][Ii][Ss][Ss][Ii][Oo][Nn]=";
            String string4 = "permission=";
            String string5 = string3 + "[a-zA-Z_$][a-zA-Z0-9_$]*([.][a-zA-Z_$][a-zA-Z0-9_$]*)*";
            Pattern pattern = Pattern.compile(string5);
            Matcher matcher = pattern.matcher(stringBuffer2);
            StringBuffer stringBuffer3 = new StringBuffer();
            while (matcher.find()) {
                string2 = matcher.group();
                stringBuffer.append(string2.replaceFirst(string3, string4));
                stringBuffer.append("  ");
                matcher.appendReplacement(stringBuffer3, "");
            }
            matcher.appendTail(stringBuffer3);
            stringBuffer2 = stringBuffer3;
            string3 = "[Cc][Oo][Dd][Ee][Bb][Aa][Ss][Ee]=";
            string4 = "codebase=";
            string5 = string3 + "[^, ;]*";
            pattern = Pattern.compile(string5);
            matcher = pattern.matcher(stringBuffer2);
            stringBuffer3 = new StringBuffer();
            while (matcher.find()) {
                string2 = matcher.group();
                stringBuffer.append(string2.replaceFirst(string3, string4));
                stringBuffer.append("  ");
                matcher.appendReplacement(stringBuffer3, "");
            }
            matcher.appendTail(stringBuffer3);
            stringBuffer2 = stringBuffer3;
            stringBuffer.append(stringBuffer2.toString().toLowerCase(Locale.ENGLISH));
            return stringBuffer.toString();
        }
        return null;
    }

    public static String toString(byte[] byArray) {
        if (byArray == null) {
            return "(null)";
        }
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 3);
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            if (i != 0) {
                stringBuilder.append(':');
            }
            stringBuilder.append(hexDigits[n >>> 4]);
            stringBuilder.append(hexDigits[n & 0xF]);
        }
        return stringBuilder.toString();
    }

    public static Level longToLevel(long l) {
        int n = Debug.safeLongToInt(l);
        if (n <= Level.FINEST.intValue()) {
            return Level.FINEST;
        }
        if (n <= Level.FINER.intValue()) {
            return Level.FINER;
        }
        if (n <= Level.FINE.intValue()) {
            return Level.FINE;
        }
        if (n <= Level.CONFIG.intValue()) {
            return Level.CONFIG;
        }
        if (n <= Level.INFO.intValue()) {
            return Level.INFO;
        }
        if (n <= Level.WARNING.intValue()) {
            return Level.WARNING;
        }
        return Level.SEVERE;
    }

    public static int safeLongToInt(long l) {
        if (l < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        if (l > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l;
    }

    public static void traceEntry(Debug debug, String string, String string2) {
        if (debug != null) {
            debug.entry(TYPE_FINER, string + "-" + Thread.currentThread().getId(), string2);
        }
    }

    public static void traceEntry(Debug debug, String string, String string2, Object object) {
        if (debug != null) {
            debug.entry(TYPE_FINER, (Object)(string + "-" + Thread.currentThread().getId()), string2, object);
        }
    }

    public static void traceEntry(Debug debug, String string, String string2, Object object, Object object2) {
        if (debug != null) {
            debug.entry(TYPE_FINER, string + "-" + Thread.currentThread().getId(), string2, object, object2);
        }
    }

    public static void traceEntry(Debug debug, String string, String string2, Object[] objectArray) {
        if (debug != null) {
            debug.entry(TYPE_FINER, (Object)(string + "-" + Thread.currentThread().getId()), string2, objectArray);
        }
    }

    public static void traceExit(Debug debug, String string, String string2) {
        if (debug != null) {
            debug.exit(TYPE_FINER, string + "-" + Thread.currentThread().getId(), string2);
        }
    }

    public static void traceExit(Debug debug, String string, String string2, Object object) {
        if (debug != null) {
            debug.exit(TYPE_FINER, (Object)(string + "-" + Thread.currentThread().getId()), string2, object);
        }
    }

    public static void traceText(Debug debug, String string, String string2, String string3) {
        if (debug != null) {
            debug.text(TYPE_FINEST, string + "-" + Thread.currentThread().getId(), string2, string3);
        }
    }

    public static void traceException(Debug debug, String string, String string2, Throwable throwable) {
        if (debug != null) {
            debug.text(TYPE_FINE, string + "-" + Thread.currentThread().getId(), string2, throwable.getMessage());
            debug.exception(TYPE_FINE, string + "-" + Thread.currentThread().getId(), string2, throwable);
        }
    }

    static {
        specifiedLevel = Level.ALL;
        ch = null;
        tl = null;
        args = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("java.security.debug");
            }
        });
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("java.security.auth.debug");
            }
        });
        if ((args = args == null ? string : args + "," + string) != null) {
            int n;
            if ((args = Debug.marshal(args)).startsWith("zertjsse") && (n = args.indexOf(".")) > 0 && n < args.length()) {
                String string2 = args.substring(n + 1);
                if ("finest".equals(string2)) {
                    specifiedLevel = Level.FINEST;
                } else if ("finer".equals(string2)) {
                    specifiedLevel = Level.FINER;
                } else if ("fine".equals(string2)) {
                    specifiedLevel = Level.FINE;
                }
            }
            if (args.equals("help")) {
                Debug.Help();
            }
        }
        TYPE_FINE = Level.FINE.intValue();
        TYPE_FINER = Level.FINER.intValue();
        TYPE_FINEST = Level.FINEST.intValue();
        TYPE_PUBLIC = Level.FINER.intValue();
        hexDigits = "0123456789abcdef".toCharArray();
    }
}

