/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.zos.utils;

import com.ibm.cic.agent.zos.utils.Messages;
import com.ibm.cic.common.logging.Logger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class SystemCharSets {
    public static final String ASCII_codeset = "ASCII";
    public static final String EBCDIC_codeset = "Cp1047";
    private static final String PLUGIN_ID = "com.ibm.cic.agent.zos.utils.SystemCharSets";
    private static final String chcp_COMMAND = "chcp -q";
    private static final String osgi_os = System.getProperty("osgi.os");
    private static final String m_os = osgi_os != null && !osgi_os.equals("") ? osgi_os : Platform.getOS();
    private static final boolean m_isZOS = "zos".equals(m_os);
    private String systemASCII;
    private String systemEBCDIC;

    public SystemCharSets() {
        this.setSystemASCII(ASCII_codeset);
        this.setSystemEBCDIC(EBCDIC_codeset);
        try {
            if (m_isZOS) {
                this.getSystemASCIIandEBCDICvalues();
            }
        }
        catch (CoreException e) {
            Logger.getGlobalLogger().error(e.getMessage());
            this.setSystemASCII(ASCII_codeset);
            this.setSystemEBCDIC(EBCDIC_codeset);
        }
    }

    public String getSystemASCII() {
        return this.systemASCII;
    }

    public void setSystemASCII(String systemASCII) {
        this.systemASCII = systemASCII;
    }

    public String getSystemEBCDIC() {
        return this.systemEBCDIC;
    }

    public void setSystemEBCDIC(String systemEBCDIC) {
        this.systemEBCDIC = systemEBCDIC;
    }

    private void getSystemASCIIandEBCDICvalues() throws CoreException {
        String command = chcp_COMMAND;
        String m_sErr = "";
        int nRetVal = -1;
        try {
            String line;
            Logger.getGlobalLogger().debug("executing command: " + command);
            Process process = Runtime.getRuntime().exec(command);
            InputStream inputstream = process.getInputStream();
            InputStreamReader isr = new InputStreamReader(inputstream);
            BufferedReader bufferedreader = new BufferedReader(isr);
            InputStream errorstream = process.getErrorStream();
            InputStreamReader esr = new InputStreamReader(errorstream);
            BufferedReader errorbufferedreader = new BufferedReader(esr);
            String ascii_regex = "^.*ASCII.*:\\s*(.*)$";
            String ebcdic_regex = "^.*EBCDIC.*:\\s*(.*)$";
            while ((line = bufferedreader.readLine()) != null) {
                Logger.getGlobalLogger().debug("Searching for Pattern " + ascii_regex + " in String " + line);
                Pattern p = Pattern.compile(ascii_regex);
                Matcher m = p.matcher(line);
                boolean doesMatch = m.matches();
                if (doesMatch) {
                    Logger.getGlobalLogger().debug("Patther match found: " + m.group(1));
                    m.group();
                    this.setSystemASCII(m.group(1));
                    continue;
                }
                Logger.getGlobalLogger().debug("Searching for Pattern " + ebcdic_regex + " in String " + line);
                p = Pattern.compile(ebcdic_regex);
                m = p.matcher(line);
                doesMatch = m.matches();
                if (!doesMatch) continue;
                Logger.getGlobalLogger().debug("Patther match found: " + m.group(1));
                m.group();
                this.setSystemEBCDIC(m.group(1));
            }
            while ((line = errorbufferedreader.readLine()) != null) {
                m_sErr = String.valueOf(m_sErr) + line + "\n";
            }
            process.waitFor();
            nRetVal = process.exitValue();
            errorbufferedreader.close();
            esr.close();
            errorstream.close();
            bufferedreader.close();
            isr.close();
            inputstream.close();
        }
        catch (IOException e) {
            m_sErr = e.getLocalizedMessage();
            nRetVal = -1;
        }
        catch (IllegalThreadStateException e) {
            m_sErr = e.getLocalizedMessage();
            nRetVal = -1;
        }
        catch (InterruptedException e) {
            m_sErr = e.getLocalizedMessage();
            nRetVal = -1;
        }
        if (nRetVal != 0) {
            throw new CoreException((IStatus)new Status(4, PLUGIN_ID, 1, Messages.bind((String)Messages.exec_error, (Object[])new String[]{command, String.valueOf(nRetVal), m_sErr}), null));
        }
    }
}

