/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.zos.utils;

import com.ibm.cic.agent.zos.utils.Messages;
import com.ibm.cic.common.logging.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class EXTATTRUtils {
    private static final long serialVersionUID = 1L;
    private static final String PLUGIN_ID = "com.ibm.cic.agent.zos.utils.EXTATTRUtils";
    private static final String DASH = "-";
    private static final String PLUS = "+";
    private static final String MINUS = "-";
    private static final String SPACE = " ";
    private static final String ls_EXTATTR_COMMAND = "/bin/ls -E ";
    private static final String ls_EXTATTR_REGEX = "[-bcdlp][-rwx]{9}\\s*(([-a])([-p])([-s])([-l])) .*";

    public String getEXTATTR(String filepath) throws FileNotFoundException, CoreException {
        int nRetVal = -1;
        String m_sErr = "";
        File file = new File(filepath);
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        String command = ls_EXTATTR_COMMAND + file.getAbsolutePath();
        Process process = null;
        try {
            String line;
            process = Runtime.getRuntime().exec(command);
            InputStream inputstream = process.getInputStream();
            InputStreamReader isr = new InputStreamReader(inputstream);
            BufferedReader bufferedreader = new BufferedReader(isr);
            InputStream errorstream = process.getErrorStream();
            InputStreamReader esr = new InputStreamReader(errorstream);
            BufferedReader errorbufferedreader = new BufferedReader(esr);
            while ((line = bufferedreader.readLine()) != null) {
                Logger.getGlobalLogger().debug("Searching for Pattern [-bcdlp][-rwx]{9}\\s*(([-a])([-p])([-s])([-l])) .* in String " + line);
                Pattern p = Pattern.compile(ls_EXTATTR_REGEX);
                Matcher m = p.matcher(line);
                boolean doesMatch = m.matches();
                if (!doesMatch) continue;
                Logger.getGlobalLogger().debug("Patther match found: " + m.group(1));
                m.group();
                bufferedreader.close();
                return m.group(1);
            }
            while ((line = errorbufferedreader.readLine()) != null) {
                m_sErr = String.valueOf(m_sErr) + line + "\n";
            }
            nRetVal = process.exitValue();
            bufferedreader.close();
            isr.close();
            inputstream.close();
            errorbufferedreader.close();
            esr.close();
            errorstream.close();
        }
        catch (IOException e) {
            m_sErr = e.getLocalizedMessage();
            nRetVal = -1;
        }
        catch (IllegalThreadStateException e) {
            m_sErr = e.getLocalizedMessage();
            nRetVal = -1;
        }
        if (nRetVal != 0) {
            throw new CoreException((IStatus)new Status(4, PLUGIN_ID, 1, Messages.bind((String)Messages.exec_error, (Object[])new String[]{command, String.valueOf(nRetVal), m_sErr}), null));
        }
        throw new CoreException((IStatus)new Status(4, PLUGIN_ID, 1, Messages.bind((String)Messages.extattr_attributes_not_found, (Object)command), null));
    }

    private static void setEXTATTR(String fileregex, String attr) throws Exception {
        int nRetVal = -1;
        String m_sErr = "";
        if (attr.length() > 5 || attr.length() < 2 || attr.indexOf("a") != attr.lastIndexOf("a") || attr.indexOf("p") != attr.lastIndexOf("p") || attr.indexOf("s") != attr.lastIndexOf("s") || attr.indexOf("l") != attr.lastIndexOf("l")) {
            throw new CoreException((IStatus)new Status(4, PLUGIN_ID, 1, String.valueOf(Messages.bind((String)Messages.extattr_usage_error, (Object)attr)) + "\n" + Messages.extattr_usage, null));
        }
        String command = String.valueOf(EXTATTRUtils.getEXTATTRLocation()) + SPACE + attr + SPACE + fileregex;
        try {
            String line;
            Logger.getGlobalLogger().debug("executing command: " + command);
            Process process = Runtime.getRuntime().exec(command);
            InputStream errorstream = process.getErrorStream();
            InputStreamReader esr = new InputStreamReader(errorstream);
            BufferedReader errorbufferedreader = new BufferedReader(esr);
            while ((line = errorbufferedreader.readLine()) != null) {
                m_sErr = String.valueOf(m_sErr) + line + "\n";
            }
            process.waitFor();
            nRetVal = process.exitValue();
            errorbufferedreader.close();
            esr.close();
            errorstream.close();
        }
        catch (IOException e) {
            m_sErr = e.getLocalizedMessage();
            nRetVal = -1;
        }
        catch (IllegalThreadStateException e) {
            m_sErr = e.getLocalizedMessage();
            nRetVal = -1;
        }
        if (nRetVal != 0) {
            throw new CoreException((IStatus)new Status(4, PLUGIN_ID, 1, Messages.bind((String)Messages.exec_error, (Object[])new String[]{command, String.valueOf(nRetVal), m_sErr}), null));
        }
    }

    public static void addEXTATTR(String fileregex, String attr) throws Exception {
        if (!attr.startsWith(PLUS)) {
            attr = PLUS + attr;
        }
        EXTATTRUtils.setEXTATTR(fileregex, attr);
    }

    public static void removeEXTATTR(String fileregex, String attr) throws Exception {
        if (!attr.startsWith("-")) {
            attr = "-" + attr;
        }
        EXTATTRUtils.setEXTATTR(fileregex, attr);
    }

    private static String getEXTATTRLocation() throws Exception {
        if (new File("/bin/extattr").exists()) {
            return "/bin/extattr";
        }
        if (new File("/usr/bin/extattr").exists()) {
            return "/usr/bin/extattr";
        }
        throw new CoreException((IStatus)new Status(4, PLUGIN_ID, 1, Messages.bind((String)Messages.extattr_command_not_found, (Object[])new String[]{"/bin/extattr", "/usr/bin/extattr"}), null));
    }

    private static IStatus createErrorStatus(String sMsg, Exception e) {
        return new Status(4, PLUGIN_ID, 1, e.getMessage(), (Throwable)e);
    }
}

