/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.zos.utils;

import com.ibm.cic.agent.zos.utils.ConvertUtil;
import com.ibm.cic.agent.zos.utils.Messages;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.io.FileNotFoundException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ConvertASCIItoEBCDIC {
    private static final String PLUGIN_ID = "com.ibm.cic.agent.zos.utils.ConvertASCIItoEBCDIC";

    public static void run(String[] args) throws Exception {
        Logger.getGlobalLogger().debug("com.ibm.cic.agent.zos.utils.ConvertASCIItoEBCDIC - run()");
        int i = 0;
        while (i < args.length) {
            File file = new File(args[i]);
            if (!file.exists()) {
                FileNotFoundException fnf = new FileNotFoundException(file.getAbsolutePath());
                throw new CoreException((IStatus)new Status(4, PLUGIN_ID, 1, fnf.getMessage(), (Throwable)fnf));
            }
            try {
                Logger.getGlobalLogger().debug("START Converting: " + file.getAbsolutePath() + " FROM: ASCII TO: EBCDIC");
                ConvertUtil.convertAndReplaceFileA2E(file);
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, PLUGIN_ID, 1, Messages.bind((String)Messages.convert_error, (Object[])new String[]{file.getAbsolutePath(), "ASCII", "EBCDIC"}), (Throwable)e));
            }
            ++i;
        }
    }

    public static void main(String[] args) throws Exception {
        ConvertASCIItoEBCDIC.run(args);
    }
}

