/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.nativeAdapterData.win32;

import com.ibm.cic.common.nativeAdapterData.win32.INativeWin32Data;
import com.ibm.icu.util.StringTokenizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class SpecialFileNativeData
extends INativeWin32Data {
    public static final String COM_TYPE = "COM";
    public static final String DOT_NET_COM_INTEROP_TYPE = ".Net-COM-interop";
    public static final String DOT_NET_TYPE = ".Net";
    public static final String TRANSLATABLE_TYPE = "translatable";
    private String path;
    private List types;
    private static List validTypes = Arrays.asList("COM", ".Net", ".Net-COM-interop", "translatable");

    public SpecialFileNativeData(String path, String typesStr) {
        this.path = path;
        this.setTypes(typesStr);
    }

    public SpecialFileNativeData(String path, List types) {
        this.path = path;
        this.types = types;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String[] getTypes() {
        return this.types.toArray(new String[this.types.size()]);
    }

    public void setTypes(String typesStr) {
        List newTypes = SpecialFileNativeData.parseTypes(typesStr);
        if (newTypes == null) {
            throw new IllegalArgumentException(typesStr);
        }
        this.types = newTypes;
    }

    public void addType(String type) {
        this.types.add(type);
    }

    public static List parseTypes(String typesStr) {
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(typesStr, " \t,");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (!SpecialFileNativeData.validType(token)) {
                return null;
            }
            result.add(token);
        }
        return result;
    }

    protected String getElementName() {
        return "specialFile";
    }

    protected String[] getAttrNameValuePairs() {
        StringBuffer sb = new StringBuffer();
        Iterator iter = this.types.iterator();
        while (iter.hasNext()) {
            String type = (String)iter.next();
            if (sb.length() != 0) {
                sb.append(',');
            }
            sb.append(type);
        }
        return new String[]{"path", this.getPath(), "types", sb.toString()};
    }

    private static boolean validType(String token) {
        return validTypes.contains(token);
    }
}

