/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.macosx.utils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class CreateInfoPlistFile {
    private static final String INFO_PLIST = "Info.plist";
    private static final String PLUGIN_ID = "com.ibm.cic.agent.macosx.createInfoPlist";
    private static final String USAGE = "Usage: CreateInfoPlist <ExecutableName> <Description> <IconFileName> <Version> <Info.plist Location>";

    public static void main(String[] args) throws Exception {
        CreateInfoPlistFile.run(args);
    }

    public static void run(String[] args) throws CoreException {
        if (args.length != 5) {
            throw new CoreException((IStatus)new Status(4, PLUGIN_ID, USAGE));
        }
        File infoPlistFile = new File(args[4], INFO_PLIST);
        if (!infoPlistFile.exists()) {
            File parentDir = infoPlistFile.getParentFile();
            if (parentDir != null && !parentDir.exists()) {
                parentDir.mkdirs();
            }
        } else {
            infoPlistFile.delete();
        }
        String content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE plist PUBLIC \"-//Apple Computer//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">\n<plist version=\"1.0\">\n\n<dict>\n <!-- Identifies the name of the main executable file in the Application bundle -->\n    <key>CFBundleExecutable</key>\n        <string>{0}</string>\n <!-- Specifies the display name of the application bundle in the menu bar -->\n    <key>CFBundleName</key>\n        <string>{1}</string>\n <!-- Identifies the file containing the icon for the bundle -->\n    <key>CFBundleIconFile</key>\n        <string>{2}</string>\n <!-- Identifies the current version of the property list structure -->\n    <key>CFBundleInfoDictionaryVersion</key>\n        <string>6.0</string>\n <!--  Identifies the type of the bundle. The type code for apps is APPL -->\n    <key>CFBundlePackageType</key>\n        <string>APPL</string>\n <!-- Specifies the release version number of the bundle -->\n    <key>CFBundleShortVersionString</key>\n        <string>{3}</string>\n <!-- Specifies the build version number of the bundle -->\n    <key>CFBundleVersion</key>\n        <string>{3}</string>\n <!-- Identifies the file containing the icon for the bundle -->\n    <key>CFBundleDevelopmentRegion</key>\n        <string>English</string>\n <!-- Contains localization information for an app that handles its own localized resources. -->\n    <key>CFBundleLocalizations</key>\n        <array>\n            <string>cs</string>\n            <string>de</string>\n            <string>en</string>\n            <string>es</string>\n            <string>fr</string>\n            <string>hu</string>\n            <string>it</string>\n            <string>ja</string>\n            <string>ko</string>\n            <string>pl</string>\n            <string>pt_BR</string>\n            <string>ru</string>\n            <string>zh_TW</string>\n            <string>zh</string>\n        </array>\n   <key>Eclipse</key>\n       <array>\n           <string>-ws</string><string>cocoa</string>\n       </array>\n</dict>\n</plist>";
        BufferedWriter bufWriter = null;
        try {
            try {
                bufWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(infoPlistFile), "UTF-8"));
                bufWriter.write(MessageFormat.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE plist PUBLIC \"-//Apple Computer//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">\n<plist version=\"1.0\">\n\n<dict>\n <!-- Identifies the name of the main executable file in the Application bundle -->\n    <key>CFBundleExecutable</key>\n        <string>{0}</string>\n <!-- Specifies the display name of the application bundle in the menu bar -->\n    <key>CFBundleName</key>\n        <string>{1}</string>\n <!-- Identifies the file containing the icon for the bundle -->\n    <key>CFBundleIconFile</key>\n        <string>{2}</string>\n <!-- Identifies the current version of the property list structure -->\n    <key>CFBundleInfoDictionaryVersion</key>\n        <string>6.0</string>\n <!--  Identifies the type of the bundle. The type code for apps is APPL -->\n    <key>CFBundlePackageType</key>\n        <string>APPL</string>\n <!-- Specifies the release version number of the bundle -->\n    <key>CFBundleShortVersionString</key>\n        <string>{3}</string>\n <!-- Specifies the build version number of the bundle -->\n    <key>CFBundleVersion</key>\n        <string>{3}</string>\n <!-- Identifies the file containing the icon for the bundle -->\n    <key>CFBundleDevelopmentRegion</key>\n        <string>English</string>\n <!-- Contains localization information for an app that handles its own localized resources. -->\n    <key>CFBundleLocalizations</key>\n        <array>\n            <string>cs</string>\n            <string>de</string>\n            <string>en</string>\n            <string>es</string>\n            <string>fr</string>\n            <string>hu</string>\n            <string>it</string>\n            <string>ja</string>\n            <string>ko</string>\n            <string>pl</string>\n            <string>pt_BR</string>\n            <string>ru</string>\n            <string>zh_TW</string>\n            <string>zh</string>\n        </array>\n   <key>Eclipse</key>\n       <array>\n           <string>-ws</string><string>cocoa</string>\n       </array>\n</dict>\n</plist>", args[0], args[1], args[2], args[3]));
            }
            catch (IOException e) {
                CreateInfoPlistFile.error(e, infoPlistFile);
                try {
                    if (bufWriter != null) {
                        bufWriter.close();
                    }
                }
                catch (IOException e2) {
                    CreateInfoPlistFile.error(e2, infoPlistFile);
                }
            }
        }
        finally {
            try {
                if (bufWriter != null) {
                    bufWriter.close();
                }
            }
            catch (IOException e) {
                CreateInfoPlistFile.error(e, infoPlistFile);
            }
        }
    }

    private static void error(Exception e, File f) throws CoreException {
        throw new CoreException((IStatus)new Status(4, PLUGIN_ID, "Failed to create file: " + f.getAbsolutePath(), (Throwable)e));
    }
}

