/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ds.web.cli.rest.security;

import com.urbancode.commons.webext.util.JSONOutputType;
import com.urbancode.ds.web.wadl.annotation.Description;
import com.urbancode.ds.web.wadl.annotation.Required;
import com.urbancode.ds.web.wadl.annotation.Summary;
import com.urbancode.ds.web.wadl.annotation.Template;
import com.urbancode.security.Role;
import com.urbancode.security.SecurityConfiguration;
import com.urbancode.security.SecurityUser;
import com.urbancode.security.TeamSpace;
import com.urbancode.security.rest.authenticationrealm.AuthenticationRealmParam;
import com.urbancode.security.rest.authenticationrealm.AuthenticationRealmResource;
import com.urbancode.security.rest.role.RoleParam;
import com.urbancode.security.rest.team.TeamParam;
import com.urbancode.security.rest.user.UserParam;
import com.urbancode.security.rest.user.UserResource;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

@Path(value="/user")
@Summary(value="Resources for creating, editing, and deleting users.")
public class UserCLIResource {
    public static final JSONObject USER_JSON_TEMPLATE;
    public static final JSONObject USER_UPDATE_JSON_TEMPLATE;

    @GET
    @Path(value="/info")
    @Produces(value={"application/json"})
    @Summary(value="List information about a user")
    public JSONObject getUser(@Required @Description(value="Name of the user") @QueryParam(value="user") UserParam userParam) throws Exception {
        SecurityUser user = (SecurityUser)userParam.getValue();
        return new UserResource().toJSON((Object)user, new JSONOutputType[]{JSONOutputType.ALL});
    }

    @GET
    @Path(value="/byEmail")
    @Produces(value={"application/json"})
    @Summary(value="Returns the user with the email that is provided")
    public Response getUserByEmail(@Required @Description(value="Email of user") @QueryParam(value="email") String email) throws Exception {
        SecurityUser user = SecurityConfiguration.getUserFactory().getUserByEmail(null, email);
        if (user == null) {
            throw new WebApplicationException((Throwable)new RuntimeException("No user was found with this email address"), 404);
        }
        JSONObject result = new JSONObject();
        result.put("id", (Object)user.getId().toString());
        result.put("name", (Object)user.getName());
        return Response.ok((Object)result).build();
    }

    @GET
    @Path(value="/inRoleOnTeam")
    @Produces(value={"application/json"})
    @Summary(value="Returns all users in a role for a given team, includes users that are associated via a group membership")
    public JSONArray getAllUsersInRoleForTeam(@Required @Description(value="Name or id of the role") @QueryParam(value="role") RoleParam roleParam, @Required @Description(value="Name or id of the team") @QueryParam(value="team") TeamParam teamParam) throws Exception {
        List users = SecurityConfiguration.getUserFactory().getAllUsersInRoleOnTeam((TeamSpace)teamParam.getValue(), (Role)roleParam.getValue());
        UserResource resource = new UserResource();
        return resource.toJSON((Collection)users, new JSONOutputType[]{JSONOutputType.ALL});
    }

    @PUT
    @Path(value="/create")
    @Produces(value={"application/json"})
    @Summary(value="Create a user")
    @Template(value="USER_JSON_TEMPLATE")
    public JSONObject createUser(String input) throws Exception {
        return new UserResource().createUser(input);
    }

    @PUT
    @Path(value="/import")
    @Produces(value={"application/json"})
    @Summary(value="Import a user from LDAP")
    @Description(value="This command adds one or more users from an LDAP realm to the server.")
    public Response importLdapUser(@Required @Description(value="Name or pattern of the users to be imported. Supports wildcard character *.") @QueryParam(value="user") String name, @Required @Description(value="Authentication realm name or ID") @QueryParam(value="authenticationRealm") String authenticationRealm) throws Exception {
        return new AuthenticationRealmResource().updateUsers(new AuthenticationRealmParam(authenticationRealm), name);
    }

    @PUT
    @Path(value="/update")
    @Produces(value={"application/json"})
    @Summary(value="Update a user")
    @Description(value="Specify the user name in the 'user' parameter and use the JSON string to specify new information about the user.")
    @Template(value="USER_UPDATE_JSON_TEMPLATE")
    public void updateUser(@Required @Description(value="Name of the user") @QueryParam(value="user") UserParam userParam, String input) throws Exception {
        new UserResource().updateUser(userParam, input);
    }

    @PUT
    @Path(value="/delete")
    @Produces(value={"application/json"})
    @Summary(value="Delete a user")
    public void deleteUser(@Required @Description(value="Name of the user") @QueryParam(value="user") UserParam userParam) throws Exception {
        new UserResource().deleteUser(userParam);
    }

    static {
        try {
            USER_JSON_TEMPLATE = new JSONObject().put("name", (Object)"User name").put("password", (Object)"Password").put("email", (Object)"Email address").put("authenticationRealm", (Object)"Authentication realm ID");
            USER_UPDATE_JSON_TEMPLATE = new JSONObject().put("password", (Object)"Password (optional)").put("actualName", (Object)"User real name (optional)").put("email", (Object)"Email address (optional)");
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }
}

