/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ds.web.cli.rest.deploy;

import com.urbancode.air.i18n.TranslatableException;
import com.urbancode.air.property.prop_def.PropDef;
import com.urbancode.air.workflow.WorkflowRuntime;
import com.urbancode.air.workflow.trace.ActivityTrace;
import com.urbancode.commons.service.ServiceRegistry;
import com.urbancode.commons.webext.util.JSONUtilities;
import com.urbancode.ds.persistence.database.FactoryLookup;
import com.urbancode.ds.security.UserLookup;
import com.urbancode.ds.subsys.deploy.workflow.WorkflowFactory;
import com.urbancode.ds.subsys.task.domain.Approval;
import com.urbancode.ds.subsys.task.domain.ApprovalTaskFactory;
import com.urbancode.ds.subsys.task.domain.Task;
import com.urbancode.ds.subsys.task.domain.TaskFactory;
import com.urbancode.ds.web.wadl.annotation.Description;
import com.urbancode.ds.web.wadl.annotation.Summary;
import com.urbancode.security.SecurityUser;
import java.util.UUID;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;

@Path(value="/approval/task/")
@Summary(value="Resources for creating, editing, and deleting agents.")
public class ApprovalTaskCLIResource {
    @GET
    @Summary(value="Get a set of approval tasks that have been modified since the given time")
    public JSONArray getApprovalTasks(@Description(value="Include approval tasks that have been created or edited since this provided time. (Optional)") @QueryParam(value="modifiedAfter") long modifiedAfter) throws Exception {
        return new ApprovalTaskFactory().getDetailedApprovalTasks(modifiedAfter);
    }

    @PUT
    @Path(value="{taskId}/close")
    @Produces(value={"application/json"})
    public JSONObject closeTask(@PathParam(value="taskId") UUID taskId, String input) throws Exception {
        Task task = TaskFactory.getInstance().getTaskForId(taskId);
        SecurityUser user = UserLookup.getUser();
        JSONObject submittedJson = new JSONObject(input);
        String comment = JSONUtilities.getStringFromJsonObject((JSONObject)submittedJson, (String)"comment");
        String passFail = JSONUtilities.getStringFromJsonObject((JSONObject)submittedJson, (String)"passFail");
        if (StringUtils.isEmpty((String)comment) && task.isCommentRequired()) {
            throw new TranslatableException("This task requires a comment.", new Object[0]);
        }
        for (PropDef propDef : task.getPropSheetDef().getPropDefList()) {
            String propValue = JSONUtilities.getStringFromJsonObject((JSONObject)submittedJson, (String)("p:" + propDef.getName()));
            task.setOutputProperty(propDef.getName(), propValue);
        }
        if (passFail == null || passFail.equals("passed")) {
            task.close(user, comment);
        } else {
            task.fail(user, comment);
            Approval approval = TaskFactory.getInstance().getApprovalForTask(task);
            if (approval != null) {
                ActivityTrace approvalTrace = this.getWorkflowFactory().getActivityTraceForApproval(approval);
                if (approvalTrace != null) {
                    WorkflowRuntime runtime = (WorkflowRuntime)ServiceRegistry.getInstance().getInstance(WorkflowRuntime.class);
                    runtime.cancelWorkflow(approvalTrace.getWorkflowTrace().getId());
                }
                approval.failApproval(user, comment);
            }
        }
        return new JSONObject();
    }

    private WorkflowFactory getWorkflowFactory() {
        return FactoryLookup.getWorkflowFactory();
    }
}

