/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ds.subsys.task.domain;

import com.google.common.collect.Lists;
import com.urbancode.ds.persistence.database.DatabaseFactory;
import com.urbancode.ds.subsys.task.domain.ApprovalTask;
import com.urbancode.ds.subsys.task.domain.Task;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.hibernate.Criteria;
import org.hibernate.SQLQuery;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApprovalTaskFactory
extends DatabaseFactory {
    private static ApprovalTaskFactory instance = new ApprovalTaskFactory();
    private static final Logger log = Logger.getLogger(ApprovalTaskFactory.class);

    public static ApprovalTaskFactory getInstance() {
        return instance;
    }

    public List<ApprovalTask> getApprovalTasks(Long modifiedAfter) {
        Criteria criteria = this.getSession().createCriteria(ApprovalTask.class);
        if (modifiedAfter != null) {
            criteria.add((Criterion)Restrictions.disjunction().add((Criterion)Restrictions.gt((String)"dateStarted", (Object)modifiedAfter)).add((Criterion)Restrictions.gt((String)"dateEnded", (Object)modifiedAfter)));
        }
        return criteria.list();
    }

    public JSONArray getDetailedApprovalTasks(Long modifiedAfter) throws JSONException {
        List<ApprovalTask> tasks = this.getApprovalTasks(modifiedAfter);
        if (tasks.isEmpty()) {
            return new JSONArray();
        }
        log.trace((Object)("Getting these approvals: " + tasks));
        log.trace((Object)"About to get taskTeamsMap");
        Map<String, List<TeamRoleObject>> taskTeamsMap = this.getTaskTeams(tasks);
        log.trace((Object)"About to get taskDetailMap");
        Map<String, TaskDetail> taskDetailMap = this.getTaskDetails(tasks);
        JSONArray result = new JSONArray();
        log.trace((Object)"Iterating through tasks");
        for (Task task : tasks) {
            JSONObject obj = new JSONObject();
            TaskDetail detail = taskDetailMap.get(task.getId().toString());
            log.trace((Object)("Detail is obtained for task " + task.getId().toString()));
            log.trace((Object)detail);
            obj.put("id", (Object)task.getId());
            obj.put("name", (Object)task.getName());
            obj.put("commentRequired", task.isCommentRequired());
            obj.put("commentPrompt", (Object)task.getCommentPrompt());
            obj.put("status", (Object)task.getStatus().toString());
            obj.put("requestedDate", (Object)detail.getSubmittedDate());
            obj.put("scheduledDate", (Object)detail.getScheduledDate());
            JSONObject requesterObj = new JSONObject();
            requesterObj.put("name", (Object)detail.getrequesterName());
            requesterObj.put("email", (Object)detail.getrequesterEmail());
            requesterObj.put("displayName", (Object)detail.getRequesterActualName());
            obj.put("applicationName", (Object)detail.getAppName());
            obj.put("environmentName", (Object)detail.getEnvName());
            obj.put("processName", (Object)detail.getAppProcName());
            obj.put("requestor", (Object)requesterObj);
            List<TeamRoleObject> taskTeamRoles = taskTeamsMap.get(task.getId().toString());
            JSONArray teamsArray = new JSONArray();
            if (taskTeamRoles != null && taskTeamRoles.size() > 0) {
                JSONObject roleObj = new JSONObject();
                roleObj.put("id", (Object)taskTeamRoles.get(0).getRoleId());
                roleObj.put("name", (Object)taskTeamRoles.get(0).getRoleName());
                obj.put("role", (Object)roleObj);
                for (TeamRoleObject taskTeamRole : taskTeamRoles) {
                    JSONObject teamObj = new JSONObject();
                    teamObj.put("id", (Object)taskTeamRole.getTeamId());
                    teamObj.put("name", (Object)taskTeamRole.getTeamName());
                    teamsArray.put((Object)teamObj);
                }
            }
            obj.put("teams", (Object)teamsArray);
            result.put((Object)obj);
        }
        return result;
    }

    private Map<String, TaskDetail> getTaskDetails(List<ApprovalTask> tasks) {
        HashMap<String, TaskDetail> result = new HashMap<String, TaskDetail>();
        ArrayList<String> ids = new ArrayList<String>();
        for (Task task : tasks) {
            ids.add(task.getId().toString());
        }
        log.trace((Object)("List of Ids: " + ids));
        if (ids.size() > 0) {
            SQLQuery query = this.getSession().createSQLQuery("select tt.id as taskId, rapr.submitted_time as submittedDate, ce.scheduled_date as scheduledDate, su.email as userEmail, su.name as userName, su.actual_name as actualName, da.name as appName, de.name as envName from {h-schema}tsk_task tt  left join {h-schema}tsk_approval_to_task tatt on tatt.task_id = tt.id left join {h-schema}tsk_approval ta on ta.id = tatt.approval_id left join {h-schema}rt_app_process_request rapr on rapr.approval_id = ta.id left join {h-schema}ds_application da on da.id = rapr.application_id left join {h-schema}ds_environment de on de.id = rapr.environment_id left join {h-schema}cal_entry ce on ce.id = rapr.calendar_entry_id left join {h-schema}sec_user su on su.id = ta.started_by_user_id where tt.id in (:taskIds)");
            query.addScalar("taskId", (Type)StandardBasicTypes.STRING);
            query.addScalar("submittedDate", (Type)StandardBasicTypes.LONG);
            query.addScalar("scheduledDate", (Type)StandardBasicTypes.LONG);
            query.addScalar("userEmail", (Type)StandardBasicTypes.STRING);
            query.addScalar("userName", (Type)StandardBasicTypes.STRING);
            query.addScalar("actualName", (Type)StandardBasicTypes.STRING);
            query.addScalar("appName", (Type)StandardBasicTypes.STRING);
            query.addScalar("envName", (Type)StandardBasicTypes.STRING);
            LinkedList linkedList = new LinkedList();
            for (List page : Lists.partition(ids, (int)1000)) {
                query.setParameterList("taskIds", (Collection)page);
                log.trace((Object)("About to run query to get details of the following tasks: " + page));
                List tempValue = query.list();
                log.trace((Object)("Number of detail rows: " + tempValue.size()));
                linkedList.addAll(tempValue);
                log.trace((Object)("Number of rows in queryResult: " + linkedList.size()));
            }
            for (Object[] row : linkedList) {
                String id = row[0].toString();
                Long submittedDate = row[1] == null ? null : Long.valueOf(Long.parseLong(row[1].toString()));
                Long scheduledDate = row[2] == null ? null : Long.valueOf(Long.parseLong(row[2].toString()));
                String requesterEmail = row[3] == null ? null : row[3].toString();
                String requesterName = row[4].toString();
                String requesterActualName = row[5] == null ? null : row[5].toString();
                String appName = row[6] == null ? null : row[6].toString();
                String envName = row[7] == null ? null : row[7].toString();
                TaskDetail value = new TaskDetail(submittedDate, scheduledDate, requesterEmail, requesterName, requesterActualName, appName, envName);
                result.put(id, value);
            }
        }
        log.trace((Object)("About to inject process name for result: " + result));
        this.injectProcessName(ids, result);
        log.trace((Object)("About to return result: " + result));
        return result;
    }

    private void injectProcessName(List<String> taskIds, Map<String, TaskDetail> taskMap) {
        if (taskIds.size() > 0) {
            LinkedList queryResult = new LinkedList();
            SQLQuery query = this.getSession().createSQLQuery("select tt.id as taskId, ppv.value as procName from {h-schema}tsk_task as tt join {h-schema}tsk_approval_to_task tatt on tatt.task_id = tt.id join {h-schema}rt_app_process_request rapr on tatt.approval_id = rapr.approval_id join {h-schema}rt_property_context rpc on rpc.id = rapr.property_context_id join {h-schema}ps_prop_sheet pps on rpc.prop_sheet_id = pps.id join {h-schema}ps_prop_value ppv on ppv.prop_sheet_id = pps.id where tt.id in (:taskIds) AND ppv.name = 'applicationProcess.name'");
            query.addScalar("taskId", (Type)StandardBasicTypes.STRING);
            query.addScalar("procName", (Type)StandardBasicTypes.STRING);
            for (List page : Lists.partition(taskIds, (int)1000)) {
                query.setParameterList("taskIds", (Collection)page);
                queryResult.addAll(query.list());
            }
            for (Object[] row : queryResult) {
                if (row[1] == null) continue;
                String taskId = row[0].toString();
                String appProcName = row[1].toString();
                if (!taskMap.containsKey(taskId) || taskMap.get(taskId) == null) continue;
                taskMap.get(taskId).setAppProcName(appProcName);
            }
        }
    }

    private Map<String, List<TeamRoleObject>> getTaskTeams(List<ApprovalTask> tasks) {
        HashMap<String, List<TeamRoleObject>> result = new HashMap<String, List<TeamRoleObject>>();
        ArrayList<String> ids = new ArrayList<String>();
        for (Task task : tasks) {
            ids.add(task.getId().toString());
        }
        if (ids.size() > 0) {
            LinkedList queryResult = new LinkedList();
            SQLQuery sQLQuery = this.getSession().createSQLQuery("select tt.id as taskId, sts.id as teamId, sts.name as teamName, sr.id as roleId, sr.name as roleName from {h-schema}tsk_task tt join {h-schema}tsk_task_resource_role_map ttrrm on tt.id = ttrrm.task_id join {h-schema}sec_resource_for_team srft on srft.sec_resource_id = ttrrm.sec_resource_id join {h-schema}sec_team_space sts on sts.id = srft.sec_team_space_id join {h-schema}sec_role sr on sr.id = ttrrm.sec_role_id where tt.id in (:taskIds)");
            sQLQuery.addScalar("taskId", (Type)StandardBasicTypes.STRING);
            sQLQuery.addScalar("teamId", (Type)StandardBasicTypes.STRING);
            sQLQuery.addScalar("teamName", (Type)StandardBasicTypes.STRING);
            sQLQuery.addScalar("roleId", (Type)StandardBasicTypes.STRING);
            sQLQuery.addScalar("roleName", (Type)StandardBasicTypes.STRING);
            for (List page : Lists.partition(ids, (int)1000)) {
                sQLQuery.setParameterList("taskIds", (Collection)page);
                queryResult.addAll(sQLQuery.list());
            }
            for (Object[] row : queryResult) {
                String id = row[0].toString();
                String teamId = row[1].toString();
                String teamName = row[2].toString();
                String roleId = row[3].toString();
                String roleName = row[4].toString();
                TeamRoleObject value = new TeamRoleObject(teamId, teamName, roleId, roleName);
                if (!result.containsKey(id)) {
                    result.put(id, new ArrayList());
                }
                ((List)result.get(id)).add(value);
            }
        }
        return result;
    }

    private class TaskDetail {
        private final Long submittedDate;
        private final Long scheduledDate;
        private final String requesterEmail;
        private final String requesterName;
        private final String requesterActualName;
        private final String appName;
        private final String envName;
        private String appProcName;

        public TaskDetail(Long submittedDate, Long scheduledDate, String requesterEmail, String requesterName, String requesterActualName, String appName, String envName) {
            this.submittedDate = submittedDate;
            this.scheduledDate = scheduledDate;
            this.requesterEmail = requesterEmail;
            this.requesterName = requesterName;
            this.requesterActualName = requesterActualName;
            this.appName = appName;
            this.envName = envName;
        }

        public Long getSubmittedDate() {
            return this.submittedDate;
        }

        public Long getScheduledDate() {
            return this.scheduledDate;
        }

        public String getrequesterEmail() {
            return this.requesterEmail;
        }

        public String getrequesterName() {
            return this.requesterName;
        }

        public String getRequesterActualName() {
            return this.requesterActualName;
        }

        public String getAppName() {
            return this.appName;
        }

        public String getEnvName() {
            return this.envName;
        }

        public String getAppProcName() {
            return this.appProcName;
        }

        public void setAppProcName(String appProcName) {
            this.appProcName = appProcName;
        }
    }

    private class TeamRoleObject {
        private final String teamId;
        private final String teamName;
        private final String roleId;
        private final String roleName;

        public TeamRoleObject(String teamId, String teamName, String roleId, String roleName) {
            this.teamId = teamId;
            this.teamName = teamName;
            this.roleId = roleId;
            this.roleName = roleName;
        }

        public String getTeamId() {
            return this.teamId;
        }

        public String getTeamName() {
            return this.teamName;
        }

        public String getRoleId() {
            return this.roleId;
        }

        public String getRoleName() {
            return this.roleName;
        }
    }
}

