/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Release
* (c) Copyright IBM Corporation 2011, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
/*globals define, uReleaseConfig, i18n*/
define([
    "dojo/_base/declare",
    "dojo/_base/fx",
    "dojo/on",
    "dojo/topic",
    "dojo/dom",
    "dojo/dom-geometry",
    "dojo/dom-class",
    "dojo/dom-construct",
    "dojo/dom-style",
    "app/widgets/UReleaseWidget"
], function (
    declare,
    fx,
    on,
    topic,
    dom,
    geo,
    domClass,
    domConstruct,
    domStyle,
    UReleaseWidget
) {
        /**
         *
         */
        return declare("app/widgets/utilities/Notification", [UReleaseWidget], {

            /**
             *
             */
            templateString:
                '<div class="notification-container hidden">' +
                    '<div class="inline-block" data-dojo-attach-point="contents">' +
                        '<div class="notification-icon" data-dojo-attach-point="iconAttach"></div>' +
                        '<div class="inline-block notification-contents" data-dojo-attach-point="messageAttach"></div>' +
                        '<div class="inline-block notification-contents" data-dojo-attach-point="containerAttach"></div>' +
                    '</div>' +
                '</div>',

            //The domNode to attach the popup to.
            attachPoint: null,
            //A dom element of the contents of the popup.
            message: null,
            content: null,
            status: "",
            closeable: true,
            boldMessage: true,
            hidden: true,

            /**
             *
             */
            postCreate: function() {
                this.inherited(arguments);
                var _this = this;
                if (this.message){
                    this.messageAttach.innerHTML = this.message;
                    if (this.boldMessage){
                        domStyle.set(this.messageAttach, "font-weight", "bold");
                    }
                } else {
                    domConstruct.destroy(this.messageAttach);
                }
                if (this.content){
                    domConstruct.place(this.content, this.containerAttach);
                } else {
                    domConstruct.destroy(this.containerAttach);
                }
                switch(this.status) {
                    case "error":
                        domClass.add(_this.domNode, "notification-error");
                        break;
                    case "warning":
                        domClass.add(_this.domNode, "notification-warning");
                        break;
                    case "info":
                        domClass.add(_this.domNode, "notification-info");
                        break;
                    default:
                        domClass.add(_this.domNode, "notification-info");
                        break;
                }
                if (!this.attachPoint){
                    this.attachPoint = dom.byId("notificationContainerNode");
                }
                domConstruct.place(this.domNode, this.attachPoint, "first");
                if (this.closeable){
                    var closeButton = domConstruct.create("div", {
                        className: "notification-close-button inline-block",
                        innerHTML: "X"
                    }, this.domNode);
                    this.own(on(closeButton, "click", function(){
                        _this.hide();
                        topic.publish("notification-closed", _this);
                    }));
                }
            },

            show: function(){
                if(this.hidden) {
                    this.hidden = false;
                    domStyle.set(this.domNode, "opacity", "0");
                    //this.domNode.style.backgroundColor = "white";
                    domClass.remove(this.domNode, "hidden");
                    //var height = geo.position(this.domNode).h;
                    //fx.animateProperty({
                        //node: this.domNode,
                        //duration: 400,
                        //properties: {
                            //height: { end: height - 10, start:0 }
                        //}
                    //}).play();
                    fx.fadeIn({
                        node: this.domNode,
                        duration: 400
                    }).play();
                }
            },

            hide: function(){
                var _this = this;
                if(!this.hidden) {
                    this.hidden = true;
                    //fx.animateProperty({
                        //node: this.domNode,
                        //duration: 600,
                        //properties: {
                            //marginLeft: 600,
                            //height: 0,
                            //opacity: 0
                        //}
                    //}).play();

                    //this.domNode.style.backgroundColor = "transparent";
                        //fx.fadeOut({
                            //node: this.domNode,
                            //duration: 400
                        //}).play();
                        //setTimeout(function () {
                            domClass.add(_this.domNode, "hidden");
                            _this.domNode.style = "";
                        //}, 390);
                }
            }
        }
    );
});
