/*globals define, uReleaseConfig, i18n */
define([
    "dojo/_base/declare",
    "dojo/_base/lang",
    "dojo/_base/array",
    "dojo/on",
    "dojo/request/xhr",
    "dojo/promise/all",
    "dojo/dom",
    "dojo/dom-class",
    "dojo/dom-construct",
    "js/webext/widgets/Switch",
    "app/widgets/select/UCRFilteringScrollSelect",
    "app/widgets/UReleaseWidget",
    "app/widgets/mixins/_MemoryCacheMixin"
], function (
    declare,
    lang,
    array,
    on,
    xhr,
    all,
    dom,
    domClass,
    domConstruct,
    Switch,
    UCRFilteringScrollSelect,
    UReleaseWidget,
    _MemoryCacheMixin
) {
    return declare("app/widgets/FilterWidgetUtil", [UReleaseWidget, _MemoryCacheMixin], {
        filterEntries: null,
        filterOptions: [],
        hash: null,
        cookieId: null,
        updateFilterCallBacks:[],
        cookieValue :null,
        filterSwitch:null,
        /**
         * Function gets the values for current filter. returns a map of filterOption hashes to values
         */
        getValues: function () {
            var _this = this;
            var result = {options:{}, status:null};
            var cookieValue = _this.getCache(_this.cookieId);
            if(!!cookieValue) {
                var filterOn = cookieValue.substring(cookieValue.indexOf("Filter:") + 7, cookieValue.indexOf(";", cookieValue.indexOf("Filter")));
                array.forEach(_this.filterOptions, function (filterOption){
                    var currentCookieValues = _this.getValueFromFilterCookie(cookieValue, filterOption.contentType);
                    result.options[filterOption.contentType]  = currentCookieValues;
                });
                result.status = filterOn;
            }
            return result;
        },
        /**
         * gets filter option from cookie string.
         */
        getValueFromFilterCookie: function (cookie, header) {
                var tag = header + ":";
                return cookie ? cookie.substring(cookie.indexOf(tag) + tag.length, cookie.indexOf(";", cookie.indexOf(tag))).split(",") : [];
        },
        postCreate: function() {
            var _this = this;
            var cookieName = "UCR-filter-" + _this.hash;//unique cookie identifier
            _this.cookieId = cookieName;
            this.putCache(_this.cookieId, util.getCookie(_this.cookieId));//creates populates cache for this unique filter 
        },
        /**
         * Build filter widget elements
         */
        buildFilterForm: function (onFilterChangeCallBack) {
            var _this = this;

            //given a cookie and a header, return the value of that header.
            //we expect the cookie to be in the form <TAG1>:<VALUE1>;<TAG2>:<VALUE2>;...

            var filteringAttachPoint = domConstruct.create("div", {});

            var oldCookieValue = _this.getCache(_this.cookieId);

            //get each filter from the cookie.
            //each item is <type>:<value1>,<value2>...;
            var filterOn = oldCookieValue ? oldCookieValue.substring(oldCookieValue.indexOf("Filter:") + 7, oldCookieValue.indexOf(";", oldCookieValue.indexOf("Filter"))) === "ON" : false;

            /**
             * prepares a call back function. Callback function sets the cookie update
             */
            function prepareFilterUpdate(_this) {
                function result() {
                    var cookieValue = "Filter:";
                    cookieValue += _this.filterSwitch.value ? "ON" : "OFF";
                    this.getParent().setToggleValue(_this.filterSwitch.value);
                    function setValueForFilterCookie(select, tag) {
                        var result = ";" + tag + ":";
                        array.forEach(select.values, function (item) {
                            result += item.id + ",";
                        });
                        return result;
                    }
                    array.forEach(_this.filterOptions, function(filter) {
                        cookieValue += setValueForFilterCookie(filter, filter.contentType);
                    });
                    cookieValue += ";";
                    util.setCookie(_this.cookieId, cookieValue, 365);
                    _this.cookieValue = cookieValue;
                    _this.putCache(_this.cookieId, cookieValue);
                    array.forEach(_this.updateFilterCallBacks, function(callback) {
                        setTimeout(callback,0);
                    });
                }
                return result;
            }

            //creates filter on off switch
            _this.filterSwitch = new Switch({
                color:"blue",
                value: filterOn,
                labelPlacement: "before",
                labelText: i18n("Filter Enabled:")
            });
            _this.filterSwitch .placeAt(filteringAttachPoint);
            domClass.add(_this.filterSwitch.domNode, "ucr-filter-switch");
            _this.own(on(_this.filterSwitch, "change", prepareFilterUpdate(_this)));

            array.forEach(_this.filterEntries, function(filterEntry) {
                var currentCookieValues = _this.getValueFromFilterCookie(oldCookieValue, filterEntry.hash);
                var filter = new UCRFilteringScrollSelect({
                multiple: true,
                options: filterEntry.options,
                onLoad: function () {
                    //set the default filtered fields to the cookie
                    var values = currentCookieValues;
                    this.set('value',
                            //return only items that were in the cookie
                            array.filter(this.options, function(item) {
                                return array.indexOf(values, item.id) !== -1;
                            })
                        );
                },
                placeHolder: filterEntry.label,
                contentType: filterEntry.contentType
                }).placeAt(filteringAttachPoint);
                filter.set('hash',filterEntry.hash);
                _this.filterOptions.push(filter);
                on(filter, "change", prepareFilterUpdate(_this));
            });
            _this.updateFilterCallBacks.push(onFilterChangeCallBack);

            return filteringAttachPoint;
        }
    });
});
