/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Cloud Sync
* (c) Copyright IBM Corporation 2016. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
define(["dijit/_TemplatedMixin",
        "app/widgets/UReleaseWidget",
        "app/model/sync/Settings",
        "dojo/_base/declare",
        "dojo/_base/xhr",
        "dojo/dom-construct",
        "dojo/dom-class",
        "dijit/form/Button",
        "js/webext/widgets/Alert",
        "js/webext/widgets/ColumnForm"
        ],
function(_TemplatedMixin,
        UReleaseWidget,
        Settings,
        declare,
        xhr,
        domConstruct,
        domClass,
        Button,
        Alert,
        ColumnForm
) {
    return declare("app/widgets/sync/SettingsView",  [UReleaseWidget, _TemplatedMixin], {
        templateString:
            '<div class="systemSettings">'+
            '  <div data-dojo-attach-point="formAttach"></div>'+
            '</div>',

        warningIcon: null,

        postCreate: function() {
            var _this = this;
            _this.isSaved = true;
            this.existingValues = {};
            if (this.version) {
                this.existingValues = this.version;
            }

            window.onbeforeunload =  function() {
                if (!_this.isSaved) {
                    return i18n("This page contains unsaved changes.");
                }
            };

            xhr.get({
                url: uReleaseConfig.urls.base+"api/settings",
                handleAs: "json",
                load: function(data) {
                    var form = new ColumnForm({
                        cancelLabel: null,
                        submitUrl: uReleaseConfig.urls.base+"api/settings",
                        postSubmit: function(data) {
                            _this.isSaved = true;
                            var savedAlert = new Alert({
                                title: i18n("Success"),
                                message: i18n("Settings saved successfully.")
                            });
                        },
                        validateFields: function(data) {
                            var result = [];
                            if (data.mailPort) {
                                var mailPort = parseInt(data.mailPort, 10);
                                if (isNaN(mailPort)) {
                                    result.push(i18n("The mail server port number must be an integer."));
                                }
                                else {
                                    data.mailPort = mailPort;
                                }
                            }
                            return result;
                        }
                    });
                    _this.form = form;
                    form.placeAt(_this.formAttach);
                    _this.addField = function(options) {
                        var field = form.addField(options);
                        if (field && field.widget.fieldRow){
                            var row = field.widget.fieldRow;
                            if (options.className){
                                domClass.add(row, options.className);
                            }
                            if (options.type === "SectionLabel"){
                                domClass.add(row, "section-label-row");
                            }
                            if (options.type === "Select" || options.type === "FilteringSelect"){
                                domClass.add(row, "select-widget-row");
                            }
                            if (options.type === "Text" || options.type === "Secure"){
                                domClass.add(row, "text-widget-row");
                            }
                            if (options.type === "Switch"){
                                domClass.add(row, "switch-widget-row");
                            }
                            if (options.icon){
                                if (options.icon === "warning-icon") {
                                    _this.warningIcon = domConstruct.create("div", {
                                        className: "inline-block setting-section warning-icon",
                                        title: i18n("Caution: Public URL and current UCR URL do not match."),
                                        style: {
                                            visibility: "hidden"
                                        }
                                    }, row, "first");
                                    _this.handlePublicURLWarning(options.value);
                                }
                                else {
                                    domConstruct.create("div", {
                                        className: "inline-block settings-icon general-settings-section-header " + options.icon + "-icon"
                                    }, field.widget.domAttach, "first");
                                }
                            }
                        }
                        return field;
                    };

                    var formContainer = domConstruct.create("div", {
                        className: "form-container"
                    }, _this.formAttach, "first");

                    ///////////////////////////////////////////////////////////////////////////////
                    // General Settings
                    ///////////////////////////////////////////////////////////////////////////////
                    var generalSettingsContainer = domConstruct.create("div", {
                        className: "inline-block settings-section"
                    }, formContainer);
                    var generalSettings = domConstruct.create("div", {
                        className: "settings-section-inner general-settings"
                    }, generalSettingsContainer);

                    _this.addField({
                        type: "SectionLabel",
                        value: i18n("General Settings"),
                        attachPoint: generalSettings
                        //icon: "general-settings"
                    });

                    _this.addField({
                        name: "syncUsers",
                        label: i18n("Allowed Users"),
                        description: i18n("A white list of IBM id user email addresses allowed to login. Separate each address or pattern with a comma. Use '*' to match multiple characters. eg. '*@domain.com' would allow everyone at domain.com to login with their IBM id."),
                        value: data.syncUsers,
                        required: false,
                        type: "TextArea",
                        textDir: "ltr",
                        bidiDynamicSTT: "USERS",
                        attachPoint: generalSettings,
                        onChange: function() {
                            _this.setSaveState(data.syncUsers, this.value);
                        }
                    });
                }
            });
        },

        setSaveState: function(oldValue, newValue) {
            var _this = this;

            if (newValue !== null && (oldValue !== newValue)) {
                _this.isSaved = false;
            }
        },

        handlePublicURLWarning: function(value) {
            var currentURL = window.location.href;
            var currentExt = "/settings/" + window.location.hash;
            var startIndex = currentURL.length - currentExt.length;
            if (startIndex >= 0 && currentURL.substr(startIndex, currentExt.length) === currentExt) {
                currentURL = currentURL.substr(0, currentURL.length - currentExt.length);
            }
            if (value.length !== 0 && value.substr(value.length - 1, 1) === "/") {
                value = value.substr(0, value.length - 1);
            }
            if (value === currentURL) {
                this.warningIcon.style.visibility = "hidden";
            }
            else {
                this.warningIcon.style.visibility = "visible";
            }
        }
    });
});
