/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Cloud Sync
* (c) Copyright IBM Corporation 2016. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
define([
        "dojo/_base/declare",
        "dojo/dom-construct",
        "dojo/request/xhr",
        "app/widgets/ResourceRow",
        "app/widgets/FieldValidation",
        "js/webext/widgets/Alert"
], function (
        declare,
        domConstruct,
        xhr,
        ResourceRow,
        validation,
        Alert
) {
    return declare("app/widgets/sync/PluginRow",
            [ResourceRow], {

        title: i18n("Plugins"),

        /**
         *
         */
        getColumns: function() {
            var _this = this;
            _this.addFieldValidation("name", i18n("Name"), validation.maxLength(255));
            return [{
                "name": i18n("Name"),
                "width": "20%",
                "formatter": function() {
                    var name = _this.model.get("name");
                    return name;
                },
                "getValue": function() {
                    return _this.model.get("name");
                }
            },
            {
                "name": i18n("Description"),
                "width": "20%",
                "formatter": function() {
                    return _this.model.get("description");
                },
                "getValue": function() {
                    return _this.model.get("description");
                }
            },
            {
                "name": i18n("Version"),
                "width": "20%",
                "formatter": function() {
                    return _this.model.get("pluginVersion").toString();
                },
                "getValue": function() {
                    return _this.model.get("pluginVersion");
                }
            },
            {
                "name": i18n("Build Number"),
                "width": "20%",
                "formatter": function() {
                    return _this.model.get("releaseVersion");
                },
                "getValue": function() {
                    return _this.model.get("releaseVersion");
                }
            }];
        },

        postDelete: function() {
            var _this = this;
            _this.model.load();
        },

        postDeleteError: function (error) {
            if (error.responseText) {
                var errorAlert = new Alert({
                    forceRawMessages:true,
                    title : i18n("Can not delete"),
                    message: error.responseText
                });
            }
        },

        preSave: function() {

        }
    });
});
