/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Cloud Sync
* (c) Copyright IBM Corporation 2016. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
/*globals define, i18n, util, uReleaseConfig*/
define([
    "dojo/_base/declare",
    "dojo/_base/lang",
    "dojo/request/xhr",
    "dojo/_base/array",
    "dojo/dom-construct",
    "dojo/dom-class",
    "dojo/on",
    "dojo/json",
    "dojo/mouse",
    "dojo/promise/all",
    "dojo/Deferred",
    "dojo/DeferredList",
    "app/widgets/ResourceRow",
    "js/webext/widgets/RestSelect",
    "app/model/ResourceRegistry",
    "js/webext/widgets/Alert",
    "dojox/form/CheckedMultiSelect",
    "app/widgets/select/FilterableCheckedMultiSelect",
    "app/widgets/select/HttpFilterableCheckedMultiSelect",
    "app/widgets/select/HttpFilterableMultipleListCheckedMultiSelect",
    "app/widgets/select/MappingBox",
    "app/widgets/icon/IconPicker",
    "dijit/form/Button",
    "dijit/form/MultiSelect",
    "dijit/form/Select",
    "dijit/form/TextBox",
    "js/webext/widgets/Dialog",
    "js/webext/widgets/ColumnForm",
    "dijit/Tooltip",
    "app/widgets/BetaNotice"
], function (
    declare,
    lang,
    xhr,
    array,
    domConstruct,
    domClass,
    on,
    json,
    mouse,
    all,
    Deferred,
    DeferredList,
    ResourceRow,
    RestSelect,
    Registry,
    Alert,
    CheckedMultiSelect,
    FilterableCheckedMultiSelect,
    HttpFilterableCheckedMultiSelect,
    HttpFilterableMultipleListCheckedMultiSelect,
    MappingBox,
    IconPicker,
    Button,
    MultiSelect,
    Select,
    TextBox,
    Dialog,
    ColumnForm,
    Tooltip,
    BetaNotice
) {
    return declare("app/widgets/sync/IntegrationProviderRow",
            [ResourceRow], {
        templateString:
            "<div class=\"resource resource-collapsed\">" +
                "<div data-dojo-attach-point=\"resourceForm\">" +
                    "<div data-dojo-attach-point=\"expandAttach\"></div>" +
                    "<div class=\"resource-title\" data-dojo-attach-point=\"headerAttach\"></div>" +
                    "<div class=\"resource-view-container\">" +
                        "<div class=\"resource-view\" data-dojo-attach-point=\"viewAttach\"></div>" +
                        "<div class=\"resource-view-actions\" data-dojo-attach-point=\"actionAttach\"></div>" +
                    "</div>" +
                    "<div class=\"resource-edit\" data-dojo-attach-point=\"editAttach\"></div>" +
                    "<div class=\"resource-edit\" data-dojo-attach-point=\"applyButtonAttach\"></div>" +
                    "<div class=\"resource-button-spacer\" data-dojo-attach-point=\"buttonSpacerAttach\"></div>" +
                    "<div class=\"resource-buttons\" data-dojo-attach-point=\"buttonAttach\">" +
                        "<div class=\"save-button inline-block\" data-dojo-attach-point=\"saveButtonAttach\"></div>" +
                        "<div class=\"cancel-button inline-block\" data-dojo-attach-point=\"cancelButtonAttach\"></div>" +
                    "</div>" +
                "</div>" +
            "</div>",
        title: null,
        separator: true,
        _initI18n : function() {
            this.title = i18n("Integration");
        },

        postCreate: function() {
         // XXX will want to have the multiselects in webext or at least registered here.
            //FormDelegates.registerDelegate("CHECKED_MULTI_HTTP_SELECT", HttpFilterableMultipleListCheckedMultiSelect);
            //FormDelegates.registerDelegate("HTTP_MULTI_SELECT", HttpFilterableCheckedMultiSelect);
            this.inherited(arguments);
            this.integrationFieldNames = [];
            this.integrationGroups = [];
            this.integrationExtraFields = [];
            this.initiativeMappingFieldNames = [];
            this.cleanupMapping = false;
            var _this = this;
            domClass.add(this.domNode, "integration-row");

        },

        /**
         *
         */
        getColumns: function() {
            var _this = this;

            //We need to save the unique name for that IntegrationType for that specific plugin
            if (_this.model && _this.model.get("integrationType")) {
                if(_this.model.get("integrationType").indexOf("com.urbancode.urelease.domain.integration.plugin.PluginIntegrationProvider_") === 0){
                   _this.pluginIntegrationName = _this.model.get("integrationType");
                }
            }

            return [{
                "name": i18n("Name"),
                "width": "15%",
                "getValue": function() {
                    return _this.model.get("name");
                },
                "fieldData": {
                    "type": "Validation Text",
                    "name": "name",
                    "label": i18n("Name"),
                    "required": "true",
                    "placeHolder": i18n("Name"),
                    "missingMessage": i18n("A name is required")
                }
            },{
                "name": i18n("Description"),
                "width": "18%",
                "getValue": function() {
                    return _this.model.get("description");
                },
                "fieldData": {
                    "type": "Text",
                    "name": "description",
                    "label": i18n("Description"),
                    "placeHolder": i18n("Description")
                }
            },{
                "name": i18n("Integration Type"),
                "width": "19%",
                "formatter": function() {
                    var value;

                    if (_this.model.get("integrationPluginVersion")) {
                        value = _this.model.get("integrationTypeName")+" - "+_this.model.get("integrationPluginVersion")+" ("+_this.model.get("defaultStep")+")";
                    }
                    else if(_this.model.get("plugin")) {
                        value = _this.model.get("plugin").name+" - "+_this.model.get("plugin").pluginVersion+" ("+_this.model.get("defaultStep")+")";
                    }
                    else {
                        value = _this.model.get("integrationTypeName");
                    }
                    return value;
                },
                "fieldData": {
                    "label": i18n("Integration Type"),
                    "getField": function() {

                        var result = domConstruct.create("div");

                        var integrationTypeDiv = domConstruct.create("div", {
                            className: "integration-type"
                        }, result);

                        var pluginVersionDiv = domConstruct.create("div", {
                            className: "integration-plugin-version"
                        }, result);

                        var pluginStepDiv = domConstruct.create("div", {
                            className: "integration-plugin-step"
                        }, result);


                        _this.integrationSelect = new RestSelect({
                            "allowNone": false,
                            "value": _this.model.get("integrationType") || (!!_this.model.get("plugin") ? _this.model.get("plugin").pluginId : null),
                            "name": "integrationType",
                            "restUrl": "/api/integrations/type",
                            "getLabel": function(item) {
                                return item.name;
                            },
                            "getValue": function(item) {
                                return item.value;
                            },
                            "onChange": function(item, fullItem) {

                                if (fullItem) {
                                    _this.integrationType = fullItem;
                                    _this.pluginIntegrationName = fullItem.name;
                                }

                                if (!_this.model.get("id") || (_this.model.get("id") && !fullItem.plugin)) {
                                     domConstruct.empty(_this.editAttach);
                                     domConstruct.empty(_this.applyButtonAttach);

                                     if (item.indexOf("com.urbancode.urelease.domain.integration.plugin.PluginIntegrationProvider") !== 0) {
                                         _this.createButtons();
                                         _this.showIntegrationTypeFields(fullItem);
                                     }
                                }

                                if (_this.versionSelect) {
                                    _this.versionSelect.destroy();
                                }

                                if (fullItem.plugin) {

                                    var currentPluginVersionId;
                                    //if it is a new Model we select the latest version by default
                                    if (!_this.model.get("id") && fullItem.plugin) {
                                        currentPluginVersionId = fullItem.plugin;
                                    }

                                    //if it is an existing Model we select the previously selected plugin version
                                    if (_this.model.get("id") && _this.model.get("plugin")) {
                                        var plugin = _this.model.get("plugin");
                                        currentPluginVersionId = plugin.id;
                                    }

                                    //if the model has been updated but not refreshed from the server yet
                                    if (_this.model.get("id") && _this.integrationPlugin) {
                                        currentPluginVersionId = _this.integrationPlugin.id;
                                    }

                                    //If the model has just been created and the version is different than the latest
                                    if (_this.model.get("id") && _this.model.get("pluginVersion")) {
                                        currentPluginVersionId = _this.model.get("pluginVersion");
                                    }

                                    _this.versionSelect = new RestSelect({
                                        "allowNone": false,
                                        "value": currentPluginVersionId || null,
                                        "name": "pluginVersion",
                                        "restUrl": "/api/integrations/"+fullItem.plugin+"/versions",
                                        "getLabel": function(item) {
                                            return item.version;
                                        },
                                        "getValue": function(item) {
                                            return item.plugin;
                                        },
                                        "onChange": function(item, versionItem) {

                                            if (_this.stepSelect) {
                                                _this.stepSelect.destroy();
                                            }

                                            //We need to keep of copy of the original UI properties
                                            //so we could compare them to the newer plugin version UI properties later
                                            if (!_this.originalProperties) {
                                                _this.originalProperties = versionItem.pluginProperties;
                                            }

                                            if (versionItem) {
                                                //if (versionItem.version !== _this.model.get("integrationPluginVersion")) {
                                                    _this.resetNotUsedFields(_this.originalProperties, versionItem.pluginProperties);
                                                    _this.model.set("plugin",versionItem.id);
                                                    _this.model.set("integrationPluginVersion", versionItem.version);
                                                    _this.model.set("integrationPlugin", versionItem);
                                                    _this.model.set("integrationTypeName", versionItem.name);
                                                //}
                                            }

                                            _this.stepSelect = new RestSelect({
                                                "allowNone": false,
                                                "value": _this.model.get("defaultStep") || null,
                                                "name": "defaultStep",
                                                "restUrl": "/api/integrations/"+versionItem.plugin+"/steps",
                                                "getLabel": function(item) {
                                                    return item.name;
                                                },
                                                "getValue": function(item) {
                                                    return item.name;
                                                },
                                                "onChange": function(item, stepItem) {
                                                    //We need to keep of copy of the original UI properties
                                                    //so we could compare them to the newer plugin version UI properties later
                                                    if (!_this.originalStepProperties) {
                                                        _this.originalStepProperties = stepItem.pluginProperties;
                                                    }

                                                    if (stepItem) {
                                                        if (stepItem.name !== _this.model.get("defaultStep")) {
                                                            _this.resetNotUsedFields(_this.originalStepProperties, stepItem.pluginProperties);
                                                            _this.model.set("defaultStep",stepItem.name);
                                                        }
                                                        domConstruct.empty(_this.editAttach);
                                                        domConstruct.empty(_this.applyButtonAttach);
                                                        _this.createButtons();
                                                       _this.showIntegrationTypeFields(stepItem);
                                                    }
                                                }
                                            });

                                            _this.stepSelect.placeAt(pluginStepDiv);
                                        }
                                    });

                                    _this.versionSelect.placeAt(pluginVersionDiv);

                                }
                                else {
                                    _this.model.set("plugin",null);
                                }
                            },
                            "disabled": _this.model.resourceId
                        });

                        _this.integrationSelect.placeAt(integrationTypeDiv);
                        return result;
                    }
                }
            },{
                "name": i18n("Last Status"),
                "width": "25%",
                "getValue": function() {
                    var status = null;
                    if (_this.model.get("lastExecutionStatus")) {
                        status = _this.model.get("lastExecutionStatus");
                    }
                    return status;
                },
                "formatter": function(){
                    var result = domConstruct.create("div");
                    if (_this.model) {
                        var status = _this.model.get("lastExecutionStatus");
                        if (status){
                            var statusIcon = domConstruct.create("div", {className: "inline-block "}, result);
                            if (status === "Success"){
                                statusIcon.className += "integration-status-icon row success";
                            }
                            else {
                                statusIcon.className += "integration-status-icon row failed";
                            }
                        }

                        _this.own(
                            on(_this.viewAttach, mouse.enter, function() {
                                if (!_this.expanded) {
                                    if (!_this.updateReport) {
                                        _this.updateReport = true;
                                        setTimeout(function(){
                                            _this.updateReport = undefined;
                                        },5000);
//                                        _this.updateLastReport().then(function(){
//                                            _this.refresh();
//                                        });
                                    }
                                }
                            })
                        );

                        if (_this.model.get("lastExecution")) {
                            var date = util.dateFormatShort(_this.model.get("lastExecution"));
                            var dateHtml = domConstruct.create("div", {
                                className: "integration-icon-date inline-block",
                                innerHTML: date+"&nbsp;"
                            }, result);
                        }

                        if (_this.model.get("lastExecutionReport")) {
                            var reportButton = domConstruct.create("a", {
                                innerHTML: i18n("View Log"),
                                className: "integration-icon-label inline-block"
                            }, result);
                            _this.own(on(reportButton, "click", function() {

                                // if the contents of lastExecutionReport is taken from the
                                // initial load of this object, it will be a JSON string.
                                // If the integration has been run locally (clicked
                                // "Run Integration"), it will already be an object, and
                                // should not be parsed. <<< this makes no sense
                                var lastExecutionReport = _this.model.get("lastExecutionReport");
                                if (typeof lastExecutionReport === 'string') {
                                    lastExecutionReport = lastExecutionReport.replace(new RegExp("\r", "g"), "").replace(new RegExp("\n", "g"), "<br/>");
                                    console.log(lastExecutionReport);
                                    lastExecutionReport = json.parse(lastExecutionReport);
                                }
                                var reportLogs = lastExecutionReport;
                                var reportDialog = new Dialog();

                                domConstruct.create("div", {
                                    innerHTML: i18n("Last Execution Report on %1",util.dateFormatShort(_this.model.get("lastExecution")))+"&nbsp;&nbsp;&nbsp;"
                                }, reportDialog.titleNode);

                                var reportHtml = domConstruct.create("div", {
                                    className: "integration-row-report columnForm",
                                    style: "line-height: 20px;"
                                }, reportDialog.containerNode);

                                var reportHtmlContainer = domConstruct.create("div", {
                                    className: "table"
                                }, reportHtml);

                                array.forEach(reportLogs, function(log) {
                                    domConstruct.create("div", {
                                        className: log.className,
                                        innerHTML: log.text
                                    },reportHtmlContainer);
                                });

                                var closeButtonContainer = domConstruct.create("div", {className: "underField"}, reportDialog.containerNode);
                                var closeButton = new Button({
                                    label: i18n("Close"),
                                    onClick: function(){
                                        reportDialog.hide();
                                    }
                                });
                                closeButton.placeAt(closeButtonContainer);
                                reportDialog.show();
                            }));
                        }
                    }
                    return result;
                }
            }];
        },

        updateLastReport: function() {
//            var _this = this;
//            //FIXME using both a load: method and a deferred is mixing the old way (load) with the new way
//            // promises --deferred  this should be fixed at some point
//            var deferred = xhr.get(uReleaseConfig.urls.base+"integrationProvider/"+_this.model.get("id")+"/updateExecutionStatus",{
//                handleAs: "json",
//                load: function(execution) {
//                    _this.model.set("lastExecutionStatus",execution.status);
//                    _this.model.set("lastExecutionReport",execution.report);
//                    _this.model.set("lastExecution",execution.lastUpdate);
//                }
//            });
//          return deferred;
        },

        createButtons: function() {
            var _this = this;

            this.applyButtonContainer = domConstruct.create("div", {
                className: "integration-apply-button-container"
            });

            var updateContainer = domConstruct.create("div", {
                style: {
                    "float":"right",
                    "marginTop": "10px"
                }
            },_this.editAttach);

            var updateButton = new Button({
                type: "update",
                className: "run-integration",
                label: i18n("Run Integration")
               });
            domConstruct.place(updateButton.domNode, updateContainer);

            on(updateButton, "click", function() {

                _this.applyChanges().then(function() {

                    //After we have save the changes using the short integration name we need to reset the full plugin unique name
                    if (_this.integrationSelect.value.indexOf("com.urbancode.urelease.domain.integration.plugin.PluginIntegrationProvider") === 0) {
                        _this.model.set("integrationType", _this.integrationSelect.value);
                    }

                    //Makes sure that some value are set before running the integration
                    if (_this.checkPrerequisites()) {
                        updateButton.set("disabled", true);

                        updateButton.set("label", i18n("Integration is running..."));

                        var postId = {"integrationProviderId": _this.model.resourceId};
                        xhr.post("/api/integrations/execute",{
                            data: postId,
                            handleAs: "json"
                        }).then(function(data) {
                            updateButton.set("disabled", false);
                            updateButton.set("label", i18n("Run Integration"));

                            var reportLogs = data.message;
                            var reportDialog = new Dialog();

                            var statusDisplayed;

                            if (data.status === "Failed") {
                                statusDisplayed = i18n("Failed");
                            } else if (data.status === "Success") {
                                statusDisplayed = i18n("Success");
                            }

                            domConstruct.create("div", {
                                innerHTML: i18n("Last Execution Report on %1 (%2)", util.dateFormatShort(data.lastExecution), statusDisplayed)+"&nbsp;&nbsp;&nbsp;"
                            }, reportDialog.titleNode);

                            var reportHtml = domConstruct.create("div", {
                                className: "integration-row-report columnForm",
                                style: "line-height: 20px;"
                            }, reportDialog.containerNode);

                            var reportHtmlContainer = domConstruct.create("div", {
                                className: "table"
                            }, reportHtml);

                            array.forEach(reportLogs, function(log) {
                                domConstruct.create("div", {
                                    className: log.className,
                                    innerHTML: log.text
                                },reportHtmlContainer);
                            });

                            var closeButtonContainer = domConstruct.create("div", {className: "underField"}, reportDialog.containerNode);
                            var closeButton = new Button({
                                label: i18n("Close"),
                                onClick: function(){
                                    reportDialog.hide();
                                }
                            });
                            closeButton.placeAt(closeButtonContainer);
                            reportDialog.show();

                            //We need to update the model in case the user click on save
                            //to make sure that what the user saves will match what has just been
                            //persisted in DB by running the integration
                            _this.model.set("lastExecutionStatus",data.status);
                            _this.model.set("lastExecutionReport",data.message);
                            _this.model.set("lastExecution",data.lastExecution);
                        }, function(error) {
                            updateButton.set("disabled", false);
                            updateButton.set("label", i18n("Run Integration"));
                            var warning = new Alert({
                                forceRawMessages:true,
                                message: i18n("Failed to update:") + "<br>" + error.response.text
                            });
                        });
                    }
                });

            });
        },

        checkPrerequisites: function() {
            var _this = this;
            var prerequisites = true;
            var warning;
            return prerequisites;
        },

        showIntegrationTypeFields: function(integration) {
            var _this = this;
            this.collapsed = false;
            array.forEach(_this.integrationFieldNames, function(fieldName) {
                _this.removeExtraFieldRow(fieldName);
            });
            _this.integrationFieldNames = [];

            array.forEach(integration.pluginProperties, function(property) {

                var fieldData;
                //Properties can be FIELD or GROUP of fields
                if (property.type === "FIELD") {
                    fieldData = lang.clone(property);
                    //We set the name the way we want to submit it
                    fieldData.propDef.name = "propSheet/"+fieldData.name;
                    //Somehow Release does not serialize propDef.type but propDef.typeName
                    //So we set the type that is expected by FormDelegates
                    fieldData.propDef.type = fieldData.propDef.typeName;
                    //This methode check if a field can be displayed
                    if (_this.checkForPrerequisites(property) && _this.checkUnlessValues(fieldData)){
                        //We set the exsiting value saved on the model
                        fieldData.propDef.value = _this.model.get(fieldData.propDef.name);
                        //We show tooltips now
                        fieldData.propDef.tooltip = fieldData.propDef.description;
                        //This HttpSelect Widget does not accept any id and will crash
                        if (fieldData.propDef.type === "HTTP_SELECT"
                            || fieldData.propDef.type === "HTTP_MULTI_SELECT"
                              || fieldData.propDef.type === "SCRIPTED_SELECT"
                                  || fieldData.propDef.type === "SCRIPTED_MULTI_SELECT") {

                            //For SCRIPTED SELECT we need to use the same widget as for HTTP_SELECT
                            if (fieldData.propDef.type === "SCRIPTED_SELECT") {
                                fieldData.propDef.type = "HTTP_SELECT";
                            }

                            fieldData.propDef.id = null;
                            if (fieldData.resolveHttpValuesUrl) {
                                //Here we want to handle it locally not using Air property endpoint
                                if (_this.model.get("id")) {
                                    fieldData.propDef.resolveHttpValuesUrl = "plugins/"+_this.model.get("id")+"/"+
                                        _this.versionSelect.value+"/"+_this.stepSelect.value+"/resolveValues/"+fieldData.name;
                                }
                                else {
                                    fieldData.propDef.resolveHttpValuesUrl = "plugins/"+
                                        _this.versionSelect.value+"/"+_this.stepSelect.value+"/resolveValues/"+fieldData.name;
                                }
                                //We gather all values for fields that this field is depending on
                                //So without having to save we can make changes that could be canceled later
                                fieldData.propDef.defaultQuery = _this.gatherPrerequisitesValues(fieldData);
                            }
                        //For button we handle it differently because we are not expecting properties back but the output of a file
                        } else if (fieldData.propDef.type === "BUTTON") {
                            if (fieldData.executeUrl) {
                                if (_this.model.get("id")) {
                                    fieldData.executeUrl = "plugins/"+_this.model.get("id")+"/"+
                                        _this.versionSelect.value+"/"+_this.stepSelect.value+"/execute/"+fieldData.name;
                                }
                                else {
                                    fieldData.executeUrl = "plugins/"+
                                        _this.versionSelect.value+"/"+_this.stepSelect.value+"/execute/"+fieldData.name;
                                }
                            }
                        }

                        fieldData.propDef.onChange = function (value) {
                            //Here we want to catch only the real onChange events
                            //The httpSelect box for example calls an onchange event everytime it is loaded
                            if (_this.model.get(fieldData.propDef.name) !== value) {
                                _this.resetChildren(integration.pluginProperties,fieldData);
                            }

                            _this.model.set(fieldData.propDef.name, value);
                            _this.doOnFieldChanged(integration);
                        };

                        if(!fieldData.propDef.hidden) {
                            //HTTP_MULTI_SELECT and BUTTON are not part of form delegates so we handle them locally here
                            if (fieldData.propDef.typeName === "HTTP_MULTI_SELECT" || fieldData.propDef.typeName === "SCRIPTED_MULTI_SELECT") {
                                //HTTP_MULTI_SELECT and SCRIPTED_MULTI_SELECT are handled by the same widget
                                var httpMultiSelect = _this.createExtraHttpSelectFieldRow (fieldData);
                                _this.integrationExtraFields.push(httpMultiSelect);
                                _this.integrationFieldNames.push(fieldData.name);
                                
                            } else if (fieldData.propDef.typeName === "BUTTON") {
                                var extraButton = _this.createExtraButtonFieldRow (fieldData);
                                
                                _this.integrationExtraFields.push(extraButton);
                                _this.integrationFieldNames.push(fieldData.propDef.name);
                                
                            } else if (fieldData.propDef.typeName === "PARAGRAPH") {
                                var extraTextHolder = _this.createExtraParagraphFieldRow (fieldData);
                                _this.integrationExtraFields.push(extraTextHolder);
                                _this.integrationFieldNames.push(fieldData.propDef.name);
                            }
                            else {
                                _this.createExtraFieldRow(fieldData.propDef, fieldData.propDef.name);
                            }
                            _this.integrationFieldNames.push(fieldData.propDef.name);
                        }
                    }
                }
                else if (property.type === "GROUP"){

                    fieldData = lang.clone(property);
                    if (_this.checkForPrerequisites(property) && _this.checkUnlessValues(fieldData)){
                        //A UIField has a widget that tells us what type of MappingBoxWidget we should use
                        //For now we have only mappingBox
                        var widget = fieldData.widget;

                        // XXX this should not just make a MappingBox, but should handle groups generically.
                        // but for now, we have to get it working.
                        var div = domConstruct.create('div');
                        //Default widget for now
                        if (widget === "mappingBox") {
                            var masterField, slaveField;

                            //The order matters and we expect at least 2 childrens
                            if (fieldData.children[0] && fieldData.children[1]) {
                                //Left field
                                masterField = fieldData.children[0];
                                //Right field
                                slaveField = fieldData.children[1];

                                //We set the url that will be used to retrieve the values
                                if (masterField && slaveField) {
                                    if (_this.model.get("id")) {
                                        masterField.resolveHttpValuesUrl = "/api/integrations/"+_this.model.get("id")+"/"+
                                            _this.versionSelect.value+"/"+_this.stepSelect.value+"/resolveValues/"+masterField.name;
                                    }
                                    else {
                                        masterField.resolveHttpValuesUrl = "/api/integrations/"+
                                            _this.versionSelect.value+"/"+_this.stepSelect.value+"/resolveValues/"+masterField.name;
                                    }

                                    masterField.propDef.defaultQuery = _this.gatherPrerequisitesValues(fieldData);

                                    if (_this.model.get("id")) {
                                        slaveField.resolveHttpValuesUrl = "/api/integrations/"+_this.model.get("id")+"/"+
                                            _this.versionSelect.value+"/"+_this.stepSelect.value+"/resolveValues/"+slaveField.name;
                                    }
                                    else {
                                        slaveField.resolveHttpValuesUrl = "/api/integrations/"+
                                            _this.versionSelect.value+"/"+_this.stepSelect.value+"/resolveValues/"+slaveField.name;
                                    }

                                    slaveField.propDef.defaultQuery = _this.gatherPrerequisitesValues(fieldData);
                                }

                                var box = new MappingBox({
                                    name: fieldData.name,
                                    title: fieldData.title,
                                    propName: fieldData.name,
                                    description: fieldData.description,
                                    slaveUIField: slaveField,
                                    masterUIField: masterField,
                                    model: _this.model
                                });
                                box.placeAt(_this.editAttach);

                                _this.integrationGroups.push(box);
                                _this.integrationFieldNames.push(fieldData.name);
                            }
                        }
                    }
                }
            });
            domConstruct.place(_this.applyButtonContainer, _this.applyButtonAttach);
        },

        //Creates HTTP_MULTI_SELECT widget
        createExtraHttpSelectFieldRow: function (fieldData) {
            var _this = this;

            var preSelectedJsonArray;
            if (_this.model.get("propSheet/"+fieldData.name)) {
                preSelectedJsonArray = json.parse(_this.model.get("propSheet/"+fieldData.name));
            }

            var resolveHttpValuesUrl = null;

            if (_this.model.get("id")) {
                resolveHttpValuesUrl = "/api/integrations/"+_this.model.get("id")+"/"+
                    _this.versionSelect.value+"/"+_this.stepSelect.value+"/resolveValues/"+fieldData.name;
            }
            else if(_this.model.get("integrationPlugin") !== null || _this.model.get("integrationPlugin").plugin !== null){
                resolveHttpValuesUrl = "/api/integrations/"+
                    _this.model.get("integrationPlugin").plugin+"/"+_this.stepSelect.value+"/resolveValues/"+fieldData.name;
            }
            else {
                resolveHttpValuesUrl = "/api/integrations/"+
                    _this.versionSelect.value+"/"+_this.stepSelect.value+"/resolveValues/"+fieldData.name;
            }

            var httpSelect = new HttpFilterableCheckedMultiSelect({
                multiple:true,
                name: fieldData.propDef.name,
                defaultQuery: _this.gatherPrerequisitesValues(fieldData),
                className: "httpFilterCheckedMultiSelect",
                preSelectedOptions: preSelectedJsonArray,
                title: fieldData.propDef.label,
                description: fieldData.propDef.description,
                uri: resolveHttpValuesUrl,
                onChange: function (value) {
                    _this.model.set("propSheet/"+fieldData.name, json.stringify(value));
                }
            });

            httpSelect.placeAt(_this.editAttach);

            return httpSelect;
        },

        //Creates Paragraph
        createExtraParagraphFieldRow: function (fieldData) {
           var _this = this;
           var paragraph = domConstruct.create("div", {
                className: "integration-plugin-paragraph"
            }, _this.editAttach);

           domConstruct.create("div", {
               innerHTML: fieldData.propDef.label,
               className: "label"
           }, paragraph);

           domConstruct.create("div", {
               innerHTML: fieldData.propDef.description,
               className: "content"
           }, paragraph);

           paragraph.name = "propSheet/"+fieldData.name;

           return paragraph;
        },

        //Creates BUTTON widget
        createExtraButtonFieldRow: function (fieldData) {
           var _this = this;

           var extraButton = new Button({
               type: fieldData.name,
               name: fieldData.propDef.name,
               label: fieldData.propDef.label
           });

           domClass.add(extraButton.domNode, "button-field");


           var helpToolTip = new Tooltip({
               connectId: [extraButton.domNode],
               label: fieldData.description,
               showDelay: 100,
               position: ["after", "above", "below", "before"]
           });

           this.own(on(extraButton, "click", function() {

               extraButton.set("disabled", true);
               extraButton.set("label", "Running...");

               var promise;
               var requireSave = false;
               if(!!fieldData.options) {
                   var options = fieldData.options.split(",");
                   
                   array.forEach(options, function(option) {
                       if(option === "requireSave") {
                           requireSave = true;
                       }
                   });
                   
               }
                       
               if(requireSave) {
                   promise = _this.applyChanges();
               }
               else {
                   promise = new Deferred();
                   promise.resolve();
               }
               
               promise.then(function() {
                   //For buttons we want to update the backend will all values
                   //from all the fields
                   var params = _this.gatherAllFieldValues();
                   if(!!_this.model.resourceId) {
                       params.releaseIntegrationProvider = _this.model.resourceId;
                   }
                   
                   var executeUrl = fieldData.executeUrl;
                   
                   // If the URL does not include the integration provider id, but we have the
                   // integration provider id on hand, then put the id in the url
                   if(executeUrl.split("/").length === 5 && _this.model.resourceId) {
                       executeUrl = executeUrl.replace("plugins/", "plugins/" + _this.model.resourceId + "/");
                   }
                   
                   xhr.post(uReleaseConfig.urls.base+executeUrl,{
                       handleAs: "json",
                       data: params
                   }).then(function(result) {
                       extraButton.set("disabled", false);
                       extraButton.set("label", fieldData.propDef.label);
                       var outputDialog = new Dialog();
                       domConstruct.create("div", {
                           innerHTML: fieldData.propDef.label,
                           className: "integration-plugin "+result.status
                       }, outputDialog.titleNode);
                       
                       var outputJson = json.parse(result.output);
                       
                       array.forEach(outputJson, function(log) {
                           domConstruct.create("div", {
                               className: "integration-plugin "+log.className,
                               innerHTML: log.text
                           },outputDialog.containerNode);
                       });
                       
                       outputDialog.show();
                   }, function(error) {
                       extraButton.set("disabled", false);
                       extraButton.set("label", fieldData.propDef.label);
                   });
               });
           }));

           extraButton.placeAt(_this.editAttach);

           return extraButton;
        },

        /**
         * This method makes sure that if a field is not present in a new or older version of the plugin
         * that the values set for those will be reset during the next save
         */
        resetNotUsedFields: function (oldProperties, properties) {
            var _this = this;

            var oldPropSheetProperty;
            var newProperties = [];

            //We build an array with the names of the new properties
            array.forEach(properties, function(prop) {
                newProperties.push(prop.name);
            });

            array.forEach(oldProperties, function(oldPropSheetProperty) {
                if (newProperties.indexOf(oldPropSheetProperty.name) === -1){
                    //If the UI property is not present in the new version
                    var propSheetProperty;
                    for (propSheetProperty in _this.model.serviceData) {
                        if (_this.model.serviceData.hasOwnProperty(propSheetProperty)) {
                            //If the model had a value for that not used property
                            if (propSheetProperty.indexOf("propSheet/"+oldPropSheetProperty.name) >= 0) {
                                //We reset that value to remove it when the user clicks on save
                                _this.model.set(propSheetProperty, null);
                            }
                        }
                    }
                }
            });
        },

        /**
         * This method makes sure that all fields depending on the current changed field
         * will be destroyed
         */
        resetChildren: function (properties, fieldData) {
            var _this = this;
            array.forEach(properties, function(property) {
                if (property.prerequisites) {
                    var prereqs = property.prerequisites.split(",");
                    array.forEach(prereqs, function(prereq) {
                        if (prereq === fieldData.name) {
                            var i;
                            var propSheetProperty;

                            if (property.type === "FIELD") {
                                //We go throught all the dependant fields and remove them from the UI
                                if (_this.integrationFieldNames.indexOf("propSheet/" + property.name) >= 0) {
                                    _this.removeExtraFieldRow("propSheet/" + property.name);
                                    _this.integrationFieldNames.splice(_this.integrationFieldNames.indexOf("propSheet/" + property.name), 1);
                                    //We reset the children field if their parent changes
                                    _this.model.set("propSheet/" + property.name, null);
                                }
                                //For widget that are not part of webext
                                for (i=0; i<=_this.integrationExtraFields.length-1; i++) {
                                    if (_this.integrationExtraFields[i]) {
                                        if (_this.integrationExtraFields[i].name === "propSheet/" + property.name) {

                                            if (_this.integrationExtraFields[i].placeAt) {
                                                _this.integrationExtraFields[i].destroy();
                                            }
                                            else {
                                                domConstruct.destroy(_this.integrationExtraFields[i]);
                                            }
                                            _this.integrationExtraFields.splice(i,1);
                                            //We reset all properties saved for each extra Field
                                            for (propSheetProperty in _this.model.serviceData) {
                                                if (_this.model.serviceData.hasOwnProperty(propSheetProperty)) {
                                                    if (propSheetProperty.indexOf("propSheet/" + property.name+":") >= 0) {
                                                        _this.model.set(propSheetProperty, null);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            else if (property.type === "GROUP"){
                                //We go throught all existing groups and if it was already created we remove it from the UI
                                for (i=0; i<=_this.integrationGroups.length-1; i++) {
                                    if (_this.integrationGroups[i]) {
                                        if (_this.integrationGroups[i].propName === property.name) {
                                            _this.integrationGroups[i].destroy();
                                            _this.integrationGroups.splice(i,1);

                                            //We reset all properties saved for each group
                                            for (propSheetProperty in _this.model.serviceData) {
                                                if (_this.model.serviceData.hasOwnProperty(propSheetProperty)) {
                                                    if (propSheetProperty.indexOf("propSheet/" + property.name+":") >= 0) {
                                                        _this.model.set(propSheetProperty, null);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    });
                }
            });
        },
        /**
         * Add or remove fields depending on their prerequisites
         * for the current plugin integration type
         */
        doOnFieldChanged: function (integration) {
            var _this = this;
            if (integration) {

                array.forEach(integration.pluginProperties, function(property) {
                    var fieldData;
                    //If it is a field
                    if (property.type === "FIELD") {
                        fieldData = lang.clone(property);
                        //We set the name the way we want to submit it
                        fieldData.propDef.name = "propSheet/"+fieldData.propDef.name;
                        fieldData.propDef.type = fieldData.propDef.typeName;
                        //This methode check if a field can be displayed
                        if (_this.checkForPrerequisites(fieldData) && _this.checkUnlessValues(fieldData)){
                            fieldData.propDef.value = _this.model.get(fieldData.propDef.name);
                            //We show tooltips now
                            fieldData.propDef.tooltip = fieldData.propDef.description;

                            //This HttpSelect Widget does not accept any id and will crash
                            if (fieldData.propDef.type === "HTTP_SELECT"
                                || fieldData.propDef.type === "HTTP_MULTI_SELECT"
                                    || fieldData.propDef.type === "SCRIPTED_SELECT") {

                                //For SCRIPTED SELECT we need to use the same widget as for HTTP_SELECT
                                if (fieldData.propDef.type === "SCRIPTED_SELECT") {
                                    fieldData.propDef.type = "HTTP_SELECT";
                                }

                                fieldData.propDef.id = null;
                                if (fieldData.resolveHttpValuesUrl) {
                                    //Here we want to handle it locally not using Air property endpoint
                                    if (_this.model.get("id")) {
                                        fieldData.propDef.resolveHttpValuesUrl = "plugins/"+_this.model.get("id")+"/"+
                                            _this.versionSelect.value+"/"+_this.stepSelect.value+"/resolveValues/"+fieldData.name;
                                    }
                                    else {
                                        fieldData.propDef.resolveHttpValuesUrl = "plugins/"+
                                            _this.versionSelect.value+"/"+_this.stepSelect.value+"/resolveValues/"+fieldData.name;
                                    }
                                    fieldData.propDef.defaultQuery = _this.gatherPrerequisitesValues(fieldData);
                                }
                            }
                            else if (fieldData.propDef.type === "BUTTON") {
                                if (fieldData.executeUrl) {
                                    if (_this.model.get("id")) {
                                        fieldData.executeUrl = "plugins/"+_this.model.get("id")+"/"+
                                            _this.versionSelect.value+"/"+_this.stepSelect.value+"/execute/"+fieldData.name;
                                    }
                                    else {
                                        fieldData.executeUrl = "plugins/"+
                                            _this.versionSelect.value+"/"+_this.stepSelect.value+"/execute/"+fieldData.name;
                                    }
                                }
                            }

                            fieldData.propDef.onChange = function (value) {
                                if (_this.model.get(fieldData.propDef.name) !== value) {
                                    _this.resetChildren(integration.pluginProperties,fieldData);
                                }

                                _this.model.set(fieldData.propDef.name, value);
                                _this.doOnFieldChanged(integration);
                            };
                            //If the field does not exist we add it
                            if (_this.integrationFieldNames.indexOf(fieldData.propDef.name) < 0) {
                                if(!fieldData.propDef.hidden) {
                                    if (fieldData.propDef.typeName === "HTTP_MULTI_SELECT"
                                        || fieldData.propDef.typeName === "SCRIPTED_MULTI_SELECT") {
                                        var httpMultiSelect = _this.createExtraHttpSelectFieldRow (fieldData);
                                        _this.integrationExtraFields.push(httpMultiSelect);
                                        _this.integrationFieldNames.push(fieldData.propDef.name);
                                    } else if (fieldData.propDef.typeName === "BUTTON") {
                                        var extraButton = _this.createExtraButtonFieldRow (fieldData);
                                        _this.integrationExtraFields.push(extraButton);
                                        _this.integrationFieldNames.push(fieldData.propDef.name);
    
                                    } else if (fieldData.propDef.typeName === "PARAGRAPH") {
                                        var extraTextHolder = _this.createExtraParagraphFieldRow (fieldData);
                                        _this.integrationExtraFields.push(extraTextHolder);
                                        _this.integrationFieldNames.push(fieldData.propDef.name);
                                    } else {
                                        _this.createExtraFieldRow(fieldData.propDef, fieldData.propDef.name);
                                        _this.integrationFieldNames.push(fieldData.propDef.name);
                                    }
                                }
                            }
                        }
                        else {

                            //If the prerequisites are not met anymore and the field was displayed
                            //We need to remove it
                            if (_this.integrationFieldNames.indexOf("propSheet/" + fieldData.name) >= 0) {
                                _this.removeExtraFieldRow(fieldData.propDef.name);

                                _this.integrationFieldNames.splice(_this.integrationFieldNames.indexOf("propSheet/" + fieldData.name), 1);
                            }
                        }
                    }
                    else if (property.type === "GROUP"){
                        fieldData = lang.clone(property);
                        if (_this.checkForPrerequisites(fieldData) && _this.checkUnlessValues(fieldData)){

                            //mappingBox only for now
                            var widget = fieldData.widget;

                            // XXX this should not just make a MappingBox, but should handle groups generically.
                            // but for now, we have to get it working.
                            var div = domConstruct.create('div');

                            if (widget === "mappingBox") {
                                var masterField, slaveField;

                                masterField = fieldData.children[0];
                                slaveField = fieldData.children[1];

                                if (masterField && slaveField) {

                                    if (_this.model.get("id")) {
                                        masterField.resolveHttpValuesUrl = uReleaseConfig.urls.base+"plugins/"+_this.model.get("id")+"/"+
                                            _this.versionSelect.value+"/"+_this.stepSelect.value+"/resolveValues/"+masterField.name;
                                    }
                                    else {
                                        masterField.resolveHttpValuesUrl = uReleaseConfig.urls.base+"plugins/"+
                                            _this.versionSelect.value+"/"+_this.stepSelect.value+"/resolveValues/"+masterField.name;
                                    }

                                    masterField.propDef.defaultQuery = _this.gatherPrerequisitesValues(fieldData);

                                    if (_this.model.get("id")) {
                                        slaveField.resolveHttpValuesUrl = uReleaseConfig.urls.base+"plugins/"+_this.model.get("id")+"/"+
                                            _this.versionSelect.value+"/"+_this.stepSelect.value+"/resolveValues/"+slaveField.name;
                                    }
                                    else {
                                        slaveField.resolveHttpValuesUrl = uReleaseConfig.urls.base+"plugins/"+
                                            _this.versionSelect.value+"/"+_this.stepSelect.value+"/resolveValues/"+slaveField.name;
                                    }

                                    //If this field depends on other fields we need to send the UI most recent and not saved yet values
                                    //along with the request
                                    slaveField.propDef.defaultQuery = _this.gatherPrerequisitesValues(fieldData);
                                }

                                var groupExist = false;
                                array.forEach(_this.integrationGroups, function(group) {
                                    if (group.propName === fieldData.name) {
                                        groupExist = true;
                                    }
                                });

                                //If the group is not displayed yet we can add the field
                                if (!groupExist) {
                                    var box = new MappingBox({
                                        title: fieldData.title,
                                        propName: fieldData.name,
                                        description: fieldData.description,
                                        slaveUIField: slaveField,
                                        masterUIField: masterField,
                                        model: _this.model
                                    });
                                    box.placeAt(_this.editAttach);

                                    _this.integrationGroups.push(box);
                                    _this.integrationFieldNames.push(fieldData.name);
                                }
                            }
                        }
                        else {
                            //We go throught all existing groups and if it was already created we remove it from the UI
                            var i;
                            for (i=0; i<=_this.integrationGroups.length-1; i++) {
                                if (_this.integrationGroups[i]) {
                                    _this.integrationGroups[i].destroy();
                                    _this.integrationGroups.splice(i,1);
                                }
                            }
                        }
                    }
                });
            }
        },

        /**
         * Retrieves the value for each of the prerequisites for a field and build a list of parameters with it
         * Since a GET request could be limited in its content size we need to submit only required prerequisites
         */
        gatherPrerequisitesValues: function(fieldData) {
            var props={};
            var _this = this;
            //Does that field has prerequisites
            if (fieldData.prerequisites) {
                var prereqs = fieldData.prerequisites.split(",");
                //prerequisites are separated by commas
                //Lets iterate through all fields in the form
                var formObject = _this.form.getValues();
                var field;

                for (field in _this.form.getValues()) {
                    if (_this.form.getValues().hasOwnProperty(field)) {

                        var i;
                        for (i in prereqs) {
                            if (prereqs.hasOwnProperty(i)) {
                                if (field === "propSheet/"+prereqs[i]) {

                                    var fieldValue = formObject[field];
                                    //We only check that a value has been set
                                    if (fieldValue && (fieldValue && fieldValue !== "")) {

                                        props[prereqs[i]] = fieldValue;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            return props;
        },

        /**
         * Retrieves the value for each of the prerequisites for a field and build a list of parameters with it
         * Since a POST request can allow a bigger content we can afford to submit all other fields
         */
        gatherAllFieldValues: function() {
            var props={};
            var _this = this;

            var formObject = _this.form.getValues();
            var field;
            var i;
            for (field in _this.form.getValues()) {
                if (_this.form.getValues().hasOwnProperty(field)) {

                    var fieldValue = formObject[field];

                    if (field.indexOf("propSheet/") === 0) {
                        //We only check that a value has been set
                        if (fieldValue && (fieldValue && fieldValue !== "")) {
                           props[field.replace("propSheet/", "")] = fieldValue;
                        }
                    }
                }
            }
            return props;
        },

        checkUnlessValues: function(fieldData) {
            if(!fieldData.unless || fieldData.unless === "") {
                return true;
            }
            return !this.checkForPrerequisitesOrUnless(fieldData, false);
        },
        
        /**
        * Check for prerequisite when building the new Plugin UI
        */
        checkForPrerequisites: function(fieldData) {
            return this.checkForPrerequisitesOrUnless(fieldData, true);
        },
        
        /**
        * Check for prerequisite when building the new Plugin UI
        */
        checkForPrerequisitesOrUnless: function(fieldData, isPrereq) {
            var _this = this;
            var display = true;
            
            var hasProp;
            
            if(isPrereq) {
                hasProp = fieldData.prerequisites;
            }
            else {
                hasProp = fieldData.unless;
            }
            //Does that field has prerequisites
            if (!!hasProp) {
                //prerequisites are separated by commas
                var props = hasProp.split(",");

                //Lets iterate through all fields in the form
                var formObject = _this.form.getValues();

                var field;
                var fieldIsEmpty = false;
                
                for (field in _this.form.getValues()) {
                    if (_this.form.getValues().hasOwnProperty(field)) {

                        var i;
                        for (i in props) {
                            if (props.hasOwnProperty(i)) {
                                //If the field does not even exist yet
                                if (!formObject["propSheet/"+props[i]]) {
                                    display = false;
                                }
                                else if (field === "propSheet/"+props[i]) {
                                    var fieldValue = formObject[field];
                                    //We only check that a value has been set
                                    if (!fieldValue || (fieldValue && fieldValue === "")) {
                                        display = false;
                                        fieldIsEmpty = true;
                                    }
                                }
                            }
                        }
                    }
                }

                if(!fieldIsEmpty && !display) {
                    var properties = _this.model.get("properties");
                    var property;
                    
                    for (property in properties) {
                        if (properties.hasOwnProperty(property)) {
                            if (!!properties[property]) {
                                var j;
                                for (j in props) {
                                    if (props.hasOwnProperty(j)) {
                                        if(property === props[j]) {
                                            if(properties[property] !== null || properties[property] !== "") {
                                                display = true;
                                            }
                                            else {
                                                return false;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            return display;
        },

        checkConnection: function(){

            var _this = this;
            var statusButtonEvent;
            var errorMessage;

            if (_this.connectionButtonBlock) {
                domConstruct.destroy(_this.connectionButtonBlock);
            }
            _this.connectionButtonBlock = domConstruct.create("div", {
                className: "inline-block"
            }, _this.applyButtonContainer);
            var loading = domConstruct.create("div", {
                "class": "loading-spinner"
            }, _this.connectionButtonBlock);

            xhr.get(uReleaseConfig.urls.base+"integrationProvider/"+_this.model.get("id")+"/checkConnection",{
                handleAs: "json"
            }).then(function(result) {

                var statusButton;

                  if (!result.error) {
                    statusButton = domConstruct.create("div", {
                        className: "inline-block"
                    },_this.connectionButtonBlock);
                    domConstruct.create("div", {
                        className: "inline-block integration-status-icon success"
                    }, statusButton);
                    domConstruct.create("div", {
                        className: "inline-block integration-icon-label",
                        innerHTML: i18n("Connection Successful")
                    }, statusButton);
                    domConstruct.destroy(loading);

                    //If we click on connection lets refresh the fields since we have saved
                    //the model
                    if (_this.integrationType) {
                        _this.doOnFieldChanged(_this.integrationType);
                    }
                }
                else {
                    var errorAlert;
                    statusButton = domConstruct.create("a", {
                        className: "inline-block"
                    }, _this.connectionButtonBlock);
                    domConstruct.create("div", {
                        className: "inline-block integration-status-icon failed"
                    }, statusButton);
                    domConstruct.create("div", {
                        className: "inline-block integration-icon-label",
                        innerHTML: i18n("Connection Failed - Click for details")
                    }, statusButton);
                    domConstruct.destroy(loading);

                    if (statusButtonEvent) {
                        statusButtonEvent.remove();
                    }

                    statusButtonEvent = on(statusButton, "click", function() {
                        if (!errorAlert) {
                            errorAlert = new Dialog();

                            var helpMessage = "";
                            errorMessage = result.error;
                            errorMessage = "<br /><br /><span style=\"font-weight: bold;\">" +
                                i18n("Error details:") + "</span><br /><br />"+errorMessage;
                            var instructionMessage = "";

                            domConstruct.create("div", {
                                innerHTML: i18n("Connection Failed")
                            }, errorAlert.titleNode);

                            if (result.helpItems) {
                                helpMessage = "<br /><br /><span style=\"font-weight: bold;\">" +
                                i18n("Our guess:") + "</span><br /><br />";

                                helpMessage += "<ul>";
                                var helpItems = json.parse(result.helpItems);
                                array.forEach(helpItems, function(help) {
                                    helpMessage += "<li> "+help.text+"</li>";
                                });
                                helpMessage += "</ul>";
                            }

                            domConstruct.create("div", {
                                innerHTML: instructionMessage+errorMessage+helpMessage
                            }, errorAlert.containerNode);
                        }
                       errorAlert.show();
                    });
                }
            });
        },

        /*--- RTC INTEGRATION ---*/
        //Apply configuration and reload the Mapping
        applyConfigurationChanges: function(reload) {
            var _this = this, propertyName;

            var submittedValues = _this.form.getValues();

            if (_this.validateFields(submittedValues)) {
                for (propertyName in submittedValues) {
                    if (submittedValues.hasOwnProperty(propertyName)) {
                        var value = submittedValues[propertyName];

                        // This annoying hack will convert results from checkboxes (an array
                        // of one element) to a simple boolean.
                        if (lang.isArray(value)) {
                            if (value.length === 1) {
                                if (typeof value[0] === "boolean" || value[0] === "on" || value[0] === "true") {
                                    value = value[0];
                                }
                            }
                            else if (value.length === 0) {
                                value = false;
                            }
                        }

                        _this.model.set(propertyName, value);
                    }
                }

                if (_this.integrationSelect.value.indexOf("com.urbancode.urelease.domain.integration.plugin.PluginIntegrationProvider") === 0){
                    _this.model.set("integrationType", "com.urbancode.urelease.domain.integration.plugin.PluginIntegrationProvider");
                    _this.integrationPlugin = _this.model.get("integrationPlugin");
                    _this.model.set("integrationPlugin",null);
                }


                _this.model.save().then(function(error) {
                    if (_this.integrationSelect.value.indexOf("com.urbancode.urelease.domain.integration.plugin.PluginIntegrationProvider") === 0) {
                        if (_this.pluginIntegrationName) {
                            _this.model.set("integrationType", _this.pluginIntegrationName);
                        }
                    }

                    _this.checkConnection();
                });
            }

        },

        //Apply Changes
        applyChanges: function() {

            var _this = this,
                propertyName,
                deferred = new Deferred();

            var submittedValues = _this.form.getValues();
            if (_this.validateFields(submittedValues)) {
                for (propertyName in submittedValues) {
                    if (submittedValues.hasOwnProperty(propertyName)) {
                        var value = submittedValues[propertyName];

                        // This annoying hack will convert results from checkboxes (an array
                        // of one element) to a simple boolean.
                        if (lang.isArray(value)) {
                            if (value.length === 1) {
                                if (typeof value[0] === "boolean" || value[0] === "on" || value[0] === "true") {
                                    value = value[0];
                                }
                            }
                            else if (value.length === 0) {
                                value = false;
                            }
                        }
                        _this.model.set(propertyName, value);
                    }
                }

                if (_this.integrationSelect.value.indexOf("com.urbancode.urelease.domain.integration.plugin.PluginIntegrationProvider") === 0){
                    _this.integrationType = _this.model.get("integrationType");

                    _this.model.set("integrationType", "com.urbancode.urelease.domain.integration.plugin.PluginIntegrationProvider");
                    _this.integrationPlugin = _this.model.get("integrationPlugin");
                    _this.model.set("integrationPlugin", null);
                }
                
                if(!_this.model.get("plugin") && !!_this.model.get("integrationPlugin") && !!_this.model.get("integrationPlugin").plugin) {
                    _this.model.set("plugin", _this.model.get("integrationPlugin").plugin);
                }

                deferred = _this.model.save();
            }
            return deferred.promise;
        },

        //Display the project area selection
        showProjectArea: function() {
            var _this = this;
            this.projectAreaBlock = domConstruct.create("div", {
            }, _this.oslcContainer);

            var title = domConstruct.create("h1", {
                innerHTML: i18n("Mapping")
            }, _this.projectAreaBlock);

            var loading = domConstruct.create("div", {
                "class": "loading-spinner"
            }, _this.projectAreaBlock);

            xhr.get(uReleaseConfig.urls.base+"integrationProvider/"+_this.model.get("id")+"/oslcProjects",{
                handleAs: "json"
            }).then(function(projectData) {
                _this.resetConnectButton();

                if (!projectData.error) {
                    projectData.projects.splice(0, 0, {
                        label: i18n("No Project Area Selected"),
                        value: "NONE_VALUE"
                     });

                    if (!_this.collapsed){
                        var fieldName = "propSheet/oslcProjectArea";
                        var projectArea = _this.createExtraFieldRow({
                            label: i18n("Select the Project Area"),
                            name: fieldName,
                            className: "project-area-select",
                            type: "Select",
                            allowedValues: projectData.projects,
                            value: _this.model.get("propSheet/oslcProjectArea"),
                            onChange: function(value) {
                                //We delete all mapping if the project Area changes
                                _this.cleanupMapping = true;
                                _this.applyConfigurationChanges();
                            }
                        });
                        domConstruct.place(projectArea, _this.projectAreaBlock);

                    }

                }
                else {
                    var instructionMessage = "";
                    var helpMessage = "";
                    var errorAlert;

                    if (projectData.helpItems) {
                        helpMessage = "<br /><br /><span style=\"font-weight: bold;\">" + i18n("Our guess:") + "</span><br /><br />";
                        helpMessage += "<ul>";
                        var helpItems = json.parse(projectData.helpItems);
                        array.forEach(helpItems, function(help) {
                            helpMessage += "<li>- "+help.text+"</li>";
                        });
                        helpMessage += "</ul>";
                    }

                    var errorMessage = "<br /><span style=\"font-weight: bold;\">" + i18n("Error:") + "</span><br />";

                    errorMessage += "<span style=\"font-weight: bold;color: red;\">"+projectData.error+"</span>";

                    errorAlert = new Dialog();

                    domConstruct.create("div", {
                        innerHTML: i18n("An error occured trying to connect to the RTC Server")
                    }, errorAlert.titleNode);

                    domConstruct.create("div", {
                        innerHTML: instructionMessage+errorMessage+helpMessage
                    }, errorAlert.containerNode);

                    errorAlert.show();
                }
                domConstruct.destroy(loading);

            },function ()  {
                _this.resetConnectButton();
            });
        },

        resetConnectButton: function () {
            this.applyButton.set("disabled", false);
            this.applyButton.set("label", i18n("Connect"));
        },

        /**
         * builds a frame-section to show ui for handling one aspect of an integration
         * @param translatedTitle the title of the frame (assumes this is already translated)
         * @param translatedDescription the description of the frame (assumes this is already translated)
         * @param populationCallback the method to execute in order to populate the new frame
         * @param additionalClasses classes to add to the frame in addition to its base classes.
         */
        buildFrame: function (translatedTitle, translatedDescription, populationCallback, additionalClasses) {
            var _this = this;

            var section = domConstruct.create("div", {
                className: "mapping-section " + (additionalClasses || "")
            }, _this.oslcContainer);

            var title = domConstruct.create("h2", {
                innerHTML: translatedTitle
            }, section);

            var info = domConstruct.create("p", {
                innerHTML: translatedDescription
            }, section);

            var frameContent = domConstruct.create("div", {
                className: "mapping-table-container"
            }, section);

            populationCallback.call(_this, frameContent);
        },

        //This method saves a PropValue when an item has been selected
        addPropValue: function(name,value){
            var _this = this;
            var propValue = {"integrationProviderId": _this.model.resourceId,"property": name,"value": value};
                xhr.post(uReleaseConfig.urls.base+"integrationProvider/addPropValue",{
                data: propValue,
                handleAs: "json"}).then(function(data) {
                    if (value === "NONE_VALUE") {
                        if (_this.model.get("propSheet/"+name)) {
                            _this.model.removeProperty("propSheet/"+name);
                        }
                    }
                    else {
                        if (!_this.model.get("propSheet/"+name)) {
                            _this.model.addProperty("propSheet/"+name,value);
                        }
                        else {
                            _this.model.set("propSheet/"+name, value);
                        }
                    }
                },
                function(error){
                    var errorAlert = new Alert({
                        message: i18n("Can not save this mapping ")
                   });
                });
        },

        //This method deletes all items related to this Integration Provider
        resetAll: function(){
            var _this = this;
            var header = {"integrationProviderId": _this.model.resourceId};
                xhr.del(uReleaseConfig.urls.base+"integrationProvider/deleteAll", {
                data: header,
                handleAs: "json"}).then(function(data) {

                },
                function(error){
                    var errorAlert = new Alert({
                        message: i18n("Can not reset the Integration Provider")
                   });
                });
        },

        applyFilter: function(childNodes, filter){
            array.forEach(childNodes, function(node){
                domClass.remove(node, "hidden");
                var filterValue = node.children[1].innerHTML;
                if (filter && filterValue){
                    var compare = filterValue.toLowerCase().indexOf(filter.toLowerCase());
                    if (compare === -1){
                        domClass.add(node, "hidden");
                    }
                }
            });
        },

        /**
         *
         */
        hideEdit: function() {
            this.collapsed = true;
            if (this && this.editAttach && this.viewAttach && this.buttonAttach){
                if (this.domNode){
                    domClass.remove(this.domNode, "resource-expanded");
                    domClass.add(this.domNode, "resource-collapsed");
                }
                domConstruct.empty(this.applyButtonAttach);
                domConstruct.empty(this.editAttach);
                domConstruct.empty(this.viewAttach);

                if (this.saveButtonAttach){
                    domConstruct.empty(this.saveButtonAttach);
                }
                if (this.cancelButtonAttach){
                    domConstruct.empty(this.cancelButtonAttach);
                }
                this.refresh();
            }
        },

        preSave: function() {

            this.inherited(arguments);
            var _this = this;
            //The controller is expecting the type of the integration and not the unique name for that plugin
            if (_this.integrationSelect.value.indexOf("com.urbancode.urelease.domain.integration.plugin.PluginIntegrationProvider") === 0){
                _this.integrationType = _this.model.get("integrationPlugin");

                _this.model.set("integrationType", "com.urbancode.urelease.domain.integration.plugin.PluginIntegrationProvider");
                _this.integrationPlugin = _this.model.get("integrationPlugin");
                _this.model.set("integrationPlugin", null);
            }
            
            if(!_this.model.get("plugin")) {
                if(!!_this.model.get("integrationPlugin")) {
                    _this.model.set("plugin", _this.model.get("integrationPlugin").plugin);
                    _this.model.set("pluginVersion", _this.model.get("integrationPlugin").plugin);
                }
            }
            
            array.forEach(this.initiativeMappingFieldNames, function(fieldName) {
                if (_this.model.get(fieldName) === "NONE_VALUE") {
                    _this.model.set(fieldName, null);
                }
            });
        },

        postCancel: function () {
            var _this = this;
            //We can not reset if the model has just been created and has no original
            if (_this.model.cleanServiceData && _this.model.cleanServiceData.id) {
                _this.model.reset();
            }
        },

        postSave: function() {
            this.inherited(arguments);
            var _this = this;
            if (_this.integrationSelect.value) {
                //We reset the unique name after it has been sent to be saved with the generic name
                _this.model.set("integrationType", _this.integrationSelect.value);
            }
        }
    });
});
