/** Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Release
* (c) Copyright IBM Corporation 2011, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
/*global define, uReleaseConfig, util, i18n */
define([
    "dojo/_base/declare",
    "dojo/_base/array",
    "dojo/request/xhr"
], function(
    declare,
    array,
    xhr

) {

        /**
          HttpFilterableCheckedMultiSelect
         * @see app/widgets/select/FilterableCheckedMultiSelect
         * provides a multi select checkbox, with a text box above it.  Options in the multi-select
         * {
         *
         *  CONSTRUCTOR ARGUMENTS:
         *  name: {String} the html name attribute of the CheckedMultiSelect, used if this widget is submitted with a form.
         *  multiple: {Boolean} whether or not multiple items can be selected at once.
         *  placeHolderText: {String} the title text of the type of thing that we are filtering, literally shows up as "Filter {placeHolderText}"
         *  onChange: {Function} a function to be fired whenever
         *
         *  EXISTING PROPERTIES AND METHODS:
         *  defaultQuery: {object} list of key pair parameters that will be added to the request {key:"", value:""}
         *  addOption(Object|Array): a single option or list of options of the form {label:"", value:""}
         *
         */
    return declare("app/widgets/_FilterableCheckedMultiSelectHttpMixin", [],{

        /**
         * the base classname of the widget
         */
        uri:"",
        uris:"",

        defaultQuery: null,
        allowNone: false,

        getLabel: function (item) {
            // assume that we are dealing with a resource, but allow it to be a simple list
            // of objects containing label and value
            return item.name || item.label;
        },
        getValue: function (item) {
            // assume that we are dealing with a resource, but allow it to be a simple list
            // of objects containing label and value
            return item.id || item.value;
        },
        postCreate: function () {
            this.inherited(arguments);
            this.useStandby();
            this.loadForUris();

        },

        //method that rebuild the list of options and marks
        //a value as selected
        refreshValue: function (value) {
            var optionList = this.getOptions();
            this.removeOption(this.getOptions());

            var _this = this;
            var options = [];
            array.forEach(optionList, function (item) {
                options.push({
                    label: _this.getLabel(item),
                    value: _this.getValue(item),
                    selected: (_this.getValue(item) === value)
                });
            });

            // do show options must be implemented by the class intending
            // to show the result of the xhr-generated option list
            this.doShowOptions(options);
        },

        loadForUris: function () {
            if(this.uri && this.uris) {
                throw new Error(this.declaredClass + " is meant to be used either with an array of URIs or a single URI.  Not both.");
            }
            // prefer uris over uri
            if(this.uris) {
                array.forEach(this.uris, function (uri) {
                    this.loadOptions(uri);
                });
            } else if (this.uri) {
                this.loadOptions(this.uri, this.defaultQuery);
            }
        },
        /**
         * load the options list from the server
         * assumes that the result will be a json array at the top.
         */
        loadOptions: function (uri, defaultQuery) {
            var _this = this;
            this.standby.show();
            xhr.get(uri, {
                handleAs: "json",
                query: defaultQuery
            }).then(function (data) {
                _this.buildOptions(data);
                _this.standby.hide();
            });

        },
        /**
         *
         */
        buildOptions: function (jsonArray) {
            var _this = this;
            var options = [];

            var noneItem = {
                label: i18n("None"),
                value: "NONE_VALUE",
                type: "none-value"
            };
            if (this.allowNone){
                options.push(noneItem);
            }

            array.forEach(jsonArray, function (item) {
                options.push({
                    label: _this.getLabel(item),
                    value: _this.getValue(item)
                });
            });

            // do show options must be implemented by the class intending
            // to show the result of the xhr-generated option list
            this.doShowOptions(options);
        },
        doShowOptions: function (options, name) {
            this.inherited(arguments);
        }

    });
});
