/** Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Release
* (c) Copyright IBM Corporation 2015 All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
define([
    "dojo/_base/declare",
    "dojo/_base/array",
    "dojo/request/xhr",
    "app/widgets/select/WebextSelectMemory"
], function(
    declare,
    array,
    xhr,
    WebextSelectMemory
) {
    return declare("app/widgets/select/WebextSelectXhrMemory", [WebextSelectMemory],{
        /*************************************************************
         * PUBLIC PROPERTIES AND METHODS
         *************************************************************/

        /**
         * the target endpoint from which to gather data for the select.
         */
        target: null,
        /**
         * Should there be an option for allowing all (really allow none).
         */
        allowAll: false,
        /**
         * Should there be an option for allowing all (really allow none).
         */
        allowAllLabel: i18n("All"),


        /*************************************************************
         * PRIVATE PROPERTIES AND METHODS
         *************************************************************/

        /**
         *
         */
        postCreate: function () {
            // xhr selects will get their data from a request.
            delete this._storeConfig.data;

            // continue with normal building of the widget,
            // based on the now-modified _storeConfig
            this.inherited(arguments);

        },

        /**
         * set values in a local Momery store from a rest request.
         * this method relies on having target set on a store, even if it is a Memory
         */
        _populateStore: function () {
            var _this = this;
            var allOption = {
                name: _this.allowAllLabel,
                id: "-1",
                isAllOption: true,
                actualName: this.allowAllLabel,
                displayName: this.allowAllLabel
            };
            if (_this.allowAll) {
                // if a all-option is allowed
                _this.store.add(allOption);
            }
            xhr.get(this.target, {
                "headers":{
                    "Accept":"application/json"
                },
                "query": this.defaultQuery,
                "handleAs": "json"
            }).then(function (data) {
                array.forEach(data, function (datum) {
                    _this.store.add(datum);
                });
                // Check that current assigned user exists in current role
                var currentUsersInRole = array.filter(_this.store.data, function(datum) {
                    return datum.id === _this.value;
                });
                // If assigned user has been removed from role
                // Still display current user
                // Do not include user in select list
                if (currentUsersInRole.length === 0) {
                  _this.set('displayedValue', _this.displayedName);
                }
                // set our select's value to be what it is supposed to be,
                // now that we have data to reference.
                if(!!_this.value) {
                    _this.set('value', _this.value);
                }
                else {
                    _this.set('value', allOption.id);
                }
            });

            // default query will interfere with Memory stores.
            // See definition at top of widget.
            // We delete here, since this method's implementation is
            // specific to Memory (see right above).
            delete this.defaultQuery;
        }
    });
});
