/** Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Release
* (c) Copyright IBM Corporation 2015 All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
define([
    "dojo/_base/declare",
    "dojo/store/Memory",
    "js/webext/widgets/select/WebextSelect"
], function(
    declare,
    Memory,
    WebextSelect
) {
    return declare("app/widgets/select/WebextSelectMemory", [WebextSelect],{
        /*************************************************************
         * PUBLIC PROPERTIES AND METHODS
         *************************************************************/
        /**
         * @see WebextSelect
         */
        queryExpr: "*${0}*",

        /**
         * @see WebextSelect.  In this case the default query is used with the xhr request.
         * Note that defaultQuery will actually prevent a Memory store from returning results
         * since the defaultQuery is sent as criteria on results without any xhr request.
         * Therefore, we delete this property after we use it to set the initial value of
         * the Memory.
         */
        defaultQuery: null,

        /**
         * the data with which to populate the store.
         */
        data:null,


        /*************************************************************
         * PRIVATE PROPERTIES AND METHODS
         *************************************************************/

        /**
         * The base configuration for the store.
         */
        _storeConfig : {
                data: this.data,
                defaultQuery:this.defaultQuery,
                idProperty: this.idProperty || "id",
                remove: function () {
                    //no-op (read-only)
                }
        },

        /**
         * postCreate
         */
        postCreate: function () {
            this._handleCompatabilityWithRestSelect();
            this._buildStore();
            this._populateStore();

            // continue with normal WebextSelect setup.
            this.inherited(arguments);
        },

        /**
         * attempt to gracefully use some RestSelect properties
         * TODO: remove this method during build process.
         */
        _handleCompatabilityWithRestSelect: function () {
            // set properties to be backwards compatible with RestSelect.
            if (this.restUrl) {
                throw new Error({
                    name: "No Such Property",
                    message: "WebextSelectMemory does not support restUrl.  use url"
                });
            }
            if (this.existingValueLabel) {
                throw new Error({
                    name: "No Such Property",
                    message: "WebextSelect does not support existinValueLabel.  use displayValue (cannot be used in conjunction with value)"
                });
            }
            // note that we drop the noneLabel, because the equivalent is an empty text box.

            // there's no way to translate the getLabel and getValue methods to the property
            // strings of the new widget, so just blow up and tell the devloper what they
            // need to change
            if (this.getLabel || this.getValue) {
                throw new Error({
                    name: "No Such Method",
                    message: "WebextSelect does not support getLabel or getValue." +
                    "Use the `searchAttr:String` and `idProperty:String` properties instead"});
            }
        },

        /**
         * build the store that will back the WebextSelect
         */
        _buildStore: function () {
            this.store = new Memory(this._storeConfig);
        },

        /**
         * set values in a local Momery store from a rest request.
         * this method relies on having target set on a store, even if it is a Memory
         */
        _populateStore: function () {
            // no-op.  Store should be populated from data property.
        }
    });
});
