/** Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Release
* (c) Copyright IBM Corporation 2015. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
define([
    "dojo/_base/declare",
    "dojo/store/JsonRest",
    "app/widgets/select/WebextSelectMemory"
], function(
    declare,
    JsonRest,
    WebextSelectMemory
) {
    return declare("app/widgets/select/WebextSelectJson", [WebextSelectMemory], {
        /*************************************************************
         * PUBLIC PROPERTIES AND METHODS
         *************************************************************/

        /*************************************************************
         * PRIVATE PROPERTIES AND METHODS
         *************************************************************/

        /**
         *
         */
        postCreate: function () {
            // data is gathered from a JsonRest, not local data.
            delete this._storeConfig.data;

            // continue with normal building of the widget,
            // based on the now-modified _storeConfig
            this.inherited(arguments);

        },

        /**
         *
         */
        _buildStore: function () {
            // configure JsonRest specific store properties
            this._storeConfig.target = this.target;

            // make sure that even if the widget was instantiated with
            // data, it is erased, so we don't see a different data
            // set flicker while the store is loading.
            this._storeConfig.data = null;

            // build store.
            this.store = new JsonRest(this._storeConfig);
        }
    });
});
