/** Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Release
* (c) Copyright IBM Corporation 2011, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
/*global define, uReleaseConfig, util, i18n */
define([
    "dojo/_base/declare",
    "app/widgets/select/HttpFilterableCheckedMultiSelect",
    "app/widgets/select/HttpFilterableMultipleListCheckedMultiSelect",
    "app/widgets/select/FilterableCheckedMultiSelect",
    "app/widgets/UReleaseWidget",
    "dojo/dom-construct",
    "dojo/request/xhr",
    "js/webext/widgets/Alert"
], function(
    declare,
    HttpFilterableCheckedMultiSelect,
    HttpFilterableMultipleListCheckedMultiSelect,
    FilterableCheckedMultiSelect,
    UReleaseWidget,
    domConstruct,
    xhr,
    Alert
) {

        /**
          MappingBox
         * provides an onlyOneSelect mapping widget with a text box above it and a filter
         * {
         *
         *  CONSTRUCTOR ARGUMENTS:
         *  propName: {String} the html name attribute of the CheckedMultiSelect, used if this widget is submitted with a form.
         *  title: {String} A title that will be displayed at the top of the conatiner
         *  description: {String} A description that will be displayed under the title
         *  masterUIField: {PropDef} propDef that will be used to create the master field
         *  slaveUIField: {PropDef} propDef that will be used to create the slave field
         *
         * Master and Slave fields can be either: HTTP_CHECKED_MULTI_SELECT, SCRIPTED_CHECKED_MULTI_SELECT
         *
         * SCRIPTED_CHECKED_MULTI_SELECT - Properties are resolved from a plugin step after the widget is displayed
         * HTTP_CHECKED_MULTI_SELECT - Properties are resolved from an external rest end point after the widget is displayed
         *
         * CHECKED_MULTI_SELECT - Properties are hard coded in the plugin.xml
         */
    return declare("app/widgets/select/MappingBox", [UReleaseWidget],{
        templateString:"<div>" +
                "<div data-dojo-attach-point=\"mappingContainer\"></div>" +
                 "</div>",
        name: null,
        title: null,
        propName: null,
        description: null,
        masterUIField:null,
        slaveUIField:null,
        model: null,
        postCreate: function () {
            var _this = this;

            var mappingSection = domConstruct.create("div", {
                className: "mapping-section release-mapping"
            }, _this.mappingContainer);

            var title = domConstruct.create("h2", {
                innerHTML: _this.title
            }, mappingSection);

            var info = domConstruct.create("p", {
                innerHTML: _this.description
            }, mappingSection);

            _this.mappingFrame = domConstruct.create("div", {
                className: "mapping-table-container"
            }, mappingSection);

            var leftBoxListFrame = domConstruct.create("div", {
                className: "inline-block mapping-table"
            }, _this.mappingFrame);

            var leftBoxFrame = domConstruct.create("div", {className: "mapping-table-inner"}, leftBoxListFrame);

            var leftBoxTitle = domConstruct.create("div", {
                className:  "resource-header select-title",
                innerHTML: _this.masterUIField.propDef.label+" - "+_this.masterUIField.description
            }, leftBoxFrame);

            var leftBoxBlockFrame = domConstruct.create("div", {}, leftBoxFrame);

            var leftBoxBlock = domConstruct.create("div", {
                className: "dijit dijitReset dijitInline dijitLeft dojoxCheckedMultiSelect"
            }, leftBoxBlockFrame);

            var rightBoxListFrame = domConstruct.create("div", {
                className: "inline-block mapping-table"
            }, _this.mappingFrame);

            var rightBoxFrame = domConstruct.create("div", {className: "mapping-table-inner"}, rightBoxListFrame);

            var rightBoxTitle = domConstruct.create("div", {
                className:  "resource-header select-title",
                innerHTML: _this.slaveUIField.propDef.label+" - "+_this.slaveUIField.description
            }, rightBoxFrame);


            var rightBoxBlockFrame = domConstruct.create("div", {}, rightBoxFrame);

            var rightBoxBlock = domConstruct.create("div", {
                className: "dijit dijitReset dijitInline dijitLeft dojoxCheckedMultiSelect"
            }, rightBoxBlockFrame);

//            console.debug(_this.masterUIField.propDef.typeName);
            if (_this.masterUIField.propDef.typeName === "HTTP_CHECKED_MULTI_SELECT"
                || _this.masterUIField.propDef.typeName === "SCRIPTED_CHECKED_MULTI_SELECT") {

                _this.masterList = new HttpFilterableCheckedMultiSelect({
                    uri:_this.masterUIField.resolveHttpValuesUrl,
                    defaultQuery: _this.masterUIField.propDef.defaultQuery,
                    multiple:false,
                    onChange: function (value) {
                        _this.selectedMasterValue = value;

                        //We want to make sure that the first list is loaded before we loads the 2nd one
                        //This way we can set the values already saved for the first item
                        if (!_this.loaded) {
                            _this.loaded = true;

                            if (_this.slaveUIField.propDef.typeName === "CHECKED_MULTI_SELECT") {
                                _this.slaveList = _this.createSlaveFilterableCheckedMultiSelect();
                            } else if (_this.slaveUIField.propDef.typeName === "HTTP_CHECKED_MULTI_SELECT"
                                || _this.slaveUIField.propDef.typeName === "SCRIPTED_CHECKED_MULTI_SELECT") {
                                _this.slaveList = _this.createSlaveHttpFilterableCheckedMultiSelect(_this.slaveUIField.resolveHttpValuesUrl);
                            }
                            _this.slaveList.placeAt(rightBoxBlock);
                        }

                        if (_this.slaveList) {
                            var selectedValue = "NONE_VALUE";
                            if (_this.model.get("propSheet/"+_this.propName+":"+value)) {
                                selectedValue = _this.model.get("propSheet/"+_this.propName+":"+value);
                            }
                            _this.slaveList.refreshValue(selectedValue);
                        }
                    }
                });
            }
            else if (_this.masterUIField.propDef.typeName === "CHECKED_MULTI_SELECT"){
                _this.masterList = new FilterableCheckedMultiSelect({
                    multiple:false,
                    defaultQuery: _this.masterUIField.propDef.defaultQuery,
                    onChange: function (value) {
                        if(value.length === 0) {
                            value = "NONE_VALUE";
                        }
                        _this.selectedMasterValue = value;
                        //We want to make sure that the first list is loaded before we loads the 2nd one
                        //This way we can set the values already saved for the first item
                        if (!_this.loaded) {
                            _this.loaded = true;

                            if (_this.slaveUIField.propDef.typeName === "CHECKED_MULTI_SELECT") {
                                _this.slaveList = _this.createSlaveFilterableCheckedMultiSelect();
                            } else if (_this.slaveUIField.propDef.typeName === "HTTP_CHECKED_MULTI_SELECT"
                                || _this.slaveUIField.propDef.typeName === "SCRIPTED_CHECKED_MULTI_SELECT") {
                                _this.slaveList = _this.createSlaveHttpFilterableCheckedMultiSelect(_this.slaveUIField.resolveHttpValuesUrl);
                            }
                            _this.slaveList.placeAt(rightBoxBlock);
                        }

                        if (_this.slaveList) {
                            var selectedValue = "NONE_VALUE";
                            if (_this.model.get("propSheet/"+_this.propName+":"+value)) {
                                selectedValue = _this.model.get("propSheet/"+_this.propName+":"+value);
                            }
                            _this.slaveList.refreshValue(selectedValue);
                        }
                    }
                });

                _this.masterList.addOption(_this.slaveUIField.propDef.allowedValues);
            }
            this.masterList.placeAt(leftBoxBlock);
        },

        _valueGetter: function () {
            var _this = this;
            return _this.selectedMasterValue;
        },

        createSlaveHttpFilterableCheckedMultiSelect: function (resolveHttpValuesUrl) {
            var _this = this;
            var httpFilterableCheckedMultiSelect = new HttpFilterableCheckedMultiSelect({
                multiple:false,
                uri: resolveHttpValuesUrl,
                defaultQuery: _this.masterUIField.propDef.defaultQuery,
                allowNone: true,
                onChange: function (value) {
                    //The first time the widget is loaded we want to set the value of the masterItem selected by default
                    if (!_this.firstResultLoaded) {
                        _this.firstResultLoaded = true;
                        var selectedValue = "NONE_VALUE";
                        if (_this.model.get("propSheet/"+_this.propName+":"+_this.selectedMasterValue)) {
                            selectedValue = _this.model.get("propSheet/"+_this.propName+":"+_this.selectedMasterValue);
                        }
                        _this.slaveList.refreshValue(selectedValue);
                    } else {
                        this.value = value;
                        var prop = _this.selectedMasterValue;
                         _this.saveValue(prop,value);
                    }
                }
            });

            return httpFilterableCheckedMultiSelect;
        },

        createSlaveFilterableCheckedMultiSelect: function () {
            var _this = this;
            var filterableCheckedMultiSelect = new FilterableCheckedMultiSelect({
                multiple:false,
                defaultQuery: _this.masterUIField.propDef.defaultQuery,
                onChange: function(value) {
                    if(value.length === 0) {
                            value = "NONE_VALUE";
                     }

                    if (!_this.firstResultLoaded) {
                        _this.firstResultLoaded = true;
                        if (_this.model.get("propSheet/"+_this.propName+":"+_this.selectedMasterValue)) {
                            _this.slaveList.refreshValue(_this.model.get("propSheet/"+_this.propName+":"+_this.selectedMasterValue));
                        }
                    } else {
                        this.value = value;
                        var prop = _this.selectedMasterValue;
                         _this.saveValue(prop,value);
                    }
                }
            });
            filterableCheckedMultiSelect.addOption(_this.slaveUIField.propDef.allowedValues);

            return filterableCheckedMultiSelect;
        },


        //This method saves a PropValue when an item has been selected
        saveValue: function(name,value){
            var _this = this;
            name = _this.propName+":"+name;
            if (!_this.model.get("propSheet/"+name)) {
                _this.model.addProperty("propSheet/"+name,value);
            }
            else {
                _this.model.set("propSheet/"+name, value);
            }
        /*    var _this = this;
            name = _this.propName+":"+name;
            var propValue = {"integrationProviderId": _this.model.get("id"),"property": name,"value": value};
                xhr.post(uReleaseConfig.urls.base+"integrationProvider/addPropValue",{
                data: propValue,
                handleAs: "json"}).then(function(data) {
                if (value === "NONE_VALUE") {
                    if (_this.model.get("propSheet/"+name)) {
                        _this.model.removeProperty("propSheet/"+name);
                    }
                }
                else {
                    if (!_this.model.get("propSheet/"+name)) {
                        _this.model.addProperty("propSheet/"+name,value);
                    }
                    else {
                        _this.model.set("propSheet/"+name, value);
                    }
                }
            },
            function(error){
                var errorAlert = new Alert({
                    message: i18n("Can not save this mapping ")
               });
            });*/
        }
    });
});
