/** Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Release
* (c) Copyright IBM Corporation 2011, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
/*global define, uReleaseConfig, util, i18n */
define([
    "dojo/_base/declare",
    "app/widgets/select/FilterableMultipleListCheckedMultiSelect",
    "app/widgets/select/_FilterableCheckedMultiSelectHttpMixin"

], function(
    declare,
    FilterableMultipleListCheckedMultiSelect,
    _FilterableCheckedMultiSelectHttpMixin
) {

        /**
          FilterableCheckedMultiSelect
         * provides a multi select checkbox, with a text box above it.  Options in the multi-select
         * {
         *
         *  CONSTRUCTOR ARGUMENTS:
         *  name: {String} the html name attribute of the CheckedMultiSelect, used if this widget is submitted with a form.
         *  multiple: {Boolean} whether or not multiple items can be selected at once.
         *  placeHolderText: {String} the title text of the type of thing that we are filtering, literally shows up as "Filter {placeHolderText}"
         *  onChange: {Function} a function to be fired whenever
         *
         *  EXISTING PROPERTIES AND METHODS:
         *  addOption(Object|Array): a single option or list of options of the form {label:"", value:""}
         *
         */
    return declare("app/widgets/HttpFilterableMultipleListCheckedMultiSelect",
        [ FilterableMultipleListCheckedMultiSelect, _FilterableCheckedMultiSelectHttpMixin ],{
            doShowOptions: function (options) {
                // TODO find a way to get both a list name and list contents from the xhr
                // request so that we can support loading multiple, different lists
                if(this.multipleLists) {
                    throw new Error('support for multiple http requests for separate lists has not yet been implemented.');
                }
                this.setList('masterList', options);
        }
    });
});
