/** Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Release
* (c) Copyright IBM Corporation 2011, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
/*global define, uReleaseConfig, util, i18n */
define([
    "dojo/_base/declare",
    "app/widgets/select/FilterableCheckedMultiSelect",
    "app/widgets/select/_FilterableCheckedMultiSelectHttpMixin",
    "dojo/_base/array"

], function(
    declare,
    FilterableCheckedMultiSelect,
    _FilterableCheckedMultiSelectHttpMixin,
    array
) {

        /**
          FilterableCheckedMultiSelect
         * provides a multi select checkbox, with a text box above it.  Options in the multi-select
         * {
         *
         *  CONSTRUCTOR ARGUMENTS:
         *  name: {String} the html name attribute of the CheckedMultiSelect, used if this widget is submitted with a form.
         *  multiple: {Boolean} whether or not multiple items can be selected at once.
         *  placeHolderText: {String} the title text of the type of thing that we are filtering, literally shows up as "Filter {placeHolderText}"
         *  onChange: {Function} a function to be fired whenever
         *
         *  EXISTING PROPERTIES AND METHODS:
         *  addOption(Object|Array): a single option or list of options of the form {label:"", value:""}
         *
         */
    return declare("app/widgets/HttpFilterableCheckedMultiSelect", [ FilterableCheckedMultiSelect, _FilterableCheckedMultiSelectHttpMixin ],{
        doShowOptions: function (options) {
            var _this = this;

            //If some items have already been selected
            if (this.preSelectedOptions) {
                var optionsWithPreSelection = [];
                array.forEach(options, function (item) {
                    optionsWithPreSelection.push({
                        label: item.label,
                        value: item.value,
                        selected: (_this.preSelectedOptions.indexOf(item.value,0) > -1)
                    });
                });
                this.addOption(optionsWithPreSelection);

            }
            else {
                this.addOption(options);
            }
        }
    });
});
