/** Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Release
* (c) Copyright IBM Corporation 2011, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
/*global define, uReleaseConfig, util, i18n */
define([
    "dojo/_base/declare",
    "app/widgets/select/FilterableCheckedMultiSelect"
], function(
    declare,
    FilterableCheckedMultiSelect
) {

        /**
         * FilterableSingleSelectBox
         * @extends app/widget/select/FilterableCheckedMultiSelect
         * provides a multi select checkbox, with a text box above it.  Options in the multi-select
         * {
         *
         *  CONSTRUCTOR ARGUMENTS: @see app/widget/select/FilterableCheckedMultiSelect for inherited properties
         *  multiple: {Boolean} whether or not multiple items can be selected at once.
         */
    return declare("app/widgets/select/FilterableSingleSelectBox", [FilterableCheckedMultiSelect],{

        /**
         * base class name appended to the widgets top most dom node
         * @see app/widgets/UReleaseWidget
         */
        className:'filterable-single-select-box',

        /**
         * whether or not multiple items can be selected.
         */
        multiple:false

    });
});
