/*
 * Licensed Materials - Property of IBM Corp.
 * IBM UrbanCode Release
 * (c) Copyright IBM Corporation 2011, 2013. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 */
/*globals uReleaseConfig, define, dijit */
define([
    "dojo/_base/declare",
    "dojo/on",
    "dojo/query",
    "dojo/dom-construct",
    "dijit/form/Button",
    "dijit/Dialog",
    "app/model/milestone/MilestoneSequence",
    "app/widgets/resourceTreeTable/ResourceTreeTable",
    "js/webext/widgets/ColumnForm",
    "js/webext/widgets/RestSelect"
], function(
    declare,
    on,
    query,
    domConstruct,
    Button,
    Dialog,
    MilestoneSequence,
    ResourceTreeTable,
    ColumnForm,
    RestSelect
) {

    /**
     * Table variant of ResourceList which shows the members as rows in a table
     * Takes an object following:
     *  {
     *      model: Resource instance containing a collection
     *      widgetClass: The dojo "class" object to instantiate for each member of the collection
     *      showHeaders: boolean, indicates whether to show column headers in the table
     *  }
     */
    return declare("app/widgets/resourceTreeTable/MilestoneSequenceTreeTable", [ResourceTreeTable], {

        /**
         * the resource class backing this TreeTable
         */
        Resource: MilestoneSequence,

        /**
         * @extends ResourceTreeTable
         */
        postCreate: function() {
            this.removeColumn("Options");
            this.inherited(arguments);
        },

        /**
         * @extends ResourceTreeTable
         */
        getData: function() {
            this.resource.sortMembers();
            return this.resource.getMembers();
        },

        edit: function(item) {
            var _this = this;
            var dialog = new Dialog({
                title: i18n("Edit Process Checklist")
            });
            on(dialog, "hide", function() {
                _this.resource.load().then(function() {
                    _this.resource.members.sort(function(a, b) {
                        return b.serviceData.name.toLowerCase() < a.serviceData.name.toLowerCase() ? 1 : -1;
                    });
                    _this.refresh();
                    dialog.destroy();
                });
            });
            this.showEditForm(dialog, item);
        },

        /**
         * XXX: This pattern is appearing in Milestone, Lifecycle, and
         * Application tree table. We may want to DRY this up.
         */
        showEditForm: function(dialog, model) {
            var _this = this;
            domConstruct.empty(dialog.containerNode);

            var newUrl = uReleaseConfig.urls.base + "milestoneSequence/" +
                (model ? model.get('id') : "");
            var form = new ColumnForm({
                submitUrl: newUrl,
                submitMethod: model ? "PUT" : "POST",
                submitFormat: "JSON",
                postSubmit: function(data, ioArgs) {
                    dialog.hide();

                    _this.resource.load().then(function() {
                        _this.loadTable();
                    });
                },
                onCancel: function() {
                    dialog.hide();
                }
            });

            form.addField({
                name: "name",
                value: model ? model.get('name') : "",
                label: i18n("Name"),
                required: true,
                type: "Text"
            });

            form.addField({
                name: "description",
                value: model ? model.get('description') : "",
                label: i18n("Description"),
                type: "Text Area",
                style: "width: 284px; font: inherit;"
            });

            form.addField({
                name: "id",
                value: model ? model.get('id') : "",
                type: "hidden"
            });

            form.placeAt(dialog.containerNode);
            dialog.show();
        },

        /**
         * override getter for child items
         * //FIXME:  TreeTable expects data to be plain java objects,
         * not Resources, so we need to find a real solution long term, or stop using WebExt
         */
        getItemChildren: function() {
            return [];
        }
    });
});
